/* valaflagsvalue.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaflagsvalue.h"
#include <vala/valaexpression.h>
#include <vala/valaflagsvalue.h>
#include <vala/valacodevisitor.h>
#include <vala/valasymbol.h>
#include <vala/valaflags.h>

struct _ValaFlagsValuePrivate {
	char* _name;
	ValaExpression* _value;
	char* cname;
};
#define VALA_FLAGS_VALUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FLAGS_VALUE, ValaFlagsValuePrivate))
enum  {
	VALA_FLAGS_VALUE_DUMMY_PROPERTY,
	VALA_FLAGS_VALUE_NAME,
	VALA_FLAGS_VALUE_VALUE,
};
static void vala_flags_value_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_flags_value_parent_class = NULL;
static void vala_flags_value_dispose (GObject * obj);


/**
 * Creates a new flags value.
 *
 * @param name  flags value name
 * @return      newly created flags value
 */
ValaFlagsValue* vala_flags_value_new (const char* _name)
{
	g_return_val_if_fail (_name != NULL, NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	ValaFlagsValue * self = g_object_newv (VALA_TYPE_FLAGS_VALUE, __params_it - __params, __params);
	return self;
}


/**
 * Creates a new flags value with the specified numerical
 * representation.
 *
 * @param name  flags value name
 * @param value numerical representation
 * @return      newly created flags value
 */
ValaFlagsValue* vala_flags_value_new_with_value (const char* _name, ValaExpression* _value)
{
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (_value == NULL || VALA_IS_EXPRESSION (_value), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	(__params_it->name = "value", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, _value), __params_it++);
	ValaFlagsValue * self = g_object_newv (VALA_TYPE_FLAGS_VALUE, __params_it - __params, __params);
	return self;
}


static void vala_flags_value_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaFlagsValue * self = VALA_FLAGS_VALUE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_flags_value (visitor, self);
}


/**
 * Returns the name of this flags value as it is used in C code.
 *
 * @return the name to be used in C code
 */
char* vala_flags_value_get_cname (ValaFlagsValue* self)
{
	g_return_val_if_fail (VALA_IS_FLAGS_VALUE (self), NULL);
	if (self->priv->cname == NULL) {
		ValaFlags* __temp0 = NULL;
		ValaFlags* fl = (__temp0 = VALA_FLAGS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (self))))), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
		char* __temp2 = NULL;
		char* __temp1 = NULL;
		self->priv->cname = (__temp2 = g_strdup_printf ("%s_%s", (__temp1 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (fl), NULL)), vala_flags_value_get_name (self)), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp2);
		(__temp1 = (g_free (__temp1), NULL));
		(fl == NULL ? NULL : (fl = (g_object_unref (fl), NULL)));
	}
	const char* __temp3 = NULL;
	return (__temp3 = self->priv->cname, (__temp3 == NULL ? NULL : g_strdup (__temp3)));
}


char* vala_flags_value_get_name (ValaFlagsValue* self)
{
	g_return_val_if_fail (VALA_IS_FLAGS_VALUE (self), NULL);
	return self->priv->_name;
}


void vala_flags_value_set_name (ValaFlagsValue* self, const char* value)
{
	g_return_if_fail (VALA_IS_FLAGS_VALUE (self));
	char* __temp6 = NULL;
	self->priv->_name = (__temp6 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp6);
}


ValaExpression* vala_flags_value_get_value (ValaFlagsValue* self)
{
	g_return_val_if_fail (VALA_IS_FLAGS_VALUE (self), NULL);
	return self->priv->_value;
}


void vala_flags_value_set_value (ValaFlagsValue* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_FLAGS_VALUE (self));
	ValaExpression* __temp9 = NULL;
	ValaExpression* __temp8 = NULL;
	self->priv->_value = (__temp9 = (__temp8 = value, (__temp8 == NULL ? NULL : g_object_ref (__temp8))), (self->priv->_value == NULL ? NULL : (self->priv->_value = (g_object_unref (self->priv->_value), NULL))), __temp9);
}


static void vala_flags_value_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaFlagsValue * self = VALA_FLAGS_VALUE (object);
	switch (property_id) {
		case VALA_FLAGS_VALUE_NAME:
		g_value_set_string (value, vala_flags_value_get_name (self));
		break;
		case VALA_FLAGS_VALUE_VALUE:
		g_value_set_object (value, vala_flags_value_get_value (self));
		break;
	}
}


static void vala_flags_value_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaFlagsValue * self = VALA_FLAGS_VALUE (object);
	switch (property_id) {
		case VALA_FLAGS_VALUE_NAME:
		vala_flags_value_set_name (self, g_value_get_string (value));
		break;
		case VALA_FLAGS_VALUE_VALUE:
		vala_flags_value_set_value (self, g_value_get_object (value));
		break;
	}
}


static void vala_flags_value_class_init (ValaFlagsValueClass * klass)
{
	vala_flags_value_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaFlagsValuePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_flags_value_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_flags_value_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_flags_value_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_flags_value_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FLAGS_VALUE_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_FLAGS_VALUE_VALUE, g_param_spec_object ("value", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_flags_value_init (ValaFlagsValue * self)
{
	self->priv = VALA_FLAGS_VALUE_GET_PRIVATE (self);
}


static void vala_flags_value_dispose (GObject * obj)
{
	ValaFlagsValue * self = VALA_FLAGS_VALUE (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->_value == NULL ? NULL : (self->priv->_value = (g_object_unref (self->priv->_value), NULL)));
	(self->priv->cname = (g_free (self->priv->cname), NULL));
	ValaFlagsValueClass * klass;
	GObjectClass * parent_class;
	klass = VALA_FLAGS_VALUE_CLASS (g_type_class_peek (VALA_TYPE_FLAGS_VALUE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_flags_value_get_type ()
{
	static GType vala_flags_value_type_id = 0;
	if (G_UNLIKELY (vala_flags_value_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlagsValueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flags_value_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlagsValue), 0, (GInstanceInitFunc) vala_flags_value_init };
		vala_flags_value_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaFlagsValue", &g_define_type_info, 0);
	}
	return vala_flags_value_type_id;
}




