/* valalockstatement.vala
 *
 * Copyright (C) 2006  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valalockstatement.h"
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valalockstatement.h>
#include <vala/valacodevisitor.h>

struct _ValaLockStatementPrivate {
	ValaExpression* _resource;
	ValaStatement* _body;
};
#define VALA_LOCK_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementPrivate))
enum  {
	VALA_LOCK_STATEMENT_DUMMY_PROPERTY,
	VALA_LOCK_STATEMENT_RESOURCE,
	VALA_LOCK_STATEMENT_BODY,
};
static void vala_lock_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_lock_statement_parent_class = NULL;
static void vala_lock_statement_dispose (GObject * obj);


ValaLockStatement* vala_lock_statement_new (ValaExpression* _resource, ValaStatement* _body, ValaSourceReference* source)
{
	g_return_val_if_fail (_resource == NULL || VALA_IS_EXPRESSION (_resource), NULL);
	g_return_val_if_fail (_body == NULL || VALA_IS_STATEMENT (_body), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 3);
	GParameter * __params_it = __params;
	(__params_it->name = "resource", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, _resource), __params_it++);
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_STATEMENT), g_value_set_object (&__params_it->value, _body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaLockStatement * self = g_object_newv (VALA_TYPE_LOCK_STATEMENT, __params_it - __params, __params);
	return self;
}


static void vala_lock_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaLockStatement * self = VALA_LOCK_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_lock_statement_get_resource (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_lock_statement_get_body (self)), visitor);
	vala_code_visitor_visit_lock_statement (visitor, self);
}


ValaExpression* vala_lock_statement_get_resource (ValaLockStatement* self)
{
	g_return_val_if_fail (VALA_IS_LOCK_STATEMENT (self), NULL);
	return self->priv->_resource;
}


void vala_lock_statement_set_resource (ValaLockStatement* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (self));
	ValaExpression* __temp1 = NULL;
	self->priv->_resource = (__temp1 = g_object_ref (value), (self->priv->_resource == NULL ? NULL : (self->priv->_resource = (g_object_unref (self->priv->_resource), NULL))), __temp1);
}


ValaStatement* vala_lock_statement_get_body (ValaLockStatement* self)
{
	g_return_val_if_fail (VALA_IS_LOCK_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_lock_statement_set_body (ValaLockStatement* self, ValaStatement* value)
{
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (self));
	ValaStatement* __temp3 = NULL;
	self->priv->_body = (__temp3 = g_object_ref (value), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp3);
}


static void vala_lock_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaLockStatement * self = VALA_LOCK_STATEMENT (object);
	switch (property_id) {
		case VALA_LOCK_STATEMENT_RESOURCE:
		g_value_set_object (value, vala_lock_statement_get_resource (self));
		break;
		case VALA_LOCK_STATEMENT_BODY:
		g_value_set_object (value, vala_lock_statement_get_body (self));
		break;
	}
}


static void vala_lock_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaLockStatement * self = VALA_LOCK_STATEMENT (object);
	switch (property_id) {
		case VALA_LOCK_STATEMENT_RESOURCE:
		vala_lock_statement_set_resource (self, g_value_get_object (value));
		break;
		case VALA_LOCK_STATEMENT_BODY:
		vala_lock_statement_set_body (self, g_value_get_object (value));
		break;
	}
}


static void vala_lock_statement_class_init (ValaLockStatementClass * klass)
{
	vala_lock_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaLockStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_lock_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_lock_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_lock_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_lock_statement_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LOCK_STATEMENT_RESOURCE, g_param_spec_object ("resource", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LOCK_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_lock_statement_init (ValaLockStatement * self)
{
	self->priv = VALA_LOCK_STATEMENT_GET_PRIVATE (self);
}


static void vala_lock_statement_dispose (GObject * obj)
{
	ValaLockStatement * self = VALA_LOCK_STATEMENT (obj);
	(self->priv->_resource == NULL ? NULL : (self->priv->_resource = (g_object_unref (self->priv->_resource), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	ValaLockStatementClass * klass;
	GObjectClass * parent_class;
	klass = VALA_LOCK_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_LOCK_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_lock_statement_get_type ()
{
	static GType vala_lock_statement_type_id = 0;
	if (G_UNLIKELY (vala_lock_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLockStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lock_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLockStatement), 0, (GInstanceInitFunc) vala_lock_statement_init };
		vala_lock_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaLockStatement", &g_define_type_info, 0);
	}
	return vala_lock_statement_type_id;
}




