/* valanamespacereference.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valanamespacereference.h"
#include <vala/valasymbol.h>
#include <vala/valasourcereference.h>
#include <vala/valanamespacereference.h>
#include <vala/valacodevisitor.h>

struct _ValaNamespaceReferencePrivate {
	char* _name;
	ValaSymbol* _namespace_symbol;
};
#define VALA_NAMESPACE_REFERENCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_NAMESPACE_REFERENCE, ValaNamespaceReferencePrivate))
enum  {
	VALA_NAMESPACE_REFERENCE_DUMMY_PROPERTY,
	VALA_NAMESPACE_REFERENCE_NAME,
	VALA_NAMESPACE_REFERENCE_NAMESPACE_SYMBOL,
};
static void vala_namespace_reference_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_namespace_reference_parent_class = NULL;
static void vala_namespace_reference_dispose (GObject * obj);


/**
 * Creates a new namespace reference.
 *
 * @param name   namespace name
 * @param source reference to source code
 * @return       newly created namespace reference
 */
ValaNamespaceReference* vala_namespace_reference_new (const char* _name, ValaSourceReference* source)
{
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaNamespaceReference * self = g_object_newv (VALA_TYPE_NAMESPACE_REFERENCE, __params_it - __params, __params);
	return self;
}


static void vala_namespace_reference_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaNamespaceReference * self = VALA_NAMESPACE_REFERENCE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_namespace_reference (visitor, self);
}


char* vala_namespace_reference_get_name (ValaNamespaceReference* self)
{
	g_return_val_if_fail (VALA_IS_NAMESPACE_REFERENCE (self), NULL);
	return self->priv->_name;
}


void vala_namespace_reference_set_name (ValaNamespaceReference* self, const char* value)
{
	g_return_if_fail (VALA_IS_NAMESPACE_REFERENCE (self));
	char* __temp1 = NULL;
	self->priv->_name = (__temp1 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp1);
}


ValaSymbol* vala_namespace_reference_get_namespace_symbol (ValaNamespaceReference* self)
{
	g_return_val_if_fail (VALA_IS_NAMESPACE_REFERENCE (self), NULL);
	return self->priv->_namespace_symbol;
}


void vala_namespace_reference_set_namespace_symbol (ValaNamespaceReference* self, ValaSymbol* value)
{
	g_return_if_fail (VALA_IS_NAMESPACE_REFERENCE (self));
	self->priv->_namespace_symbol = value;
}


static void vala_namespace_reference_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaNamespaceReference * self = VALA_NAMESPACE_REFERENCE (object);
	switch (property_id) {
		case VALA_NAMESPACE_REFERENCE_NAME:
		g_value_set_string (value, vala_namespace_reference_get_name (self));
		break;
		case VALA_NAMESPACE_REFERENCE_NAMESPACE_SYMBOL:
		g_value_set_object (value, vala_namespace_reference_get_namespace_symbol (self));
		break;
	}
}


static void vala_namespace_reference_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaNamespaceReference * self = VALA_NAMESPACE_REFERENCE (object);
	switch (property_id) {
		case VALA_NAMESPACE_REFERENCE_NAME:
		vala_namespace_reference_set_name (self, g_value_get_string (value));
		break;
		case VALA_NAMESPACE_REFERENCE_NAMESPACE_SYMBOL:
		vala_namespace_reference_set_namespace_symbol (self, g_value_get_object (value));
		break;
	}
}


static void vala_namespace_reference_class_init (ValaNamespaceReferenceClass * klass)
{
	vala_namespace_reference_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaNamespaceReferencePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_namespace_reference_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_namespace_reference_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_namespace_reference_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_namespace_reference_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_NAMESPACE_REFERENCE_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_NAMESPACE_REFERENCE_NAMESPACE_SYMBOL, g_param_spec_object ("namespace-symbol", "foo", "bar", VALA_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_namespace_reference_init (ValaNamespaceReference * self)
{
	self->priv = VALA_NAMESPACE_REFERENCE_GET_PRIVATE (self);
}


static void vala_namespace_reference_dispose (GObject * obj)
{
	ValaNamespaceReference * self = VALA_NAMESPACE_REFERENCE (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	ValaNamespaceReferenceClass * klass;
	GObjectClass * parent_class;
	klass = VALA_NAMESPACE_REFERENCE_CLASS (g_type_class_peek (VALA_TYPE_NAMESPACE_REFERENCE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_namespace_reference_get_type ()
{
	static GType vala_namespace_reference_type_id = 0;
	if (G_UNLIKELY (vala_namespace_reference_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNamespaceReferenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_namespace_reference_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamespaceReference), 0, (GInstanceInitFunc) vala_namespace_reference_init };
		vala_namespace_reference_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaNamespaceReference", &g_define_type_info, 0);
	}
	return vala_namespace_reference_type_id;
}




