/* valasourcefile.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALASOURCEFILE_H__
#define __VALASOURCEFILE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcefile.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFilePrivate ValaSourceFilePrivate;

/**
 * Represents a Vala source or VAPI package file.
 */
struct _ValaSourceFile {
	GObject parent;
	ValaSourceFilePrivate * priv;
};
struct _ValaSourceFileClass {
	GObjectClass parent;
};
typedef enum  {
	VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_FULL,
	VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_SHALLOW,
	VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE,
} ValaSourceFileDependencyType;

ValaSourceFile* vala_source_file_new (ValaCodeContext* _context, const char* _filename, gboolean _pkg);
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaNamespaceReference* ns);
GList* vala_source_file_get_using_directives (ValaSourceFile* self);
void vala_source_file_add_namespace (ValaSourceFile* self, ValaNamespace* ns);
ValaNamespace* vala_source_file_get_global_namespace (ValaSourceFile* self);
GList* vala_source_file_get_namespaces (ValaSourceFile* self);
void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor);
char* vala_source_file_get_cheader_filename (ValaSourceFile* self);
char* vala_source_file_get_csource_filename (ValaSourceFile* self);
char* vala_source_file_get_cinclude_filename (ValaSourceFile* self);
void vala_source_file_add_symbol_dependency (ValaSourceFile* self, ValaSymbol* sym, ValaSourceFileDependencyType dep_type);
GList* vala_source_file_get_header_external_includes (ValaSourceFile* self);
void vala_source_file_add_header_internal_include (ValaSourceFile* self, const char* include);
GList* vala_source_file_get_header_internal_includes (ValaSourceFile* self);
GList* vala_source_file_get_source_external_includes (ValaSourceFile* self);
GList* vala_source_file_get_source_internal_includes (ValaSourceFile* self);
GList* vala_source_file_get_header_internal_full_dependencies (ValaSourceFile* self);
GList* vala_source_file_get_header_internal_dependencies (ValaSourceFile* self);
char* vala_source_file_get_filename (ValaSourceFile* self);
void vala_source_file_set_filename (ValaSourceFile* self, const char* value);
char* vala_source_file_get_comment (ValaSourceFile* self);
void vala_source_file_set_comment (ValaSourceFile* self, const char* value);
gboolean vala_source_file_get_pkg (ValaSourceFile* self);
void vala_source_file_set_pkg (ValaSourceFile* self, gboolean value);
ValaSourceFileCycle* vala_source_file_get_cycle (ValaSourceFile* self);
void vala_source_file_set_cycle (ValaSourceFile* self, ValaSourceFileCycle* value);
gboolean vala_source_file_get_is_cycle_head (ValaSourceFile* self);
void vala_source_file_set_is_cycle_head (ValaSourceFile* self, gboolean value);
gint vala_source_file_get_mark (ValaSourceFile* self);
void vala_source_file_set_mark (ValaSourceFile* self, gint value);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
void vala_source_file_set_context (ValaSourceFile* self, ValaCodeContext* value);
GType vala_source_file_get_type ();

G_END_DECLS

#endif
