/* valasourcefilecycle.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valasourcefilecycle.h"

struct _ValaSourceFileCyclePrivate {
};
#define VALA_SOURCE_FILE_CYCLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SOURCE_FILE_CYCLE, ValaSourceFileCyclePrivate))
enum  {
	VALA_SOURCE_FILE_CYCLE_DUMMY_PROPERTY,
};
static gpointer vala_source_file_cycle_parent_class = NULL;
static void vala_source_file_cycle_dispose (GObject * obj);


static void vala_source_file_cycle_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaSourceFileCycle * self = VALA_SOURCE_FILE_CYCLE (object);
	switch (property_id) {
	}
}


static void vala_source_file_cycle_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaSourceFileCycle * self = VALA_SOURCE_FILE_CYCLE (object);
	switch (property_id) {
	}
}


static void vala_source_file_cycle_class_init (ValaSourceFileCycleClass * klass)
{
	vala_source_file_cycle_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_source_file_cycle_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_source_file_cycle_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_source_file_cycle_dispose;
}


static void vala_source_file_cycle_init (ValaSourceFileCycle * self)
{
}


static void vala_source_file_cycle_dispose (GObject * obj)
{
	ValaSourceFileCycle * self = VALA_SOURCE_FILE_CYCLE (obj);
	(self->files == NULL ? NULL : (self->files = (g_list_free (self->files), NULL)));
	ValaSourceFileCycleClass * klass;
	GObjectClass * parent_class;
	klass = VALA_SOURCE_FILE_CYCLE_CLASS (g_type_class_peek (VALA_TYPE_SOURCE_FILE_CYCLE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_source_file_cycle_get_type ()
{
	static GType vala_source_file_cycle_type_id = 0;
	if (G_UNLIKELY (vala_source_file_cycle_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSourceFileCycleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_source_file_cycle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSourceFileCycle), 0, (GInstanceInitFunc) vala_source_file_cycle_init };
		vala_source_file_cycle_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaSourceFileCycle", &g_define_type_info, 0);
	}
	return vala_source_file_cycle_type_id;
}




