/* valaswitchlabel.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaswitchlabel.h"
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valaswitchlabel.h>
#include <vala/valacodevisitor.h>

struct _ValaSwitchLabelPrivate {
	ValaExpression* _expression;
};
#define VALA_SWITCH_LABEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelPrivate))
enum  {
	VALA_SWITCH_LABEL_DUMMY_PROPERTY,
	VALA_SWITCH_LABEL_EXPRESSION,
};
static void vala_switch_label_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_switch_label_parent_class = NULL;
static void vala_switch_label_dispose (GObject * obj);


/**
 * Creates a new switch case label.
 *
 * @param expr   label expression
 * @param source reference to source code
 * @return       newly created switch case label
 */
ValaSwitchLabel* vala_switch_label_new (ValaExpression* expr, ValaSourceReference* source)
{
	g_return_val_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "expression", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, expr), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaSwitchLabel * self = g_object_newv (VALA_TYPE_SWITCH_LABEL, __params_it - __params, __params);
	return self;
}


/**
 * Creates a new switch default label.
 *
 * @param source reference to source code
 * @return       newly created switch default label
 */
ValaSwitchLabel* vala_switch_label_new_with_default (ValaSourceReference* source)
{
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaSwitchLabel * self = g_object_newv (VALA_TYPE_SWITCH_LABEL, __params_it - __params, __params);
	return self;
}


static void vala_switch_label_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaSwitchLabel * self = VALA_SWITCH_LABEL (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_switch_label_get_expression (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_switch_label_get_expression (self)), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_switch_label_get_expression (self));
	}
	vala_code_visitor_visit_switch_label (visitor, self);
}


ValaExpression* vala_switch_label_get_expression (ValaSwitchLabel* self)
{
	g_return_val_if_fail (VALA_IS_SWITCH_LABEL (self), NULL);
	return self->priv->_expression;
}


void vala_switch_label_set_expression (ValaSwitchLabel* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_SWITCH_LABEL (self));
	ValaExpression* __temp2 = NULL;
	ValaExpression* __temp1 = NULL;
	self->priv->_expression = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), __temp2);
}


static void vala_switch_label_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaSwitchLabel * self = VALA_SWITCH_LABEL (object);
	switch (property_id) {
		case VALA_SWITCH_LABEL_EXPRESSION:
		g_value_set_object (value, vala_switch_label_get_expression (self));
		break;
	}
}


static void vala_switch_label_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaSwitchLabel * self = VALA_SWITCH_LABEL (object);
	switch (property_id) {
		case VALA_SWITCH_LABEL_EXPRESSION:
		vala_switch_label_set_expression (self, g_value_get_object (value));
		break;
	}
}


static void vala_switch_label_class_init (ValaSwitchLabelClass * klass)
{
	vala_switch_label_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSwitchLabelPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_switch_label_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_switch_label_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_switch_label_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_switch_label_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SWITCH_LABEL_EXPRESSION, g_param_spec_object ("expression", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_switch_label_init (ValaSwitchLabel * self)
{
	self->priv = VALA_SWITCH_LABEL_GET_PRIVATE (self);
}


static void vala_switch_label_dispose (GObject * obj)
{
	ValaSwitchLabel * self = VALA_SWITCH_LABEL (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	ValaSwitchLabelClass * klass;
	GObjectClass * parent_class;
	klass = VALA_SWITCH_LABEL_CLASS (g_type_class_peek (VALA_TYPE_SWITCH_LABEL));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_switch_label_get_type ()
{
	static GType vala_switch_label_type_id = 0;
	if (G_UNLIKELY (vala_switch_label_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchLabel), 0, (GInstanceInitFunc) vala_switch_label_init };
		vala_switch_label_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSwitchLabel", &g_define_type_info, 0);
	}
	return vala_switch_label_type_id;
}




