/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valatyperegisterfunction.h"
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <vala/valatyperegisterfunction.h>

struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
};
#define VALA_TYPE_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPE_REGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPE_REGISTER_FUNCTION_DUMMY_PROPERTY,
};
static char* vala_type_register_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static gpointer vala_type_register_function_parent_class = NULL;
static void vala_type_register_function_dispose (GObject * obj);


/**
 * Constructs the C function from the specified type.
 */
void vala_type_register_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin)
{
	g_return_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self));
	char* __temp1 = NULL;
	ValaDataType* __temp0 = NULL;
	char* __temp2 = NULL;
	char* type_id_name = (__temp2 = g_strdup_printf ("%s_type_id", (__temp1 = vala_data_type_get_lower_case_cname ((__temp0 = vala_type_register_function_get_type_declaration (self)), NULL))), (__temp1 = (g_free (__temp1), NULL)), (__temp0 = (g_object_unref (__temp0), NULL)), __temp2);
	ValaCCodeBlock* type_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeDeclaration* cdecl = vala_ccode_declaration_new ("GType");
	ValaCCodeVariableDeclarator* __temp3 = NULL;
	vala_ccode_declaration_add_declarator (cdecl, VALA_CCODE_DECLARATOR ((__temp3 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))))));
	(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	(vala_ccode_declaration_set_modifiers (cdecl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (cdecl));
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cdecl));
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (cdecl));
	}
	ValaCCodeFunction* fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* __temp6 = NULL;
		char* __temp5 = NULL;
		ValaDataType* __temp4 = NULL;
		fun = (__temp6 = vala_ccode_function_new (g_strdup_printf ("%s_get_type", (__temp5 = vala_data_type_get_lower_case_cname ((__temp4 = vala_type_register_function_get_type_declaration (self)), NULL))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), __temp6);
		(__temp5 = (g_free (__temp5), NULL));
		(__temp4 = (g_object_unref (__temp4), NULL));
	} else {
		ValaCCodeFunction* __temp9 = NULL;
		char* __temp8 = NULL;
		ValaDataType* __temp7 = NULL;
		fun = (__temp9 = vala_ccode_function_new (g_strdup_printf ("%s_register_type", (__temp8 = vala_data_type_get_lower_case_cname ((__temp7 = vala_type_register_function_get_type_declaration (self)), NULL))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), __temp9);
		(__temp8 = (g_free (__temp8), NULL));
		(__temp7 = (g_object_unref (__temp7), NULL));
		ValaCCodeFormalParameter* __temp10 = NULL;
		vala_ccode_function_add_parameter (fun, (__temp10 = vala_ccode_formal_parameter_new ("module", "GTypeModule *")));
		(__temp10 == NULL ? NULL : (__temp10 = (g_object_unref (__temp10), NULL)));
		char* __temp12 = NULL;
		ValaDataType* __temp11 = NULL;
		ValaCCodeFunction* __temp13 = NULL;
		ValaCCodeFunction* get_fun = (__temp13 = vala_ccode_function_new (g_strdup_printf ("%s_get_type", (__temp12 = vala_data_type_get_lower_case_cname ((__temp11 = vala_type_register_function_get_type_declaration (self)), NULL))), "GType"), (__temp12 = (g_free (__temp12), NULL)), (__temp11 = (g_object_unref (__temp11), NULL)), __temp13);
		ValaCCodeFunction* __temp14 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((__temp14 = vala_ccode_function_copy (get_fun))));
		(__temp14 = (g_object_unref (__temp14), NULL));
		ValaCCodeBlock* __temp15 = NULL;
		(vala_ccode_function_set_block (get_fun, (__temp15 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL))), vala_ccode_function_get_block (get_fun));
		(__temp15 == NULL ? NULL : (__temp15 = (g_object_unref (__temp15), NULL)));
		ValaCCodeReturnStatement* __temp16 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), VALA_CCODE_NODE ((__temp16 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (type_id_name))))));
		(__temp16 == NULL ? NULL : (__temp16 = (g_object_unref (__temp16), NULL)));
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (get_fun));
		(get_fun == NULL ? NULL : (get_fun = (g_object_unref (get_fun), NULL)));
	}
	ValaCCodeBlock* type_init = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ValaCCodeDeclaration* ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
	(vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (ctypedecl));
	ValaCCodeVariableDeclarator* __temp22 = NULL;
	char* __temp21 = NULL;
	char* __temp20 = NULL;
	char* __temp19 = NULL;
	char* __temp18 = NULL;
	char* __temp17 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((__temp22 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", VALA_CCODE_EXPRESSION (vala_ccode_constant_new (g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) NULL, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s }", (__temp17 = vala_type_register_function_get_type_struct_name (self)), (__temp18 = vala_type_register_function_get_base_init_func_name (self)), (__temp19 = vala_type_register_function_get_class_init_func_name (self)), (__temp20 = vala_type_register_function_get_instance_struct_size (self)), (__temp21 = vala_type_register_function_get_instance_init_func_name (self)))))))));
	(__temp22 == NULL ? NULL : (__temp22 = (g_object_unref (__temp22), NULL)));
	(__temp21 = (g_free (__temp21), NULL));
	(__temp20 = (g_free (__temp20), NULL));
	(__temp19 = (g_free (__temp19), NULL));
	(__temp18 = (g_free (__temp18), NULL));
	(__temp17 = (g_free (__temp17), NULL));
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (ctypedecl));
	ValaCCodeFunctionCall* reg_call = NULL;
	if (!plugin) {
		ValaCCodeFunctionCall* __temp23 = NULL;
		reg_call = (__temp23 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_register_static"))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), __temp23);
	} else {
		ValaCCodeFunctionCall* __temp24 = NULL;
		reg_call = (__temp24 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_module_register_type"))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), __temp24);
		ValaCCodeIdentifier* __temp25 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp25 = vala_ccode_identifier_new ("module"))));
		(__temp25 == NULL ? NULL : (__temp25 = (g_object_unref (__temp25), NULL)));
	}
	ValaCCodeIdentifier* __temp26 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp26 = vala_ccode_identifier_new (vala_type_register_function_get_parent_type_name (self)))));
	(__temp26 == NULL ? NULL : (__temp26 = (g_object_unref (__temp26), NULL)));
	ValaCCodeConstant* __temp29 = NULL;
	char* __temp28 = NULL;
	ValaDataType* __temp27 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp29 = vala_ccode_constant_new (g_strdup_printf ("\"%s\"", (__temp28 = vala_data_type_get_cname ((__temp27 = vala_type_register_function_get_type_declaration (self)), FALSE)))))));
	(__temp29 == NULL ? NULL : (__temp29 = (g_object_unref (__temp29), NULL)));
	(__temp28 = (g_free (__temp28), NULL));
	(__temp27 = (g_object_unref (__temp27), NULL));
	ValaCCodeIdentifier* __temp30 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp30 = vala_ccode_identifier_new ("&g_define_type_info"))));
	(__temp30 == NULL ? NULL : (__temp30 = (g_object_unref (__temp30), NULL)));
	ValaCCodeConstant* __temp31 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp31 = vala_ccode_constant_new (vala_type_register_function_get_type_flags (self)))));
	(__temp31 == NULL ? NULL : (__temp31 = (g_object_unref (__temp31), NULL)));
	ValaCCodeExpressionStatement* __temp32 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((__temp32 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (type_id_name)), VALA_CCODE_EXPRESSION (reg_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp32 == NULL ? NULL : (__temp32 = (g_object_unref (__temp32), NULL)));
	ValaCCodeFragment* __temp33 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((__temp33 = vala_type_register_function_get_type_interface_init_statements (self))));
	(__temp33 = (g_object_unref (__temp33), NULL));
	if (!plugin) {
		ValaCCodeFunctionCall* cond = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_UNLIKELY")));
		ValaCCodeBinaryExpression* __temp34 = NULL;
		vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((__temp34 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (type_id_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))))));
		(__temp34 == NULL ? NULL : (__temp34 = (g_object_unref (__temp34), NULL)));
		ValaCCodeIfStatement* cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (type_init), NULL);
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cif));
		(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
		(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	} else {
		ValaCCodeBlock* __temp36 = NULL;
		ValaCCodeBlock* __temp35 = NULL;
		type_block = (__temp36 = (__temp35 = type_init, (__temp35 == NULL ? NULL : g_object_ref (__temp35))), (type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL))), __temp36);
	}
	ValaCCodeReturnStatement* __temp37 = NULL;
	vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE ((__temp37 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (type_id_name))))));
	(__temp37 == NULL ? NULL : (__temp37 = (g_object_unref (__temp37), NULL)));
	ValaCCodeFunction* __temp38 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((__temp38 = vala_ccode_function_copy (fun))));
	(__temp38 = (g_object_unref (__temp38), NULL));
	(vala_ccode_function_set_block (fun, type_block), vala_ccode_function_get_block (fun));
	vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (fun));
	(type_id_name = (g_free (type_id_name), NULL));
	(type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL)));
	(cdecl == NULL ? NULL : (cdecl = (g_object_unref (cdecl), NULL)));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(type_init == NULL ? NULL : (type_init = (g_object_unref (type_init), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (g_object_unref (ctypedecl), NULL)));
	(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
}


ValaDataType* vala_type_register_function_get_type_declaration (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


char* vala_type_register_function_get_type_struct_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


char* vala_type_register_function_get_base_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


char* vala_type_register_function_get_class_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


char* vala_type_register_function_get_instance_struct_size (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


char* vala_type_register_function_get_instance_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


char* vala_type_register_function_get_parent_type_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_type_register_function_real_get_type_flags (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	return g_strdup ("0");
}


char* vala_type_register_function_get_type_flags (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


ValaCCodeFragment* vala_type_register_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_type_register_function_get_declaration (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	ValaCCodeFragment* __temp40 = NULL;
	return (__temp40 = self->priv->declaration_fragment, (__temp40 == NULL ? NULL : g_object_ref (__temp40)));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_type_register_function_get_definition (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	ValaCCodeFragment* __temp42 = NULL;
	return (__temp42 = self->priv->definition_fragment, (__temp42 == NULL ? NULL : g_object_ref (__temp42)));
}


static void vala_type_register_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaTypeRegisterFunction * self = VALA_TYPE_REGISTER_FUNCTION (object);
	switch (property_id) {
	}
}


static void vala_type_register_function_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaTypeRegisterFunction * self = VALA_TYPE_REGISTER_FUNCTION (object);
	switch (property_id) {
	}
}


static void vala_type_register_function_class_init (ValaTypeRegisterFunctionClass * klass)
{
	vala_type_register_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_type_register_function_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_type_register_function_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_type_register_function_dispose;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_type_register_function_real_get_type_flags;
}


static void vala_type_register_function_init (ValaTypeRegisterFunction * self)
{
	self->priv = VALA_TYPE_REGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	self->priv->definition_fragment = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
}


static void vala_type_register_function_dispose (GObject * obj)
{
	ValaTypeRegisterFunction * self = VALA_TYPE_REGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL ? NULL : (self->priv->declaration_fragment = (g_object_unref (self->priv->declaration_fragment), NULL)));
	(self->priv->definition_fragment == NULL ? NULL : (self->priv->definition_fragment = (g_object_unref (self->priv->definition_fragment), NULL)));
	ValaTypeRegisterFunctionClass * klass;
	GObjectClass * parent_class;
	klass = VALA_TYPE_REGISTER_FUNCTION_CLASS (g_type_class_peek (VALA_TYPE_TYPE_REGISTER_FUNCTION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_type_register_function_get_type ()
{
	static GType vala_type_register_function_type_id = 0;
	if (G_UNLIKELY (vala_type_register_function_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_type_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_type_register_function_init };
		vala_type_register_function_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaTypeRegisterFunction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_type_register_function_type_id;
}




