/* valavariabledeclarator.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAVARIABLEDECLARATOR_H__
#define __VALAVARIABLEDECLARATOR_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>
#include <vala/valainvokable.h>

G_BEGIN_DECLS


#define VALA_TYPE_VARIABLE_DECLARATOR (vala_variable_declarator_get_type ())
#define VALA_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE_DECLARATOR, ValaVariableDeclarator))
#define VALA_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE_DECLARATOR, ValaVariableDeclaratorClass))
#define VALA_IS_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE_DECLARATOR))
#define VALA_IS_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE_DECLARATOR))
#define VALA_VARIABLE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE_DECLARATOR, ValaVariableDeclaratorClass))

typedef struct _ValaVariableDeclaratorPrivate ValaVariableDeclaratorPrivate;

/**
 * Represents a variable declarator in the source code.
 */
struct _ValaVariableDeclarator {
	ValaCodeNode parent;
	ValaVariableDeclaratorPrivate * priv;
};
struct _ValaVariableDeclaratorClass {
	ValaCodeNodeClass parent;
};

ValaVariableDeclarator* vala_variable_declarator_new (const char* _name, ValaExpression* init, ValaSourceReference* source);
char* vala_variable_declarator_get_name (ValaVariableDeclarator* self);
void vala_variable_declarator_set_name (ValaVariableDeclarator* self, const char* value);
ValaExpression* vala_variable_declarator_get_initializer (ValaVariableDeclarator* self);
void vala_variable_declarator_set_initializer (ValaVariableDeclarator* self, ValaExpression* value);
ValaTypeReference* vala_variable_declarator_get_type_reference (ValaVariableDeclarator* self);
void vala_variable_declarator_set_type_reference (ValaVariableDeclarator* self, ValaTypeReference* value);
GType vala_variable_declarator_get_type ();

G_END_DECLS

#endif
