/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaarraycreationexpression.h"
#include <vala/valatypereference.h>
#include <vala/valainitializerlist.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaArrayCreationExpressionPrivate {
	ValaTypeReference* _element_type;
	gint _rank;
	GList* sizes;
	ValaInitializerList* _initializer_list;
};
#define VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionPrivate))
enum  {
	VALA_ARRAY_CREATION_EXPRESSION_DUMMY_PROPERTY,
	VALA_ARRAY_CREATION_EXPRESSION_ELEMENT_TYPE,
	VALA_ARRAY_CREATION_EXPRESSION_RANK,
	VALA_ARRAY_CREATION_EXPRESSION_INITIALIZER_LIST,
};
static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_array_creation_expression_parent_class = NULL;
static void vala_array_creation_expression_dispose (GObject * obj);


/**
 * Add a size expression.
 */
void vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, ValaExpression* size)
{
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	g_return_if_fail (VALA_IS_EXPRESSION (size));
	self->priv->sizes = g_list_append (self->priv->sizes, g_object_ref (size));
}


/**
 * Get the sizes for all dimensions ascending from left to right.
 */
GList* vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self)
{
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return g_list_copy (self->priv->sizes);
}


ValaArrayCreationExpression* vala_array_creation_expression_new (ValaTypeReference* _element_type, gint _rank, ValaInitializerList* _initializer, ValaSourceReference* source)
{
	g_return_val_if_fail (_element_type == NULL || VALA_IS_TYPE_REFERENCE (_element_type), NULL);
	g_return_val_if_fail (_initializer == NULL || VALA_IS_INITIALIZER_LIST (_initializer), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 4);
	GParameter * __params_it = __params;
	(__params_it->name = "element-type", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, _element_type), __params_it++);
	(__params_it->name = "rank", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _rank), __params_it++);
	(__params_it->name = "initializer-list", g_value_init (&__params_it->value, VALA_TYPE_INITIALIZER_LIST), g_value_set_object (&__params_it->value, _initializer), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaArrayCreationExpression * self = g_object_newv (VALA_TYPE_ARRAY_CREATION_EXPRESSION, __params_it - __params, __params);
	return self;
}


static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaArrayCreationExpression * self = VALA_ARRAY_CREATION_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_array_creation_expression_get_element_type (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_array_creation_expression_get_element_type (self)), visitor);
	}
	if (self->priv->sizes != NULL) {
		{
			GList* __temp1 = NULL;
			__temp1 = self->priv->sizes;
			GList* e_it;
			for (e_it = __temp1; e_it != NULL; e_it = e_it->next) {
				ValaExpression* e = e_it->data;
				{
					vala_code_node_accept (VALA_CODE_NODE (e), visitor);
				}
			}
		}
	}
	vala_code_visitor_visit_begin_array_creation_expression (visitor, self);
	if (vala_array_creation_expression_get_initializer_list (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_array_creation_expression_get_initializer_list (self)), visitor);
	}
	vala_code_visitor_visit_end_array_creation_expression (visitor, self);
}


ValaTypeReference* vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self)
{
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return self->priv->_element_type;
}


void vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self, ValaTypeReference* value)
{
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	ValaTypeReference* __temp4 = NULL;
	ValaTypeReference* __temp3 = NULL;
	self->priv->_element_type = (__temp4 = (__temp3 = value, (__temp3 == NULL ? NULL : g_object_ref (__temp3))), (self->priv->_element_type == NULL ? NULL : (self->priv->_element_type = (g_object_unref (self->priv->_element_type), NULL))), __temp4);
}


gint vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self)
{
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), 0);
	return self->priv->_rank;
}


void vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self, gint value)
{
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	self->priv->_rank = value;
}


ValaInitializerList* vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self)
{
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return self->priv->_initializer_list;
}


void vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self, ValaInitializerList* value)
{
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	ValaInitializerList* __temp8 = NULL;
	ValaInitializerList* __temp7 = NULL;
	self->priv->_initializer_list = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_object_ref (__temp7))), (self->priv->_initializer_list == NULL ? NULL : (self->priv->_initializer_list = (g_object_unref (self->priv->_initializer_list), NULL))), __temp8);
}


static void vala_array_creation_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaArrayCreationExpression * self = VALA_ARRAY_CREATION_EXPRESSION (object);
	switch (property_id) {
		case VALA_ARRAY_CREATION_EXPRESSION_ELEMENT_TYPE:
		g_value_set_object (value, vala_array_creation_expression_get_element_type (self));
		break;
		case VALA_ARRAY_CREATION_EXPRESSION_RANK:
		g_value_set_int (value, vala_array_creation_expression_get_rank (self));
		break;
		case VALA_ARRAY_CREATION_EXPRESSION_INITIALIZER_LIST:
		g_value_set_object (value, vala_array_creation_expression_get_initializer_list (self));
		break;
	}
}


static void vala_array_creation_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaArrayCreationExpression * self = VALA_ARRAY_CREATION_EXPRESSION (object);
	switch (property_id) {
		case VALA_ARRAY_CREATION_EXPRESSION_ELEMENT_TYPE:
		vala_array_creation_expression_set_element_type (self, g_value_get_object (value));
		break;
		case VALA_ARRAY_CREATION_EXPRESSION_RANK:
		vala_array_creation_expression_set_rank (self, g_value_get_int (value));
		break;
		case VALA_ARRAY_CREATION_EXPRESSION_INITIALIZER_LIST:
		vala_array_creation_expression_set_initializer_list (self, g_value_get_object (value));
		break;
	}
}


static void vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass)
{
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaArrayCreationExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_array_creation_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_creation_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_array_creation_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_array_creation_expression_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_CREATION_EXPRESSION_ELEMENT_TYPE, g_param_spec_object ("element-type", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_CREATION_EXPRESSION_RANK, g_param_spec_int ("rank", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_CREATION_EXPRESSION_INITIALIZER_LIST, g_param_spec_object ("initializer-list", "foo", "bar", VALA_TYPE_INITIALIZER_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_array_creation_expression_init (ValaArrayCreationExpression * self)
{
	self->priv = VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE (self);
}


static void vala_array_creation_expression_dispose (GObject * obj)
{
	ValaArrayCreationExpression * self = VALA_ARRAY_CREATION_EXPRESSION (obj);
	(self->priv->_element_type == NULL ? NULL : (self->priv->_element_type = (g_object_unref (self->priv->_element_type), NULL)));
	(self->priv->sizes == NULL ? NULL : (self->priv->sizes = (g_list_foreach (self->priv->sizes, (GFunc) g_object_unref, NULL), g_list_free (self->priv->sizes), NULL)));
	(self->priv->_initializer_list == NULL ? NULL : (self->priv->_initializer_list = (g_object_unref (self->priv->_initializer_list), NULL)));
	ValaArrayCreationExpressionClass * klass;
	GObjectClass * parent_class;
	klass = VALA_ARRAY_CREATION_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_ARRAY_CREATION_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_array_creation_expression_get_type ()
{
	static GType vala_array_creation_expression_type_id = 0;
	if (G_UNLIKELY (vala_array_creation_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_init };
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
	}
	return vala_array_creation_expression_type_id;
}




