/* valabinaryexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALABINARYEXPRESSION_H__
#define __VALABINARYEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valaexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpressionPrivate ValaBinaryExpressionPrivate;

/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||.
 */
struct _ValaBinaryExpression {
	ValaExpression parent;
	ValaBinaryExpressionPrivate * priv;
};
struct _ValaBinaryExpressionClass {
	ValaExpressionClass parent;
};
typedef enum  {
	VALA_BINARY_OPERATOR_PLUS,
	VALA_BINARY_OPERATOR_MINUS,
	VALA_BINARY_OPERATOR_MUL,
	VALA_BINARY_OPERATOR_DIV,
	VALA_BINARY_OPERATOR_MOD,
	VALA_BINARY_OPERATOR_SHIFT_LEFT,
	VALA_BINARY_OPERATOR_SHIFT_RIGHT,
	VALA_BINARY_OPERATOR_LESS_THAN,
	VALA_BINARY_OPERATOR_GREATER_THAN,
	VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL,
	VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL,
	VALA_BINARY_OPERATOR_EQUALITY,
	VALA_BINARY_OPERATOR_INEQUALITY,
	VALA_BINARY_OPERATOR_BITWISE_AND,
	VALA_BINARY_OPERATOR_BITWISE_OR,
	VALA_BINARY_OPERATOR_BITWISE_XOR,
	VALA_BINARY_OPERATOR_AND,
	VALA_BINARY_OPERATOR_OR,
} ValaBinaryOperator;

ValaBinaryExpression* vala_binary_expression_new (ValaBinaryOperator op, ValaExpression* _left, ValaExpression* _right, ValaSourceReference* source);
ValaBinaryOperator vala_binary_expression_get_operator (ValaBinaryExpression* self);
void vala_binary_expression_set_operator (ValaBinaryExpression* self, ValaBinaryOperator value);
ValaExpression* vala_binary_expression_get_left (ValaBinaryExpression* self);
void vala_binary_expression_set_left (ValaBinaryExpression* self, ValaExpression* value);
ValaExpression* vala_binary_expression_get_right (ValaBinaryExpression* self);
void vala_binary_expression_set_right (ValaBinaryExpression* self, ValaExpression* value);
GType vala_binary_expression_get_type ();

G_END_DECLS

#endif
