/* valabooleanliteral.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

using GLib;

/**
 * Represents a literal boolean, i.e. true or false.
 */
public class Vala.BooleanLiteral : Literal {
	/**
	 * The literal value.
	 */
	public bool value { get; set; }

	/**
	 * Creates a new boolean literal.
	 *
	 * @param b      boolean value
	 * @param source reference to source code
	 * @return       newly created boolean literal
	 */
	public BooleanLiteral (bool b, SourceReference source) {
		value = b;
		source_reference = source;
	}
	
	public override void accept (CodeVisitor! visitor) {
		visitor.visit_boolean_literal (this);
	}

	public override ref string! to_string () {
		if (value) {
			return "true";
		} else {
			return "false";
		}
	}
}
