/* valaexpressionstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaexpressionstatement.h"
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valacodevisitor.h>
#include <vala/valaassignment.h>
#include <vala/valamemberaccess.h>
#include <vala/valasymbol.h>
#include <vala/valaproperty.h>

struct _ValaExpressionStatementPrivate {
	ValaExpression* _expression;
};
#define VALA_EXPRESSION_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementPrivate))
enum  {
	VALA_EXPRESSION_STATEMENT_DUMMY_PROPERTY,
	VALA_EXPRESSION_STATEMENT_EXPRESSION,
};
static void vala_expression_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_expression_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gint vala_expression_statement_real_get_number_of_set_construction_parameters (ValaStatement* base);
static gpointer vala_expression_statement_parent_class = NULL;
static void vala_expression_statement_dispose (GObject * obj);


/**
 * Creates a new expression statement.
 *
 * @param expr   expression to evaluate
 * @param source reference to source code
 * @return       newly created expression statement
 */
ValaExpressionStatement* vala_expression_statement_new (ValaExpression* expr, ValaSourceReference* source)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	GParameter * __params = g_new0 (GParameter, 2);
	GParameter * __params_it = __params;
	(__params_it->name = "expression", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, expr), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	ValaExpressionStatement * self = g_object_newv (VALA_TYPE_EXPRESSION_STATEMENT, __params_it - __params, __params);
	return self;
}


static void vala_expression_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaExpressionStatement * self = VALA_EXPRESSION_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_expression_statement_get_expression (self)), visitor);
	vala_code_visitor_visit_expression_statement (visitor, self);
}


static void vala_expression_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaExpressionStatement * self = VALA_EXPRESSION_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_expression_statement_get_expression (self)) == old_node) {
		(vala_expression_statement_set_expression (self, VALA_EXPRESSION (new_node)), vala_expression_statement_get_expression (self));
	}
}


static gint vala_expression_statement_real_get_number_of_set_construction_parameters (ValaStatement* base)
{
	ValaExpressionStatement * self = VALA_EXPRESSION_STATEMENT (base);
	if (VALA_IS_ASSIGNMENT (vala_expression_statement_get_expression (self))) {
		ValaAssignment* __temp0 = NULL;
		ValaAssignment* assign = (__temp0 = VALA_ASSIGNMENT (vala_expression_statement_get_expression (self)), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (assign))) {
			ValaMemberAccess* __temp1 = NULL;
			ValaMemberAccess* ma = (__temp1 = VALA_MEMBER_ACCESS (vala_assignment_get_left (assign)), (__temp1 == NULL ? NULL : g_object_ref (__temp1)));
			if (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)) != NULL) {
				if (VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma))))) {
					ValaProperty* __temp2 = NULL;
					ValaProperty* prop = (__temp2 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))), (__temp2 == NULL ? NULL : g_object_ref (__temp2)));
					gint __temp3;
					return (__temp3 = 1, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), __temp3);
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				}
			}
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		}
		(assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL)));
	}
	return -1;
}


ValaExpression* vala_expression_statement_get_expression (ValaExpressionStatement* self)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_expression_statement_set_expression (ValaExpressionStatement* self, ValaExpression* value)
{
	g_return_if_fail (VALA_IS_EXPRESSION_STATEMENT (self));
	ValaExpression* __temp6 = NULL;
	self->priv->_expression = (__temp6 = g_object_ref (value), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), __temp6);
	(vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_expression), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_expression)));
}


static void vala_expression_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaExpressionStatement * self = VALA_EXPRESSION_STATEMENT (object);
	switch (property_id) {
		case VALA_EXPRESSION_STATEMENT_EXPRESSION:
		g_value_set_object (value, vala_expression_statement_get_expression (self));
		break;
	}
}


static void vala_expression_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaExpressionStatement * self = VALA_EXPRESSION_STATEMENT (object);
	switch (property_id) {
		case VALA_EXPRESSION_STATEMENT_EXPRESSION:
		vala_expression_statement_set_expression (self, g_value_get_object (value));
		break;
	}
}


static void vala_expression_statement_class_init (ValaExpressionStatementClass * klass)
{
	vala_expression_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaExpressionStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_expression_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_expression_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_expression_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_expression_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_expression_statement_real_replace;
	VALA_STATEMENT_CLASS (klass)->get_number_of_set_construction_parameters = vala_expression_statement_real_get_number_of_set_construction_parameters;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_STATEMENT_EXPRESSION, g_param_spec_object ("expression", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_expression_statement_init (ValaExpressionStatement * self)
{
	self->priv = VALA_EXPRESSION_STATEMENT_GET_PRIVATE (self);
}


static void vala_expression_statement_dispose (GObject * obj)
{
	ValaExpressionStatement * self = VALA_EXPRESSION_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	ValaExpressionStatementClass * klass;
	GObjectClass * parent_class;
	klass = VALA_EXPRESSION_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_EXPRESSION_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_expression_statement_get_type ()
{
	static GType vala_expression_statement_type_id = 0;
	if (G_UNLIKELY (vala_expression_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaExpressionStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_expression_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaExpressionStatement), 0, (GInstanceInitFunc) vala_expression_statement_init };
		vala_expression_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaExpressionStatement", &g_define_type_info, 0);
	}
	return vala_expression_statement_type_id;
}




