/* valareport.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valareport.h"
#include <stdio.h>
#include <glib/gstdio.h>
#include <vala/valareport.h>

struct _ValaReportPrivate {
};
#define VALA_REPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_REPORT, ValaReportPrivate))
enum  {
	VALA_REPORT_DUMMY_PROPERTY,
};
static gint vala_report_warnings;
static gint vala_report_errors;
static gpointer vala_report_parent_class = NULL;
static void vala_report_dispose (GObject * obj);


/**
 * Returns the total number of warnings reported.
 */
gint vala_report_get_warnings ()
{
	return vala_report_warnings;
}


/**
 * Returns the total number of errors reported.
 */
gint vala_report_get_errors ()
{
	return vala_report_errors;
}


/**
 * Reports the specified message as warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
void vala_report_warning (ValaSourceReference* source, const char* message)
{
	g_return_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source));
	g_return_if_fail (message != NULL);
	vala_report_warnings++;
	if (source == NULL) {
		fprintf (stderr, "warning: %s\n", message);
	} else {
		char* __temp2 = NULL;
		fprintf (stderr, "%s: warning: %s\n", (__temp2 = vala_source_reference_to_string (source)), message);
		(__temp2 = (g_free (__temp2), NULL));
	}
}


/**
 * Reports the specified message as error.
 *
 * @param source  reference to source code
 * @param message error message
 */
void vala_report_error (ValaSourceReference* source, const char* message)
{
	g_return_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source));
	g_return_if_fail (message != NULL);
	vala_report_errors++;
	if (source == NULL) {
		fprintf (stderr, "error: %s\n", message);
	} else {
		char* __temp3 = NULL;
		fprintf (stderr, "%s: error: %s\n", (__temp3 = vala_source_reference_to_string (source)), message);
		(__temp3 = (g_free (__temp3), NULL));
	}
}


static void vala_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaReport * self = VALA_REPORT (object);
	switch (property_id) {
	}
}


static void vala_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaReport * self = VALA_REPORT (object);
	switch (property_id) {
	}
}


static void vala_report_class_init (ValaReportClass * klass)
{
	vala_report_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = vala_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_report_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_report_dispose;
}


static void vala_report_init (ValaReport * self)
{
}


static void vala_report_dispose (GObject * obj)
{
	ValaReport * self = VALA_REPORT (obj);
	ValaReportClass * klass;
	GObjectClass * parent_class;
	klass = VALA_REPORT_CLASS (g_type_class_peek (VALA_TYPE_REPORT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_report_get_type ()
{
	static GType vala_report_type_id = 0;
	if (G_UNLIKELY (vala_report_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReport), 0, (GInstanceInitFunc) vala_report_init };
		vala_report_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaReport", &g_define_type_info, 0);
	}
	return vala_report_type_id;
}




