/* valaccodefunctiondeclarator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODEFUNCTIONDECLARATOR_H__
#define __VALACCODEFUNCTIONDECLARATOR_H__
typedef struct _ValaCCodeFunctionDeclarator ValaCCodeFunctionDeclarator;
typedef struct _ValaCCodeFunctionDeclaratorClass ValaCCodeFunctionDeclaratorClass;
typedef struct _ValaCCodeFunctionDeclaratorPrivate ValaCCodeFunctionDeclaratorPrivate;

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_FUNCTION_DECLARATOR (vala_ccode_function_declarator_get_type ())
#define VALA_CCODE_FUNCTION_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclarator))
#define VALA_CCODE_FUNCTION_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclaratorClass))
#define VALA_IS_CCODE_FUNCTION_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FUNCTION_DECLARATOR))
#define VALA_IS_CCODE_FUNCTION_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FUNCTION_DECLARATOR))
#define VALA_CCODE_FUNCTION_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclaratorClass))


/**
 * Represents a function pointer declarator in the C code.
 */
struct _ValaCCodeFunctionDeclarator {
	ValaCCodeDeclarator parent;
	ValaCCodeFunctionDeclaratorPrivate * priv;
};
struct _ValaCCodeFunctionDeclaratorClass {
	ValaCCodeDeclaratorClass parent;
};

ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_new (const char* n);
void vala_ccode_function_declarator_add_parameter (ValaCCodeFunctionDeclarator* self, ValaCCodeFormalParameter* param);
char* vala_ccode_function_declarator_get_name (ValaCCodeFunctionDeclarator* self);
void vala_ccode_function_declarator_set_name (ValaCCodeFunctionDeclarator* self, const char* value);
GType vala_ccode_function_declarator_get_type ();

G_END_DECLS

#endif
