/* valaconstant.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACONSTANT_H__
#define __VALACONSTANT_H__
typedef struct _ValaConstantPrivate ValaConstantPrivate;

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valamember.h>
#include <vala/valalockable.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))


/**
 * Represents a type member with a constant value.
 */
struct _ValaConstant {
	ValaMember parent;
	ValaConstantPrivate * priv;
	ValaMemberAccessibility access;
};
struct _ValaConstantClass {
	ValaMemberClass parent;
};

ValaConstant* vala_constant_new (const char* _name, ValaTypeReference* type, ValaExpression* init, ValaSourceReference* source);
char* vala_constant_get_cname (ValaConstant* self);
char* vala_constant_get_name (ValaConstant* self);
void vala_constant_set_name (ValaConstant* self, const char* value);
ValaTypeReference* vala_constant_get_type_reference (ValaConstant* self);
void vala_constant_set_type_reference (ValaConstant* self, ValaTypeReference* value);
ValaExpression* vala_constant_get_initializer (ValaConstant* self);
void vala_constant_set_initializer (ValaConstant* self, ValaExpression* value);
GType vala_constant_get_type ();

G_END_DECLS

#endif
