/* valaconstructor.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaconstructor.h"
#include <vala/valastatement.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valaconstructor.h>

struct _ValaConstructorPrivate {
	ValaStatement* _body;
	gboolean _instance;
};
#define VALA_CONSTRUCTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONSTRUCTOR, ValaConstructorPrivate))
enum  {
	VALA_CONSTRUCTOR_DUMMY_PROPERTY,
	VALA_CONSTRUCTOR_BODY,
	VALA_CONSTRUCTOR_INSTANCE
};
static void vala_constructor_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_constructor_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_constructor_parent_class = NULL;
static void vala_constructor_dispose (GObject * obj);


/**
 * Creates a new constructor.
 *
 * @param source reference to source code
 * @return       newly created constructor
 */
ValaConstructor* vala_constructor_new (ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaConstructor * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_CONSTRUCTOR, __params_it - __params, __params);
	return self;
}


static void vala_constructor_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaConstructor * self;
	self = VALA_CONSTRUCTOR (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_constructor (visitor, self);
}


static void vala_constructor_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaConstructor * self;
	self = VALA_CONSTRUCTOR (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_constructor_get_body (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_constructor_get_body (self)), visitor);
	}
}


ValaStatement* vala_constructor_get_body (ValaConstructor* self)
{
	g_return_val_if_fail (VALA_IS_CONSTRUCTOR (self), NULL);
	return self->priv->_body;
}


void vala_constructor_set_body (ValaConstructor* self, ValaStatement* value)
{
	ValaStatement* __temp2;
	ValaStatement* __temp1;
	g_return_if_fail (VALA_IS_CONSTRUCTOR (self));
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->_body = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp2);
}


gboolean vala_constructor_get_instance (ValaConstructor* self)
{
	g_return_val_if_fail (VALA_IS_CONSTRUCTOR (self), FALSE);
	return self->priv->_instance;
}


void vala_constructor_set_instance (ValaConstructor* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CONSTRUCTOR (self));
	self->priv->_instance = value;
}


static void vala_constructor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaConstructor * self;
	self = VALA_CONSTRUCTOR (object);
	switch (property_id) {
		case VALA_CONSTRUCTOR_BODY:
		g_value_set_object (value, vala_constructor_get_body (self));
		break;
		case VALA_CONSTRUCTOR_INSTANCE:
		g_value_set_boolean (value, vala_constructor_get_instance (self));
		break;
	}
}


static void vala_constructor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaConstructor * self;
	self = VALA_CONSTRUCTOR (object);
	switch (property_id) {
		case VALA_CONSTRUCTOR_BODY:
		vala_constructor_set_body (self, g_value_get_object (value));
		break;
		case VALA_CONSTRUCTOR_INSTANCE:
		vala_constructor_set_instance (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_constructor_class_init (ValaConstructorClass * klass)
{
	vala_constructor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaConstructorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_constructor_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_constructor_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_constructor_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_constructor_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_constructor_real_accept_children;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CONSTRUCTOR_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CONSTRUCTOR_INSTANCE, g_param_spec_boolean ("instance", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_constructor_init (ValaConstructor * self)
{
	self->priv = VALA_CONSTRUCTOR_GET_PRIVATE (self);
	self->priv->_instance = TRUE;
}


static void vala_constructor_dispose (GObject * obj)
{
	ValaConstructor * self;
	ValaConstructorClass * klass;
	GObjectClass * parent_class;
	self = VALA_CONSTRUCTOR (obj);
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	klass = VALA_CONSTRUCTOR_CLASS (g_type_class_peek (VALA_TYPE_CONSTRUCTOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_constructor_get_type ()
{
	static GType vala_constructor_type_id = 0;
	if (G_UNLIKELY (vala_constructor_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConstructorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_constructor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConstructor), 0, (GInstanceInitFunc) vala_constructor_init };
		vala_constructor_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaConstructor", &g_define_type_info, 0);
	}
	return vala_constructor_type_id;
}




