/* valainstancecast.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valainstancecast.h"
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valainstancecast.h>

struct _ValaInstanceCastPrivate {
	ValaDataType* _type_reference;
	ValaCCodeExpression* _inner;
};
#define VALA_INSTANCE_CAST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INSTANCE_CAST, ValaInstanceCastPrivate))
enum  {
	VALA_INSTANCE_CAST_DUMMY_PROPERTY,
	VALA_INSTANCE_CAST_TYPE_REFERENCE,
	VALA_INSTANCE_CAST_INNER
};
static GObject * vala_instance_cast_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_instance_cast_parent_class = NULL;
static void vala_instance_cast_dispose (GObject * obj);


/**
 * Creates a new instance cast expression.
 *
 * @param expr an expression
 * @param type the target type
 * @return     newly created instance cast expression
 */
ValaInstanceCast* vala_instance_cast_new (ValaCCodeExpression* expr, ValaDataType* type)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaInstanceCast * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expr), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "inner", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, expr), __params_it++);
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_DATA_TYPE), g_value_set_object (&__params_it->value, type), __params_it++);
	self = g_object_newv (VALA_TYPE_INSTANCE_CAST, __params_it - __params, __params);
	return self;
}


ValaDataType* vala_instance_cast_get_type_reference (ValaInstanceCast* self)
{
	g_return_val_if_fail (VALA_IS_INSTANCE_CAST (self), NULL);
	return self->priv->_type_reference;
}


void vala_instance_cast_set_type_reference (ValaInstanceCast* self, ValaDataType* value)
{
	ValaDataType* __temp1;
	g_return_if_fail (VALA_IS_INSTANCE_CAST (self));
	__temp1 = NULL;
	self->priv->_type_reference = (__temp1 = g_object_ref (value), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp1);
}


ValaCCodeExpression* vala_instance_cast_get_inner (ValaInstanceCast* self)
{
	g_return_val_if_fail (VALA_IS_INSTANCE_CAST (self), NULL);
	return self->priv->_inner;
}


void vala_instance_cast_set_inner (ValaInstanceCast* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp3;
	g_return_if_fail (VALA_IS_INSTANCE_CAST (self));
	__temp3 = NULL;
	self->priv->_inner = (__temp3 = g_object_ref (value), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), __temp3);
}


static GObject * vala_instance_cast_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaInstanceCastClass * klass;
	GObjectClass * parent_class;
	ValaInstanceCast * self;
	klass = VALA_INSTANCE_CAST_CLASS (g_type_class_peek (VALA_TYPE_INSTANCE_CAST));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_INSTANCE_CAST (obj);
	{
		ValaCCodeIdentifier* __temp4;
		__temp4 = NULL;
		(vala_ccode_function_call_set_call (VALA_CCODE_FUNCTION_CALL (self), VALA_CCODE_EXPRESSION ((__temp4 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_instance_cast_get_type_reference (self), NULL))))), vala_ccode_function_call_get_call (VALA_CCODE_FUNCTION_CALL (self)));
		(__temp4 == NULL ? NULL : (__temp4 = (g_object_unref (__temp4), NULL)));
		vala_ccode_function_call_add_argument (VALA_CCODE_FUNCTION_CALL (self), VALA_CCODE_EXPRESSION (vala_instance_cast_get_inner (self)));
	}
	return obj;
}


static void vala_instance_cast_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaInstanceCast * self;
	self = VALA_INSTANCE_CAST (object);
	switch (property_id) {
		case VALA_INSTANCE_CAST_TYPE_REFERENCE:
		g_value_set_object (value, vala_instance_cast_get_type_reference (self));
		break;
		case VALA_INSTANCE_CAST_INNER:
		g_value_set_object (value, vala_instance_cast_get_inner (self));
		break;
	}
}


static void vala_instance_cast_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaInstanceCast * self;
	self = VALA_INSTANCE_CAST (object);
	switch (property_id) {
		case VALA_INSTANCE_CAST_TYPE_REFERENCE:
		vala_instance_cast_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_INSTANCE_CAST_INNER:
		vala_instance_cast_set_inner (self, g_value_get_object (value));
		break;
	}
}


static void vala_instance_cast_class_init (ValaInstanceCastClass * klass)
{
	vala_instance_cast_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaInstanceCastPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_instance_cast_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_instance_cast_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_instance_cast_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_instance_cast_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_INSTANCE_CAST_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_INSTANCE_CAST_INNER, g_param_spec_object ("inner", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_instance_cast_init (ValaInstanceCast * self)
{
	self->priv = VALA_INSTANCE_CAST_GET_PRIVATE (self);
}


static void vala_instance_cast_dispose (GObject * obj)
{
	ValaInstanceCast * self;
	ValaInstanceCastClass * klass;
	GObjectClass * parent_class;
	self = VALA_INSTANCE_CAST (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	klass = VALA_INSTANCE_CAST_CLASS (g_type_class_peek (VALA_TYPE_INSTANCE_CAST));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_instance_cast_get_type ()
{
	static GType vala_instance_cast_type_id = 0;
	if (G_UNLIKELY (vala_instance_cast_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInstanceCastClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_instance_cast_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInstanceCast), 0, (GInstanceInitFunc) vala_instance_cast_init };
		vala_instance_cast_type_id = g_type_register_static (VALA_TYPE_CCODE_FUNCTION_CALL, "ValaInstanceCast", &g_define_type_info, 0);
	}
	return vala_instance_cast_type_id;
}




