/* valamethod.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALAMETHOD_H__
#define __VALAMETHOD_H__
typedef struct _ValaMethodPrivate ValaMethodPrivate;

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valamember.h>
#include <vala/valainvokable.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))


/**
 * Represents a type or namespace method.
 */
struct _ValaMethod {
	ValaMember parent;
	ValaMethodPrivate * priv;
	ValaMemberAccessibility access;
};
struct _ValaMethodClass {
	ValaMemberClass parent;
	char* (*get_default_cname) (ValaMethod* self);
};

ValaMethod* vala_method_new (const char* _name, ValaTypeReference* _return_type, ValaSourceReference* source);
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param);
char* vala_method_get_cname (ValaMethod* self);
char* vala_method_get_default_cname (ValaMethod* self);
char* vala_method_get_real_cname (ValaMethod* self);
void vala_method_set_cname (ValaMethod* self, const char* cname);
void vala_method_process_attributes (ValaMethod* self);
gboolean vala_method_equals (ValaMethod* self, ValaMethod* m2);
char* vala_method_get_name (ValaMethod* self);
void vala_method_set_name (ValaMethod* self, const char* value);
ValaTypeReference* vala_method_get_return_type (ValaMethod* self);
void vala_method_set_return_type (ValaMethod* self, ValaTypeReference* value);
ValaBlock* vala_method_get_body (ValaMethod* self);
void vala_method_set_body (ValaMethod* self, ValaBlock* value);
gboolean vala_method_get_instance (ValaMethod* self);
void vala_method_set_instance (ValaMethod* self, gboolean value);
gboolean vala_method_get_is_abstract (ValaMethod* self);
void vala_method_set_is_abstract (ValaMethod* self, gboolean value);
gboolean vala_method_get_is_virtual (ValaMethod* self);
void vala_method_set_is_virtual (ValaMethod* self, gboolean value);
gboolean vala_method_get_overrides (ValaMethod* self);
void vala_method_set_overrides (ValaMethod* self, gboolean value);
gboolean vala_method_get_returns_modified_pointer (ValaMethod* self);
void vala_method_set_returns_modified_pointer (ValaMethod* self, gboolean value);
gboolean vala_method_get_instance_last (ValaMethod* self);
void vala_method_set_instance_last (ValaMethod* self, gboolean value);
gboolean vala_method_get_instance_by_reference (ValaMethod* self);
void vala_method_set_instance_by_reference (ValaMethod* self, gboolean value);
ValaMethod* vala_method_get_base_method (ValaMethod* self);
void vala_method_set_base_method (ValaMethod* self, ValaMethod* value);
ValaMethod* vala_method_get_base_interface_method (ValaMethod* self);
void vala_method_set_base_interface_method (ValaMethod* self, ValaMethod* value);
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value);
gboolean vala_method_get_no_array_length (ValaMethod* self);
void vala_method_set_no_array_length (ValaMethod* self, gboolean value);
gboolean vala_method_get_printf_format (ValaMethod* self);
void vala_method_set_printf_format (ValaMethod* self, gboolean value);
GType vala_method_get_type ();

G_END_DECLS

#endif
