[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeassignment.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeassignment.h")]
	public class CCodeAssignment : Vala.CCodeExpression {
		public CCodeAssignment (Vala.CCodeExpression l, Vala.CCodeExpression r, Vala.CCodeAssignmentOperator op = CCodeAssignmentOperator.SIMPLE);
		public Vala.CCodeExpression left { get; construct; }
		public weak Vala.CCodeAssignmentOperator operator { get; set; }
		public Vala.CCodeExpression right { get; construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeassignment.h")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_ASSIGNMENT_OPERATOR_")]
	public enum CCodeAssignmentOperator {
		SIMPLE,
		BITWISE_OR,
		BITWISE_AND,
		BITWISE_XOR,
		ADD,
		SUB,
		MUL,
		DIV,
		PERCENT,
		SHIFT_LEFT,
		SHIFT_RIGHT,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodebinaryexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodebinaryexpression.h")]
	public class CCodeBinaryExpression : Vala.CCodeExpression {
		public CCodeBinaryExpression (Vala.CCodeBinaryOperator op, Vala.CCodeExpression! l, Vala.CCodeExpression! r);
		public weak Vala.CCodeBinaryOperator operator { get; set; }
		public Vala.CCodeExpression left { get; set construct; }
		public Vala.CCodeExpression right { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodebinaryexpression.h")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_BINARY_OPERATOR_")]
	public enum CCodeBinaryOperator {
		PLUS,
		MINUS,
		MUL,
		DIV,
		MOD,
		SHIFT_LEFT,
		SHIFT_RIGHT,
		LESS_THAN,
		GREATER_THAN,
		LESS_THAN_OR_EQUAL,
		GREATER_THAN_OR_EQUAL,
		EQUALITY,
		INEQUALITY,
		BITWISE_AND,
		BITWISE_OR,
		BITWISE_XOR,
		AND,
		OR,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeblock.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeblock.h")]
	public class CCodeBlock : Vala.CCodeStatement {
		public void prepend_statement (Vala.CCodeNode! statement);
		public void add_statement (Vala.CCodeNode! statement);
		public weak bool suppress_newline { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodebreakstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodebreakstatement.h")]
	public class CCodeBreakStatement : Vala.CCodeStatement {
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodecasestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecasestatement.h")]
	public class CCodeCaseStatement : Vala.CCodeStatement {
		public CCodeCaseStatement (Vala.CCodeExpression! expr);
		public void add_statement (Vala.CCodeStatement! stmt);
		public Vala.CCodeExpression expression { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodecastexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecastexpression.h")]
	public class CCodeCastExpression : Vala.CCodeExpression {
		public CCodeCastExpression (Vala.CCodeExpression! expr, string! type);
		public Vala.CCodeExpression inner { get; set construct; }
		public string type_name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodecommaexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecommaexpression.h")]
	public class CCodeCommaExpression : Vala.CCodeExpression {
		public void append_expression (Vala.CCodeExpression! expr);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodecomment.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecomment.h")]
	public class CCodeComment : Vala.CCodeNode {
		public CCodeComment (string! _text);
		public string text { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeconditionalexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeconditionalexpression.h")]
	public class CCodeConditionalExpression : Vala.CCodeExpression {
		public CCodeConditionalExpression (Vala.CCodeExpression! cond, Vala.CCodeExpression! true_expr, Vala.CCodeExpression! false_expr);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeExpression true_expression { get; set construct; }
		public Vala.CCodeExpression false_expression { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeconstant.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeconstant.h")]
	public class CCodeConstant : Vala.CCodeExpression {
		public CCodeConstant (string! _name);
		public string name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodecontinuestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodecontinuestatement.h")]
	public class CCodeContinueStatement : Vala.CCodeStatement {
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodedeclaration.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodedeclaration.h")]
	public class CCodeDeclaration : Vala.CCodeStatement {
		public CCodeDeclaration (string! _type_name);
		public void add_declarator (Vala.CCodeDeclarator! decl);
		public string type_name { get; set construct; }
		public weak Vala.CCodeModifiers modifiers { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodedeclarator.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodedeclarator.h")]
	public abstract class CCodeDeclarator : Vala.CCodeNode {
		public virtual void write_initialization (Vala.CCodeWriter! writer);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodedostatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodedostatement.h")]
	public class CCodeDoStatement : Vala.CCodeStatement {
		public CCodeDoStatement (Vala.CCodeStatement stmt, Vala.CCodeExpression! cond);
		public Vala.CCodeStatement body { get; set; }
		public Vala.CCodeExpression condition { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeemptystatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeemptystatement.h")]
	public class CCodeEmptyStatement : Vala.CCodeStatement {
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeenum.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeenum.h")]
	public class CCodeEnum : Vala.CCodeNode {
		public CCodeEnum (string n = null);
		public void add_value (string! name, string value = null);
		public string name { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeexpression.h")]
	public abstract class CCodeExpression : Vala.CCodeNode {
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeexpressionstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeexpressionstatement.h")]
	public class CCodeExpressionStatement : Vala.CCodeStatement {
		public CCodeExpressionStatement (Vala.CCodeExpression expr);
		public Vala.CCodeExpression expression { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeformalparameter.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeformalparameter.h")]
	public class CCodeFormalParameter : Vala.CCodeNode {
		public CCodeFormalParameter (string! n, string! type);
		public string name { get; set construct; }
		public string type_name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeforstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeforstatement.h")]
	public class CCodeForStatement : Vala.CCodeStatement {
		public CCodeForStatement (Vala.CCodeExpression! cond, Vala.CCodeStatement stmt = null);
		public void add_initializer (Vala.CCodeExpression! expr);
		public void add_iterator (Vala.CCodeExpression! expr);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeStatement body { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodefragment.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodefragment.h")]
	public class CCodeFragment : Vala.CCodeNode {
		public void append (Vala.CCodeNode! node);
		public GLib.List get_children ();
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodefunction.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodefunction.h")]
	public class CCodeFunction : Vala.CCodeNode {
		public CCodeFunction (string! _name, string! _return_type);
		public void add_parameter (Vala.CCodeFormalParameter! param);
		public Vala.CCodeFunction! copy ();
		public string name { get; set construct; }
		public weak Vala.CCodeModifiers modifiers { get; set; }
		public string return_type { get; set construct; }
		public Vala.CCodeBlock block { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodefunctioncall.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodefunctioncall.h")]
	public class CCodeFunctionCall : Vala.CCodeExpression {
		public CCodeFunctionCall (Vala.CCodeExpression _call = null);
		public void add_argument (Vala.CCodeExpression! expr);
		public Vala.CCodeExpression call { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodefunctiondeclarator.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodefunctiondeclarator.h")]
	public class CCodeFunctionDeclarator : Vala.CCodeDeclarator {
		public CCodeFunctionDeclarator (string! n);
		public void add_parameter (Vala.CCodeFormalParameter! param);
		public string name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeidentifier.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeidentifier.h")]
	public class CCodeIdentifier : Vala.CCodeExpression {
		public CCodeIdentifier (string! _name);
		public string name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeifstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeifstatement.h")]
	public class CCodeIfStatement : Vala.CCodeStatement {
		public CCodeIfStatement (Vala.CCodeExpression! cond, Vala.CCodeStatement! true_stmt, Vala.CCodeStatement false_stmt = null);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeStatement true_statement { get; set construct; }
		public Vala.CCodeStatement false_statement { get; set construct; }
		public weak bool else_if { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeincludedirective.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeincludedirective.h")]
	public class CCodeIncludeDirective : Vala.CCodeNode {
		public CCodeIncludeDirective (string! _filename, bool _local = false);
		public string filename { get; set construct; }
		public weak bool local { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeinitializerlist.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeinitializerlist.h")]
	public class CCodeInitializerList : Vala.CCodeExpression {
		public void append (Vala.CCodeExpression! expr);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodelinedirective.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodelinedirective.h")]
	public class CCodeLineDirective : Vala.CCodeNode {
		public CCodeLineDirective (string! _filename, int _line);
		public string filename { get; set construct; }
		public weak int line { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodemacroreplacement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodemacroreplacement.h")]
	public class CCodeMacroReplacement : Vala.CCodeNode {
		public CCodeMacroReplacement (string! n, string! replace);
		public string name { get; set construct; }
		public string replacement { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodememberaccess.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodememberaccess.h")]
	public class CCodeMemberAccess : Vala.CCodeExpression {
		public CCodeMemberAccess (Vala.CCodeExpression! container, string! member, bool pointer = false);
		public CCodeMemberAccess.pointer (Vala.CCodeExpression! container, string! member);
		public Vala.CCodeExpression inner { get; set construct; }
		public string member_name { get; set construct; }
		public weak bool is_pointer { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodemodifiers.h")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_MODIFIERS_")]
	public enum CCodeModifiers {
		NONE,
		STATIC,
		REGISTER,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodenewline.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodenewline.h")]
	public class CCodeNewline : Vala.CCodeNode {
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodenode.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodenode.h")]
	public abstract class CCodeNode : GLib.Object {
		public abstract void write (Vala.CCodeWriter! writer);
		public virtual void write_declaration (Vala.CCodeWriter! writer);
		public Vala.CCodeLineDirective line { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeoncesection.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeoncesection.h")]
	public class CCodeOnceSection : Vala.CCodeFragment {
		public CCodeOnceSection (string! def);
		public string define { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeparenthesizedexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeparenthesizedexpression.h")]
	public class CCodeParenthesizedExpression : Vala.CCodeExpression {
		public CCodeParenthesizedExpression (Vala.CCodeExpression! expr);
		public Vala.CCodeExpression inner { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodereturnstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodereturnstatement.h")]
	public class CCodeReturnStatement : Vala.CCodeStatement {
		public CCodeReturnStatement (Vala.CCodeExpression expr = null);
		public Vala.CCodeExpression return_expression { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodestatement.h")]
	public abstract class CCodeStatement : Vala.CCodeNode {
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodestruct.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodestruct.h")]
	public class CCodeStruct : Vala.CCodeNode {
		public CCodeStruct (string! n);
		public void add_declaration (Vala.CCodeDeclaration! decl);
		public void add_field (string! type_name, string! name);
		public string name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeswitchstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeswitchstatement.h")]
	public class CCodeSwitchStatement : Vala.CCodeStatement {
		public CCodeSwitchStatement (Vala.CCodeExpression! expr);
		public void add_case (Vala.CCodeCaseStatement! case_stmt);
		public Vala.CCodeExpression expression { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodetypedefinition.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodetypedefinition.h")]
	public class CCodeTypeDefinition : Vala.CCodeNode {
		public CCodeTypeDefinition (string type, Vala.CCodeDeclarator decl);
		public string type_name { get; set; }
		public Vala.CCodeDeclarator declarator { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeunaryexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeunaryexpression.h")]
	public class CCodeUnaryExpression : Vala.CCodeExpression {
		public CCodeUnaryExpression (Vala.CCodeUnaryOperator op, Vala.CCodeExpression! expr);
		public weak Vala.CCodeUnaryOperator operator { get; set; }
		public Vala.CCodeExpression inner { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeunaryexpression.h")]
namespace Vala {
	[CCode (cprefix = "VALA_CCODE_UNARY_OPERATOR_")]
	public enum CCodeUnaryOperator {
		PLUS,
		MINUS,
		LOGICAL_NEGATION,
		BITWISE_COMPLEMENT,
		POINTER_INDIRECTION,
		ADDRESS_OF,
		PREFIX_INCREMENT,
		PREFIX_DECREMENT,
		POSTFIX_INCREMENT,
		POSTFIX_DECREMENT,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodevariabledeclarator.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodevariabledeclarator.h")]
	public class CCodeVariableDeclarator : Vala.CCodeDeclarator {
		public CCodeVariableDeclarator (string! _name);
		public CCodeVariableDeclarator.with_initializer (string! _name, Vala.CCodeExpression init);
		public string name { get; set construct; }
		public Vala.CCodeExpression initializer { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodewhilestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodewhilestatement.h")]
	public class CCodeWhileStatement : Vala.CCodeStatement {
		public CCodeWhileStatement (Vala.CCodeExpression! cond, Vala.CCodeStatement stmt = null);
		public Vala.CCodeExpression condition { get; set construct; }
		public Vala.CCodeStatement body { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodewriter.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodewriter.h")]
	public class CCodeWriter : GLib.Object {
		public CCodeWriter (string! _filename);
		public void close ();
		public void write_indent ();
		public void write_string (string! s);
		public void write_newline ();
		public void write_begin_block ();
		public void write_end_block ();
		public void write_comment (string! text);
		public string filename { get; construct; }
		public weak bool bol { get; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "ccode/valaccodeelementaccess.h")]
namespace Vala {
	[CCode (cheader_filename = "ccode/valaccodeelementaccess.h")]
	public class CCodeElementAccess : Vala.CCodeExpression {
		public CCodeElementAccess (Vala.CCodeExpression! cont, Vala.CCodeExpression! i);
		public Vala.CCodeExpression container { get; set construct; }
		public Vala.CCodeExpression index { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaaddressofexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaaddressofexpression.h")]
	public class AddressofExpression : Vala.Expression {
		public AddressofExpression (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.Expression inner { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaarray.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaarray.h")]
	public class Array : Vala.DataType {
		public Array (Vala.DataType! _element_type, int _rank, Vala.SourceReference! _source_reference);
		public Array.with_type_parameter (Vala.TypeParameter! _element_type_parameter, int _rank, Vala.SourceReference! _source_reference);
		public Vala.ArrayLengthField get_length_field ();
		public Vala.ArrayResizeMethod get_resize_method ();
		public Vala.DataType element_type { get; set construct; }
		public Vala.TypeParameter element_type_parameter { get; set construct; }
		public weak int rank { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaarraycreationexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaarraycreationexpression.h")]
	public class ArrayCreationExpression : Vala.Expression {
		public void append_size (Vala.Expression! size);
		public GLib.List get_sizes ();
		public ArrayCreationExpression (Vala.TypeReference _element_type, int _rank, Vala.InitializerList _initializer, Vala.SourceReference source);
		public Vala.TypeReference element_type { get; set construct; }
		public weak int rank { get; set construct; }
		public Vala.InitializerList initializer_list { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaarraylengthfield.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaarraylengthfield.h")]
	public class ArrayLengthField : Vala.Field {
		public ArrayLengthField (Vala.SourceReference! source);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaarrayresizemethod.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaarrayresizemethod.h")]
	public class ArrayResizeMethod : Vala.Method {
		public ArrayResizeMethod (Vala.SourceReference! _source_reference);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaassignment.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaassignment.h")]
	public class Assignment : Vala.Expression {
		public Assignment (Vala.Expression! _left, Vala.Expression! _right, Vala.AssignmentOperator _op = AssignmentOperator.SIMPLE, Vala.SourceReference _source = null);
		public Vala.Expression left { get; set construct; }
		public weak Vala.AssignmentOperator operator { get; set; }
		public Vala.Expression right { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaassignment.h")]
namespace Vala {
	[CCode (cprefix = "VALA_ASSIGNMENT_OPERATOR_")]
	public enum AssignmentOperator {
		SIMPLE,
		BITWISE_OR,
		BITWISE_AND,
		BITWISE_XOR,
		ADD,
		SUB,
		MUL,
		DIV,
		PERCENT,
		SHIFT_LEFT,
		SHIFT_RIGHT,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaattribute.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaattribute.h")]
	public class Attribute : Vala.CodeNode {
		public GLib.List<Vala.NamedArgument> args;
		public Attribute (string! _name, Vala.SourceReference source);
		public void add_argument (Vala.NamedArgument! arg);
		public bool has_argument (string! name);
		public string get_string (string! name);
		public int get_integer (string! name);
		public bool get_bool (string! name);
		public string name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaattributeprocessor.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaattributeprocessor.h")]
	public class AttributeProcessor : Vala.CodeVisitor {
		public void process (Vala.CodeContext! context);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valabaseaccess.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valabaseaccess.h")]
	public class BaseAccess : Vala.Expression {
		public BaseAccess (Vala.SourceReference source = null);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valabinaryexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valabinaryexpression.h")]
	public class BinaryExpression : Vala.Expression {
		public BinaryExpression (Vala.BinaryOperator op, Vala.Expression! _left, Vala.Expression! _right, Vala.SourceReference source = null);
		public weak Vala.BinaryOperator operator { get; set; }
		public Vala.Expression left { get; set construct; }
		public Vala.Expression right { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valabinaryexpression.h")]
namespace Vala {
	[CCode (cprefix = "VALA_BINARY_OPERATOR_")]
	public enum BinaryOperator {
		PLUS,
		MINUS,
		MUL,
		DIV,
		MOD,
		SHIFT_LEFT,
		SHIFT_RIGHT,
		LESS_THAN,
		GREATER_THAN,
		LESS_THAN_OR_EQUAL,
		GREATER_THAN_OR_EQUAL,
		EQUALITY,
		INEQUALITY,
		BITWISE_AND,
		BITWISE_OR,
		BITWISE_XOR,
		AND,
		OR,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valablock.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valablock.h")]
	public class Block : Vala.Statement {
		public Block (Vala.SourceReference source = null);
		public void add_statement (Vala.Statement! stmt);
		public GLib.List get_statements ();
		public void add_local_variable (Vala.VariableDeclarator! decl);
		public GLib.List get_local_variables ();
		public weak bool contains_jump_statement { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valabooleanliteral.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valabooleanliteral.h")]
	public class BooleanLiteral : Vala.Literal {
		public BooleanLiteral (bool b, Vala.SourceReference source);
		public weak bool value { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valabreakstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valabreakstatement.h")]
	public class BreakStatement : Vala.Statement {
		public BreakStatement (Vala.SourceReference source);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacallback.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacallback.h")]
	public class Callback : Vala.DataType {
		public Callback (string _name, Vala.TypeReference _return_type, Vala.SourceReference source = null);
		public void add_type_parameter (Vala.TypeParameter! p);
		public void add_parameter (Vala.FormalParameter! param);
		public GLib.List get_parameters ();
		public bool matches_method (Vala.Method! m);
		public void set_cname (string cname);
		public void process_attributes ();
		public Vala.TypeReference return_type { get; set; }
		public weak bool instance { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacastexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacastexpression.h")]
	public class CastExpression : Vala.Expression {
		public CastExpression (Vala.Expression! _inner, Vala.TypeReference! type, Vala.SourceReference source);
		public Vala.Expression inner { get; set construct; }
		public Vala.TypeReference type_reference { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacatchclause.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacatchclause.h")]
	public class CatchClause : Vala.CodeNode {
		public CatchClause (Vala.TypeReference type_reference, string variable_name, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.TypeReference type_reference { get; set; }
		public string variable_name { get; set; }
		public Vala.Block body { get; set; }
		public Vala.VariableDeclarator variable_declarator { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacharacterliteral.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacharacterliteral.h")]
	public class CharacterLiteral : Vala.Literal {
		public CharacterLiteral (string! c, Vala.SourceReference source);
		public unichar get_char ();
		public string value { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaclass.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaclass.h")]
	public class Class : Vala.DataType {
		public Class (string! _name, Vala.SourceReference source = null);
		public void add_base_type (Vala.TypeReference! type);
		public GLib.List get_base_types ();
		public void add_type_parameter (Vala.TypeParameter! p);
		public GLib.List get_type_parameters ();
		public void add_constant (Vala.Constant! c);
		public void add_field (Vala.Field! f);
		public GLib.List get_fields ();
		public void add_method (Vala.Method! m);
		public GLib.List get_methods ();
		public void add_property (Vala.Property! prop, bool no_field = false);
		public GLib.List get_properties ();
		public void add_signal (Vala.Signal! sig);
		public GLib.List get_signals ();
		public void set_cname (string! cname);
		public void process_attributes ();
		public Vala.Class base_class { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_static { get; set; }
		public weak bool has_private_fields { get; }
		public Vala.Method default_construction_method { get; set; }
		public Vala.Constructor constructor { get; set; }
		public Vala.Destructor destructor { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacodecontext.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacodecontext.h")]
	public class CodeContext : GLib.Object {
		public Vala.Symbol! get_root ();
		public GLib.List get_source_files ();
		public void add_source_file (Vala.SourceFile! file);
		public GLib.List get_packages ();
		public bool has_package (string! pkg);
		public void add_package (string! pkg);
		public void accept (Vala.CodeVisitor! visitor);
		public void find_header_cycles ();
		public string library { get; set; }
		public weak bool memory_management { get; set; }
		public weak bool assert { get; set; }
		public weak bool checking { get; set; }
		public weak bool ccode_only { get; set; }
		public weak bool compile_only { get; set; }
		public string output { get; set; }
		public weak bool debug { get; set; }
		public weak int optlevel { get; set; }
		public Vala.Method module_init_method { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacodenode.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacodenode.h")]
	public abstract class CodeNode : GLib.Object {
		public GLib.List<Vala.Attribute> attributes;
		public virtual void accept (Vala.CodeVisitor! visitor);
		public virtual void accept_children (Vala.CodeVisitor! visitor);
		public virtual void replace (Vala.CodeNode! old_node, Vala.CodeNode! new_node);
		public Vala.Attribute get_attribute (string! name);
		public virtual string! to_string ();
		public Vala.CodeNode parent_node { get; set; }
		public Vala.Symbol symbol { get; set; }
		public Vala.SourceReference source_reference { get; set construct; }
		public Vala.CCodeNode ccodenode { get; set; }
		public weak bool error { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacodevisitor.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacodevisitor.h")]
	public abstract class CodeVisitor : GLib.Object {
		public virtual void visit_source_file (Vala.SourceFile! source_file);
		public virtual void visit_namespace (Vala.Namespace! ns);
		public virtual void visit_class (Vala.Class! cl);
		public virtual void visit_struct (Vala.Struct! st);
		public virtual void visit_interface (Vala.Interface! iface);
		public virtual void visit_enum (Vala.Enum! en);
		public virtual void visit_enum_value (Vala.EnumValue! ev);
		public virtual void visit_flags (Vala.Flags! fl);
		public virtual void visit_flags_value (Vala.FlagsValue! fv);
		public virtual void visit_callback (Vala.Callback! cb);
		public virtual void visit_member (Vala.Member! m);
		public virtual void visit_constant (Vala.Constant! c);
		public virtual void visit_field (Vala.Field! f);
		public virtual void visit_method (Vala.Method! m);
		public virtual void visit_creation_method (Vala.CreationMethod! m);
		public virtual void visit_formal_parameter (Vala.FormalParameter! p);
		public virtual void visit_property (Vala.Property! prop);
		public virtual void visit_property_accessor (Vala.PropertyAccessor! acc);
		public virtual void visit_signal (Vala.Signal! sig);
		public virtual void visit_constructor (Vala.Constructor! c);
		public virtual void visit_destructor (Vala.Destructor! d);
		public virtual void visit_named_argument (Vala.NamedArgument! n);
		public virtual void visit_type_parameter (Vala.TypeParameter! p);
		public virtual void visit_namespace_reference (Vala.NamespaceReference! ns);
		public virtual void visit_type_reference (Vala.TypeReference! type);
		public virtual void visit_begin_block (Vala.Block! b);
		public virtual void visit_end_block (Vala.Block! b);
		public virtual void visit_empty_statement (Vala.EmptyStatement! stmt);
		public virtual void visit_declaration_statement (Vala.DeclarationStatement! stmt);
		public virtual void visit_local_variable_declaration (Vala.LocalVariableDeclaration! decl);
		public virtual void visit_variable_declarator (Vala.VariableDeclarator! decl);
		public virtual void visit_begin_initializer_list (Vala.InitializerList! list);
		public virtual void visit_end_initializer_list (Vala.InitializerList! list);
		public virtual void visit_expression_statement (Vala.ExpressionStatement! stmt);
		public virtual void visit_if_statement (Vala.IfStatement! stmt);
		public virtual void visit_switch_statement (Vala.SwitchStatement! stmt);
		public virtual void visit_switch_section (Vala.SwitchSection! section);
		public virtual void visit_switch_label (Vala.SwitchLabel! label);
		public virtual void visit_while_statement (Vala.WhileStatement! stmt);
		public virtual void visit_do_statement (Vala.DoStatement! stmt);
		public virtual void visit_for_statement (Vala.ForStatement! stmt);
		public virtual void visit_begin_foreach_statement (Vala.ForeachStatement! stmt);
		public virtual void visit_end_foreach_statement (Vala.ForeachStatement! stmt);
		public virtual void visit_break_statement (Vala.BreakStatement! stmt);
		public virtual void visit_continue_statement (Vala.ContinueStatement! stmt);
		public virtual void visit_begin_return_statement (Vala.ReturnStatement! stmt);
		public virtual void visit_end_return_statement (Vala.ReturnStatement! stmt);
		public virtual void visit_begin_throw_statement (Vala.ThrowStatement! stmt);
		public virtual void visit_end_throw_statement (Vala.ThrowStatement! stmt);
		public virtual void visit_begin_try_statement (Vala.TryStatement! stmt);
		public virtual void visit_end_try_statement (Vala.TryStatement! stmt);
		public virtual void visit_begin_catch_clause (Vala.CatchClause! clause);
		public virtual void visit_end_catch_clause (Vala.CatchClause! clause);
		public virtual void visit_lock_statement (Vala.LockStatement! stmt);
		public virtual void visit_begin_array_creation_expression (Vala.ArrayCreationExpression! expr);
		public virtual void visit_end_array_creation_expression (Vala.ArrayCreationExpression! expr);
		public virtual void visit_boolean_literal (Vala.BooleanLiteral! lit);
		public virtual void visit_character_literal (Vala.CharacterLiteral! lit);
		public virtual void visit_integer_literal (Vala.IntegerLiteral! lit);
		public virtual void visit_real_literal (Vala.RealLiteral! lit);
		public virtual void visit_string_literal (Vala.StringLiteral! lit);
		public virtual void visit_null_literal (Vala.NullLiteral! lit);
		public virtual void visit_literal_expression (Vala.LiteralExpression! expr);
		public virtual void visit_parenthesized_expression (Vala.ParenthesizedExpression! expr);
		public virtual void visit_member_access (Vala.MemberAccess! expr);
		public virtual void visit_begin_invocation_expression (Vala.InvocationExpression! expr);
		public virtual void visit_end_invocation_expression (Vala.InvocationExpression! expr);
		public virtual void visit_element_access (Vala.ElementAccess! expr);
		public virtual void visit_base_access (Vala.BaseAccess! expr);
		public virtual void visit_postfix_expression (Vala.PostfixExpression! expr);
		public virtual void visit_begin_object_creation_expression (Vala.ObjectCreationExpression! expr);
		public virtual void visit_end_object_creation_expression (Vala.ObjectCreationExpression! expr);
		public virtual void visit_sizeof_expression (Vala.SizeofExpression! expr);
		public virtual void visit_typeof_expression (Vala.TypeofExpression! expr);
		public virtual void visit_unary_expression (Vala.UnaryExpression! expr);
		public virtual void visit_cast_expression (Vala.CastExpression! expr);
		public virtual void visit_pointer_indirection (Vala.PointerIndirection! expr);
		public virtual void visit_addressof_expression (Vala.AddressofExpression! expr);
		public virtual void visit_reference_transfer_expression (Vala.ReferenceTransferExpression! expr);
		public virtual void visit_binary_expression (Vala.BinaryExpression! expr);
		public virtual void visit_type_check (Vala.TypeCheck! expr);
		public virtual void visit_conditional_expression (Vala.ConditionalExpression! expr);
		public virtual void visit_begin_lambda_expression (Vala.LambdaExpression! expr);
		public virtual void visit_end_lambda_expression (Vala.LambdaExpression! expr);
		public virtual void visit_begin_assignment (Vala.Assignment! a);
		public virtual void visit_end_assignment (Vala.Assignment! a);
		public virtual void visit_end_full_expression (Vala.Expression! expr);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaconditionalexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaconditionalexpression.h")]
	public class ConditionalExpression : Vala.Expression {
		public ConditionalExpression (Vala.Expression! cond, Vala.Expression! true_expr, Vala.Expression! false_expr, Vala.SourceReference source);
		public Vala.Expression condition { get; set construct; }
		public Vala.Expression true_expression { get; set construct; }
		public Vala.Expression false_expression { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaconstant.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaconstant.h")]
	public class Constant : Vala.Member, Vala.Lockable {
		public Vala.MemberAccessibility access;
		public Constant (string! _name, Vala.TypeReference! type, Vala.Expression init, Vala.SourceReference source);
		public string! get_cname ();
		public bool get_lock_used ();
		public void set_lock_used (bool used);
		public string name { get; set construct; }
		public Vala.TypeReference type_reference { get; set construct; }
		public Vala.Expression initializer { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaconstructor.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaconstructor.h")]
	public class Constructor : Vala.CodeNode {
		public Constructor (Vala.SourceReference source);
		public Vala.Statement body { get; set; }
		public weak bool instance { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacontinuestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacontinuestatement.h")]
	public class ContinueStatement : Vala.Statement {
		public ContinueStatement (Vala.SourceReference source);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valacreationmethod.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valacreationmethod.h")]
	public class CreationMethod : Vala.Method {
		public CreationMethod (string name, Vala.SourceReference source_reference = null);
		public weak int n_construction_params { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valadatatype.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valadatatype.h")]
	public abstract class DataType : Vala.CodeNode {
		public Vala.MemberAccessibility access;
		public weak Vala.Namespace @namespace;
		public abstract string get_cname (bool const_type = false);
		public virtual bool is_reference_type ();
		public virtual string get_dup_function ();
		public virtual string get_free_function ();
		public virtual bool is_reference_counting ();
		public virtual string get_ref_function ();
		public virtual string get_unref_function ();
		public virtual string get_type_id ();
		public virtual string get_marshaller_type_name ();
		public virtual string get_get_value_function ();
		public virtual string get_set_value_function ();
		public virtual string get_upper_case_cname (string infix = null);
		public virtual string get_lower_case_cname (string infix = null);
		public virtual string get_lower_case_cprefix ();
		public virtual string get_default_value ();
		public virtual GLib.List get_cheader_filenames ();
		public void add_cheader_filename (string! filename);
		public Vala.Pointer! get_pointer ();
		public Vala.Array! get_array (int rank);
		public virtual bool is_subtype_of (Vala.DataType! t);
		public virtual int get_type_parameter_index (string! name);
		public string name { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valadeclarationstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valadeclarationstatement.h")]
	public class DeclarationStatement : Vala.Statement {
		public DeclarationStatement (Vala.LocalVariableDeclaration! decl, Vala.SourceReference source);
		public Vala.LocalVariableDeclaration declaration { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valadestructor.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valadestructor.h")]
	public class Destructor : Vala.CodeNode {
		public Destructor (Vala.SourceReference source);
		public Vala.Statement body { get; set; }
		public weak bool instance { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valadostatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valadostatement.h")]
	public class DoStatement : Vala.Statement {
		public DoStatement (Vala.Statement! _body, Vala.Expression! cond, Vala.SourceReference source);
		public Vala.Statement body { get; set; }
		public Vala.Expression condition { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaelementaccess.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaelementaccess.h")]
	public class ElementAccess : Vala.Expression {
		public void append_index (Vala.Expression! index);
		public GLib.List get_indices ();
		public ElementAccess (Vala.Expression _container, Vala.SourceReference source);
		public Vala.Expression container { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaemptystatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaemptystatement.h")]
	public class EmptyStatement : Vala.Statement {
		public EmptyStatement (Vala.SourceReference source);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaenum.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaenum.h")]
	public class Enum : Vala.DataType {
		public Enum (string! name, Vala.SourceReference source_reference = null);
		public void add_value (Vala.EnumValue! value);
		public void add_method (Vala.Method! m);
		public GLib.List get_methods ();
		public string! get_cprefix ();
		public void set_cprefix (string! cprefix);
		public void process_attributes ();
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaenumvalue.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaenumvalue.h")]
	public class EnumValue : Vala.CodeNode {
		public EnumValue (string! _name);
		public EnumValue.with_value (string! _name, Vala.Expression _value);
		public string! get_cname ();
		public string name { get; set construct; }
		public Vala.Expression value { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaexpression.h")]
	public abstract class Expression : Vala.CodeNode {
		public GLib.List<Vala.VariableDeclarator> temp_vars;
		public Vala.TypeReference static_type { get; set; }
		public Vala.TypeReference expected_type { get; set; }
		public Vala.Symbol symbol_reference { get; set; }
		public weak bool ref_leaked { get; set; }
		public weak bool ref_missing { get; set; }
		public weak bool ref_sink { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaexpressionstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaexpressionstatement.h")]
	public class ExpressionStatement : Vala.Statement {
		public ExpressionStatement (Vala.Expression! expr, Vala.SourceReference source = null);
		public Vala.Expression expression { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valafield.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valafield.h")]
	public class Field : Vala.Member, Vala.Invokable, Vala.Lockable {
		public Vala.MemberAccessibility access;
		public Field (string! _name, Vala.TypeReference! type, Vala.Expression init, Vala.SourceReference source);
		public string! get_cname ();
		public void process_attributes ();
		public GLib.List get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public bool get_lock_used ();
		public void set_lock_used (bool used);
		public string name { get; set construct; }
		public Vala.TypeReference type_reference { get; set construct; }
		public Vala.Expression initializer { get; set; }
		public weak bool instance { get; set; }
		public weak bool no_array_length { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaflags.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaflags.h")]
	public class Flags : Vala.DataType {
		public Flags (string! name, Vala.SourceReference source_reference = null);
		public void add_value (Vala.FlagsValue! value);
		public string! get_cprefix ();
		public void set_cprefix (string! cprefix);
		public void process_attributes ();
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaflagsvalue.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaflagsvalue.h")]
	public class FlagsValue : Vala.CodeNode {
		public FlagsValue (string! _name);
		public FlagsValue.with_value (string! _name, Vala.Expression _value);
		public string! get_cname ();
		public string name { get; set construct; }
		public Vala.Expression value { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaforeachstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaforeachstatement.h")]
	public class ForeachStatement : Vala.Statement {
		public ForeachStatement (Vala.TypeReference! type, string! id, Vala.Expression! col, Vala.Statement _body, Vala.SourceReference source);
		public Vala.TypeReference type_reference { get; set construct; }
		public string variable_name { get; set construct; }
		public Vala.Expression collection { get; set construct; }
		public Vala.Statement body { get; set; }
		public Vala.VariableDeclarator variable_declarator { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaformalparameter.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaformalparameter.h")]
	public class FormalParameter : Vala.CodeNode, Vala.Invokable {
		public FormalParameter (string! _name, Vala.TypeReference type, Vala.SourceReference source = null);
		public FormalParameter.with_ellipsis (Vala.SourceReference source = null);
		public GLib.List get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public string name { get; set construct; }
		public Vala.TypeReference type_reference { get; set; }
		public weak bool ellipsis { get; set; }
		public Vala.Expression default_expression { get; set; }
		public weak bool no_array_length { get; set; }
		public weak bool construct_parameter { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaforstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaforstatement.h")]
	public class ForStatement : Vala.Statement {
		public ForStatement (Vala.Expression cond, Vala.Statement _body, Vala.SourceReference source);
		public void add_initializer (Vala.Expression! init);
		public GLib.List get_initializer ();
		public void add_iterator (Vala.Expression! iter);
		public GLib.List get_iterator ();
		public Vala.Expression condition { get; set construct; }
		public Vala.Statement body { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaifstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaifstatement.h")]
	public class IfStatement : Vala.Statement {
		public IfStatement (Vala.Expression! cond, Vala.Block! true_stmt, Vala.Block false_stmt, Vala.SourceReference source);
		public Vala.Expression condition { get; set construct; }
		public Vala.Block true_statement { get; set construct; }
		public Vala.Block false_statement { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valainitializerlist.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valainitializerlist.h")]
	public class InitializerList : Vala.Expression {
		public void append (Vala.Expression! expr);
		public GLib.List get_initializers ();
		public InitializerList (Vala.SourceReference source);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valainstancecast.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valainstancecast.h")]
	public class InstanceCast : Vala.CCodeFunctionCall {
		public InstanceCast (Vala.CCodeExpression! expr, Vala.DataType! type);
		public Vala.DataType type_reference { get; set construct; }
		public Vala.CCodeExpression inner { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaintegerliteral.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaintegerliteral.h")]
	public class IntegerLiteral : Vala.Literal {
		public IntegerLiteral (string! i, Vala.SourceReference source = null);
		public string! get_type_name ();
		public string value { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valainterface.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valainterface.h")]
	public class Interface : Vala.DataType {
		public Interface (string! _name, Vala.SourceReference source = null);
		public void add_type_parameter (Vala.TypeParameter! p);
		public void add_prerequisite (Vala.TypeReference! type);
		public GLib.List get_prerequisites ();
		public void add_method (Vala.Method! m);
		public GLib.List get_methods ();
		public void add_property (Vala.Property! prop);
		public GLib.List get_properties ();
		public void add_signal (Vala.Signal! sig);
		public GLib.List get_signals ();
		public string! get_lower_case_csuffix ();
		public void set_lower_case_csuffix (string! csuffix);
		public void process_attributes ();
		public string get_type_cname ();
		public void set_type_cname (string! type_cname);
		public weak bool is_static { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valainterfacewriter.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valainterfacewriter.h")]
	public class InterfaceWriter : Vala.CodeVisitor {
		public void write_file (Vala.CodeContext! context, string! filename);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valainvocationexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valainvocationexpression.h")]
	public class InvocationExpression : Vala.Expression {
		public Vala.Expression _call;
		public InvocationExpression (Vala.Expression! _call, Vala.SourceReference source = null);
		public void add_argument (Vala.Expression! arg);
		public GLib.List get_argument_list ();
		public void append_array_size (Vala.CCodeExpression! size);
		public GLib.List get_array_sizes ();
		public Vala.Expression call { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valainvokable.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valainvokable.h")]
	public interface Invokable {
		public abstract bool is_invokable ();
		public abstract Vala.TypeReference get_return_type ();
		public abstract GLib.List get_parameters ();
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valalambdaexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valalambdaexpression.h")]
	public class LambdaExpression : Vala.Expression {
		public LambdaExpression (Vala.Expression! body, Vala.SourceReference source);
		public LambdaExpression.with_statement_body (Vala.Block! body, Vala.SourceReference source);
		public void add_parameter (string! param);
		public GLib.List get_parameters ();
		public Vala.Expression expression_body { get; set; }
		public Vala.Block statement_body { get; set; }
		public Vala.Method method { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaliteral.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaliteral.h")]
	public abstract class Literal : Vala.CodeNode {
		public Vala.TypeReference static_type { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaliteralexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaliteralexpression.h")]
	public class LiteralExpression : Vala.Expression {
		public LiteralExpression (Vala.Literal! _literal, Vala.SourceReference source = null);
		public Vala.Literal literal { get; construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valalocalvariabledeclaration.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valalocalvariabledeclaration.h")]
	public class LocalVariableDeclaration : Vala.CodeNode {
		public LocalVariableDeclaration (Vala.TypeReference type, Vala.SourceReference source);
		public LocalVariableDeclaration.var_type (Vala.SourceReference source);
		public void add_declarator (Vala.VariableDeclarator! declarator);
		public GLib.List get_variable_declarators ();
		public Vala.TypeReference type_reference { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valalockable.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valalockable.h")]
	public interface Lockable {
		public abstract bool get_lock_used ();
		public abstract void set_lock_used (bool used);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valalockstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valalockstatement.h")]
	public class LockStatement : Vala.Statement {
		public LockStatement (Vala.Expression _resource, Vala.Statement _body, Vala.SourceReference source);
		public Vala.Expression resource { get; set construct; }
		public Vala.Statement body { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valamember.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valamember.h")]
	public class Member : Vala.CodeNode {
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valamemberaccess.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valamemberaccess.h")]
	public class MemberAccess : Vala.Expression {
		public MemberAccess (Vala.Expression _inner, string! member, Vala.SourceReference source = null);
		public MemberAccess.simple (string! member, Vala.SourceReference source = null);
		public void add_type_argument (Vala.TypeReference! arg);
		public GLib.List get_type_arguments ();
		public Vala.Expression inner { get; set; }
		public string member_name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valamemberaccessibility.h")]
namespace Vala {
	[CCode (cprefix = "VALA_MEMBER_ACCESSIBILITY_")]
	public enum MemberAccessibility {
		PRIVATE,
		INTERNAL,
		PROTECTED,
		PUBLIC,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valamemorymanager.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valamemorymanager.h")]
	public class MemoryManager : Vala.CodeVisitor {
		public void analyze (Vala.CodeContext! context);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valamethod.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valamethod.h")]
	public class Method : Vala.Member, Vala.Invokable {
		public Vala.MemberAccessibility access;
		public Method (string _name, Vala.TypeReference _return_type, Vala.SourceReference source = null);
		public void add_parameter (Vala.FormalParameter! param);
		public GLib.List get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public string! get_cname ();
		public virtual string! get_default_cname ();
		public string! get_real_cname ();
		public void set_cname (string cname);
		public void process_attributes ();
		public bool equals (Vala.Method! m2);
		public string name { get; set; }
		public Vala.TypeReference return_type { get; set; }
		public Vala.Block body { get; set; }
		public weak bool instance { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_virtual { get; set; }
		public weak bool overrides { get; set; }
		public weak bool returns_modified_pointer { get; set; }
		public weak bool instance_last { get; set; }
		public weak bool instance_by_reference { get; set; }
		public weak Vala.Method base_method { get; set; }
		public Vala.Method base_interface_method { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public weak bool no_array_length { get; set; }
		public weak bool printf_format { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valanamedargument.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valanamedargument.h")]
	public class NamedArgument : Vala.CodeNode {
		public NamedArgument (string! _name, Vala.Expression! arg, Vala.SourceReference source);
		public string name { get; set construct; }
		public Vala.Expression argument { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valanamespace.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valanamespace.h")]
	public class Namespace : Vala.CodeNode {
		public Namespace (string _name, Vala.SourceReference source = null);
		public void add_class (Vala.Class! cl);
		public void remove_class (Vala.Class! cl);
		public void add_interface (Vala.Interface! iface);
		public void add_struct (Vala.Struct! st);
		public void add_enum (Vala.Enum! en);
		public void add_flags (Vala.Flags! fl);
		public void add_callback (Vala.Callback! cb);
		public GLib.List get_structs ();
		public GLib.List get_classes ();
		public GLib.List get_interfaces ();
		public void add_constant (Vala.Constant! constant);
		public void add_field (Vala.Field! f);
		public void add_method (Vala.Method! m);
		public static string! camel_case_to_lower_case (string! camel_case);
		public string! get_cprefix ();
		public void set_cprefix (string cprefix);
		public string! get_lower_case_cprefix ();
		public void set_lower_case_cprefix (string cprefix);
		public GLib.List get_cheader_filenames ();
		public string get_cheader_filename ();
		public void set_cheader_filename (string! cheader_filename);
		public void process_attributes ();
		public string name { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valanamespacereference.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valanamespacereference.h")]
	public class NamespaceReference : Vala.CodeNode {
		public NamespaceReference (string! _name, Vala.SourceReference source);
		public string name { get; set construct; }
		public weak Vala.Symbol namespace_symbol { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valanullliteral.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valanullliteral.h")]
	public class NullLiteral : Vala.Literal {
		public NullLiteral (Vala.SourceReference source = null);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaobjectcreationexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaobjectcreationexpression.h")]
	public class ObjectCreationExpression : Vala.Expression {
		public ObjectCreationExpression (Vala.MemberAccess! name, Vala.SourceReference source);
		public void add_argument (Vala.Expression! arg);
		public GLib.List get_argument_list ();
		public Vala.TypeReference type_reference { get; set; }
		public Vala.Method constructor { get; set; }
		public Vala.MemberAccess member_name { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaparenthesizedexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaparenthesizedexpression.h")]
	public class ParenthesizedExpression : Vala.Expression {
		public ParenthesizedExpression (Vala.Expression! _inner, Vala.SourceReference source);
		public Vala.Expression inner { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaparser.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaparser.h")]
	public class Parser : Vala.CodeVisitor {
		public void parse (Vala.CodeContext! context);
		public void push_comment (string! comment_item, bool file_comment);
		public string pop_comment ();
		public void parse_file (Vala.SourceFile! source_file);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valapointer.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valapointer.h")]
	public class Pointer : Vala.DataType {
		public Pointer (Vala.DataType! referent_type, Vala.SourceReference source_reference = null);
		public Vala.DataType referent_type { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valapointerindirection.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valapointerindirection.h")]
	public class PointerIndirection : Vala.Expression {
		public PointerIndirection (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.Expression inner { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valapostfixexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valapostfixexpression.h")]
	public class PostfixExpression : Vala.Expression {
		public PostfixExpression (Vala.Expression! _inner, bool inc, Vala.SourceReference source);
		public Vala.Expression inner { get; set construct; }
		public weak bool increment { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valapropertyaccessor.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valapropertyaccessor.h")]
	public class PropertyAccessor : Vala.CodeNode {
		public PropertyAccessor (bool _readable, bool _writable, bool _construction, Vala.Statement _body, Vala.SourceReference source);
		public weak bool readable { get; set; }
		public weak bool writable { get; set; }
		public weak bool construction { get; set; }
		public Vala.Statement body { get; set; }
		public Vala.FormalParameter value_parameter { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaproperty.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaproperty.h")]
	public class Property : Vala.Member, Vala.Lockable {
		public Property (string! _name, Vala.TypeReference! type, Vala.PropertyAccessor _get_accessor, Vala.PropertyAccessor _set_accessor, Vala.SourceReference source);
		public string! get_upper_case_cname ();
		public Vala.CCodeConstant! get_canonical_cconstant ();
		public void process_attributes ();
		public bool get_lock_used ();
		public void set_lock_used (bool used);
		public bool equals (Vala.Property! prop2);
		public string name { get; set construct; }
		public Vala.TypeReference type_reference { get; set construct; }
		public Vala.PropertyAccessor get_accessor { get; set; }
		public Vala.PropertyAccessor set_accessor { get; set; }
		public weak Vala.MemberAccessibility access { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public weak bool no_accessor_method { get; set; }
		public weak bool interface_only { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_virtual { get; set; }
		public weak bool overrides { get; set; }
		public weak Vala.Property base_property { get; set; }
		public Vala.Property base_interface_property { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valarealliteral.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valarealliteral.h")]
	public class RealLiteral : Vala.Literal {
		public RealLiteral (string r, Vala.SourceReference source);
		public string! get_type_name ();
		public string value { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valareferencetransferexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valareferencetransferexpression.h")]
	public class ReferenceTransferExpression : Vala.Expression {
		public ReferenceTransferExpression (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.Expression inner { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valareport.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valareport.h")]
	public class Report : GLib.Object {
		public static int get_warnings ();
		public static int get_errors ();
		public static void warning (Vala.SourceReference source, string! message);
		public static void error (Vala.SourceReference source, string! message);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valareturnstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valareturnstatement.h")]
	public class ReturnStatement : Vala.Statement {
		public ReturnStatement (Vala.Expression result = null, Vala.SourceReference source = null);
		public Vala.Expression return_expression { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasemanticanalyzer.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasemanticanalyzer.h")]
	public class SemanticAnalyzer : Vala.CodeVisitor {
		public SemanticAnalyzer (bool manage_memory = true);
		public void analyze (Vala.CodeContext! context);
		public static Vala.Symbol symbol_lookup_inherited (Vala.Symbol! sym, string! name);
		public weak bool memory_management { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasignal.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasignal.h")]
	public class Signal : Vala.Member, Vala.Invokable, Vala.Lockable {
		public Signal (string! _name, Vala.TypeReference! _return_type, Vala.SourceReference source);
		public void add_parameter (Vala.FormalParameter! param);
		public GLib.List get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public Vala.Callback! get_callback ();
		public string! get_cname ();
		public void set_cname (string cname);
		public Vala.CCodeConstant! get_canonical_cconstant ();
		public void process_attributes ();
		public bool get_lock_used ();
		public void set_lock_used (bool used);
		public string name { get; set construct; }
		public Vala.TypeReference return_type { get; set construct; }
		public weak Vala.MemberAccessibility access { get; set; }
		public weak bool has_emitter { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasizeofexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasizeofexpression.h")]
	public class SizeofExpression : Vala.Expression {
		public SizeofExpression (Vala.TypeReference! type, Vala.SourceReference source);
		public Vala.TypeReference type_reference { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasourcefile.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasourcefile.h")]
	public class SourceFile : GLib.Object {
		public SourceFile (Vala.CodeContext! _context, string! _filename, bool _pkg = false);
		public void add_using_directive (Vala.NamespaceReference! ns);
		public GLib.List get_using_directives ();
		public void add_namespace (Vala.Namespace! ns);
		public Vala.Namespace! get_global_namespace ();
		public GLib.List get_namespaces ();
		public void accept (Vala.CodeVisitor! visitor);
		public void accept_children (Vala.CodeVisitor! visitor);
		public string! get_cheader_filename ();
		public string! get_csource_filename ();
		public string! get_cinclude_filename ();
		public void add_symbol_dependency (Vala.Symbol! sym, Vala.SourceFileDependencyType dep_type);
		public weak GLib.List get_header_external_includes ();
		public void add_header_internal_include (string! include);
		public weak GLib.List get_header_internal_includes ();
		public weak GLib.List get_source_external_includes ();
		public weak GLib.List get_source_internal_includes ();
		public weak GLib.List get_header_internal_full_dependencies ();
		public weak GLib.List get_header_internal_dependencies ();
		public string filename { get; set construct; }
		public string comment { get; set; }
		public weak bool pkg { get; set; }
		public Vala.SourceFileCycle cycle { get; set; }
		public weak bool is_cycle_head { get; set; }
		public weak int mark { get; set; }
		public weak Vala.CodeContext context { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasourcefile.h")]
namespace Vala {
	[CCode (cprefix = "VALA_SOURCE_FILE_DEPENDENCY_TYPE_")]
	public enum SourceFileDependencyType {
		HEADER_FULL,
		HEADER_SHALLOW,
		SOURCE,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasourcefilecycle.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasourcefilecycle.h")]
	public class SourceFileCycle : GLib.Object {
		public GLib.List<weak Vala.SourceFile> files;
		public weak Vala.SourceFile head;
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasourcereference.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasourcereference.h")]
	public class SourceReference : GLib.Object {
		public SourceReference (Vala.SourceFile _file, int _first_line = 0, int _first_column = 0, int _last_line = 0, int _last_column = 0);
		public SourceReference.with_comment (Vala.SourceFile _file, int _first_line, int _first_column, int _last_line, int _last_column, string _comment);
		public string! to_string ();
		public weak Vala.SourceFile file { get; set; }
		public weak int first_line { get; set; }
		public weak int first_column { get; set; }
		public weak int last_line { get; set; }
		public weak int last_column { get; set; }
		public string comment { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valastatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valastatement.h")]
	public abstract class Statement : Vala.CodeNode {
		public virtual int get_number_of_set_construction_parameters ();
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valastringliteral.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valastringliteral.h")]
	public class StringLiteral : Vala.Literal {
		public StringLiteral (string s, Vala.SourceReference source);
		public string eval ();
		public string value { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valastruct.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valastruct.h")]
	public class Struct : Vala.DataType {
		public Struct (string! _name, Vala.SourceReference source = null);
		public void add_type_parameter (Vala.TypeParameter! p);
		public void add_constant (Vala.Constant! c);
		public void add_field (Vala.Field! f);
		public GLib.List get_fields ();
		public void add_method (Vala.Method! m);
		public GLib.List get_methods ();
		public bool is_integer_type ();
		public bool is_floating_type ();
		public int get_rank ();
		public void set_is_reference_type (bool ref_type);
		public void process_attributes ();
		public void set_dup_function (string! name);
		public void set_type_id (string! name);
		public void add_base_type (Vala.TypeReference! type);
		public GLib.List get_base_types ();
		public Vala.Method default_construction_method { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaswitchlabel.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaswitchlabel.h")]
	public class SwitchLabel : Vala.CodeNode {
		public SwitchLabel (Vala.Expression expr, Vala.SourceReference source = null);
		public SwitchLabel.with_default (Vala.SourceReference source = null);
		public Vala.Expression expression { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaswitchsection.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaswitchsection.h")]
	public class SwitchSection : Vala.CodeNode {
		public SwitchSection (Vala.SourceReference source);
		public void add_label (Vala.SwitchLabel! label);
		public GLib.List get_labels ();
		public bool has_default_label ();
		public void add_statement (Vala.Statement! stmt);
		public GLib.List get_statements ();
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaswitchstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaswitchstatement.h")]
	public class SwitchStatement : Vala.Statement {
		public SwitchStatement (Vala.Expression! expr, Vala.SourceReference source);
		public void add_section (Vala.SwitchSection! section);
		public GLib.List get_sections ();
		public Vala.Expression expression { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasymbolbuilder.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasymbolbuilder.h")]
	public class SymbolBuilder : Vala.CodeVisitor {
		public void build (Vala.CodeContext! context);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasymbol.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasymbol.h")]
	public class Symbol : GLib.Object {
		public Symbol (Vala.CodeNode _node = null);
		public string get_full_name ();
		public void add (string! name, Vala.Symbol! sym);
		public Vala.Symbol lookup (string! name);
		public weak Vala.CodeNode node { get; set; }
		public weak Vala.Symbol parent_symbol { get; set; }
		public string name { get; set; }
		public weak bool active { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valasymbolresolver.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valasymbolresolver.h")]
	public class SymbolResolver : Vala.CodeVisitor {
		public void resolve (Vala.CodeContext! context);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valathrowstatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valathrowstatement.h")]
	public class ThrowStatement : Vala.Statement {
		public ThrowStatement (Vala.Expression! error_expression, Vala.SourceReference source_reference = null);
		public Vala.Expression error_expression { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valatrystatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valatrystatement.h")]
	public class TryStatement : Vala.Statement {
		public TryStatement (Vala.Block! body, Vala.Block finally_body, Vala.SourceReference source_reference = null);
		public void add_catch_clause (Vala.CatchClause! clause);
		public Vala.Block body { get; set construct; }
		public Vala.Block finally_body { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valatypecheck.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valatypecheck.h")]
	public class TypeCheck : Vala.Expression {
		public TypeCheck (Vala.Expression! expr, Vala.TypeReference! type, Vala.SourceReference source);
		public Vala.Expression expression { get; set construct; }
		public Vala.TypeReference type_reference { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valatypeofexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valatypeofexpression.h")]
	public class TypeofExpression : Vala.Expression {
		public TypeofExpression (Vala.TypeReference! type, Vala.SourceReference source);
		public Vala.TypeReference type_reference { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valatypeparameter.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valatypeparameter.h")]
	public class TypeParameter : Vala.CodeNode {
		public weak Vala.DataType type;
		public TypeParameter (string! _name, Vala.SourceReference source);
		public Vala.Array! get_array (int rank);
		public bool equals (Vala.TypeParameter! param2);
		public string name { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valatypereference.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valatypereference.h")]
	public class TypeReference : Vala.CodeNode {
		public TypeReference ();
		public TypeReference.from_name (string ns, string! type, Vala.SourceReference source = null);
		public static Vala.TypeReference new_from_expression (Vala.Expression! expr);
		public void add_type_argument (Vala.TypeReference! arg);
		public GLib.List get_type_arguments ();
		public void remove_all_type_arguments ();
		public string get_cname (bool var_type = false, bool const_type = false);
		public string get_const_cname ();
		public string! to_string ();
		public Vala.TypeReference! copy ();
		public bool equals (Vala.TypeReference! type2);
		public bool stricter (Vala.TypeReference! type2);
		public weak bool transfers_ownership { get; set; }
		public weak bool takes_ownership { get; set; }
		public weak bool is_out { get; set; }
		public weak bool non_null { get; set; }
		public weak bool is_null { get; set; }
		public weak Vala.DataType data_type { get; set; }
		public Vala.TypeParameter type_parameter { get; set; }
		public weak bool floating_reference { get; set; }
		public string namespace_name { get; set; }
		public string type_name { get; set; }
		public weak int array_rank { get; set; }
		public weak int pointer_level { get; set; }
		public weak bool is_ref { get; set; }
		public weak bool is_weak { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaunaryexpression.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valaunaryexpression.h")]
	public class UnaryExpression : Vala.Expression {
		public UnaryExpression (Vala.UnaryOperator op, Vala.Expression! _inner, Vala.SourceReference source);
		public weak Vala.UnaryOperator operator { get; set; }
		public Vala.Expression inner { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valaunaryexpression.h")]
namespace Vala {
	[CCode (cprefix = "VALA_UNARY_OPERATOR_")]
	public enum UnaryOperator {
		PLUS,
		MINUS,
		LOGICAL_NEGATION,
		BITWISE_COMPLEMENT,
		INCREMENT,
		DECREMENT,
		REF,
		OUT,
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valavariabledeclarator.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valavariabledeclarator.h")]
	public class VariableDeclarator : Vala.CodeNode, Vala.Invokable {
		public VariableDeclarator (string! _name, Vala.Expression init = null, Vala.SourceReference source = null);
		public GLib.List get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public string name { get; set construct; }
		public Vala.Expression initializer { get; set; }
		public Vala.TypeReference type_reference { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "vala/valawhilestatement.h")]
namespace Vala {
	[CCode (cheader_filename = "vala/valawhilestatement.h")]
	public class WhileStatement : Vala.Statement {
		public WhileStatement (Vala.Expression! cond, Vala.Statement! _body, Vala.SourceReference source);
		public Vala.Expression condition { get; set construct; }
		public Vala.Statement body { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valaccodecompiler.h")]
namespace Vala {
	[CCode (cheader_filename = "gobject/valaccodecompiler.h")]
	public class CCodeCompiler : GLib.Object {
		public CCodeCompiler ();
		public void compile (Vala.CodeContext! context);
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valaclassregisterfunction.h")]
namespace Vala {
	[CCode (cheader_filename = "gobject/valaclassregisterfunction.h")]
	public class ClassRegisterFunction : Vala.TypeRegisterFunction {
		public ClassRegisterFunction (Vala.Class! cl);
		public Vala.Class class_reference { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegenerator.h")]
namespace Vala {
	[CCode (cheader_filename = "gobject/valacodegenerator.h")]
	public class CodeGenerator : Vala.CodeVisitor {
		public CodeGenerator (bool manage_memory = true);
		public void emit (Vala.CodeContext! context);
		public weak bool memory_management { get; set; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratorassignment.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratorclass.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratorinterface.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratorinvocationexpression.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratormemberaccess.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratormethod.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratorsignal.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratorsourcefile.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valacodegeneratorstruct.h")]
namespace Vala {
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valainterfaceregisterfunction.h")]
namespace Vala {
	[CCode (cheader_filename = "gobject/valainterfaceregisterfunction.h")]
	public class InterfaceRegisterFunction : Vala.TypeRegisterFunction {
		public InterfaceRegisterFunction (Vala.Interface! iface);
		public Vala.Interface interface_reference { get; set construct; }
	}
}
[CCode (cprefix = "Vala", lower_case_cprefix = "vala_", cheader_filename = "gobject/valatyperegisterfunction.h")]
namespace Vala {
	[CCode (cheader_filename = "gobject/valatyperegisterfunction.h")]
	public abstract class TypeRegisterFunction : GLib.Object {
		public void init_from_type (bool plugin = false);
		public abstract Vala.DataType! get_type_declaration ();
		public abstract string! get_type_struct_name ();
		public abstract string! get_base_init_func_name ();
		public abstract string! get_class_init_func_name ();
		public abstract string! get_instance_struct_size ();
		public abstract string! get_instance_init_func_name ();
		public abstract string! get_parent_type_name ();
		public virtual string get_type_flags ();
		public virtual Vala.CCodeFragment! get_type_interface_init_declaration ();
		public abstract Vala.CCodeFragment! get_type_interface_init_statements ();
		public Vala.CCodeFragment! get_declaration ();
		public Vala.CCodeFragment! get_definition ();
	}
}
