/* valaattribute.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaattribute.h"
#include <vala/valasourcereference.h>
#include <vala/valaattribute.h>
#include <vala/valanamedargument.h>
#include <vala/valaliteralexpression.h>
#include <vala/valaliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valabooleanliteral.h>

struct _ValaAttributePrivate {
	char* _name;
};
#define VALA_ATTRIBUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ATTRIBUTE, ValaAttributePrivate))
enum  {
	VALA_ATTRIBUTE_DUMMY_PROPERTY,
	VALA_ATTRIBUTE_NAME
};
static gpointer vala_attribute_parent_class = NULL;
static void vala_attribute_dispose (GObject * obj);


/**
 * Creates a new attribute.
 *
 * @param name attribute type name
 * @param source reference to source code
 * @return newly created attribute
 */
ValaAttribute* vala_attribute_new (const char* _name, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaAttribute * self;
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _name), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_ATTRIBUTE, __params_it - __params, __params);
	return self;
}


/**
 * Adds an attribute argument.
 *
 * @param arg named argument
 */
void vala_attribute_add_argument (ValaAttribute* self, ValaNamedArgument* arg)
{
	g_return_if_fail (VALA_IS_ATTRIBUTE (self));
	g_return_if_fail (VALA_IS_NAMED_ARGUMENT (arg));
	self->args = g_list_append (self->args, g_object_ref (arg));
}


/**
 * Returns whether this attribute has the specified named argument.
 *
 * @param name argument name
 * @return     true if the argument has been found, false otherwise
 */
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		GList* __temp1;
		GList* arg_it;
		__temp1 = NULL;
		__temp1 = self->args;
		for (arg_it = __temp1; arg_it != NULL; arg_it = arg_it->next) {
			ValaNamedArgument* arg;
			arg = arg_it->data;
			{
				/* FIXME: use hash table*/
				if (g_utf8_collate (vala_named_argument_get_name (arg), name) == 0) {
					return TRUE;
				}
			}
		}
	}
	return FALSE;
}


/**
 * Returns the string value of the specified named argument.
 *
 * @param name argument name
 * @return     string value
 */
char* vala_attribute_get_string (ValaAttribute* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GList* __temp5;
		GList* arg_it;
		__temp5 = NULL;
		__temp5 = self->args;
		for (arg_it = __temp5; arg_it != NULL; arg_it = arg_it->next) {
			ValaNamedArgument* arg;
			arg = arg_it->data;
			{
				/* FIXME: use hash table*/
				if (g_utf8_collate (vala_named_argument_get_name (arg), name) == 0) {
					if (VALA_IS_LITERAL_EXPRESSION (vala_named_argument_get_argument (arg))) {
						ValaLiteral* __temp3;
						ValaLiteral* lit;
						__temp3 = NULL;
						lit = (__temp3 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_named_argument_get_argument (arg)))), (__temp3 == NULL ? NULL : g_object_ref (__temp3)));
						if (VALA_IS_STRING_LITERAL (lit)) {
							char* __temp4;
							__temp4 = NULL;
							return (__temp4 = vala_string_literal_eval ((VALA_STRING_LITERAL (lit))), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), __temp4);
						}
						(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
					}
				}
			}
		}
	}
	return NULL;
}


/**
 * Returns the integer value of the specified named argument.
 *
 * @param name argument name
 * @return     integer value
 */
gint vala_attribute_get_integer (ValaAttribute* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), 0);
	g_return_val_if_fail (name != NULL, 0);
	{
		GList* __temp9;
		GList* arg_it;
		__temp9 = NULL;
		__temp9 = self->args;
		for (arg_it = __temp9; arg_it != NULL; arg_it = arg_it->next) {
			ValaNamedArgument* arg;
			arg = arg_it->data;
			{
				/* FIXME: use hash table*/
				if (g_utf8_collate (vala_named_argument_get_name (arg), name) == 0) {
					if (VALA_IS_LITERAL_EXPRESSION (vala_named_argument_get_argument (arg))) {
						ValaLiteral* __temp7;
						ValaLiteral* lit;
						__temp7 = NULL;
						lit = (__temp7 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_named_argument_get_argument (arg)))), (__temp7 == NULL ? NULL : g_object_ref (__temp7)));
						if (VALA_IS_INTEGER_LITERAL (lit)) {
							gint __temp8;
							return (__temp8 = atoi (vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit)))), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), __temp8);
						}
						(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
					}
				}
			}
		}
	}
	return 0;
}


/**
 * Returns the boolean value of the specified named argument.
 *
 * @param name argument name
 * @return     boolean value
 */
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		GList* __temp13;
		GList* arg_it;
		__temp13 = NULL;
		__temp13 = self->args;
		for (arg_it = __temp13; arg_it != NULL; arg_it = arg_it->next) {
			ValaNamedArgument* arg;
			arg = arg_it->data;
			{
				/* FIXME: use hash table*/
				if (g_utf8_collate (vala_named_argument_get_name (arg), name) == 0) {
					if (VALA_IS_LITERAL_EXPRESSION (vala_named_argument_get_argument (arg))) {
						ValaLiteral* __temp11;
						ValaLiteral* lit;
						__temp11 = NULL;
						lit = (__temp11 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_named_argument_get_argument (arg)))), (__temp11 == NULL ? NULL : g_object_ref (__temp11)));
						if (VALA_IS_BOOLEAN_LITERAL (lit)) {
							gboolean __temp12;
							return (__temp12 = vala_boolean_literal_get_value ((VALA_BOOLEAN_LITERAL (lit))), (lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL))), __temp12);
						}
						(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
					}
				}
			}
		}
	}
	return FALSE;
}


char* vala_attribute_get_name (ValaAttribute* self)
{
	g_return_val_if_fail (VALA_IS_ATTRIBUTE (self), NULL);
	return self->priv->_name;
}


void vala_attribute_set_name (ValaAttribute* self, const char* value)
{
	char* __temp16;
	g_return_if_fail (VALA_IS_ATTRIBUTE (self));
	__temp16 = NULL;
	self->priv->_name = (__temp16 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp16);
}


static void vala_attribute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaAttribute * self;
	self = VALA_ATTRIBUTE (object);
	switch (property_id) {
		case VALA_ATTRIBUTE_NAME:
		g_value_set_string (value, vala_attribute_get_name (self));
		break;
	}
}


static void vala_attribute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaAttribute * self;
	self = VALA_ATTRIBUTE (object);
	switch (property_id) {
		case VALA_ATTRIBUTE_NAME:
		vala_attribute_set_name (self, g_value_get_string (value));
		break;
	}
}


static void vala_attribute_class_init (ValaAttributeClass * klass)
{
	vala_attribute_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaAttributePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_attribute_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_attribute_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_attribute_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ATTRIBUTE_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_attribute_init (ValaAttribute * self)
{
	self->priv = VALA_ATTRIBUTE_GET_PRIVATE (self);
}


static void vala_attribute_dispose (GObject * obj)
{
	ValaAttribute * self;
	ValaAttributeClass * klass;
	GObjectClass * parent_class;
	self = VALA_ATTRIBUTE (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->args == NULL ? NULL : (self->args = (g_list_foreach (self->args, (GFunc) g_object_unref, NULL), g_list_free (self->args), NULL)));
	klass = VALA_ATTRIBUTE_CLASS (g_type_class_peek (VALA_TYPE_ATTRIBUTE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_attribute_get_type ()
{
	static GType vala_attribute_type_id = 0;
	if (G_UNLIKELY (vala_attribute_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAttribute), 0, (GInstanceInitFunc) vala_attribute_init };
		vala_attribute_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaAttribute", &g_define_type_info, 0);
	}
	return vala_attribute_type_id;
}




