/* valacreationmethod.vala
 *
 * Copyright (C) 2007  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valacreationmethod.h"
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valablock.h>
#include <vala/valasymbol.h>
#include <vala/valadatatype.h>

struct _ValaCreationMethodPrivate {
	gint _n_construction_params;
};
#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
enum  {
	VALA_CREATION_METHOD_DUMMY_PROPERTY,
	VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS
};
static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_creation_method_real_get_default_cname (ValaMethod* base);
static gpointer vala_creation_method_parent_class = NULL;
static void vala_creation_method_dispose (GObject * obj);


/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod* vala_creation_method_new (const char* name, ValaSourceReference* source_reference)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCreationMethod * self;
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, name), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source_reference), __params_it++);
	self = g_object_newv (VALA_TYPE_CREATION_METHOD, __params_it - __params, __params);
	return self;
}


static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_creation_method (visitor, self);
}


static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	{
		GList* __temp0;
		GList* param_it;
		__temp0 = NULL;
		__temp0 = vala_invokable_get_parameters (VALA_INVOKABLE (self));
		for (param_it = __temp0; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param;
			param = param_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (param), visitor);
			}
		}
		(__temp0 == NULL ? NULL : (__temp0 = (g_list_free (__temp0), NULL)));
	}
	if (vala_method_get_body (VALA_METHOD (self)) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_method_get_body (VALA_METHOD (self))), visitor);
	}
}


static char* vala_creation_method_real_get_default_cname (ValaMethod* base)
{
	ValaCreationMethod * self;
	ValaCodeNode* __temp1;
	ValaCodeNode* parent;
	self = VALA_CREATION_METHOD (base);
	__temp1 = NULL;
	parent = (__temp1 = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (self)))), (__temp1 == NULL ? NULL : g_object_ref (__temp1)));
	g_assert (VALA_IS_DATA_TYPE (parent));
	if (vala_method_get_name (VALA_METHOD (self)) == NULL) {
		char* __temp2;
		char* __temp3;
		char* __temp4;
		__temp2 = NULL;
		__temp3 = NULL;
		__temp4 = NULL;
		return (__temp4 = (__temp3 = g_strdup_printf ("%snew", (__temp2 = vala_data_type_get_lower_case_cprefix ((VALA_DATA_TYPE (parent))))), (__temp2 = (g_free (__temp2), NULL)), __temp3), (parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL))), __temp4);
	} else {
		char* __temp5;
		char* __temp6;
		char* __temp7;
		__temp5 = NULL;
		__temp6 = NULL;
		__temp7 = NULL;
		return (__temp7 = (__temp6 = g_strdup_printf ("%snew_%s", (__temp5 = vala_data_type_get_lower_case_cprefix ((VALA_DATA_TYPE (parent)))), vala_method_get_name (VALA_METHOD (self))), (__temp5 = (g_free (__temp5), NULL)), __temp6), (parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL))), __temp7);
	}
	(parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL)));
}


gint vala_creation_method_get_n_construction_params (ValaCreationMethod* self)
{
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), 0);
	return self->priv->_n_construction_params;
}


void vala_creation_method_set_n_construction_params (ValaCreationMethod* self, gint value)
{
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	self->priv->_n_construction_params = value;
}


static void vala_creation_method_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (object);
	switch (property_id) {
		case VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS:
		g_value_set_int (value, vala_creation_method_get_n_construction_params (self));
		break;
	}
}


static void vala_creation_method_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (object);
	switch (property_id) {
		case VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS:
		vala_creation_method_set_n_construction_params (self, g_value_get_int (value));
		break;
	}
}


static void vala_creation_method_class_init (ValaCreationMethodClass * klass)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_creation_method_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_creation_method_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_creation_method_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_creation_method_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_creation_method_real_accept_children;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_creation_method_real_get_default_cname;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS, g_param_spec_int ("n-construction-params", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_creation_method_init (ValaCreationMethod * self)
{
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void vala_creation_method_dispose (GObject * obj)
{
	ValaCreationMethod * self;
	ValaCreationMethodClass * klass;
	GObjectClass * parent_class;
	self = VALA_CREATION_METHOD (obj);
	klass = VALA_CREATION_METHOD_CLASS (g_type_class_peek (VALA_TYPE_CREATION_METHOD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_creation_method_get_type ()
{
	static GType vala_creation_method_type_id = 0;
	if (G_UNLIKELY (vala_creation_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_init };
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	}
	return vala_creation_method_type_id;
}




