/* valastringliteral.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valastringliteral.h"
#include <vala/valasourcereference.h>
#include <vala/valastringliteral.h>
#include <vala/valacodevisitor.h>

struct _ValaStringLiteralPrivate {
	char* _value;
};
#define VALA_STRING_LITERAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STRING_LITERAL, ValaStringLiteralPrivate))
enum  {
	VALA_STRING_LITERAL_DUMMY_PROPERTY,
	VALA_STRING_LITERAL_VALUE
};
static void vala_string_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_string_literal_parent_class = NULL;
static void vala_string_literal_dispose (GObject * obj);


/**
 * Creates a new string literal.
 *
 * @param s      the literal value
 * @param source reference to source code
 * @return       newly created string literal
 */
ValaStringLiteral* vala_string_literal_new (const char* s, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaStringLiteral * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "value", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, s), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_STRING_LITERAL, __params_it - __params, __params);
	return self;
}


/**
 * Evaluates the literal string value.
 *
 * @return the unescaped string
 */
char* vala_string_literal_eval (ValaStringLiteral* self)
{
	char* noquotes;
	char* __temp1;
	g_return_val_if_fail (VALA_IS_STRING_LITERAL (self), NULL);
	if (vala_string_literal_get_value (self) == NULL) {
		return NULL;
	}
	/* remove quotes */
	noquotes = g_strndup (g_utf8_offset_to_pointer (vala_string_literal_get_value (self), 1), ((guint) (g_utf8_strlen (vala_string_literal_get_value (self), -1) - 2)));
	__temp1 = NULL;
	return (__temp1 = g_strcompress (noquotes), (noquotes = (g_free (noquotes), NULL)), __temp1);
	(noquotes = (g_free (noquotes), NULL));
}


/* unescape string */
static void vala_string_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaStringLiteral * self;
	self = VALA_STRING_LITERAL (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_string_literal (visitor, self);
}


char* vala_string_literal_get_value (ValaStringLiteral* self)
{
	g_return_val_if_fail (VALA_IS_STRING_LITERAL (self), NULL);
	return self->priv->_value;
}


void vala_string_literal_set_value (ValaStringLiteral* self, const char* value)
{
	char* __temp4;
	const char* __temp3;
	g_return_if_fail (VALA_IS_STRING_LITERAL (self));
	__temp4 = NULL;
	__temp3 = NULL;
	self->priv->_value = (__temp4 = (__temp3 = value, (__temp3 == NULL ? NULL : g_strdup (__temp3))), (self->priv->_value = (g_free (self->priv->_value), NULL)), __temp4);
}


static void vala_string_literal_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaStringLiteral * self;
	self = VALA_STRING_LITERAL (object);
	switch (property_id) {
		case VALA_STRING_LITERAL_VALUE:
		g_value_set_string (value, vala_string_literal_get_value (self));
		break;
	}
}


static void vala_string_literal_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaStringLiteral * self;
	self = VALA_STRING_LITERAL (object);
	switch (property_id) {
		case VALA_STRING_LITERAL_VALUE:
		vala_string_literal_set_value (self, g_value_get_string (value));
		break;
	}
}


static void vala_string_literal_class_init (ValaStringLiteralClass * klass)
{
	vala_string_literal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaStringLiteralPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_string_literal_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_string_literal_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_string_literal_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_string_literal_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_STRING_LITERAL_VALUE, g_param_spec_string ("value", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_string_literal_init (ValaStringLiteral * self)
{
	self->priv = VALA_STRING_LITERAL_GET_PRIVATE (self);
}


static void vala_string_literal_dispose (GObject * obj)
{
	ValaStringLiteral * self;
	ValaStringLiteralClass * klass;
	GObjectClass * parent_class;
	self = VALA_STRING_LITERAL (obj);
	(self->priv->_value = (g_free (self->priv->_value), NULL));
	klass = VALA_STRING_LITERAL_CLASS (g_type_class_peek (VALA_TYPE_STRING_LITERAL));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_string_literal_get_type ()
{
	static GType vala_string_literal_type_id = 0;
	if (G_UNLIKELY (vala_string_literal_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStringLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_string_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStringLiteral), 0, (GInstanceInitFunc) vala_string_literal_init };
		vala_string_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaStringLiteral", &g_define_type_info, 0);
	}
	return vala_string_literal_type_id;
}




