/* FIXME check whether the corresponding data type of one of the
       parameters is a base type of the corresponding data
       type of the other parameter and check along the path
       whether one parameter maps to the other
 valatypereference.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valatypereference.h"
#include <vala/valadatatype.h>
#include <vala/valatypeparameter.h>
#include <vala/valasourcereference.h>
#include <vala/valatypereference.h>
#include <vala/valaexpression.h>
#include <vala/valamemberaccess.h>
#include <vala/valareport.h>
#include <vala/valacodevisitor.h>
#include <vala/valaarray.h>
#include <vala/valasymbol.h>

struct _ValaTypeReferencePrivate {
	gboolean _transfers_ownership;
	gboolean _takes_ownership;
	gboolean _is_out;
	gboolean _non_null;
	gboolean _is_null;
	ValaDataType* _data_type;
	ValaTypeParameter* _type_parameter;
	gboolean _floating_reference;
	char* _namespace_name;
	char* _type_name;
	gint _array_rank;
	gint _pointer_level;
	gboolean _is_ref;
	gboolean _is_weak;
	GList* type_argument_list;
};
#define VALA_TYPE_REFERENCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPE_REFERENCE, ValaTypeReferencePrivate))
enum  {
	VALA_TYPE_REFERENCE_DUMMY_PROPERTY,
	VALA_TYPE_REFERENCE_TRANSFERS_OWNERSHIP,
	VALA_TYPE_REFERENCE_TAKES_OWNERSHIP,
	VALA_TYPE_REFERENCE_IS_OUT,
	VALA_TYPE_REFERENCE_NON_NULL,
	VALA_TYPE_REFERENCE_IS_NULL,
	VALA_TYPE_REFERENCE_DATA_TYPE,
	VALA_TYPE_REFERENCE_TYPE_PARAMETER,
	VALA_TYPE_REFERENCE_FLOATING_REFERENCE,
	VALA_TYPE_REFERENCE_NAMESPACE_NAME,
	VALA_TYPE_REFERENCE_TYPE_NAME,
	VALA_TYPE_REFERENCE_ARRAY_RANK,
	VALA_TYPE_REFERENCE_POINTER_LEVEL,
	VALA_TYPE_REFERENCE_IS_REF,
	VALA_TYPE_REFERENCE_IS_WEAK
};
static void vala_type_reference_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_type_reference_parent_class = NULL;
static void vala_type_reference_dispose (GObject * obj);


ValaTypeReference* vala_type_reference_new ()
{
	GParameter * __params;
	GParameter * __params_it;
	ValaTypeReference * self;
	__params = g_new0 (GParameter, 0);
	__params_it = __params;
	self = g_object_newv (VALA_TYPE_TYPE_REFERENCE, __params_it - __params, __params);
	return self;
}


/**
 * Creates a new type reference.
 *
 * @param ns        optional namespace name
 * @param type_name type symbol name
 * @param source    reference to source code
 * @return          newly created type reference
 */
ValaTypeReference* vala_type_reference_new_from_name (const char* ns, const char* type, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaTypeReference * self;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "namespace-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, ns), __params_it++);
	(__params_it->name = "type-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, type), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_TYPE_REFERENCE, __params_it - __params, __params);
	return self;
}


/**
 * Creates a new type reference from a code expression.
 *
 * @param expr   member access expression
 * @param source reference to source code
 * @return       newly created type reference
 */
ValaTypeReference* vala_type_reference_new_from_expression (ValaExpression* expr)
{
	char* ns;
	char* type_name;
	gpointer __temp6;
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	ns = NULL;
	type_name = NULL;
	if (VALA_IS_MEMBER_ACCESS (expr)) {
		ValaTypeReference* type_ref;
		ValaMemberAccess* __temp0;
		ValaMemberAccess* ma;
		type_ref = NULL;
		__temp0 = NULL;
		ma = (__temp0 = VALA_MEMBER_ACCESS (expr), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
		if (vala_member_access_get_inner (ma) != NULL) {
			if (VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (ma))) {
				ValaMemberAccess* __temp1;
				ValaMemberAccess* simple;
				ValaTypeReference* __temp2;
				__temp1 = NULL;
				simple = (__temp1 = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (__temp1 == NULL ? NULL : g_object_ref (__temp1)));
				__temp2 = NULL;
				type_ref = (__temp2 = vala_type_reference_new_from_name (vala_member_access_get_member_name (simple), vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL))), __temp2);
				(simple == NULL ? NULL : (simple = (g_object_unref (simple), NULL)));
			}
		} else {
			ValaTypeReference* __temp3;
			__temp3 = NULL;
			type_ref = (__temp3 = vala_type_reference_new_from_name (NULL, vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL))), __temp3);
		}
		if (type_ref != NULL) {
			GList* type_args;
			ValaTypeReference* __temp5;
			type_args = vala_member_access_get_type_arguments (ma);
			{
				GList* __temp4;
				GList* arg_it;
				__temp4 = NULL;
				__temp4 = type_args;
				for (arg_it = __temp4; arg_it != NULL; arg_it = arg_it->next) {
					ValaTypeReference* arg;
					arg = arg_it->data;
					{
						vala_type_reference_add_type_argument (type_ref, arg);
					}
				}
			}
			__temp5 = NULL;
			return (__temp5 = type_ref, (type_args == NULL ? NULL : (type_args = (g_list_free (type_args), NULL))), __temp5);
			(type_args == NULL ? NULL : (type_args = (g_list_free (type_args), NULL)));
		}
		(type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	}
	vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Type reference must be simple name or member access expression");
	return VALA_TYPE_REFERENCE ((__temp6 = NULL, (ns = (g_free (ns), NULL)), (type_name = (g_free (type_name), NULL)), __temp6));
	(ns = (g_free (ns), NULL));
	(type_name = (g_free (type_name), NULL));
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void vala_type_reference_add_type_argument (ValaTypeReference* self, ValaTypeReference* arg)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (arg));
	self->priv->type_argument_list = g_list_append (self->priv->type_argument_list, g_object_ref (arg));
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
GList* vala_type_reference_get_type_arguments (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	return g_list_copy (self->priv->type_argument_list);
}


/**
 * Removes all generic type arguments.
 */
void vala_type_reference_remove_all_type_arguments (ValaTypeReference* self)
{
	GList* __temp8;
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	__temp8 = NULL;
	self->priv->type_argument_list = (__temp8 = NULL, (self->priv->type_argument_list == NULL ? NULL : (self->priv->type_argument_list = (g_list_foreach (self->priv->type_argument_list, (GFunc) g_object_unref, NULL), g_list_free (self->priv->type_argument_list), NULL))), __temp8);
}


static void vala_type_reference_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaTypeReference * self;
	self = VALA_TYPE_REFERENCE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	{
		GList* __temp9;
		GList* type_arg_it;
		__temp9 = NULL;
		__temp9 = self->priv->type_argument_list;
		for (type_arg_it = __temp9; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
			ValaTypeReference* type_arg;
			type_arg = type_arg_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (type_arg), visitor);
			}
		}
	}
	vala_code_visitor_visit_type_reference (visitor, self);
}


/**
 * Returns the name and qualifiers of this type as it is used in C code.
 *
 * @return the type string to be used in C code
 */
char* vala_type_reference_get_cname (ValaTypeReference* self, gboolean var_type, gboolean const_type)
{
	char* ptr;
	char* arr;
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	if (vala_type_reference_get_data_type (self) == NULL && vala_type_reference_get_type_parameter (self) == NULL) {
		if (var_type) {
			return g_strdup ("gpointer");
		} else {
			return g_strdup ("void");
		}
	}
	ptr = NULL;
	arr = NULL;
	if (vala_type_reference_get_type_parameter (self) != NULL || (!vala_data_type_is_reference_type (vala_type_reference_get_data_type (self)) && !vala_type_reference_get_is_ref (self) && !vala_type_reference_get_is_out (self))) {
		char* __temp12;
		__temp12 = NULL;
		ptr = (__temp12 = g_strdup (""), (ptr = (g_free (ptr), NULL)), __temp12);
	} else {
		if ((vala_data_type_is_reference_type (vala_type_reference_get_data_type (self)) && !vala_type_reference_get_is_ref (self) && !vala_type_reference_get_is_out (self)) || (!vala_data_type_is_reference_type (vala_type_reference_get_data_type (self)) && (vala_type_reference_get_is_ref (self) || vala_type_reference_get_is_out (self)))) {
			char* __temp13;
			__temp13 = NULL;
			ptr = (__temp13 = g_strdup ("*"), (ptr = (g_free (ptr), NULL)), __temp13);
		} else {
			char* __temp14;
			__temp14 = NULL;
			ptr = (__temp14 = g_strdup ("**"), (ptr = (g_free (ptr), NULL)), __temp14);
		}
	}
	if (vala_type_reference_get_data_type (self) != NULL) {
		char* __temp15;
		char* __temp16;
		char* __temp17;
		__temp15 = NULL;
		__temp16 = NULL;
		__temp17 = NULL;
		return (__temp17 = (__temp16 = g_strconcat ((__temp15 = vala_data_type_get_cname (vala_type_reference_get_data_type (self), const_type)), ptr, arr, NULL, NULL), (__temp15 = (g_free (__temp15), NULL)), __temp16), (ptr = (g_free (ptr), NULL)), (arr = (g_free (arr), NULL)), __temp17);
	} else {
		if (vala_type_reference_get_type_parameter (self) != NULL) {
			char* __temp18;
			__temp18 = NULL;
			return (__temp18 = g_strconcat ("gpointer", ptr, arr, NULL, NULL), (ptr = (g_free (ptr), NULL)), (arr = (g_free (arr), NULL)), __temp18);
		} else {
			gpointer __temp19;
			/* raise error */
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self)), "unresolved type reference");
			return (__temp19 = NULL, (ptr = (g_free (ptr), NULL)), (arr = (g_free (arr), NULL)), __temp19);
		}
	}
	(ptr = (g_free (ptr), NULL));
	(arr = (g_free (arr), NULL));
}


/**
 * Returns the name and qualifiers of this type as it is used in C code
 * in a const declaration.
 *
 * @return the type string to be used in C code const declarations
 */
char* vala_type_reference_get_const_cname (ValaTypeReference* self)
{
	char* ptr;
	ValaDataType* t;
	char* __temp26;
	char* __temp27;
	char* __temp28;
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	ptr = NULL;
	t = NULL;
	/* FIXME: dirty hack to make constant arrays possible */
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (self))) {
		ValaDataType* __temp21;
		ValaDataType* __temp20;
		__temp21 = NULL;
		__temp20 = NULL;
		t = (__temp21 = (__temp20 = vala_array_get_element_type ((VALA_ARRAY (vala_type_reference_get_data_type (self)))), (__temp20 == NULL ? NULL : g_object_ref (__temp20))), (t == NULL ? NULL : (t = (g_object_unref (t), NULL))), __temp21);
	} else {
		ValaDataType* __temp23;
		ValaDataType* __temp22;
		__temp23 = NULL;
		__temp22 = NULL;
		t = (__temp23 = (__temp22 = vala_type_reference_get_data_type (self), (__temp22 == NULL ? NULL : g_object_ref (__temp22))), (t == NULL ? NULL : (t = (g_object_unref (t), NULL))), __temp23);
	}
	if (!vala_data_type_is_reference_type (t)) {
		char* __temp24;
		__temp24 = NULL;
		ptr = (__temp24 = g_strdup (""), (ptr = (g_free (ptr), NULL)), __temp24);
	} else {
		char* __temp25;
		__temp25 = NULL;
		ptr = (__temp25 = g_strdup ("*"), (ptr = (g_free (ptr), NULL)), __temp25);
	}
	__temp26 = NULL;
	__temp27 = NULL;
	__temp28 = NULL;
	return (__temp28 = (__temp27 = g_strdup_printf ("const %s%s", (__temp26 = vala_data_type_get_cname (t, FALSE)), ptr), (__temp26 = (g_free (__temp26), NULL)), __temp27), (ptr = (g_free (ptr), NULL)), (t == NULL ? NULL : (t = (g_object_unref (t), NULL))), __temp28);
	(ptr = (g_free (ptr), NULL));
	(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
}


/**
 * Returns a user-readable name of the type corresponding to this type
 * reference.
 *
 * @return display name
 */
char* vala_type_reference_to_string (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	if (vala_type_reference_get_data_type (self) != NULL) {
		return vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (self))));
	} else {
		if (vala_type_reference_get_type_parameter (self) != NULL) {
			return g_strdup (vala_type_parameter_get_name (vala_type_reference_get_type_parameter (self)));
		} else {
			return g_strdup ("null");
		}
	}
}


/**
 * Creates a shallow copy of this type reference.
 *
 * @return copy of this type reference
 */
ValaTypeReference* vala_type_reference_copy (ValaTypeReference* self)
{
	ValaTypeReference* result;
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	result = vala_type_reference_new ();
	(vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self))), vala_code_node_get_source_reference (VALA_CODE_NODE (result)));
	(vala_type_reference_set_transfers_ownership (result, vala_type_reference_get_transfers_ownership (self)), vala_type_reference_get_transfers_ownership (result));
	(vala_type_reference_set_takes_ownership (result, vala_type_reference_get_takes_ownership (self)), vala_type_reference_get_takes_ownership (result));
	(vala_type_reference_set_is_out (result, vala_type_reference_get_is_out (self)), vala_type_reference_get_is_out (result));
	(vala_type_reference_set_non_null (result, vala_type_reference_get_non_null (self)), vala_type_reference_get_non_null (result));
	(vala_type_reference_set_data_type (result, vala_type_reference_get_data_type (self)), vala_type_reference_get_data_type (result));
	(vala_type_reference_set_type_parameter (result, vala_type_reference_get_type_parameter (self)), vala_type_reference_get_type_parameter (result));
	(vala_type_reference_set_floating_reference (result, vala_type_reference_get_floating_reference (self)), vala_type_reference_get_floating_reference (result));
	(vala_type_reference_set_namespace_name (result, vala_type_reference_get_namespace_name (self)), vala_type_reference_get_namespace_name (result));
	(vala_type_reference_set_type_name (result, vala_type_reference_get_type_name (self)), vala_type_reference_get_type_name (result));
	(vala_type_reference_set_array_rank (result, vala_type_reference_get_array_rank (self)), vala_type_reference_get_array_rank (result));
	(vala_type_reference_set_pointer_level (result, vala_type_reference_get_pointer_level (self)), vala_type_reference_get_pointer_level (result));
	(vala_type_reference_set_is_ref (result, vala_type_reference_get_is_ref (self)), vala_type_reference_get_is_ref (result));
	(vala_type_reference_set_is_weak (result, vala_type_reference_get_is_weak (self)), vala_type_reference_get_is_weak (result));
	{
		GList* __temp32;
		GList* arg_it;
		__temp32 = NULL;
		__temp32 = self->priv->type_argument_list;
		for (arg_it = __temp32; arg_it != NULL; arg_it = arg_it->next) {
			ValaTypeReference* arg;
			arg = arg_it->data;
			{
				result->priv->type_argument_list = g_list_append (result->priv->type_argument_list, vala_type_reference_copy (arg));
			}
		}
	}
	return result;
	(result == NULL ? NULL : (result = (g_object_unref (result), NULL)));
}


/**
 * Checks two type references for equality. May only be used with
 * resolved type references.
 *
 * @param type2 a type reference
 * @return      true if this type reference is equal to type2, false
 *              otherwise
 */
gboolean vala_type_reference_equals (ValaTypeReference* self, ValaTypeReference* type2)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type2), FALSE);
	if (vala_type_reference_get_transfers_ownership (type2) != vala_type_reference_get_transfers_ownership (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_takes_ownership (type2) != vala_type_reference_get_takes_ownership (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_is_ref (type2) != vala_type_reference_get_is_ref (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_is_out (type2) != vala_type_reference_get_is_out (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_non_null (type2) != vala_type_reference_get_non_null (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_data_type (type2) != vala_type_reference_get_data_type (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_type_parameter (type2) != NULL || vala_type_reference_get_type_parameter (self) != NULL) {
		if (vala_type_reference_get_type_parameter (type2) == NULL || vala_type_reference_get_type_parameter (self) == NULL) {
			return FALSE;
		}
		if (!vala_type_parameter_equals (vala_type_reference_get_type_parameter (type2), vala_type_reference_get_type_parameter (self))) {
			return FALSE;
		}
	}
	if (vala_type_reference_get_floating_reference (type2) != vala_type_reference_get_floating_reference (self)) {
		return FALSE;
	}
	return TRUE;
}


/**
 * Checks whether this type reference is at least as strict as the
 * specified type reference type2.
 *
 * @param type2 a type reference
 * @return      true if this type reference is stricter or equal
 */
gboolean vala_type_reference_stricter (ValaTypeReference* self, ValaTypeReference* type2)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type2), FALSE);
	if (vala_type_reference_get_transfers_ownership (type2) != vala_type_reference_get_transfers_ownership (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_takes_ownership (type2) != vala_type_reference_get_takes_ownership (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_is_ref (type2) != vala_type_reference_get_is_ref (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_is_out (type2) != vala_type_reference_get_is_out (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_non_null (type2) && !vala_type_reference_get_non_null (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_data_type (type2) != vala_type_reference_get_data_type (self)) {
		return FALSE;
	}
	/* FIXME: allow this type reference to refer to a
	        subtype of the type type2 is referring to*/
	if (vala_type_reference_get_type_parameter (type2) != vala_type_reference_get_type_parameter (self)) {
		return FALSE;
	}
	if (vala_type_reference_get_floating_reference (type2) != vala_type_reference_get_floating_reference (self)) {
		return FALSE;
	}
	return TRUE;
}


gboolean vala_type_reference_get_transfers_ownership (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	return self->priv->_transfers_ownership;
}


void vala_type_reference_set_transfers_ownership (ValaTypeReference* self, gboolean value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_transfers_ownership = value;
}


gboolean vala_type_reference_get_takes_ownership (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	return self->priv->_takes_ownership;
}


void vala_type_reference_set_takes_ownership (ValaTypeReference* self, gboolean value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_takes_ownership = value;
}


gboolean vala_type_reference_get_is_out (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	return self->priv->_is_out;
}


void vala_type_reference_set_is_out (ValaTypeReference* self, gboolean value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_is_out = value;
}


gboolean vala_type_reference_get_non_null (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	return self->priv->_non_null;
}


void vala_type_reference_set_non_null (ValaTypeReference* self, gboolean value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_non_null = value;
}


gboolean vala_type_reference_get_is_null (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	return self->priv->_is_null;
}


void vala_type_reference_set_is_null (ValaTypeReference* self, gboolean value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_is_null = value;
}


ValaDataType* vala_type_reference_get_data_type (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	return self->priv->_data_type;
}


void vala_type_reference_set_data_type (ValaTypeReference* self, ValaDataType* value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_data_type = value;
}


ValaTypeParameter* vala_type_reference_get_type_parameter (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	return self->priv->_type_parameter;
}


void vala_type_reference_set_type_parameter (ValaTypeReference* self, ValaTypeParameter* value)
{
	ValaTypeParameter* __temp61;
	ValaTypeParameter* __temp60;
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	__temp61 = NULL;
	__temp60 = NULL;
	self->priv->_type_parameter = (__temp61 = (__temp60 = value, (__temp60 == NULL ? NULL : g_object_ref (__temp60))), (self->priv->_type_parameter == NULL ? NULL : (self->priv->_type_parameter = (g_object_unref (self->priv->_type_parameter), NULL))), __temp61);
}


gboolean vala_type_reference_get_floating_reference (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	return self->priv->_floating_reference;
}


void vala_type_reference_set_floating_reference (ValaTypeReference* self, gboolean value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_floating_reference = value;
}


char* vala_type_reference_get_namespace_name (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	return self->priv->_namespace_name;
}


void vala_type_reference_set_namespace_name (ValaTypeReference* self, const char* value)
{
	char* __temp65;
	const char* __temp64;
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	__temp65 = NULL;
	__temp64 = NULL;
	self->priv->_namespace_name = (__temp65 = (__temp64 = value, (__temp64 == NULL ? NULL : g_strdup (__temp64))), (self->priv->_namespace_name = (g_free (self->priv->_namespace_name), NULL)), __temp65);
}


char* vala_type_reference_get_type_name (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), NULL);
	return self->priv->_type_name;
}


void vala_type_reference_set_type_name (ValaTypeReference* self, const char* value)
{
	char* __temp68;
	const char* __temp67;
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	__temp68 = NULL;
	__temp67 = NULL;
	self->priv->_type_name = (__temp68 = (__temp67 = value, (__temp67 == NULL ? NULL : g_strdup (__temp67))), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), __temp68);
}


gint vala_type_reference_get_array_rank (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), 0);
	return self->priv->_array_rank;
}


void vala_type_reference_set_array_rank (ValaTypeReference* self, gint value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_array_rank = value;
}


gint vala_type_reference_get_pointer_level (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), 0);
	return self->priv->_pointer_level;
}


void vala_type_reference_set_pointer_level (ValaTypeReference* self, gint value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_pointer_level = value;
}


gboolean vala_type_reference_get_is_ref (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	return self->priv->_is_ref;
}


void vala_type_reference_set_is_ref (ValaTypeReference* self, gboolean value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_is_ref = value;
}


gboolean vala_type_reference_get_is_weak (ValaTypeReference* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (self), FALSE);
	return self->priv->_is_weak;
}


void vala_type_reference_set_is_weak (ValaTypeReference* self, gboolean value)
{
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (self));
	self->priv->_is_weak = value;
}


static void vala_type_reference_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaTypeReference * self;
	self = VALA_TYPE_REFERENCE (object);
	switch (property_id) {
		case VALA_TYPE_REFERENCE_TRANSFERS_OWNERSHIP:
		g_value_set_boolean (value, vala_type_reference_get_transfers_ownership (self));
		break;
		case VALA_TYPE_REFERENCE_TAKES_OWNERSHIP:
		g_value_set_boolean (value, vala_type_reference_get_takes_ownership (self));
		break;
		case VALA_TYPE_REFERENCE_IS_OUT:
		g_value_set_boolean (value, vala_type_reference_get_is_out (self));
		break;
		case VALA_TYPE_REFERENCE_NON_NULL:
		g_value_set_boolean (value, vala_type_reference_get_non_null (self));
		break;
		case VALA_TYPE_REFERENCE_IS_NULL:
		g_value_set_boolean (value, vala_type_reference_get_is_null (self));
		break;
		case VALA_TYPE_REFERENCE_DATA_TYPE:
		g_value_set_object (value, vala_type_reference_get_data_type (self));
		break;
		case VALA_TYPE_REFERENCE_TYPE_PARAMETER:
		g_value_set_object (value, vala_type_reference_get_type_parameter (self));
		break;
		case VALA_TYPE_REFERENCE_FLOATING_REFERENCE:
		g_value_set_boolean (value, vala_type_reference_get_floating_reference (self));
		break;
		case VALA_TYPE_REFERENCE_NAMESPACE_NAME:
		g_value_set_string (value, vala_type_reference_get_namespace_name (self));
		break;
		case VALA_TYPE_REFERENCE_TYPE_NAME:
		g_value_set_string (value, vala_type_reference_get_type_name (self));
		break;
		case VALA_TYPE_REFERENCE_ARRAY_RANK:
		g_value_set_int (value, vala_type_reference_get_array_rank (self));
		break;
		case VALA_TYPE_REFERENCE_POINTER_LEVEL:
		g_value_set_int (value, vala_type_reference_get_pointer_level (self));
		break;
		case VALA_TYPE_REFERENCE_IS_REF:
		g_value_set_boolean (value, vala_type_reference_get_is_ref (self));
		break;
		case VALA_TYPE_REFERENCE_IS_WEAK:
		g_value_set_boolean (value, vala_type_reference_get_is_weak (self));
		break;
	}
}


static void vala_type_reference_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaTypeReference * self;
	self = VALA_TYPE_REFERENCE (object);
	switch (property_id) {
		case VALA_TYPE_REFERENCE_TRANSFERS_OWNERSHIP:
		vala_type_reference_set_transfers_ownership (self, g_value_get_boolean (value));
		break;
		case VALA_TYPE_REFERENCE_TAKES_OWNERSHIP:
		vala_type_reference_set_takes_ownership (self, g_value_get_boolean (value));
		break;
		case VALA_TYPE_REFERENCE_IS_OUT:
		vala_type_reference_set_is_out (self, g_value_get_boolean (value));
		break;
		case VALA_TYPE_REFERENCE_NON_NULL:
		vala_type_reference_set_non_null (self, g_value_get_boolean (value));
		break;
		case VALA_TYPE_REFERENCE_IS_NULL:
		vala_type_reference_set_is_null (self, g_value_get_boolean (value));
		break;
		case VALA_TYPE_REFERENCE_DATA_TYPE:
		vala_type_reference_set_data_type (self, g_value_get_object (value));
		break;
		case VALA_TYPE_REFERENCE_TYPE_PARAMETER:
		vala_type_reference_set_type_parameter (self, g_value_get_object (value));
		break;
		case VALA_TYPE_REFERENCE_FLOATING_REFERENCE:
		vala_type_reference_set_floating_reference (self, g_value_get_boolean (value));
		break;
		case VALA_TYPE_REFERENCE_NAMESPACE_NAME:
		vala_type_reference_set_namespace_name (self, g_value_get_string (value));
		break;
		case VALA_TYPE_REFERENCE_TYPE_NAME:
		vala_type_reference_set_type_name (self, g_value_get_string (value));
		break;
		case VALA_TYPE_REFERENCE_ARRAY_RANK:
		vala_type_reference_set_array_rank (self, g_value_get_int (value));
		break;
		case VALA_TYPE_REFERENCE_POINTER_LEVEL:
		vala_type_reference_set_pointer_level (self, g_value_get_int (value));
		break;
		case VALA_TYPE_REFERENCE_IS_REF:
		vala_type_reference_set_is_ref (self, g_value_get_boolean (value));
		break;
		case VALA_TYPE_REFERENCE_IS_WEAK:
		vala_type_reference_set_is_weak (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_type_reference_class_init (ValaTypeReferenceClass * klass)
{
	vala_type_reference_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeReferencePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_type_reference_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_type_reference_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_type_reference_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_type_reference_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_TRANSFERS_OWNERSHIP, g_param_spec_boolean ("transfers-ownership", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_TAKES_OWNERSHIP, g_param_spec_boolean ("takes-ownership", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_IS_OUT, g_param_spec_boolean ("is-out", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_NON_NULL, g_param_spec_boolean ("non-null", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_IS_NULL, g_param_spec_boolean ("is-null", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_DATA_TYPE, g_param_spec_object ("data-type", "foo", "bar", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_TYPE_PARAMETER, g_param_spec_object ("type-parameter", "foo", "bar", VALA_TYPE_TYPE_PARAMETER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_FLOATING_REFERENCE, g_param_spec_boolean ("floating-reference", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_NAMESPACE_NAME, g_param_spec_string ("namespace-name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_TYPE_NAME, g_param_spec_string ("type-name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_ARRAY_RANK, g_param_spec_int ("array-rank", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_POINTER_LEVEL, g_param_spec_int ("pointer-level", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_IS_REF, g_param_spec_boolean ("is-ref", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_REFERENCE_IS_WEAK, g_param_spec_boolean ("is-weak", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_type_reference_init (ValaTypeReference * self)
{
	self->priv = VALA_TYPE_REFERENCE_GET_PRIVATE (self);
}


static void vala_type_reference_dispose (GObject * obj)
{
	ValaTypeReference * self;
	ValaTypeReferenceClass * klass;
	GObjectClass * parent_class;
	self = VALA_TYPE_REFERENCE (obj);
	(self->priv->_type_parameter == NULL ? NULL : (self->priv->_type_parameter = (g_object_unref (self->priv->_type_parameter), NULL)));
	(self->priv->_namespace_name = (g_free (self->priv->_namespace_name), NULL));
	(self->priv->_type_name = (g_free (self->priv->_type_name), NULL));
	(self->priv->type_argument_list == NULL ? NULL : (self->priv->type_argument_list = (g_list_foreach (self->priv->type_argument_list, (GFunc) g_object_unref, NULL), g_list_free (self->priv->type_argument_list), NULL)));
	klass = VALA_TYPE_REFERENCE_CLASS (g_type_class_peek (VALA_TYPE_TYPE_REFERENCE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_type_reference_get_type ()
{
	static GType vala_type_reference_type_id = 0;
	if (G_UNLIKELY (vala_type_reference_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeReferenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_type_reference_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeReference), 0, (GInstanceInitFunc) vala_type_reference_init };
		vala_type_reference_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaTypeReference", &g_define_type_info, 0);
	}
	return vala_type_reference_type_id;
}




