/* valaccodecasestatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodecasestatement.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeCaseStatementPrivate {
	ValaCCodeExpression* _expression;
	GList* statements;
};
#define VALA_CCODE_CASE_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatementPrivate))
enum  {
	VALA_CCODE_CASE_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_CASE_STATEMENT_EXPRESSION
};
static void vala_ccode_case_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_case_statement_parent_class = NULL;
static void vala_ccode_case_statement_dispose (GObject * obj);


ValaCCodeCaseStatement* vala_ccode_case_statement_new (ValaCCodeExpression* expr)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeCaseStatement * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expr), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "expression", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, expr), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_CASE_STATEMENT, __params_it - __params, __params);
	return self;
}


/**
 * Append the specified statement to this switch section.
 *
 * @param stmt a statement
 */
void vala_ccode_case_statement_add_statement (ValaCCodeCaseStatement* self, ValaCCodeStatement* stmt)
{
	g_return_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_STATEMENT (stmt));
	self->priv->statements = g_list_append (self->priv->statements, g_object_ref (stmt));
}


static void vala_ccode_case_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "case ");
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_case_statement_get_expression (self)), writer);
	vala_ccode_writer_write_string (writer, ":");
	vala_ccode_writer_write_newline (writer);
	{
		GList* __temp0;
		GList* stmt_it;
		__temp0 = NULL;
		__temp0 = self->priv->statements;
		for (stmt_it = __temp0; stmt_it != NULL; stmt_it = stmt_it->next) {
			ValaCCodeStatement* stmt;
			stmt = stmt_it->data;
			{
				vala_ccode_node_write (VALA_CCODE_NODE (stmt), writer);
			}
		}
	}
}


ValaCCodeExpression* vala_ccode_case_statement_get_expression (ValaCCodeCaseStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_ccode_case_statement_set_expression (ValaCCodeCaseStatement* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp2;
	g_return_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self));
	__temp2 = NULL;
	self->priv->_expression = (__temp2 = g_object_ref (value), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), __temp2);
}


static void vala_ccode_case_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_CASE_STATEMENT_EXPRESSION:
		g_value_set_object (value, vala_ccode_case_statement_get_expression (self));
		break;
	}
}


static void vala_ccode_case_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_CASE_STATEMENT_EXPRESSION:
		vala_ccode_case_statement_set_expression (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_case_statement_class_init (ValaCCodeCaseStatementClass * klass)
{
	vala_ccode_case_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeCaseStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_case_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_case_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_case_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_case_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_CASE_STATEMENT_EXPRESSION, g_param_spec_object ("expression", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_case_statement_init (ValaCCodeCaseStatement * self)
{
	self->priv = VALA_CCODE_CASE_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_case_statement_dispose (GObject * obj)
{
	ValaCCodeCaseStatement * self;
	ValaCCodeCaseStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_CASE_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	(self->priv->statements == NULL ? NULL : (self->priv->statements = (g_list_foreach (self->priv->statements, (GFunc) g_object_unref, NULL), g_list_free (self->priv->statements), NULL)));
	klass = VALA_CCODE_CASE_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_CASE_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_case_statement_get_type ()
{
	static GType vala_ccode_case_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_case_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCaseStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_case_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCaseStatement), 0, (GInstanceInitFunc) vala_ccode_case_statement_init };
		vala_ccode_case_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeCaseStatement", &g_define_type_info, 0);
	}
	return vala_ccode_case_statement_type_id;
}




