/* valaccodeforstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodeforstatement.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeForStatementPrivate {
	ValaCCodeExpression* _condition;
	ValaCCodeStatement* _body;
	GList* initializer;
	GList* iterator;
};
#define VALA_CCODE_FOR_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FOR_STATEMENT, ValaCCodeForStatementPrivate))
enum  {
	VALA_CCODE_FOR_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_FOR_STATEMENT_CONDITION,
	VALA_CCODE_FOR_STATEMENT_BODY
};
static void vala_ccode_for_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_for_statement_parent_class = NULL;
static void vala_ccode_for_statement_dispose (GObject * obj);


ValaCCodeForStatement* vala_ccode_for_statement_new (ValaCCodeExpression* cond, ValaCCodeStatement* stmt)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeForStatement * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cond), NULL);
	g_return_val_if_fail (stmt == NULL || VALA_IS_CCODE_STATEMENT (stmt), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "condition", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, cond), __params_it++);
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_CCODE_STATEMENT), g_value_set_object (&__params_it->value, stmt), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_FOR_STATEMENT, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified expression to the list of initializers.
 *
 * @param expr an initializer expression
 */
void vala_ccode_for_statement_add_initializer (ValaCCodeForStatement* self, ValaCCodeExpression* expr)
{
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	self->priv->initializer = g_list_append (self->priv->initializer, g_object_ref (expr));
}


/**
 * Appends the specified expression to the iterator.
 *
 * @param expr an iterator expression
 */
void vala_ccode_for_statement_add_iterator (ValaCCodeForStatement* self, ValaCCodeExpression* expr)
{
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	self->priv->iterator = g_list_append (self->priv->iterator, g_object_ref (expr));
}


static void vala_ccode_for_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeForStatement * self;
	gboolean first;
	self = VALA_CCODE_FOR_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	first = FALSE;
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "for (");
	first = TRUE;
	{
		GList* __temp0;
		GList* init_expr_it;
		__temp0 = NULL;
		__temp0 = self->priv->initializer;
		for (init_expr_it = __temp0; init_expr_it != NULL; init_expr_it = init_expr_it->next) {
			ValaCCodeExpression* init_expr;
			init_expr = init_expr_it->data;
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (init_expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (init_expr), writer);
				}
			}
		}
	}
	vala_ccode_writer_write_string (writer, "; ");
	if (vala_ccode_for_statement_get_condition (self) != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_for_statement_get_condition (self)), writer);
	}
	vala_ccode_writer_write_string (writer, "; ");
	first = TRUE;
	{
		GList* __temp1;
		GList* it_expr_it;
		__temp1 = NULL;
		__temp1 = self->priv->iterator;
		for (it_expr_it = __temp1; it_expr_it != NULL; it_expr_it = it_expr_it->next) {
			ValaCCodeExpression* it_expr;
			it_expr = it_expr_it->data;
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (it_expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (it_expr), writer);
				}
			}
		}
	}
	vala_ccode_writer_write_string (writer, ")");
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_for_statement_get_body (self)), writer);
}


ValaCCodeExpression* vala_ccode_for_statement_get_condition (ValaCCodeForStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_ccode_for_statement_set_condition (ValaCCodeForStatement* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp3;
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	__temp3 = NULL;
	self->priv->_condition = (__temp3 = g_object_ref (value), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), __temp3);
}


ValaCCodeStatement* vala_ccode_for_statement_get_body (ValaCCodeForStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_ccode_for_statement_set_body (ValaCCodeForStatement* self, ValaCCodeStatement* value)
{
	ValaCCodeStatement* __temp6;
	ValaCCodeStatement* __temp5;
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	__temp6 = NULL;
	__temp5 = NULL;
	self->priv->_body = (__temp6 = (__temp5 = value, (__temp5 == NULL ? NULL : g_object_ref (__temp5))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp6);
}


static void vala_ccode_for_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeForStatement * self;
	self = VALA_CCODE_FOR_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_FOR_STATEMENT_CONDITION:
		g_value_set_object (value, vala_ccode_for_statement_get_condition (self));
		break;
		case VALA_CCODE_FOR_STATEMENT_BODY:
		g_value_set_object (value, vala_ccode_for_statement_get_body (self));
		break;
	}
}


static void vala_ccode_for_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeForStatement * self;
	self = VALA_CCODE_FOR_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_FOR_STATEMENT_CONDITION:
		vala_ccode_for_statement_set_condition (self, g_value_get_object (value));
		break;
		case VALA_CCODE_FOR_STATEMENT_BODY:
		vala_ccode_for_statement_set_body (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_for_statement_class_init (ValaCCodeForStatementClass * klass)
{
	vala_ccode_for_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeForStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_for_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_for_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_for_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_for_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FOR_STATEMENT_CONDITION, g_param_spec_object ("condition", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FOR_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_CCODE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_for_statement_init (ValaCCodeForStatement * self)
{
	self->priv = VALA_CCODE_FOR_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_for_statement_dispose (GObject * obj)
{
	ValaCCodeForStatement * self;
	ValaCCodeForStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_FOR_STATEMENT (obj);
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->initializer == NULL ? NULL : (self->priv->initializer = (g_list_foreach (self->priv->initializer, (GFunc) g_object_unref, NULL), g_list_free (self->priv->initializer), NULL)));
	(self->priv->iterator == NULL ? NULL : (self->priv->iterator = (g_list_foreach (self->priv->iterator, (GFunc) g_object_unref, NULL), g_list_free (self->priv->iterator), NULL)));
	klass = VALA_CCODE_FOR_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_FOR_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_for_statement_get_type ()
{
	static GType vala_ccode_for_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_for_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeForStatement), 0, (GInstanceInitFunc) vala_ccode_for_statement_init };
		vala_ccode_for_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeForStatement", &g_define_type_info, 0);
	}
	return vala_ccode_for_statement_type_id;
}




