/* valaclassregisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACLASSREGISTERFUNCTION_H__
#define __VALACLASSREGISTERFUNCTION_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valaclass.h>
#include <vala/valadatatype.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodefragment.h>
#include <gobject/valatyperegisterfunction.h>

G_BEGIN_DECLS


#define VALA_TYPE_CLASS_REGISTER_FUNCTION (vala_class_register_function_get_type ())
#define VALA_CLASS_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunction))
#define VALA_CLASS_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionClass))
#define VALA_IS_CLASS_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION))
#define VALA_IS_CLASS_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS_REGISTER_FUNCTION))
#define VALA_CLASS_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionClass))

typedef struct _ValaClassRegisterFunction ValaClassRegisterFunction;
typedef struct _ValaClassRegisterFunctionClass ValaClassRegisterFunctionClass;
typedef struct _ValaClassRegisterFunctionPrivate ValaClassRegisterFunctionPrivate;

/**
 * C function to register a class at runtime.
 */
struct _ValaClassRegisterFunction {
	ValaTypeRegisterFunction parent;
	ValaClassRegisterFunctionPrivate * priv;
};
struct _ValaClassRegisterFunctionClass {
	ValaTypeRegisterFunctionClass parent;
};

ValaClassRegisterFunction* vala_class_register_function_new (ValaClass* cl);
ValaClass* vala_class_register_function_get_class_reference (ValaClassRegisterFunction* self);
void vala_class_register_function_set_class_reference (ValaClassRegisterFunction* self, ValaClass* value);
GType vala_class_register_function_get_type ();

G_END_DECLS

#endif
