/* valasourcereference.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALASOURCEREFERENCE_H__
#define __VALASOURCEREFERENCE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReferencePrivate ValaSourceReferencePrivate;

/**
 * Represents a reference to a location in a source file.
 */
struct _ValaSourceReference {
	GObject parent;
	ValaSourceReferencePrivate * priv;
};
struct _ValaSourceReferenceClass {
	GObjectClass parent;
};

ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaSourceReference* vala_source_reference_new_with_comment (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column, const char* _comment);
char* vala_source_reference_to_string (ValaSourceReference* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_source_reference_set_file (ValaSourceReference* self, ValaSourceFile* value);
gint vala_source_reference_get_first_line (ValaSourceReference* self);
void vala_source_reference_set_first_line (ValaSourceReference* self, gint value);
gint vala_source_reference_get_first_column (ValaSourceReference* self);
void vala_source_reference_set_first_column (ValaSourceReference* self, gint value);
gint vala_source_reference_get_last_line (ValaSourceReference* self);
void vala_source_reference_set_last_line (ValaSourceReference* self, gint value);
gint vala_source_reference_get_last_column (ValaSourceReference* self);
void vala_source_reference_set_last_column (ValaSourceReference* self, gint value);
char* vala_source_reference_get_comment (ValaSourceReference* self);
void vala_source_reference_set_comment (ValaSourceReference* self, const char* value);
GType vala_source_reference_get_type ();

G_END_DECLS

#endif
