/* valaccodefunctiondeclarator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodefunctiondeclarator.h"
#include <ccode/valaccodefunctiondeclarator.h>

struct _ValaCCodeFunctionDeclaratorPrivate {
	char* _name;
	GList* parameters;
};
#define VALA_CCODE_FUNCTION_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclaratorPrivate))
enum  {
	VALA_CCODE_FUNCTION_DECLARATOR_DUMMY_PROPERTY,
	VALA_CCODE_FUNCTION_DECLARATOR_NAME
};
static void vala_ccode_function_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_function_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_function_declarator_parent_class = NULL;
static void vala_ccode_function_declarator_dispose (GObject * obj);


ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_new (const char* n)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeFunctionDeclarator * self;
	g_return_val_if_fail (n != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, n), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_FUNCTION_DECLARATOR, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified parameter to the list of function parameters.
 *
 * @param param a formal parameter
 */
void vala_ccode_function_declarator_add_parameter (ValaCCodeFunctionDeclarator* self, ValaCCodeFormalParameter* param)
{
	g_return_if_fail (VALA_IS_CCODE_FUNCTION_DECLARATOR (self));
	g_return_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (param));
	self->priv->parameters = g_list_append (self->priv->parameters, g_object_ref (param));
}


static void vala_ccode_function_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeFunctionDeclarator * self;
	self = VALA_CCODE_FUNCTION_DECLARATOR (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self), writer);
}


static void vala_ccode_function_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeFunctionDeclarator * self;
	gboolean first;
	self = VALA_CCODE_FUNCTION_DECLARATOR (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, "(*");
	vala_ccode_writer_write_string (writer, vala_ccode_function_declarator_get_name (self));
	vala_ccode_writer_write_string (writer, ") (");
	first = TRUE;
	{
		GList* __temp0;
		GList* param_it;
		__temp0 = NULL;
		__temp0 = self->priv->parameters;
		for (param_it = __temp0; param_it != NULL; param_it = param_it->next) {
			ValaCCodeFormalParameter* param;
			param = param_it->data;
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				vala_ccode_node_write (VALA_CCODE_NODE (param), writer);
			}
		}
	}
	vala_ccode_writer_write_string (writer, ")");
}


char* vala_ccode_function_declarator_get_name (ValaCCodeFunctionDeclarator* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FUNCTION_DECLARATOR (self), NULL);
	return self->priv->_name;
}


void vala_ccode_function_declarator_set_name (ValaCCodeFunctionDeclarator* self, const char* value)
{
	char* __temp2;
	g_return_if_fail (VALA_IS_CCODE_FUNCTION_DECLARATOR (self));
	__temp2 = NULL;
	self->priv->_name = (__temp2 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp2);
}


static void vala_ccode_function_declarator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeFunctionDeclarator * self;
	self = VALA_CCODE_FUNCTION_DECLARATOR (object);
	switch (property_id) {
		case VALA_CCODE_FUNCTION_DECLARATOR_NAME:
		g_value_set_string (value, vala_ccode_function_declarator_get_name (self));
		break;
	}
}


static void vala_ccode_function_declarator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeFunctionDeclarator * self;
	self = VALA_CCODE_FUNCTION_DECLARATOR (object);
	switch (property_id) {
		case VALA_CCODE_FUNCTION_DECLARATOR_NAME:
		vala_ccode_function_declarator_set_name (self, g_value_get_string (value));
		break;
	}
}


static void vala_ccode_function_declarator_class_init (ValaCCodeFunctionDeclaratorClass * klass)
{
	vala_ccode_function_declarator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeFunctionDeclaratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_function_declarator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_function_declarator_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_function_declarator_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_function_declarator_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_function_declarator_real_write_declaration;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FUNCTION_DECLARATOR_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_function_declarator_init (ValaCCodeFunctionDeclarator * self)
{
	self->priv = VALA_CCODE_FUNCTION_DECLARATOR_GET_PRIVATE (self);
}


static void vala_ccode_function_declarator_dispose (GObject * obj)
{
	ValaCCodeFunctionDeclarator * self;
	ValaCCodeFunctionDeclaratorClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_FUNCTION_DECLARATOR (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->parameters == NULL ? NULL : (self->priv->parameters = (g_list_foreach (self->priv->parameters, (GFunc) g_object_unref, NULL), g_list_free (self->priv->parameters), NULL)));
	klass = VALA_CCODE_FUNCTION_DECLARATOR_CLASS (g_type_class_peek (VALA_TYPE_CCODE_FUNCTION_DECLARATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_function_declarator_get_type ()
{
	static GType vala_ccode_function_declarator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_function_declarator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFunctionDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_function_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFunctionDeclarator), 0, (GInstanceInitFunc) vala_ccode_function_declarator_init };
		vala_ccode_function_declarator_type_id = g_type_register_static (VALA_TYPE_CCODE_DECLARATOR, "ValaCCodeFunctionDeclarator", &g_define_type_info, 0);
	}
	return vala_ccode_function_declarator_type_id;
}




