/* valalocalvariabledeclaration.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valalocalvariabledeclaration.h"
#include <vala/valatypereference.h>
#include <vala/valasourcereference.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valacodevisitor.h>

struct _ValaLocalVariableDeclarationPrivate {
	ValaTypeReference* _type_reference;
	GList* variable_declarators;
};
#define VALA_LOCAL_VARIABLE_DECLARATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE_DECLARATION, ValaLocalVariableDeclarationPrivate))
enum  {
	VALA_LOCAL_VARIABLE_DECLARATION_DUMMY_PROPERTY,
	VALA_LOCAL_VARIABLE_DECLARATION_TYPE_REFERENCE
};
static void vala_local_variable_declaration_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_local_variable_declaration_parent_class = NULL;
static void vala_local_variable_declaration_dispose (GObject * obj);


/**
 * Creates a new local variable declaration.
 *
 * @param type   type of the variable
 * @param source reference to source code
 * @return       newly created local variable declaration
 */
ValaLocalVariableDeclaration* vala_local_variable_declaration_new (ValaTypeReference* type, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaLocalVariableDeclaration * self;
	g_return_val_if_fail (type == NULL || VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, type), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_LOCAL_VARIABLE_DECLARATION, __params_it - __params, __params);
	return self;
}


/**
 * Creates a new implicitly typed local variable declaration. The type
 * of the variable is inferred from the expression used to initialize
 * the variable.
 *
 * @param source reference to source code
 * @return       newly created local variable declaration
 */
ValaLocalVariableDeclaration* vala_local_variable_declaration_new_var_type (ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaLocalVariableDeclaration * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_LOCAL_VARIABLE_DECLARATION, __params_it - __params, __params);
	return self;
}


/**
 * Add the specified variable declarator to this local variable
 * declaration.
 *
 * @param declarator a variable declarator
 */
void vala_local_variable_declaration_add_declarator (ValaLocalVariableDeclaration* self, ValaVariableDeclarator* declarator)
{
	g_return_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (self));
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (declarator));
	self->priv->variable_declarators = g_list_append (self->priv->variable_declarators, g_object_ref (declarator));
}


/**
 * Returns a copy of the list of variable declarators.
 *
 * @return variable declarator list
 */
GList* vala_local_variable_declaration_get_variable_declarators (ValaLocalVariableDeclaration* self)
{
	g_return_val_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (self), NULL);
	return g_list_copy (self->priv->variable_declarators);
}


static void vala_local_variable_declaration_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaLocalVariableDeclaration * self;
	self = VALA_LOCAL_VARIABLE_DECLARATION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_local_variable_declaration_get_type_reference (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_local_variable_declaration_get_type_reference (self)), visitor);
	}
	{
		GList* __temp1;
		GList* decl_it;
		__temp1 = NULL;
		__temp1 = self->priv->variable_declarators;
		for (decl_it = __temp1; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (decl), visitor);
			}
		}
	}
	vala_code_visitor_visit_local_variable_declaration (visitor, self);
}


ValaTypeReference* vala_local_variable_declaration_get_type_reference (ValaLocalVariableDeclaration* self)
{
	g_return_val_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (self), NULL);
	return self->priv->_type_reference;
}


void vala_local_variable_declaration_set_type_reference (ValaLocalVariableDeclaration* self, ValaTypeReference* value)
{
	ValaTypeReference* __temp4;
	ValaTypeReference* __temp3;
	g_return_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (self));
	__temp4 = NULL;
	__temp3 = NULL;
	self->priv->_type_reference = (__temp4 = (__temp3 = value, (__temp3 == NULL ? NULL : g_object_ref (__temp3))), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp4);
}


static void vala_local_variable_declaration_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaLocalVariableDeclaration * self;
	self = VALA_LOCAL_VARIABLE_DECLARATION (object);
	switch (property_id) {
		case VALA_LOCAL_VARIABLE_DECLARATION_TYPE_REFERENCE:
		g_value_set_object (value, vala_local_variable_declaration_get_type_reference (self));
		break;
	}
}


static void vala_local_variable_declaration_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaLocalVariableDeclaration * self;
	self = VALA_LOCAL_VARIABLE_DECLARATION (object);
	switch (property_id) {
		case VALA_LOCAL_VARIABLE_DECLARATION_TYPE_REFERENCE:
		vala_local_variable_declaration_set_type_reference (self, g_value_get_object (value));
		break;
	}
}


static void vala_local_variable_declaration_class_init (ValaLocalVariableDeclarationClass * klass)
{
	vala_local_variable_declaration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaLocalVariableDeclarationPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_local_variable_declaration_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_local_variable_declaration_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_local_variable_declaration_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_local_variable_declaration_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LOCAL_VARIABLE_DECLARATION_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_local_variable_declaration_init (ValaLocalVariableDeclaration * self)
{
	self->priv = VALA_LOCAL_VARIABLE_DECLARATION_GET_PRIVATE (self);
}


static void vala_local_variable_declaration_dispose (GObject * obj)
{
	ValaLocalVariableDeclaration * self;
	ValaLocalVariableDeclarationClass * klass;
	GObjectClass * parent_class;
	self = VALA_LOCAL_VARIABLE_DECLARATION (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->variable_declarators == NULL ? NULL : (self->priv->variable_declarators = (g_list_foreach (self->priv->variable_declarators, (GFunc) g_object_unref, NULL), g_list_free (self->priv->variable_declarators), NULL)));
	klass = VALA_LOCAL_VARIABLE_DECLARATION_CLASS (g_type_class_peek (VALA_TYPE_LOCAL_VARIABLE_DECLARATION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_local_variable_declaration_get_type ()
{
	static GType vala_local_variable_declaration_type_id = 0;
	if (G_UNLIKELY (vala_local_variable_declaration_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableDeclarationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_declaration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariableDeclaration), 0, (GInstanceInitFunc) vala_local_variable_declaration_init };
		vala_local_variable_declaration_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaLocalVariableDeclaration", &g_define_type_info, 0);
	}
	return vala_local_variable_declaration_type_id;
}




