/* valanamespace.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALANAMESPACE_H__
#define __VALANAMESPACE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespacePrivate ValaNamespacePrivate;

/**
 * Represents a namespace declaration in the source code.
 */
struct _ValaNamespace {
	ValaCodeNode parent;
	ValaNamespacePrivate * priv;
};
struct _ValaNamespaceClass {
	ValaCodeNodeClass parent;
};

ValaNamespace* vala_namespace_new (const char* _name, ValaSourceReference* source);
void vala_namespace_add_class (ValaNamespace* self, ValaClass* cl);
void vala_namespace_remove_class (ValaNamespace* self, ValaClass* cl);
void vala_namespace_add_interface (ValaNamespace* self, ValaInterface* iface);
void vala_namespace_add_struct (ValaNamespace* self, ValaStruct* st);
void vala_namespace_add_enum (ValaNamespace* self, ValaEnum* en);
void vala_namespace_add_flags (ValaNamespace* self, ValaFlags* fl);
void vala_namespace_add_callback (ValaNamespace* self, ValaCallback* cb);
GList* vala_namespace_get_structs (ValaNamespace* self);
GList* vala_namespace_get_classes (ValaNamespace* self);
GList* vala_namespace_get_interfaces (ValaNamespace* self);
void vala_namespace_add_constant (ValaNamespace* self, ValaConstant* constant);
void vala_namespace_add_field (ValaNamespace* self, ValaField* f);
void vala_namespace_add_method (ValaNamespace* self, ValaMethod* m);
char* vala_namespace_camel_case_to_lower_case (const char* camel_case);
char* vala_namespace_get_cprefix (ValaNamespace* self);
void vala_namespace_set_cprefix (ValaNamespace* self, const char* cprefix);
char* vala_namespace_get_lower_case_cprefix (ValaNamespace* self);
void vala_namespace_set_lower_case_cprefix (ValaNamespace* self, const char* cprefix);
GList* vala_namespace_get_cheader_filenames (ValaNamespace* self);
char* vala_namespace_get_cheader_filename (ValaNamespace* self);
void vala_namespace_set_cheader_filename (ValaNamespace* self, const char* cheader_filename);
void vala_namespace_process_attributes (ValaNamespace* self);
char* vala_namespace_get_name (ValaNamespace* self);
void vala_namespace_set_name (ValaNamespace* self, const char* value);
GType vala_namespace_get_type ();

G_END_DECLS

#endif
