/* valareturnstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valareturnstatement.h"
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valareturnstatement.h>
#include <vala/valacodevisitor.h>

struct _ValaReturnStatementPrivate {
	ValaExpression* _return_expression;
};
#define VALA_RETURN_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementPrivate))
enum  {
	VALA_RETURN_STATEMENT_DUMMY_PROPERTY,
	VALA_RETURN_STATEMENT_RETURN_EXPRESSION
};
static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_return_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_return_statement_parent_class = NULL;
static void vala_return_statement_dispose (GObject * obj);


/**
 * Creates a new return statement.
 *
 * @param result the return expression
 * @param source reference to source code
 * @return       newly created return statement
 */
ValaReturnStatement* vala_return_statement_new (ValaExpression* result, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaReturnStatement * self;
	g_return_val_if_fail (result == NULL || VALA_IS_EXPRESSION (result), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "return-expression", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, result), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_RETURN_STATEMENT, __params_it - __params, __params);
	return self;
}


static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaReturnStatement * self;
	self = VALA_RETURN_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_begin_return_statement (visitor, self);
	if (vala_return_statement_get_return_expression (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_return_statement_get_return_expression (self)), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_return_statement_get_return_expression (self));
	}
	vala_code_visitor_visit_end_return_statement (visitor, self);
}


static void vala_return_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaReturnStatement * self;
	self = VALA_RETURN_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_return_statement_get_return_expression (self)) == old_node) {
		(vala_return_statement_set_return_expression (self, VALA_EXPRESSION (new_node)), vala_return_statement_get_return_expression (self));
	}
}


ValaExpression* vala_return_statement_get_return_expression (ValaReturnStatement* self)
{
	g_return_val_if_fail (VALA_IS_RETURN_STATEMENT (self), NULL);
	return self->priv->_return_expression;
}


void vala_return_statement_set_return_expression (ValaReturnStatement* self, ValaExpression* value)
{
	ValaExpression* __temp2;
	ValaExpression* __temp1;
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (self));
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->_return_expression = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->_return_expression == NULL ? NULL : (self->priv->_return_expression = (g_object_unref (self->priv->_return_expression), NULL))), __temp2);
	if (self->priv->_return_expression != NULL) {
		(vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_return_expression), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (self->priv->_return_expression)));
	}
}


static void vala_return_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaReturnStatement * self;
	self = VALA_RETURN_STATEMENT (object);
	switch (property_id) {
		case VALA_RETURN_STATEMENT_RETURN_EXPRESSION:
		g_value_set_object (value, vala_return_statement_get_return_expression (self));
		break;
	}
}


static void vala_return_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaReturnStatement * self;
	self = VALA_RETURN_STATEMENT (object);
	switch (property_id) {
		case VALA_RETURN_STATEMENT_RETURN_EXPRESSION:
		vala_return_statement_set_return_expression (self, g_value_get_object (value));
		break;
	}
}


static void vala_return_statement_class_init (ValaReturnStatementClass * klass)
{
	vala_return_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaReturnStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_return_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_return_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_return_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_return_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_return_statement_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_RETURN_STATEMENT_RETURN_EXPRESSION, g_param_spec_object ("return-expression", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_return_statement_init (ValaReturnStatement * self)
{
	self->priv = VALA_RETURN_STATEMENT_GET_PRIVATE (self);
}


static void vala_return_statement_dispose (GObject * obj)
{
	ValaReturnStatement * self;
	ValaReturnStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_RETURN_STATEMENT (obj);
	(self->priv->_return_expression == NULL ? NULL : (self->priv->_return_expression = (g_object_unref (self->priv->_return_expression), NULL)));
	klass = VALA_RETURN_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_RETURN_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_return_statement_get_type ()
{
	static GType vala_return_statement_type_id = 0;
	if (G_UNLIKELY (vala_return_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReturnStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_return_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReturnStatement), 0, (GInstanceInitFunc) vala_return_statement_init };
		vala_return_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaReturnStatement", &g_define_type_info, 0);
	}
	return vala_return_statement_type_id;
}




