/* valasymbol.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valasymbol.h"
#include <vala/valasymbol.h>

struct _ValaSymbolPrivate {
	ValaCodeNode* _node;
	ValaSymbol* _parent_symbol;
	char* _name;
	gboolean _active;
	GHashTable* symbol_table;
};
#define VALA_SYMBOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL, ValaSymbolPrivate))
enum  {
	VALA_SYMBOL_DUMMY_PROPERTY,
	VALA_SYMBOL_NODE,
	VALA_SYMBOL_PARENT_SYMBOL,
	VALA_SYMBOL_NAME,
	VALA_SYMBOL_ACTIVE
};
static GObject * vala_symbol_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_symbol_parent_class = NULL;
static void vala_symbol_dispose (GObject * obj);


/**
 * Creates a new symbol.
 *
 * @param node the corresponding code node
 * @return     newly created symbol
 */
ValaSymbol* vala_symbol_new (ValaCodeNode* _node)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaSymbol * self;
	g_return_val_if_fail (_node == NULL || VALA_IS_CODE_NODE (_node), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "node", g_value_init (&__params_it->value, VALA_TYPE_CODE_NODE), g_value_set_object (&__params_it->value, _node), __params_it++);
	self = g_object_newv (VALA_TYPE_SYMBOL, __params_it - __params, __params);
	return self;
}


/**
 * Returns the fully expanded name of this symbol for use in
 * human-readable messages.
 *
 * @return full name
 */
char* vala_symbol_get_full_name (ValaSymbol* self)
{
	char* __temp3;
	gboolean __temp4;
	char* __temp7;
	char* __temp8;
	g_return_val_if_fail (VALA_IS_SYMBOL (self), NULL);
	if (vala_symbol_get_parent_symbol (self) == NULL) {
		const char* __temp0;
		__temp0 = NULL;
		return (__temp0 = vala_symbol_get_name (self), (__temp0 == NULL ? NULL : g_strdup (__temp0)));
	}
	if (vala_symbol_get_name (self) == NULL) {
		return vala_symbol_get_full_name (vala_symbol_get_parent_symbol (self));
	}
	__temp3 = NULL;
	if ((__temp4 = (__temp3 = vala_symbol_get_full_name (vala_symbol_get_parent_symbol (self))) == NULL, (__temp3 = (g_free (__temp3), NULL)), __temp4)) {
		const char* __temp5;
		__temp5 = NULL;
		return (__temp5 = vala_symbol_get_name (self), (__temp5 == NULL ? NULL : g_strdup (__temp5)));
	}
	__temp7 = NULL;
	__temp8 = NULL;
	return (__temp8 = g_strdup_printf ("%s.%s", (__temp7 = vala_symbol_get_full_name (vala_symbol_get_parent_symbol (self))), vala_symbol_get_name (self)), (__temp7 = (g_free (__temp7), NULL)), __temp8);
}


/**
 * Adds the specified symbol with the specified name to the symbol table
 * of this symbol.
 *
 * @param name name for the specified symbol
 * @param sym  a symbol
 */
void vala_symbol_add (ValaSymbol* self, const char* name, ValaSymbol* sym)
{
	g_return_if_fail (VALA_IS_SYMBOL (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (VALA_IS_SYMBOL (sym));
	g_hash_table_insert (self->priv->symbol_table, g_strdup (name), g_object_ref (sym));
	(vala_symbol_set_parent_symbol (sym, self), vala_symbol_get_parent_symbol (sym));
	(vala_symbol_set_name (sym, name), vala_symbol_get_name (sym));
}


/**
 * Returns the symbol stored in the symbol table with the specified
 * name.
 *
 * @param name name of the symbol to be returned
 * @return     found symbol or null
 */
ValaSymbol* vala_symbol_lookup (ValaSymbol* self, const char* name)
{
	ValaSymbol* __temp10;
	ValaSymbol* sym;
	g_return_val_if_fail (VALA_IS_SYMBOL (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	__temp10 = NULL;
	sym = (__temp10 = g_hash_table_lookup (self->priv->symbol_table, name), (__temp10 == NULL ? NULL : g_object_ref (__temp10)));
	if (sym != NULL && !vala_symbol_get_active (sym)) {
		ValaSymbol* __temp11;
		__temp11 = NULL;
		sym = (__temp11 = NULL, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp11);
	}
	return sym;
	(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
}


ValaCodeNode* vala_symbol_get_node (ValaSymbol* self)
{
	g_return_val_if_fail (VALA_IS_SYMBOL (self), NULL);
	return self->priv->_node;
}


void vala_symbol_set_node (ValaSymbol* self, ValaCodeNode* value)
{
	g_return_if_fail (VALA_IS_SYMBOL (self));
	self->priv->_node = value;
}


ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self)
{
	g_return_val_if_fail (VALA_IS_SYMBOL (self), NULL);
	return self->priv->_parent_symbol;
}


void vala_symbol_set_parent_symbol (ValaSymbol* self, ValaSymbol* value)
{
	g_return_if_fail (VALA_IS_SYMBOL (self));
	self->priv->_parent_symbol = value;
}


char* vala_symbol_get_name (ValaSymbol* self)
{
	g_return_val_if_fail (VALA_IS_SYMBOL (self), NULL);
	return self->priv->_name;
}


void vala_symbol_set_name (ValaSymbol* self, const char* value)
{
	char* __temp17;
	const char* __temp16;
	g_return_if_fail (VALA_IS_SYMBOL (self));
	__temp17 = NULL;
	__temp16 = NULL;
	self->priv->_name = (__temp17 = (__temp16 = value, (__temp16 == NULL ? NULL : g_strdup (__temp16))), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp17);
}


gboolean vala_symbol_get_active (ValaSymbol* self)
{
	g_return_val_if_fail (VALA_IS_SYMBOL (self), FALSE);
	return self->priv->_active;
}


void vala_symbol_set_active (ValaSymbol* self, gboolean value)
{
	g_return_if_fail (VALA_IS_SYMBOL (self));
	self->priv->_active = value;
}


static GObject * vala_symbol_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaSymbolClass * klass;
	GObjectClass * parent_class;
	ValaSymbol * self;
	klass = VALA_SYMBOL_CLASS (g_type_class_peek (VALA_TYPE_SYMBOL));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_SYMBOL (obj);
	{
		(vala_symbol_set_active (self, TRUE), vala_symbol_get_active (self));
	}
	return obj;
}


static void vala_symbol_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaSymbol * self;
	self = VALA_SYMBOL (object);
	switch (property_id) {
		case VALA_SYMBOL_NODE:
		g_value_set_object (value, vala_symbol_get_node (self));
		break;
		case VALA_SYMBOL_PARENT_SYMBOL:
		g_value_set_object (value, vala_symbol_get_parent_symbol (self));
		break;
		case VALA_SYMBOL_NAME:
		g_value_set_string (value, vala_symbol_get_name (self));
		break;
		case VALA_SYMBOL_ACTIVE:
		g_value_set_boolean (value, vala_symbol_get_active (self));
		break;
	}
}


static void vala_symbol_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaSymbol * self;
	self = VALA_SYMBOL (object);
	switch (property_id) {
		case VALA_SYMBOL_NODE:
		vala_symbol_set_node (self, g_value_get_object (value));
		break;
		case VALA_SYMBOL_PARENT_SYMBOL:
		vala_symbol_set_parent_symbol (self, g_value_get_object (value));
		break;
		case VALA_SYMBOL_NAME:
		vala_symbol_set_name (self, g_value_get_string (value));
		break;
		case VALA_SYMBOL_ACTIVE:
		vala_symbol_set_active (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_symbol_class_init (ValaSymbolClass * klass)
{
	vala_symbol_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSymbolPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_symbol_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_symbol_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_symbol_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_symbol_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SYMBOL_NODE, g_param_spec_object ("node", "foo", "bar", VALA_TYPE_CODE_NODE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SYMBOL_PARENT_SYMBOL, g_param_spec_object ("parent-symbol", "foo", "bar", VALA_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SYMBOL_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SYMBOL_ACTIVE, g_param_spec_boolean ("active", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_symbol_init (ValaSymbol * self)
{
	self->priv = VALA_SYMBOL_GET_PRIVATE (self);
	self->priv->symbol_table = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref);
}


static void vala_symbol_dispose (GObject * obj)
{
	ValaSymbol * self;
	ValaSymbolClass * klass;
	GObjectClass * parent_class;
	self = VALA_SYMBOL (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->symbol_table == NULL ? NULL : (self->priv->symbol_table = (g_hash_table_unref (self->priv->symbol_table), NULL)));
	klass = VALA_SYMBOL_CLASS (g_type_class_peek (VALA_TYPE_SYMBOL));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_symbol_get_type ()
{
	static GType vala_symbol_type_id = 0;
	if (G_UNLIKELY (vala_symbol_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbol), 0, (GInstanceInitFunc) vala_symbol_init };
		vala_symbol_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaSymbol", &g_define_type_info, 0);
	}
	return vala_symbol_type_id;
}




