/* map.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __MAP_H__
#define __MAP_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/set.h>
#include <gee/collection.h>

G_BEGIN_DECLS


#define GEE_TYPE_MAP (gee_map_get_type ())
#define GEE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP, GeeMap))
#define GEE_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP))
#define GEE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP, GeeMapIface))

typedef struct _GeeMap GeeMap;
typedef struct _GeeMapIface GeeMapIface;

/**
 * A map is a generic collection of key/value pairs.
 */
struct _GeeMapIface {
	GTypeInterface parent;
	GeeSet* (*get_keys) (GeeMap* self);
	GeeCollection* (*get_values) (GeeMap* self);
	gboolean (*contains) (GeeMap* self, gpointer key);
	gpointer (*get) (GeeMap* self, gpointer key);
	void (*set) (GeeMap* self, gpointer key, gpointer value);
	gboolean (*remove) (GeeMap* self, gpointer key);
	void (*clear) (GeeMap* self);
};

GeeSet* gee_map_get_keys (GeeMap* self);
GeeCollection* gee_map_get_values (GeeMap* self);
gboolean gee_map_contains (GeeMap* self, gpointer key);
gpointer gee_map_get (GeeMap* self, gpointer key);
void gee_map_set (GeeMap* self, gpointer key, gpointer value);
gboolean gee_map_remove (GeeMap* self, gpointer key);
void gee_map_clear (GeeMap* self);
gint gee_map_get_size (GeeMap* self);
GType gee_map_get_type (void);

G_END_DECLS

#endif
