/* valapointer.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAPOINTER_H__
#define __VALAPOINTER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valadatatype.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_POINTER (vala_pointer_get_type ())
#define VALA_POINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER, ValaPointer))
#define VALA_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER, ValaPointerClass))
#define VALA_IS_POINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER))
#define VALA_IS_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER))
#define VALA_POINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER, ValaPointerClass))

typedef struct _ValaPointerPrivate ValaPointerPrivate;

/**
 * Represents a pointer-type.
 */
struct _ValaPointer {
	ValaDataType parent;
	ValaPointerPrivate * priv;
};
struct _ValaPointerClass {
	ValaDataTypeClass parent;
};

ValaPointer* vala_pointer_new (ValaDataType* referent_type, ValaSourceReference* source_reference);
ValaDataType* vala_pointer_get_referent_type (ValaPointer* self);
void vala_pointer_set_referent_type (ValaPointer* self, ValaDataType* value);
GType vala_pointer_get_type (void);

G_END_DECLS

#endif
