/* valaccodereturnstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccodereturnstatement.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeReturnStatementPrivate {
	ValaCCodeExpression* _return_expression;
};
#define VALA_CCODE_RETURN_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_RETURN_STATEMENT, ValaCCodeReturnStatementPrivate))
enum  {
	VALA_CCODE_RETURN_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_RETURN_STATEMENT_RETURN_EXPRESSION
};
static void vala_ccode_return_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_return_statement_parent_class = NULL;
static void vala_ccode_return_statement_dispose (GObject * obj);


ValaCCodeReturnStatement* vala_ccode_return_statement_new (ValaCCodeExpression* expr)
{
	ValaCCodeReturnStatement * self;
	g_return_val_if_fail (expr == NULL || VALA_IS_CCODE_EXPRESSION (expr), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_RETURN_STATEMENT, 0, NULL);
	vala_ccode_return_statement_set_return_expression (self, expr);
	return self;
}


static void vala_ccode_return_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeReturnStatement * self;
	self = ((ValaCCodeReturnStatement*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "return");
	if (vala_ccode_return_statement_get_return_expression (self) != NULL) {
		vala_ccode_writer_write_string (writer, " ");
		vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_return_statement_get_return_expression (self)), writer);
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


ValaCCodeExpression* vala_ccode_return_statement_get_return_expression (ValaCCodeReturnStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_RETURN_STATEMENT (self), NULL);
	return self->priv->_return_expression;
}


void vala_ccode_return_statement_set_return_expression (ValaCCodeReturnStatement* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp2;
	ValaCCodeExpression* __temp1;
	g_return_if_fail (VALA_IS_CCODE_RETURN_STATEMENT (self));
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->_return_expression = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->_return_expression == NULL ? NULL : (self->priv->_return_expression = (g_object_unref (self->priv->_return_expression), NULL))), __temp2);
}


static void vala_ccode_return_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeReturnStatement * self;
	self = VALA_CCODE_RETURN_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_RETURN_STATEMENT_RETURN_EXPRESSION:
		g_value_set_object (value, vala_ccode_return_statement_get_return_expression (self));
		break;
	}
}


static void vala_ccode_return_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeReturnStatement * self;
	self = VALA_CCODE_RETURN_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_RETURN_STATEMENT_RETURN_EXPRESSION:
		vala_ccode_return_statement_set_return_expression (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_return_statement_class_init (ValaCCodeReturnStatementClass * klass)
{
	vala_ccode_return_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeReturnStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_return_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_return_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_return_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_return_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_RETURN_STATEMENT_RETURN_EXPRESSION, g_param_spec_object ("return-expression", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_return_statement_init (ValaCCodeReturnStatement * self)
{
	self->priv = VALA_CCODE_RETURN_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_return_statement_dispose (GObject * obj)
{
	ValaCCodeReturnStatement * self;
	ValaCCodeReturnStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_RETURN_STATEMENT (obj);
	(self->priv->_return_expression == NULL ? NULL : (self->priv->_return_expression = (g_object_unref (self->priv->_return_expression), NULL)));
	klass = VALA_CCODE_RETURN_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_RETURN_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_return_statement_get_type (void)
{
	static GType vala_ccode_return_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_return_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeReturnStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_return_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeReturnStatement), 0, (GInstanceInitFunc) vala_ccode_return_statement_init };
		vala_ccode_return_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeReturnStatement", &g_define_type_info, 0);
	}
	return vala_ccode_return_statement_type_id;
}




