/* valareport.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAREPORT_H__
#define __VALAREPORT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>

G_BEGIN_DECLS


#define VALA_TYPE_REPORT (vala_report_get_type ())
#define VALA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REPORT, ValaReport))
#define VALA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REPORT, ValaReportClass))
#define VALA_IS_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REPORT))
#define VALA_IS_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REPORT))
#define VALA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REPORT, ValaReportClass))

typedef struct _ValaReport ValaReport;
typedef struct _ValaReportClass ValaReportClass;
typedef struct _ValaReportPrivate ValaReportPrivate;

/**
 * Static class to centralize reporting warnings and errors.
 */
struct _ValaReport {
	GObject parent;
	ValaReportPrivate * priv;
};
struct _ValaReportClass {
	GObjectClass parent;
};

gint vala_report_get_warnings (void);
gint vala_report_get_errors (void);
void vala_report_warning (ValaSourceReference* source, const char* message);
void vala_report_error (ValaSourceReference* source, const char* message);
GType vala_report_get_type (void);

G_END_DECLS

#endif
