/* valaclassregisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaclassregisterfunction.h"
#include <vala/valasymbol.h>
#include <vala/valatypereference.h>
#include <vala/valainterface.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <gobject/valaclassregisterfunction.h>

struct _ValaClassRegisterFunctionPrivate {
	ValaClass* _class_reference;
};
#define VALA_CLASS_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionPrivate))
enum  {
	VALA_CLASS_REGISTER_FUNCTION_DUMMY_PROPERTY,
	VALA_CLASS_REGISTER_FUNCTION_CLASS_REFERENCE
};
static ValaDataType* vala_class_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_type_flags (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base);
static gpointer vala_class_register_function_parent_class = NULL;
static void vala_class_register_function_dispose (GObject * obj);


/**
 * Creates a new C function to register the specified class at runtime.
 *
 * @param cl a class
 * @return   newly created class register function
 */
ValaClassRegisterFunction* vala_class_register_function_new (ValaClass* cl)
{
	ValaClassRegisterFunction * self;
	g_return_val_if_fail (VALA_IS_CLASS (cl), NULL);
	self = g_object_newv (VALA_TYPE_CLASS_REGISTER_FUNCTION, 0, NULL);
	vala_class_register_function_set_class_reference (self, cl);
	return self;
}


static ValaDataType* vala_class_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	self = ((ValaClassRegisterFunction*) base);
	return VALA_DATA_TYPE (g_object_ref (vala_class_register_function_get_class_reference (self)));
}


static char* vala_class_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	char* __temp1;
	char* __temp2;
	self = ((ValaClassRegisterFunction*) base);
	__temp1 = NULL;
	__temp2 = NULL;
	return (__temp2 = g_strdup_printf ("%sClass", (__temp1 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_register_function_get_class_reference (self)), FALSE))), (__temp1 = (g_free (__temp1), NULL)), __temp2);
}


static char* vala_class_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	self = ((ValaClassRegisterFunction*) base);
	return g_strdup ("NULL");
}


static char* vala_class_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	char* __temp5;
	char* __temp6;
	self = ((ValaClassRegisterFunction*) base);
	__temp5 = NULL;
	__temp6 = NULL;
	return (__temp6 = g_strdup_printf ("%s_class_init", (__temp5 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_class_register_function_get_class_reference (self)), NULL))), (__temp5 = (g_free (__temp5), NULL)), __temp6);
}


static char* vala_class_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	char* __temp8;
	char* __temp9;
	self = ((ValaClassRegisterFunction*) base);
	__temp8 = NULL;
	__temp9 = NULL;
	return (__temp9 = g_strdup_printf ("sizeof (%s)", (__temp8 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_register_function_get_class_reference (self)), FALSE))), (__temp8 = (g_free (__temp8), NULL)), __temp9);
}


static char* vala_class_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	char* __temp11;
	char* __temp12;
	self = ((ValaClassRegisterFunction*) base);
	__temp11 = NULL;
	__temp12 = NULL;
	return (__temp12 = g_strdup_printf ("%s_init", (__temp11 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_class_register_function_get_class_reference (self)), NULL))), (__temp11 = (g_free (__temp11), NULL)), __temp12);
}


static char* vala_class_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	self = ((ValaClassRegisterFunction*) base);
	return vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (vala_class_get_base_class (vala_class_register_function_get_class_reference (self))), "TYPE_");
}


static char* vala_class_register_function_real_get_type_flags (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	self = ((ValaClassRegisterFunction*) base);
	if (vala_class_get_is_abstract (vala_class_register_function_get_class_reference (self))) {
		return g_strdup ("G_TYPE_FLAG_ABSTRACT");
	} else {
		return g_strdup ("0");
	}
}


static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	ValaCCodeFragment* frag;
	self = ((ValaClassRegisterFunction*) base);
	frag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	{
		GeeCollection* base_type_collection;
		GeeIterator* base_type_it;
		base_type_collection = vala_class_get_base_types (vala_class_register_function_get_class_reference (self));
		base_type_it = gee_iterable_iterator (GEE_ITERABLE (base_type_collection));
		while (gee_iterator_next (base_type_it)) {
			ValaTypeReference* base_type;
			base_type = gee_iterator_get (base_type_it);
			{
				ValaInterface* __temp17;
				ValaInterface* iface;
				char* __temp18;
				char* __temp19;
				char* iface_info_name;
				ValaCCodeDeclaration* ctypedecl;
				ValaCCodeVariableDeclarator* __temp24;
				ValaCCodeConstant* __temp23;
				char* __temp22;
				char* __temp21;
				char* __temp20;
				if (!(VALA_IS_INTERFACE (vala_type_reference_get_data_type (base_type)))) {
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
					continue;
				}
				__temp17 = NULL;
				iface = (__temp17 = VALA_INTERFACE (vala_type_reference_get_data_type (base_type)), (__temp17 == NULL ? NULL : g_object_ref (__temp17)));
				__temp18 = NULL;
				__temp19 = NULL;
				iface_info_name = (__temp19 = g_strdup_printf ("%s_info", (__temp18 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (__temp18 = (g_free (__temp18), NULL)), __temp19);
				ctypedecl = vala_ccode_declaration_new ("const GInterfaceInfo");
				vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
				__temp24 = NULL;
				__temp23 = NULL;
				__temp22 = NULL;
				__temp21 = NULL;
				__temp20 = NULL;
				vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((__temp24 = vala_ccode_variable_declarator_new_with_initializer (iface_info_name, VALA_CCODE_EXPRESSION ((__temp23 = vala_ccode_constant_new ((__temp22 = g_strdup_printf ("{ (GInterfaceInitFunc) %s_%s_interface_init, (GInterfaceFinalizeFunc) NULL, NULL}", (__temp20 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_class_register_function_get_class_reference (self)), NULL)), (__temp21 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))))))))));
				(__temp24 == NULL ? NULL : (__temp24 = (g_object_unref (__temp24), NULL)));
				(__temp23 == NULL ? NULL : (__temp23 = (g_object_unref (__temp23), NULL)));
				(__temp22 = (g_free (__temp22), NULL));
				(__temp21 = (g_free (__temp21), NULL));
				(__temp20 = (g_free (__temp20), NULL));
				vala_ccode_fragment_append (frag, VALA_CCODE_NODE (ctypedecl));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
				(iface_info_name = (g_free (iface_info_name), NULL));
				(ctypedecl == NULL ? NULL : (ctypedecl = (g_object_unref (ctypedecl), NULL)));
			}
		}
		(base_type_collection == NULL ? NULL : (base_type_collection = (g_object_unref (base_type_collection), NULL)));
		(base_type_it == NULL ? NULL : (base_type_it = (g_object_unref (base_type_it), NULL)));
	}
	return frag;
	(frag == NULL ? NULL : (frag = (g_object_unref (frag), NULL)));
}


static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base)
{
	ValaClassRegisterFunction * self;
	ValaCCodeFragment* frag;
	self = ((ValaClassRegisterFunction*) base);
	frag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	{
		GeeCollection* base_type_collection;
		GeeIterator* base_type_it;
		base_type_collection = vala_class_get_base_types (vala_class_register_function_get_class_reference (self));
		base_type_it = gee_iterable_iterator (GEE_ITERABLE (base_type_collection));
		while (gee_iterator_next (base_type_it)) {
			ValaTypeReference* base_type;
			base_type = gee_iterator_get (base_type_it);
			{
				ValaInterface* __temp26;
				ValaInterface* iface;
				char* __temp27;
				char* __temp28;
				char* iface_info_name;
				ValaCCodeIdentifier* __temp29;
				ValaCCodeFunctionCall* __temp30;
				ValaCCodeFunctionCall* reg_call;
				ValaCCodeIdentifier* __temp33;
				char* __temp32;
				char* __temp31;
				ValaCCodeIdentifier* __temp35;
				char* __temp34;
				ValaCCodeIdentifier* __temp37;
				char* __temp36;
				ValaCCodeExpressionStatement* __temp38;
				if (!(VALA_IS_INTERFACE (vala_type_reference_get_data_type (base_type)))) {
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
					continue;
				}
				__temp26 = NULL;
				iface = (__temp26 = VALA_INTERFACE (vala_type_reference_get_data_type (base_type)), (__temp26 == NULL ? NULL : g_object_ref (__temp26)));
				__temp27 = NULL;
				__temp28 = NULL;
				iface_info_name = (__temp28 = g_strdup_printf ("%s_info", (__temp27 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (__temp27 = (g_free (__temp27), NULL)), __temp28);
				__temp29 = NULL;
				__temp30 = NULL;
				reg_call = (__temp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp29 = vala_ccode_identifier_new ("g_type_add_interface_static")))), (__temp29 == NULL ? NULL : (__temp29 = (g_object_unref (__temp29), NULL))), __temp30);
				__temp33 = NULL;
				__temp32 = NULL;
				__temp31 = NULL;
				vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp33 = vala_ccode_identifier_new ((__temp32 = g_strdup_printf ("%s_type_id", (__temp31 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_class_register_function_get_class_reference (self)), NULL))))))));
				(__temp33 == NULL ? NULL : (__temp33 = (g_object_unref (__temp33), NULL)));
				(__temp32 = (g_free (__temp32), NULL));
				(__temp31 = (g_free (__temp31), NULL));
				__temp35 = NULL;
				__temp34 = NULL;
				vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp35 = vala_ccode_identifier_new ((__temp34 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"))))));
				(__temp35 == NULL ? NULL : (__temp35 = (g_object_unref (__temp35), NULL)));
				(__temp34 = (g_free (__temp34), NULL));
				__temp37 = NULL;
				__temp36 = NULL;
				vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((__temp37 = vala_ccode_identifier_new ((__temp36 = g_strdup_printf ("&%s", iface_info_name))))));
				(__temp37 == NULL ? NULL : (__temp37 = (g_object_unref (__temp37), NULL)));
				(__temp36 = (g_free (__temp36), NULL));
				__temp38 = NULL;
				vala_ccode_fragment_append (frag, VALA_CCODE_NODE ((__temp38 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (reg_call)))));
				(__temp38 == NULL ? NULL : (__temp38 = (g_object_unref (__temp38), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
				(iface_info_name = (g_free (iface_info_name), NULL));
				(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
			}
		}
		(base_type_collection == NULL ? NULL : (base_type_collection = (g_object_unref (base_type_collection), NULL)));
		(base_type_it == NULL ? NULL : (base_type_it = (g_object_unref (base_type_it), NULL)));
	}
	return frag;
	(frag == NULL ? NULL : (frag = (g_object_unref (frag), NULL)));
}


ValaClass* vala_class_register_function_get_class_reference (ValaClassRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_CLASS_REGISTER_FUNCTION (self), NULL);
	return self->priv->_class_reference;
}


void vala_class_register_function_set_class_reference (ValaClassRegisterFunction* self, ValaClass* value)
{
	g_return_if_fail (VALA_IS_CLASS_REGISTER_FUNCTION (self));
	self->priv->_class_reference = value;
}


static void vala_class_register_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (object);
	switch (property_id) {
		case VALA_CLASS_REGISTER_FUNCTION_CLASS_REFERENCE:
		g_value_set_object (value, vala_class_register_function_get_class_reference (self));
		break;
	}
}


static void vala_class_register_function_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (object);
	switch (property_id) {
		case VALA_CLASS_REGISTER_FUNCTION_CLASS_REFERENCE:
		vala_class_register_function_set_class_reference (self, g_value_get_object (value));
		break;
	}
}


static void vala_class_register_function_class_init (ValaClassRegisterFunctionClass * klass)
{
	vala_class_register_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaClassRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_class_register_function_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_class_register_function_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_class_register_function_dispose;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_class_register_function_real_get_type_declaration;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_class_register_function_real_get_type_struct_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_class_register_function_real_get_base_init_func_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_class_register_function_real_get_class_init_func_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_class_register_function_real_get_instance_struct_size;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_class_register_function_real_get_instance_init_func_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_class_register_function_real_get_parent_type_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_class_register_function_real_get_type_flags;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_class_register_function_real_get_type_interface_init_declaration;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_class_register_function_real_get_type_interface_init_statements;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CLASS_REGISTER_FUNCTION_CLASS_REFERENCE, g_param_spec_object ("class-reference", "foo", "bar", VALA_TYPE_CLASS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_class_register_function_init (ValaClassRegisterFunction * self)
{
	self->priv = VALA_CLASS_REGISTER_FUNCTION_GET_PRIVATE (self);
}


static void vala_class_register_function_dispose (GObject * obj)
{
	ValaClassRegisterFunction * self;
	ValaClassRegisterFunctionClass * klass;
	GObjectClass * parent_class;
	self = VALA_CLASS_REGISTER_FUNCTION (obj);
	klass = VALA_CLASS_REGISTER_FUNCTION_CLASS (g_type_class_peek (VALA_TYPE_CLASS_REGISTER_FUNCTION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_class_register_function_get_type (void)
{
	static GType vala_class_register_function_type_id = 0;
	if (G_UNLIKELY (vala_class_register_function_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClassRegisterFunction), 0, (GInstanceInitFunc) vala_class_register_function_init };
		vala_class_register_function_type_id = g_type_register_static (VALA_TYPE_TYPE_REGISTER_FUNCTION, "ValaClassRegisterFunction", &g_define_type_info, 0);
	}
	return vala_class_register_function_type_id;
}




