/* valathrowstatement.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valathrowstatement.h"
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valathrowstatement.h>
#include <vala/valacodevisitor.h>

struct _ValaThrowStatementPrivate {
	ValaExpression* _error_expression;
};
#define VALA_THROW_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementPrivate))
enum  {
	VALA_THROW_STATEMENT_DUMMY_PROPERTY,
	VALA_THROW_STATEMENT_ERROR_EXPRESSION
};
static void vala_throw_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_throw_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_throw_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_throw_statement_parent_class = NULL;
static ValaStatementIface* vala_throw_statement_vala_statement_parent_iface = NULL;
static void vala_throw_statement_dispose (GObject * obj);


/**
 * Creates a new throw statement.
 *
 * @param error_expression the error expression
 * @param source_reference reference to source code
 * @return                 newly created throw statement
 */
ValaThrowStatement* vala_throw_statement_new (ValaExpression* error_expression, ValaSourceReference* source_reference)
{
	ValaThrowStatement * self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (error_expression), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_THROW_STATEMENT, 0, NULL);
	vala_throw_statement_set_error_expression (self, error_expression);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static void vala_throw_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaThrowStatement * self;
	self = ((ValaThrowStatement*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_throw_statement (visitor, self);
}


static void vala_throw_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaThrowStatement * self;
	self = ((ValaThrowStatement*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_throw_statement_get_error_expression (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_throw_statement_get_error_expression (self)), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_throw_statement_get_error_expression (self));
	}
}


static void vala_throw_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaThrowStatement * self;
	self = ((ValaThrowStatement*) base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_throw_statement_get_error_expression (self)) == old_node) {
		vala_throw_statement_set_error_expression (self, VALA_EXPRESSION (new_node));
	}
}


ValaExpression* vala_throw_statement_get_error_expression (ValaThrowStatement* self)
{
	g_return_val_if_fail (VALA_IS_THROW_STATEMENT (self), NULL);
	return self->priv->_error_expression;
}


void vala_throw_statement_set_error_expression (ValaThrowStatement* self, ValaExpression* value)
{
	ValaExpression* __temp2;
	ValaExpression* __temp1;
	g_return_if_fail (VALA_IS_THROW_STATEMENT (self));
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->_error_expression = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->_error_expression == NULL ? NULL : (self->priv->_error_expression = (g_object_unref (self->priv->_error_expression), NULL))), __temp2);
	if (self->priv->_error_expression != NULL) {
		vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_error_expression), VALA_CODE_NODE (self));
	}
}


static void vala_throw_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaThrowStatement * self;
	self = VALA_THROW_STATEMENT (object);
	switch (property_id) {
		case VALA_THROW_STATEMENT_ERROR_EXPRESSION:
		g_value_set_object (value, vala_throw_statement_get_error_expression (self));
		break;
	}
}


static void vala_throw_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaThrowStatement * self;
	self = VALA_THROW_STATEMENT (object);
	switch (property_id) {
		case VALA_THROW_STATEMENT_ERROR_EXPRESSION:
		vala_throw_statement_set_error_expression (self, g_value_get_object (value));
		break;
	}
}


static void vala_throw_statement_class_init (ValaThrowStatementClass * klass)
{
	vala_throw_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaThrowStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_throw_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_throw_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_throw_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_throw_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_throw_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_throw_statement_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_THROW_STATEMENT_ERROR_EXPRESSION, g_param_spec_object ("error-expression", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_throw_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_throw_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_throw_statement_init (ValaThrowStatement * self)
{
	self->priv = VALA_THROW_STATEMENT_GET_PRIVATE (self);
}


static void vala_throw_statement_dispose (GObject * obj)
{
	ValaThrowStatement * self;
	ValaThrowStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_THROW_STATEMENT (obj);
	(self->priv->_error_expression == NULL ? NULL : (self->priv->_error_expression = (g_object_unref (self->priv->_error_expression), NULL)));
	klass = VALA_THROW_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_THROW_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_throw_statement_get_type (void)
{
	static GType vala_throw_statement_type_id = 0;
	if (G_UNLIKELY (vala_throw_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaThrowStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_throw_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaThrowStatement), 0, (GInstanceInitFunc) vala_throw_statement_init };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_throw_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_throw_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaThrowStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_throw_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_throw_statement_type_id;
}




