/* valaccodefunctiondeclarator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccodefunctiondeclarator.h"
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <ccode/valaccodefunctiondeclarator.h>

struct _ValaCCodeFunctionDeclaratorPrivate {
	char* _name;
	GeeList* parameters;
};
#define VALA_CCODE_FUNCTION_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclaratorPrivate))
enum  {
	VALA_CCODE_FUNCTION_DECLARATOR_DUMMY_PROPERTY,
	VALA_CCODE_FUNCTION_DECLARATOR_NAME
};
static void vala_ccode_function_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_function_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_function_declarator_parent_class = NULL;
static void vala_ccode_function_declarator_dispose (GObject * obj);


ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_new (const char* name)
{
	ValaCCodeFunctionDeclarator * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_object_newv (VALA_TYPE_CCODE_FUNCTION_DECLARATOR, 0, NULL);
	vala_ccode_function_declarator_set_name (self, name);
	return self;
}


/**
 * Appends the specified parameter to the list of function parameters.
 *
 * @param param a formal parameter
 */
void vala_ccode_function_declarator_add_parameter (ValaCCodeFunctionDeclarator* self, ValaCCodeFormalParameter* param)
{
	g_return_if_fail (VALA_IS_CCODE_FUNCTION_DECLARATOR (self));
	g_return_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (param));
	gee_collection_add (GEE_COLLECTION (self->priv->parameters), param);
}


static void vala_ccode_function_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeFunctionDeclarator * self;
	self = ((ValaCCodeFunctionDeclarator*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self), writer);
}


static void vala_ccode_function_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeFunctionDeclarator * self;
	gboolean first;
	self = ((ValaCCodeFunctionDeclarator*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, "(*");
	vala_ccode_writer_write_string (writer, vala_ccode_function_declarator_get_name (self));
	vala_ccode_writer_write_string (writer, ") (");
	first = TRUE;
	{
		GeeList* param_collection;
		GeeIterator* param_it;
		param_collection = self->priv->parameters;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaCCodeFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				vala_ccode_node_write (VALA_CCODE_NODE (param), writer);
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	vala_ccode_writer_write_string (writer, ")");
}


char* vala_ccode_function_declarator_get_name (ValaCCodeFunctionDeclarator* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FUNCTION_DECLARATOR (self), NULL);
	return self->priv->_name;
}


void vala_ccode_function_declarator_set_name (ValaCCodeFunctionDeclarator* self, const char* value)
{
	char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_FUNCTION_DECLARATOR (self));
	_tmp1 = NULL;
	self->priv->_name = (_tmp1 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp1);
}


static void vala_ccode_function_declarator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeFunctionDeclarator * self;
	self = VALA_CCODE_FUNCTION_DECLARATOR (object);
	switch (property_id) {
		case VALA_CCODE_FUNCTION_DECLARATOR_NAME:
		g_value_set_string (value, vala_ccode_function_declarator_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_function_declarator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeFunctionDeclarator * self;
	self = VALA_CCODE_FUNCTION_DECLARATOR (object);
	switch (property_id) {
		case VALA_CCODE_FUNCTION_DECLARATOR_NAME:
		vala_ccode_function_declarator_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_function_declarator_class_init (ValaCCodeFunctionDeclaratorClass * klass)
{
	vala_ccode_function_declarator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeFunctionDeclaratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_function_declarator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_function_declarator_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_function_declarator_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_function_declarator_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_function_declarator_real_write_declaration;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FUNCTION_DECLARATOR_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_function_declarator_init (ValaCCodeFunctionDeclarator * self)
{
	self->priv = VALA_CCODE_FUNCTION_DECLARATOR_GET_PRIVATE (self);
	self->priv->parameters = GEE_LIST (gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal));
}


static void vala_ccode_function_declarator_dispose (GObject * obj)
{
	ValaCCodeFunctionDeclarator * self;
	ValaCCodeFunctionDeclaratorClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_FUNCTION_DECLARATOR (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->parameters == NULL ? NULL : (self->priv->parameters = (g_object_unref (self->priv->parameters), NULL)));
	klass = VALA_CCODE_FUNCTION_DECLARATOR_CLASS (g_type_class_peek (VALA_TYPE_CCODE_FUNCTION_DECLARATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_function_declarator_get_type (void)
{
	static GType vala_ccode_function_declarator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_function_declarator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFunctionDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_function_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFunctionDeclarator), 0, (GInstanceInitFunc) vala_ccode_function_declarator_init };
		vala_ccode_function_declarator_type_id = g_type_register_static (VALA_TYPE_CCODE_DECLARATOR, "ValaCCodeFunctionDeclarator", &g_define_type_info, 0);
	}
	return vala_ccode_function_declarator_type_id;
}




