/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valatyperegisterfunction.h"
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <gobject/valatyperegisterfunction.h>

struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
};
#define VALA_TYPE_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPE_REGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPE_REGISTER_FUNCTION_DUMMY_PROPERTY
};
static char* vala_type_register_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_type_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static gpointer vala_type_register_function_parent_class = NULL;
static void vala_type_register_function_dispose (GObject * obj);


/**
 * Constructs the C function from the specified type.
 */
void vala_type_register_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin)
{
	char* _tmp1;
	ValaDataType* _tmp0;
	char* _tmp2;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeConstant* _tmp3;
	ValaCCodeFunction* fun;
	ValaCCodeBlock* type_init;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp29;
	ValaCCodeConstant* _tmp28;
	char* _tmp27;
	char* _tmp26;
	char* _tmp25;
	char* _tmp24;
	char* _tmp23;
	char* _tmp22;
	ValaCCodeFragment* _tmp30;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeIdentifier* _tmp37;
	char* _tmp36;
	ValaCCodeConstant* _tmp41;
	char* _tmp40;
	char* _tmp39;
	ValaDataType* _tmp38;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeConstant* _tmp44;
	char* _tmp43;
	ValaCCodeExpressionStatement* _tmp47;
	ValaCCodeAssignment* _tmp46;
	ValaCCodeIdentifier* _tmp45;
	ValaCCodeFragment* _tmp48;
	ValaCCodeReturnStatement* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeFunction* _tmp58;
	g_return_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	type_id_name = (_tmp2 = g_strdup_printf ("%s_type_id", (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp0 = vala_type_register_function_get_type_declaration (self))), NULL))), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_object_unref (_tmp0), NULL)), _tmp2);
	type_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GType");
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp4 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ("0")))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cdecl_));
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (cdecl_));
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* _tmp8;
		char* _tmp7;
		char* _tmp6;
		ValaDataType* _tmp5;
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		fun = (_tmp8 = vala_ccode_function_new ((_tmp7 = g_strdup_printf ("%s_get_type", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp5 = vala_type_register_function_get_type_declaration (self))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), _tmp8);
		(_tmp7 = (g_free (_tmp7), NULL));
		(_tmp6 = (g_free (_tmp6), NULL));
		(_tmp5 = (g_object_unref (_tmp5), NULL));
		/* Function will not be prototyped anyway */
		if (vala_type_register_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
	} else {
		ValaCCodeFunction* _tmp12;
		char* _tmp11;
		char* _tmp10;
		ValaDataType* _tmp9;
		ValaCCodeFormalParameter* _tmp13;
		char* _tmp16;
		char* _tmp15;
		ValaDataType* _tmp14;
		ValaCCodeFunction* _tmp17;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* _tmp18;
		ValaCCodeBlock* _tmp19;
		ValaCCodeReturnStatement* _tmp21;
		ValaCCodeIdentifier* _tmp20;
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		fun = (_tmp12 = vala_ccode_function_new ((_tmp11 = g_strdup_printf ("%s_register_type", (_tmp10 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp9 = vala_type_register_function_get_type_declaration (self))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), _tmp12);
		(_tmp11 = (g_free (_tmp11), NULL));
		(_tmp10 = (g_free (_tmp10), NULL));
		(_tmp9 = (g_object_unref (_tmp9), NULL));
		_tmp13 = NULL;
		vala_ccode_function_add_parameter (fun, (_tmp13 = vala_ccode_formal_parameter_new ("module", "GTypeModule *")));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp17 = NULL;
		get_fun = (_tmp17 = vala_ccode_function_new ((_tmp16 = g_strdup_printf ("%s_get_type", (_tmp15 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp14 = vala_type_register_function_get_type_declaration (self))), NULL)))), "GType"), (_tmp16 = (g_free (_tmp16), NULL)), (_tmp15 = (g_free (_tmp15), NULL)), (_tmp14 = (g_object_unref (_tmp14), NULL)), _tmp17);
		if (vala_type_register_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp18 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((_tmp18 = vala_ccode_function_copy (get_fun))));
		(_tmp18 = (g_object_unref (_tmp18), NULL));
		_tmp19 = NULL;
		vala_ccode_function_set_block (get_fun, (_tmp19 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), VALA_CCODE_NODE ((_tmp21 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new (type_id_name)))))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (get_fun));
		(get_fun == NULL ? NULL : (get_fun = (g_object_unref (get_fun), NULL)));
	}
	type_init = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
	vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((_tmp29 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_constant_new ((_tmp27 = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) NULL, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s }", (_tmp22 = vala_type_register_function_get_type_struct_name (self)), (_tmp23 = vala_type_register_function_get_base_init_func_name (self)), (_tmp24 = vala_type_register_function_get_class_init_func_name (self)), (_tmp25 = vala_type_register_function_get_instance_struct_size (self)), (_tmp26 = vala_type_register_function_get_instance_init_func_name (self)))))))))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	(_tmp27 = (g_free (_tmp27), NULL));
	(_tmp26 = (g_free (_tmp26), NULL));
	(_tmp25 = (g_free (_tmp25), NULL));
	(_tmp24 = (g_free (_tmp24), NULL));
	(_tmp23 = (g_free (_tmp23), NULL));
	(_tmp22 = (g_free (_tmp22), NULL));
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (ctypedecl));
	_tmp30 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp30 = vala_type_register_function_get_type_interface_init_declaration (self))));
	(_tmp30 = (g_object_unref (_tmp30), NULL));
	reg_call = NULL;
	if (!plugin) {
		ValaCCodeFunctionCall* _tmp32;
		ValaCCodeIdentifier* _tmp31;
		_tmp32 = NULL;
		_tmp31 = NULL;
		reg_call = (_tmp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("g_type_register_static")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp32);
		(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	} else {
		ValaCCodeFunctionCall* _tmp34;
		ValaCCodeIdentifier* _tmp33;
		ValaCCodeIdentifier* _tmp35;
		_tmp34 = NULL;
		_tmp33 = NULL;
		reg_call = (_tmp34 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("g_type_module_register_type")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp34);
		(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
		_tmp35 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ("module"))));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	}
	_tmp37 = NULL;
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ((_tmp36 = vala_type_register_function_get_parent_type_name (self))))));
	(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	(_tmp36 = (g_free (_tmp36), NULL));
	_tmp41 = NULL;
	_tmp40 = NULL;
	_tmp39 = NULL;
	_tmp38 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ((_tmp40 = g_strdup_printf ("\"%s\"", (_tmp39 = vala_data_type_get_cname ((_tmp38 = vala_type_register_function_get_type_declaration (self)), FALSE))))))));
	(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
	(_tmp40 = (g_free (_tmp40), NULL));
	(_tmp39 = (g_free (_tmp39), NULL));
	(_tmp38 = (g_object_unref (_tmp38), NULL));
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new ("&g_define_type_info"))));
	(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_constant_new ((_tmp43 = vala_type_register_function_get_type_flags (self))))));
	(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
	(_tmp43 = (g_free (_tmp43), NULL));
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp47 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION (reg_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
	(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
	(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
	_tmp48 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp48 = vala_type_register_function_get_type_interface_init_statements (self))));
	(_tmp48 = (g_object_unref (_tmp48), NULL));
	if (!plugin) {
		ValaCCodeIdentifier* _tmp49;
		ValaCCodeFunctionCall* _tmp50;
		ValaCCodeFunctionCall* cond;
		ValaCCodeBinaryExpression* _tmp53;
		ValaCCodeConstant* _tmp52;
		ValaCCodeIdentifier* _tmp51;
		ValaCCodeIfStatement* cif;
		_tmp49 = NULL;
		_tmp50 = NULL;
		cond = (_tmp50 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("G_UNLIKELY")))), (_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL))), _tmp50);
		_tmp53 = NULL;
		_tmp52 = NULL;
		_tmp51 = NULL;
		vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_constant_new ("0")))))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
		(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
		cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (type_init), NULL);
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cif));
		(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
		(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	} else {
		ValaCCodeBlock* _tmp55;
		ValaCCodeBlock* _tmp54;
		_tmp55 = NULL;
		_tmp54 = NULL;
		type_block = (_tmp55 = (_tmp54 = type_init, (_tmp54 == NULL ? NULL : g_object_ref (_tmp54))), (type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL))), _tmp55);
	}
	_tmp57 = NULL;
	_tmp56 = NULL;
	vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE ((_tmp57 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new (type_id_name)))))));
	(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
	(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
	_tmp58 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((_tmp58 = vala_ccode_function_copy (fun))));
	(_tmp58 = (g_object_unref (_tmp58), NULL));
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (fun));
	(type_id_name = (g_free (type_id_name), NULL));
	(type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(type_init == NULL ? NULL : (type_init = (g_object_unref (type_init), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (g_object_unref (ctypedecl), NULL)));
	(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
}


ValaDataType* vala_type_register_function_get_type_declaration (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


char* vala_type_register_function_get_type_struct_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


char* vala_type_register_function_get_base_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


char* vala_type_register_function_get_class_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


char* vala_type_register_function_get_instance_struct_size (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


char* vala_type_register_function_get_instance_init_func_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


char* vala_type_register_function_get_parent_type_name (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_type_register_function_real_get_type_flags (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	return g_strdup ("0");
}


char* vala_type_register_function_get_type_flags (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_type_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	return g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
}


ValaCCodeFragment* vala_type_register_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


ValaCCodeFragment* vala_type_register_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_type_register_function_get_declaration (ValaTypeRegisterFunction* self)
{
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->declaration_fragment, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_type_register_function_get_definition (ValaTypeRegisterFunction* self)
{
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (VALA_IS_TYPE_REGISTER_FUNCTION (self), NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->definition_fragment, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


ValaSymbolAccessibility vala_type_register_function_get_accessibility (ValaTypeRegisterFunction* self)
{
	return VALA_TYPE_REGISTER_FUNCTION_GET_CLASS (self)->get_accessibility (self);
}


static void vala_type_register_function_class_init (ValaTypeRegisterFunctionClass * klass)
{
	vala_type_register_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_type_register_function_dispose;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_type_register_function_real_get_type_flags;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_type_register_function_real_get_type_interface_init_declaration;
}


static void vala_type_register_function_init (ValaTypeRegisterFunction * self)
{
	self->priv = VALA_TYPE_REGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	self->priv->definition_fragment = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
}


static void vala_type_register_function_dispose (GObject * obj)
{
	ValaTypeRegisterFunction * self;
	ValaTypeRegisterFunctionClass * klass;
	GObjectClass * parent_class;
	self = VALA_TYPE_REGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL ? NULL : (self->priv->declaration_fragment = (g_object_unref (self->priv->declaration_fragment), NULL)));
	(self->priv->definition_fragment == NULL ? NULL : (self->priv->definition_fragment = (g_object_unref (self->priv->definition_fragment), NULL)));
	klass = VALA_TYPE_REGISTER_FUNCTION_CLASS (g_type_class_peek (VALA_TYPE_TYPE_REGISTER_FUNCTION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_type_register_function_get_type (void)
{
	static GType vala_type_register_function_type_id = 0;
	if (G_UNLIKELY (vala_type_register_function_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_type_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_type_register_function_init };
		vala_type_register_function_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaTypeRegisterFunction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_type_register_function_type_id;
}




