/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaelementaccess.h"
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <vala/valaelementaccess.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaElementAccessPrivate {
	ValaExpression* _container;
	GeeList* indices;
};
#define VALA_ELEMENT_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessPrivate))
enum  {
	VALA_ELEMENT_ACCESS_DUMMY_PROPERTY,
	VALA_ELEMENT_ACCESS_CONTAINER
};
static void vala_element_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_element_access_parent_class = NULL;
static void vala_element_access_dispose (GObject * obj);


void vala_element_access_append_index (ValaElementAccess* self, ValaExpression* index)
{
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (self));
	g_return_if_fail (VALA_IS_EXPRESSION (index));
	gee_collection_add (GEE_COLLECTION (self->priv->indices), index);
}


GeeList* vala_element_access_get_indices (ValaElementAccess* self)
{
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (self), NULL);
	return GEE_LIST (gee_read_only_list_new (g_object_ref, g_object_unref, self->priv->indices));
}


ValaElementAccess* vala_element_access_new (ValaExpression* container, ValaSourceReference* source_reference)
{
	ValaElementAccess * self;
	g_return_val_if_fail (container == NULL || VALA_IS_EXPRESSION (container), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_ELEMENT_ACCESS, 0, NULL);
	vala_element_access_set_container (self, container);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static void vala_element_access_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	self = ((ValaElementAccess*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_element_access_get_container (self)), visitor);
	{
		GeeList* e_collection;
		GeeIterator* e_it;
		e_collection = self->priv->indices;
		e_it = gee_iterable_iterator (GEE_ITERABLE (e_collection));
		while (gee_iterator_next (e_it)) {
			ValaExpression* e;
			e = gee_iterator_get (e_it);
			{
				vala_code_node_accept (VALA_CODE_NODE (e), visitor);
				(e == NULL ? NULL : (e = (g_object_unref (e), NULL)));
			}
		}
		(e_it == NULL ? NULL : (e_it = (g_object_unref (e_it), NULL)));
	}
	vala_code_visitor_visit_element_access (visitor, self);
}


ValaExpression* vala_element_access_get_container (ValaElementAccess* self)
{
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (self), NULL);
	return self->priv->_container;
}


void vala_element_access_set_container (ValaElementAccess* self, ValaExpression* value)
{
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (self));
	_tmp1 = NULL;
	self->priv->_container = (_tmp1 = g_object_ref (value), (self->priv->_container == NULL ? NULL : (self->priv->_container = (g_object_unref (self->priv->_container), NULL))), _tmp1);
}


static void vala_element_access_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaElementAccess * self;
	self = VALA_ELEMENT_ACCESS (object);
	switch (property_id) {
		case VALA_ELEMENT_ACCESS_CONTAINER:
		g_value_set_object (value, vala_element_access_get_container (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_element_access_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaElementAccess * self;
	self = VALA_ELEMENT_ACCESS (object);
	switch (property_id) {
		case VALA_ELEMENT_ACCESS_CONTAINER:
		vala_element_access_set_container (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_element_access_class_init (ValaElementAccessClass * klass)
{
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaElementAccessPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_element_access_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_element_access_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_element_access_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_element_access_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ELEMENT_ACCESS_CONTAINER, g_param_spec_object ("container", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_element_access_init (ValaElementAccess * self)
{
	self->priv = VALA_ELEMENT_ACCESS_GET_PRIVATE (self);
	self->priv->indices = GEE_LIST (gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal));
}


static void vala_element_access_dispose (GObject * obj)
{
	ValaElementAccess * self;
	ValaElementAccessClass * klass;
	GObjectClass * parent_class;
	self = VALA_ELEMENT_ACCESS (obj);
	(self->priv->_container == NULL ? NULL : (self->priv->_container = (g_object_unref (self->priv->_container), NULL)));
	(self->priv->indices == NULL ? NULL : (self->priv->indices = (g_object_unref (self->priv->indices), NULL)));
	klass = VALA_ELEMENT_ACCESS_CLASS (g_type_class_peek (VALA_TYPE_ELEMENT_ACCESS));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_element_access_get_type (void)
{
	static GType vala_element_access_type_id = 0;
	if (G_UNLIKELY (vala_element_access_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_init };
		vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
	}
	return vala_element_access_type_id;
}




