/* valaccodebinaryexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccodebinaryexpression.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeBinaryExpressionPrivate {
	ValaCCodeBinaryOperator _operator;
	ValaCCodeExpression* _left;
	ValaCCodeExpression* _right;
};
#define VALA_CCODE_BINARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BINARY_EXPRESSION, ValaCCodeBinaryExpressionPrivate))
enum  {
	VALA_CCODE_BINARY_EXPRESSION_DUMMY_PROPERTY,
	VALA_CCODE_BINARY_EXPRESSION_OPERATOR,
	VALA_CCODE_BINARY_EXPRESSION_LEFT,
	VALA_CCODE_BINARY_EXPRESSION_RIGHT
};
static void vala_ccode_binary_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_binary_expression_parent_class = NULL;
static void vala_ccode_binary_expression_dispose (GObject * obj);


ValaCCodeBinaryExpression* vala_ccode_binary_expression_new (ValaCCodeBinaryOperator op, ValaCCodeExpression* l, ValaCCodeExpression* r)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeBinaryExpression * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (l), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (r), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "left", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, l), __params_it++);
	(__params_it->name = "right", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, r), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_BINARY_EXPRESSION, __params_it - __params, __params);
	vala_ccode_binary_expression_set_operator (self, op);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_binary_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeBinaryExpression * self;
	self = ((ValaCCodeBinaryExpression*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if (vala_ccode_binary_expression_get_left (self) != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_binary_expression_get_left (self)), writer);
	}
	vala_ccode_writer_write_string (writer, " ");
	if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_PLUS) {
		vala_ccode_writer_write_string (writer, "+");
	} else {
		if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_MINUS) {
			vala_ccode_writer_write_string (writer, "-");
		} else {
			if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_MUL) {
				vala_ccode_writer_write_string (writer, "*");
			} else {
				if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_DIV) {
					vala_ccode_writer_write_string (writer, "/");
				} else {
					if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_MOD) {
						vala_ccode_writer_write_string (writer, "%");
					} else {
						if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT) {
							vala_ccode_writer_write_string (writer, "<<");
						} else {
							if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT) {
								vala_ccode_writer_write_string (writer, ">>");
							} else {
								if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_LESS_THAN) {
									vala_ccode_writer_write_string (writer, "<");
								} else {
									if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_GREATER_THAN) {
										vala_ccode_writer_write_string (writer, ">");
									} else {
										if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											vala_ccode_writer_write_string (writer, "<=");
										} else {
											if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												vala_ccode_writer_write_string (writer, ">=");
											} else {
												if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_EQUALITY) {
													vala_ccode_writer_write_string (writer, "==");
												} else {
													if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_INEQUALITY) {
														vala_ccode_writer_write_string (writer, "!=");
													} else {
														if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_BITWISE_AND) {
															vala_ccode_writer_write_string (writer, "&");
														} else {
															if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_BITWISE_OR) {
																vala_ccode_writer_write_string (writer, "|");
															} else {
																if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR) {
																	vala_ccode_writer_write_string (writer, "^");
																} else {
																	if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_AND) {
																		vala_ccode_writer_write_string (writer, "&&");
																	} else {
																		if (vala_ccode_binary_expression_get_operator (self) == VALA_CCODE_BINARY_OPERATOR_OR) {
																			vala_ccode_writer_write_string (writer, "||");
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	vala_ccode_writer_write_string (writer, " ");
	if (vala_ccode_binary_expression_get_right (self) != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_binary_expression_get_right (self)), writer);
	}
}


ValaCCodeBinaryOperator vala_ccode_binary_expression_get_operator (ValaCCodeBinaryExpression* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_BINARY_EXPRESSION (self), 0);
	return self->priv->_operator;
}


void vala_ccode_binary_expression_set_operator (ValaCCodeBinaryExpression* self, ValaCCodeBinaryOperator value)
{
	g_return_if_fail (VALA_IS_CCODE_BINARY_EXPRESSION (self));
	self->priv->_operator = value;
}


ValaCCodeExpression* vala_ccode_binary_expression_get_left (ValaCCodeBinaryExpression* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_BINARY_EXPRESSION (self), NULL);
	return self->priv->_left;
}


void vala_ccode_binary_expression_set_left (ValaCCodeBinaryExpression* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_BINARY_EXPRESSION (self));
	_tmp1 = NULL;
	self->priv->_left = (_tmp1 = g_object_ref (value), (self->priv->_left == NULL ? NULL : (self->priv->_left = (g_object_unref (self->priv->_left), NULL))), _tmp1);
}


ValaCCodeExpression* vala_ccode_binary_expression_get_right (ValaCCodeBinaryExpression* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_BINARY_EXPRESSION (self), NULL);
	return self->priv->_right;
}


void vala_ccode_binary_expression_set_right (ValaCCodeBinaryExpression* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_BINARY_EXPRESSION (self));
	_tmp1 = NULL;
	self->priv->_right = (_tmp1 = g_object_ref (value), (self->priv->_right == NULL ? NULL : (self->priv->_right = (g_object_unref (self->priv->_right), NULL))), _tmp1);
}


static void vala_ccode_binary_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeBinaryExpression * self;
	self = VALA_CCODE_BINARY_EXPRESSION (object);
	switch (property_id) {
		case VALA_CCODE_BINARY_EXPRESSION_OPERATOR:
		g_value_set_int (value, vala_ccode_binary_expression_get_operator (self));
		break;
		case VALA_CCODE_BINARY_EXPRESSION_LEFT:
		g_value_set_object (value, vala_ccode_binary_expression_get_left (self));
		break;
		case VALA_CCODE_BINARY_EXPRESSION_RIGHT:
		g_value_set_object (value, vala_ccode_binary_expression_get_right (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_binary_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeBinaryExpression * self;
	self = VALA_CCODE_BINARY_EXPRESSION (object);
	switch (property_id) {
		case VALA_CCODE_BINARY_EXPRESSION_OPERATOR:
		vala_ccode_binary_expression_set_operator (self, g_value_get_int (value));
		break;
		case VALA_CCODE_BINARY_EXPRESSION_LEFT:
		vala_ccode_binary_expression_set_left (self, g_value_get_object (value));
		break;
		case VALA_CCODE_BINARY_EXPRESSION_RIGHT:
		vala_ccode_binary_expression_set_right (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_binary_expression_class_init (ValaCCodeBinaryExpressionClass * klass)
{
	vala_ccode_binary_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeBinaryExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_binary_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_binary_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_binary_expression_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_binary_expression_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_BINARY_EXPRESSION_OPERATOR, g_param_spec_int ("operator", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_BINARY_EXPRESSION_LEFT, g_param_spec_object ("left", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_BINARY_EXPRESSION_RIGHT, g_param_spec_object ("right", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_binary_expression_init (ValaCCodeBinaryExpression * self)
{
	self->priv = VALA_CCODE_BINARY_EXPRESSION_GET_PRIVATE (self);
}


static void vala_ccode_binary_expression_dispose (GObject * obj)
{
	ValaCCodeBinaryExpression * self;
	ValaCCodeBinaryExpressionClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_BINARY_EXPRESSION (obj);
	(self->priv->_left == NULL ? NULL : (self->priv->_left = (g_object_unref (self->priv->_left), NULL)));
	(self->priv->_right == NULL ? NULL : (self->priv->_right = (g_object_unref (self->priv->_right), NULL)));
	klass = VALA_CCODE_BINARY_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_CCODE_BINARY_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_binary_expression_get_type (void)
{
	static GType vala_ccode_binary_expression_type_id = 0;
	if (G_UNLIKELY (vala_ccode_binary_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBinaryExpression), 0, (GInstanceInitFunc) vala_ccode_binary_expression_init };
		vala_ccode_binary_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeBinaryExpression", &g_define_type_info, 0);
	}
	return vala_ccode_binary_expression_type_id;
}




