/* valacodegenerator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#include "valacodegenerator.h"
#include <vala/valasymbol.h>
#include <vala/valatypereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeblock.h>
#include <gee/arraylist.h>
#include <gee/set.h>
#include <vala/valadatatype.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valascope.h>
#include <gee/collection.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valaliteral.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valalockable.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valareport.h>
#include <ccode/valaccodedeclaration.h>
#include <vala/valaarray.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <vala/valainstancecast.h>
#include <gee/list.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valastatement.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodegotostatement.h>
#include <ccode/valaccodeifstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodeelementaccess.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodecontinuestatement.h>
#include <ccode/valaccodelabel.h>
#include <ccode/valaccodenewline.h>
#include <vala/valatypeparameter.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valainvokable.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valaattribute.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valapointer.h>
#include <ccode/valaccodeincludedirective.h>
#include <gee/hashset.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <gobject/valacodegenerator.h>
#include <gobject/valadbussignal.h>
#include <gobject/valaclassregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>
#include <gobject/valainterfaceregisterfunction.h>
#include <gobject/valadbusmethod.h>

struct _ValaCodeGeneratorPrivate {
	gboolean _memory_management;
	ValaCodeContext* context;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaTypeReference* current_return_type;
	ValaTryStatement* current_try;
	ValaCCodeFragment* header_begin;
	ValaCCodeFragment* header_type_declaration;
	ValaCCodeFragment* header_type_definition;
	ValaCCodeFragment* header_type_member_declaration;
	ValaCCodeFragment* source_begin;
	ValaCCodeFragment* source_include_directives;
	ValaCCodeFragment* source_type_member_declaration;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_dispose_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* instance_struct;
	ValaCCodeStruct* type_struct;
	ValaCCodeStruct* instance_priv_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeEnum* cenum;
	ValaCCodeFunction* function;
	ValaCCodeBlock* block;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gint current_try_id;
	gint next_try_id;
	gboolean in_creation_method;
	gboolean current_method_inner_error;
	ValaTypeReference* bool_type;
	ValaTypeReference* char_type;
	ValaTypeReference* unichar_type;
	ValaTypeReference* short_type;
	ValaTypeReference* ushort_type;
	ValaTypeReference* int_type;
	ValaTypeReference* uint_type;
	ValaTypeReference* long_type;
	ValaTypeReference* ulong_type;
	ValaTypeReference* int64_type;
	ValaTypeReference* uint64_type;
	ValaTypeReference* string_type;
	ValaTypeReference* float_type;
	ValaTypeReference* double_type;
	ValaDataType* gobject_type;
	ValaDataType* gerror_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* gstring_type;
	ValaDataType* garray_type;
	ValaTypeReference* mutex_type;
	ValaDataType* type_module_type;
	ValaDataType* iterable_type;
	ValaDataType* iterator_type;
	ValaDataType* list_type;
	ValaDataType* map_type;
	ValaDataType* connection_type;
	ValaMethod* substring_method;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean requires_free_checked;
	gboolean requires_array_free;
	gboolean requires_array_move;
};
#define VALA_CODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorPrivate))
enum  {
	VALA_CODE_GENERATOR_DUMMY_PROPERTY,
	VALA_CODE_GENERATOR_MEMORY_MANAGEMENT
};
static void vala_code_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_code_generator_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static gboolean vala_code_generator_is_constant_ccode_expression (ValaCodeGenerator* self, ValaCCodeExpression* cexpr);
static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_code_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_code_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_code_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_code_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static char* vala_code_generator_get_variable_cname (ValaCodeGenerator* self, const char* name);
static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl);
static void vala_code_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership);
static ValaCCodeExpression* vala_code_generator_get_dup_func_expression (ValaCodeGenerator* self, ValaTypeReference* type);
static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type);
static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type, ValaExpression* expr);
static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GeeCollection* temp_vars);
static void vala_code_generator_add_simple_check (ValaCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GeeCollection* temp_vars);
static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_code_generator_real_visit_begin_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaCodeNode* stmt, gboolean stop_at_loop);
static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_code_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_code_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_code_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym);
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_code_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr);
static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim);
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_code_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static ValaCCodeFunctionCall* vala_code_generator_create_type_check (ValaCCodeNode* ccodenode, ValaDataType* type);
static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static ValaCCodeExpression* vala_code_generator_convert_from_generic_pointer (ValaCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type);
static ValaCCodeExpression* vala_code_generator_convert_to_generic_pointer (ValaCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type);
static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr);
static void vala_code_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface);
static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl);
static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference);
static gboolean vala_code_generator_class_has_readable_properties (ValaCodeGenerator* self, ValaClass* cl);
static gboolean vala_code_generator_class_has_writable_properties (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl);
static ValaCCodeStatement* vala_code_generator_get_invalid_property_id_warn_statement (ValaCodeGenerator* self);
static void vala_code_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop);
static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type);
static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface);
static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_dbus_array_type (ValaCodeGenerator* self, ValaArray* array);
static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_code_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeExpression* vala_code_generator_default_value_for_type (ValaCodeGenerator* self, ValaDataType* type);
static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaSymbol* sym);
static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim);
static void vala_code_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b, gboolean has_params);
static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix);
static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig);
static void vala_code_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename);
static ValaCCodeForStatement* vala_code_generator_get_vala_array_free_loop (ValaCodeGenerator* self, gboolean have_length);
static void vala_code_generator_append_vala_array_free (ValaCodeGenerator* self);
static void vala_code_generator_append_vala_array_move (ValaCodeGenerator* self);
static void vala_code_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static char* vala_code_generator_get_define_for_filename (const char* filename);
static void vala_code_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_code_generator_parent_class = NULL;
static void vala_code_generator_dispose (GObject * obj);


ValaCodeGenerator* vala_code_generator_new (gboolean manage_memory)
{
	ValaCodeGenerator * self;
	self = g_object_newv (VALA_TYPE_CODE_GENERATOR, 0, NULL);
	vala_code_generator_set_memory_management (self, manage_memory);
	return self;
}


/**
 * Generate and emit C code for the specified code context.
 *
 * @param context a code context
 */
void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context)
{
	ValaCodeContext* _tmp0;
	ValaSymbol* _tmp1;
	ValaTypeReference* _tmp2;
	ValaDataType* _tmp3;
	ValaTypeReference* _tmp4;
	ValaDataType* _tmp5;
	ValaTypeReference* _tmp6;
	ValaDataType* _tmp7;
	ValaTypeReference* _tmp8;
	ValaDataType* _tmp9;
	ValaTypeReference* _tmp10;
	ValaDataType* _tmp11;
	ValaTypeReference* _tmp12;
	ValaDataType* _tmp13;
	ValaTypeReference* _tmp14;
	ValaDataType* _tmp15;
	ValaTypeReference* _tmp16;
	ValaDataType* _tmp17;
	ValaTypeReference* _tmp18;
	ValaDataType* _tmp19;
	ValaTypeReference* _tmp20;
	ValaDataType* _tmp21;
	ValaTypeReference* _tmp22;
	ValaDataType* _tmp23;
	ValaTypeReference* _tmp24;
	ValaDataType* _tmp25;
	ValaTypeReference* _tmp26;
	ValaDataType* _tmp27;
	ValaTypeReference* _tmp28;
	ValaDataType* _tmp29;
	ValaMethod* _tmp30;
	ValaSymbol* glib_ns;
	ValaDataType* _tmp31;
	ValaDataType* _tmp32;
	ValaDataType* _tmp33;
	ValaDataType* _tmp34;
	ValaDataType* _tmp35;
	ValaDataType* _tmp36;
	ValaTypeReference* _tmp37;
	ValaDataType* _tmp38;
	ValaDataType* _tmp39;
	ValaSymbol* gee_ns;
	ValaSymbol* dbus_ns;
	GeeCollection* source_files;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	_tmp0 = NULL;
	self->priv->context = (_tmp0 = g_object_ref (context), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), _tmp0);
	vala_code_context_find_header_cycles (context);
	_tmp1 = NULL;
	self->priv->root_symbol = (_tmp1 = VALA_SYMBOL (g_object_ref (vala_code_context_get_root (context))), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), _tmp1);
	_tmp2 = NULL;
	self->priv->bool_type = (_tmp2 = vala_type_reference_new (), (self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL))), _tmp2);
	_tmp3 = NULL;
	vala_type_reference_set_data_type (self->priv->bool_type, (_tmp3 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "bool"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	self->priv->char_type = (_tmp4 = vala_type_reference_new (), (self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL))), _tmp4);
	_tmp5 = NULL;
	vala_type_reference_set_data_type (self->priv->char_type, (_tmp5 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "char"))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	self->priv->unichar_type = (_tmp6 = vala_type_reference_new (), (self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL))), _tmp6);
	_tmp7 = NULL;
	vala_type_reference_set_data_type (self->priv->unichar_type, (_tmp7 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "unichar"))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	self->priv->short_type = (_tmp8 = vala_type_reference_new (), (self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL))), _tmp8);
	_tmp9 = NULL;
	vala_type_reference_set_data_type (self->priv->short_type, (_tmp9 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "short"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	self->priv->ushort_type = (_tmp10 = vala_type_reference_new (), (self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL))), _tmp10);
	_tmp11 = NULL;
	vala_type_reference_set_data_type (self->priv->ushort_type, (_tmp11 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ushort"))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	self->priv->int_type = (_tmp12 = vala_type_reference_new (), (self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL))), _tmp12);
	_tmp13 = NULL;
	vala_type_reference_set_data_type (self->priv->int_type, (_tmp13 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "int"))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	_tmp14 = NULL;
	self->priv->uint_type = (_tmp14 = vala_type_reference_new (), (self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL))), _tmp14);
	_tmp15 = NULL;
	vala_type_reference_set_data_type (self->priv->uint_type, (_tmp15 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "uint"))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	_tmp16 = NULL;
	self->priv->long_type = (_tmp16 = vala_type_reference_new (), (self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL))), _tmp16);
	_tmp17 = NULL;
	vala_type_reference_set_data_type (self->priv->long_type, (_tmp17 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "long"))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	self->priv->ulong_type = (_tmp18 = vala_type_reference_new (), (self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_type_reference_set_data_type (self->priv->ulong_type, (_tmp19 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ulong"))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	_tmp20 = NULL;
	self->priv->int64_type = (_tmp20 = vala_type_reference_new (), (self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL))), _tmp20);
	_tmp21 = NULL;
	vala_type_reference_set_data_type (self->priv->int64_type, (_tmp21 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "int64"))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	_tmp22 = NULL;
	self->priv->uint64_type = (_tmp22 = vala_type_reference_new (), (self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL))), _tmp22);
	_tmp23 = NULL;
	vala_type_reference_set_data_type (self->priv->uint64_type, (_tmp23 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "uint64"))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	_tmp24 = NULL;
	self->priv->float_type = (_tmp24 = vala_type_reference_new (), (self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL))), _tmp24);
	_tmp25 = NULL;
	vala_type_reference_set_data_type (self->priv->float_type, (_tmp25 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "float"))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	_tmp26 = NULL;
	self->priv->double_type = (_tmp26 = vala_type_reference_new (), (self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL))), _tmp26);
	_tmp27 = NULL;
	vala_type_reference_set_data_type (self->priv->double_type, (_tmp27 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "double"))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	_tmp28 = NULL;
	self->priv->string_type = (_tmp28 = vala_type_reference_new (), (self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL))), _tmp28);
	_tmp29 = NULL;
	vala_type_reference_set_data_type (self->priv->string_type, (_tmp29 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "string"))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	self->priv->substring_method = (_tmp30 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) vala_type_reference_get_data_type (self->priv->string_type))), "substring")), (self->priv->substring_method == NULL ? NULL : (self->priv->substring_method = (g_object_unref (self->priv->substring_method), NULL))), _tmp30);
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "GLib");
	_tmp31 = NULL;
	self->priv->gobject_type = (_tmp31 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->priv->gobject_type == NULL ? NULL : (self->priv->gobject_type = (g_object_unref (self->priv->gobject_type), NULL))), _tmp31);
	_tmp32 = NULL;
	self->priv->gerror_type = (_tmp32 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Error")), (self->priv->gerror_type == NULL ? NULL : (self->priv->gerror_type = (g_object_unref (self->priv->gerror_type), NULL))), _tmp32);
	_tmp33 = NULL;
	self->priv->glist_type = (_tmp33 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")), (self->priv->glist_type == NULL ? NULL : (self->priv->glist_type = (g_object_unref (self->priv->glist_type), NULL))), _tmp33);
	_tmp34 = NULL;
	self->priv->gslist_type = (_tmp34 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")), (self->priv->gslist_type == NULL ? NULL : (self->priv->gslist_type = (g_object_unref (self->priv->gslist_type), NULL))), _tmp34);
	_tmp35 = NULL;
	self->priv->gstring_type = (_tmp35 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "String")), (self->priv->gstring_type == NULL ? NULL : (self->priv->gstring_type = (g_object_unref (self->priv->gstring_type), NULL))), _tmp35);
	_tmp36 = NULL;
	self->priv->garray_type = (_tmp36 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")), (self->priv->garray_type == NULL ? NULL : (self->priv->garray_type = (g_object_unref (self->priv->garray_type), NULL))), _tmp36);
	_tmp37 = NULL;
	self->priv->mutex_type = (_tmp37 = vala_type_reference_new (), (self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL))), _tmp37);
	_tmp38 = NULL;
	vala_type_reference_set_data_type (self->priv->mutex_type, (_tmp38 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Mutex"))));
	(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
	_tmp39 = NULL;
	self->priv->type_module_type = (_tmp39 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeModule")), (self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL))), _tmp39);
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* _tmp40;
		_tmp40 = NULL;
		self->priv->module_init_fragment = (_tmp40 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL))), _tmp40);
		{
			GeeCollection* parameter_collection;
			GeeIterator* parameter_it;
			parameter_collection = vala_invokable_get_parameters (VALA_INVOKABLE (vala_code_context_get_module_init_method (context)));
			parameter_it = gee_iterable_iterator (GEE_ITERABLE (parameter_collection));
			while (gee_iterator_next (parameter_it)) {
				ValaFormalParameter* parameter;
				parameter = gee_iterator_get (parameter_it);
				{
					if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (parameter)) == self->priv->type_module_type) {
						char* _tmp42;
						const char* _tmp41;
						self->priv->in_plugin = TRUE;
						_tmp42 = NULL;
						_tmp41 = NULL;
						self->priv->module_init_param_name = (_tmp42 = (_tmp41 = vala_symbol_get_name (((ValaSymbol*) parameter)), (_tmp41 == NULL ? NULL : g_strdup (_tmp41))), (self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL)), _tmp42);
						(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
						break;
					}
					(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
				}
			}
			(parameter_collection == NULL ? NULL : (parameter_collection = (g_object_unref (parameter_collection), NULL)));
			(parameter_it == NULL ? NULL : (parameter_it = (g_object_unref (parameter_it), NULL)));
		}
	}
	gee_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "Gee");
	if (gee_ns != NULL) {
		ValaDataType* _tmp43;
		ValaDataType* _tmp44;
		ValaDataType* _tmp45;
		ValaDataType* _tmp46;
		_tmp43 = NULL;
		self->priv->iterable_type = (_tmp43 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterable")), (self->priv->iterable_type == NULL ? NULL : (self->priv->iterable_type = (g_object_unref (self->priv->iterable_type), NULL))), _tmp43);
		_tmp44 = NULL;
		self->priv->iterator_type = (_tmp44 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterator")), (self->priv->iterator_type == NULL ? NULL : (self->priv->iterator_type = (g_object_unref (self->priv->iterator_type), NULL))), _tmp44);
		_tmp45 = NULL;
		self->priv->list_type = (_tmp45 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "List")), (self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL))), _tmp45);
		_tmp46 = NULL;
		self->priv->map_type = (_tmp46 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Map")), (self->priv->map_type == NULL ? NULL : (self->priv->map_type = (g_object_unref (self->priv->map_type), NULL))), _tmp46);
	}
	dbus_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "DBus");
	if (dbus_ns != NULL) {
		ValaDataType* _tmp47;
		_tmp47 = NULL;
		self->priv->connection_type = (_tmp47 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Connection")), (self->priv->connection_type == NULL ? NULL : (self->priv->connection_type = (g_object_unref (self->priv->connection_type), NULL))), _tmp47);
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GeeCollection* file_collection;
		GeeIterator* file_it;
		file_collection = source_files;
		file_it = gee_iterable_iterator (GEE_ITERABLE (file_collection));
		while (gee_iterator_next (file_it)) {
			ValaSourceFile* file;
			file = gee_iterator_get (file_it);
			{
				if (!vala_source_file_get_pkg (file)) {
					vala_source_file_accept (file, VALA_CODE_VISITOR (self));
				}
				(file == NULL ? NULL : (file = (g_object_unref (file), NULL)));
			}
		}
		(file_it == NULL ? NULL : (file_it = (g_object_unref (file_it), NULL)));
	}
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
	(gee_ns == NULL ? NULL : (gee_ns = (g_object_unref (gee_ns), NULL)));
	(dbus_ns == NULL ? NULL : (dbus_ns = (g_object_unref (dbus_ns), NULL)));
	(source_files == NULL ? NULL : (source_files = (g_object_unref (source_files), NULL)));
}


static void vala_code_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaCodeGenerator * self;
	ValaCCodeEnum* _tmp1;
	char* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ENUM (en));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->cenum = (_tmp1 = vala_ccode_enum_new ((_tmp0 = vala_data_type_get_cname (VALA_DATA_TYPE (en), FALSE))), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), _tmp1);
	(_tmp0 = (g_free (_tmp0), NULL));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) en))) != NULL) {
		ValaCCodeComment* _tmp2;
		_tmp2 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((_tmp2 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) en)))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
	if (vala_enum_get_error_domain (en)) {
		char* _tmp3;
		char* _tmp4;
		char* quark_fun_name;
		char* _tmp6;
		char* _tmp5;
		ValaCCodeMacroReplacement* _tmp7;
		ValaCCodeMacroReplacement* error_domain_define;
		ValaCCodeFunction* cquark_fun;
		ValaCCodeBlock* cquark_block;
		ValaCCodeIdentifier* _tmp8;
		ValaCCodeFunctionCall* _tmp9;
		ValaCCodeFunctionCall* cquark_call;
		ValaCCodeConstant* _tmp13;
		char* _tmp12;
		char* _tmp11;
		char* _tmp10;
		ValaCCodeReturnStatement* _tmp14;
		ValaCCodeFunction* _tmp15;
		_tmp3 = NULL;
		_tmp4 = NULL;
		quark_fun_name = (_tmp4 = g_strconcat ((_tmp3 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (en))), "quark", NULL), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp7 = NULL;
		error_domain_define = (_tmp7 = vala_ccode_macro_replacement_new ((_tmp5 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (en), NULL)), (_tmp6 = g_strconcat (quark_fun_name, " ()", NULL))), (_tmp6 = (g_free (_tmp6), NULL)), (_tmp5 = (g_free (_tmp5), NULL)), _tmp7);
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (error_domain_define));
		cquark_fun = vala_ccode_function_new (quark_fun_name, "GQuark");
		cquark_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		_tmp8 = NULL;
		_tmp9 = NULL;
		cquark_call = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_quark_from_static_string")))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		vala_ccode_function_call_add_argument (cquark_call, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ((_tmp12 = g_strconcat ((_tmp11 = g_strconcat ("\"", (_tmp10 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (en), NULL)), NULL)), "-quark\"", NULL))))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		(_tmp12 = (g_free (_tmp12), NULL));
		(_tmp11 = (g_free (_tmp11), NULL));
		(_tmp10 = (g_free (_tmp10), NULL));
		_tmp14 = NULL;
		vala_ccode_block_add_statement (cquark_block, VALA_CCODE_NODE ((_tmp14 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (cquark_call)))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		_tmp15 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp15 = vala_ccode_function_copy (cquark_fun))));
		(_tmp15 = (g_object_unref (_tmp15), NULL));
		vala_ccode_function_set_block (cquark_fun, cquark_block);
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cquark_fun));
		(quark_fun_name = (g_free (quark_fun_name), NULL));
		(error_domain_define == NULL ? NULL : (error_domain_define = (g_object_unref (error_domain_define), NULL)));
		(cquark_fun == NULL ? NULL : (cquark_fun = (g_object_unref (cquark_fun), NULL)));
		(cquark_block == NULL ? NULL : (cquark_block = (g_object_unref (cquark_block), NULL)));
		(cquark_call == NULL ? NULL : (cquark_call = (g_object_unref (cquark_call), NULL)));
	}
}


static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev)
{
	ValaCodeGenerator * self;
	char* val;
	char* _tmp2;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ENUM_VALUE (ev));
	val = NULL;
	if (VALA_IS_LITERAL_EXPRESSION (vala_enum_value_get_value (ev))) {
		ValaLiteral* _tmp0;
		ValaLiteral* lit;
		_tmp0 = NULL;
		lit = (_tmp0 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_enum_value_get_value (ev)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (VALA_IS_INTEGER_LITERAL (lit)) {
			char* _tmp1;
			_tmp1 = NULL;
			val = (_tmp1 = g_strdup (vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit)))), (val = (g_free (val), NULL)), _tmp1);
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
	}
	_tmp2 = NULL;
	vala_ccode_enum_add_value (self->priv->cenum, (_tmp2 = vala_enum_value_get_cname (ev)), val);
	(_tmp2 = (g_free (_tmp2), NULL));
	(val = (g_free (val), NULL));
}


static void vala_code_generator_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaCodeGenerator * self;
	char* _tmp0;
	ValaCCodeFunctionDeclarator* _tmp1;
	ValaCCodeFunctionDeclarator* cfundecl;
	char* _tmp2;
	ValaCCodeTypeDefinition* _tmp3;
	ValaCCodeTypeDefinition* ctypedef;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	vala_code_node_accept_children (VALA_CODE_NODE (cb), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	_tmp1 = NULL;
	cfundecl = (_tmp1 = vala_ccode_function_declarator_new ((_tmp0 = vala_data_type_get_cname (VALA_DATA_TYPE (cb), FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_callback_get_parameters (cb);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) param))));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	ctypedef = (_tmp3 = vala_ccode_type_definition_new ((_tmp2 = vala_type_reference_get_cname (vala_callback_get_return_type (cb), FALSE, FALSE)), VALA_CCODE_DECLARATOR (cfundecl)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
	if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (cb))) {
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (ctypedef));
	} else {
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (ctypedef));
	}
	(cfundecl == NULL ? NULL : (cfundecl = (g_object_unref (cfundecl), NULL)));
	(ctypedef == NULL ? NULL : (ctypedef = (g_object_unref (ctypedef), NULL)));
}


static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_MEMBER (m));
	/* stuff meant for all lockable members */
	if (VALA_IS_LOCKABLE (m) && vala_lockable_get_lock_used ((VALA_LOCKABLE (m)))) {
		char* _tmp1;
		char* _tmp0;
		ValaCCodeExpressionStatement* _tmp10;
		ValaCCodeAssignment* _tmp9;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		ValaCCodeMemberAccess* _tmp5;
		char* _tmp4;
		ValaCCodeMemberAccess* _tmp3;
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeIdentifier* _tmp11;
		ValaCCodeFunctionCall* _tmp12;
		ValaCCodeFunctionCall* fc;
		ValaCCodeMemberAccess* _tmp16;
		char* _tmp15;
		ValaCCodeMemberAccess* _tmp14;
		ValaCCodeIdentifier* _tmp13;
		char* _tmp17;
		gboolean _tmp18;
		ValaCCodeIdentifier* _tmp22;
		char* _tmp21;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_priv_struct, (_tmp0 = vala_type_reference_get_cname (self->priv->mutex_type, FALSE, FALSE)), (_tmp1 = vala_code_generator_get_symbol_lock_name (self, VALA_SYMBOL (m))));
		(_tmp1 = (g_free (_tmp1), NULL));
		(_tmp0 = (g_free (_tmp0), NULL));
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((_tmp10 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp4 = vala_code_generator_get_symbol_lock_name (self, VALA_SYMBOL (m)))))), VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_method_get_cname (vala_struct_get_default_construction_method ((VALA_STRUCT (vala_type_reference_get_data_type (self->priv->mutex_type)))))))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		(_tmp6 = (g_free (_tmp6), NULL));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 = (g_free (_tmp4), NULL));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		self->priv->requires_free_checked = TRUE;
		_tmp11 = NULL;
		_tmp12 = NULL;
		fc = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("VALA_FREE_CHECKED")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp15 = vala_code_generator_get_symbol_lock_name (self, VALA_SYMBOL (m)))))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		(_tmp15 = (g_free (_tmp15), NULL));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp17 = NULL;
		if ((_tmp18 = (_tmp17 = vala_data_type_get_free_function (vala_type_reference_get_data_type (self->priv->mutex_type))) == NULL, (_tmp17 = (g_free (_tmp17), NULL)), _tmp18)) {
			char* _tmp20;
			char* _tmp19;
			_tmp20 = NULL;
			_tmp19 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) vala_type_reference_get_data_type (self->priv->mutex_type))), (_tmp20 = g_strdup_printf ("The type `%s` doesn't contain a free function", (_tmp19 = vala_symbol_get_full_name (VALA_SYMBOL (vala_type_reference_get_data_type (self->priv->mutex_type)))))));
			(_tmp20 = (g_free (_tmp20), NULL));
			(_tmp19 = (g_free (_tmp19), NULL));
			(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
			return;
		}
		_tmp22 = NULL;
		_tmp21 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = vala_data_type_get_free_function (vala_type_reference_get_data_type (self->priv->mutex_type)))))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		(_tmp21 = (g_free (_tmp21), NULL));
		if (self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* _tmp23;
			_tmp23 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((_tmp23 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		}
		(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	}
}


static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	if (VALA_IS_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) c)))) {
		ValaDataType* _tmp0;
		ValaDataType* t;
		char* _tmp1;
		ValaCCodeDeclaration* _tmp2;
		ValaCCodeDeclaration* cdecl_;
		char* arr;
		ValaCCodeVariableDeclarator* _tmp6;
		char* _tmp5;
		char* _tmp4;
		_tmp0 = NULL;
		t = (_tmp0 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) c))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		_tmp1 = NULL;
		_tmp2 = NULL;
		cdecl_ = (_tmp2 = vala_ccode_declaration_new ((_tmp1 = vala_type_reference_get_const_cname (vala_constant_get_type_reference (c)))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
		arr = g_strdup ("");
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_constant_get_type_reference (c)))) {
			char* _tmp3;
			_tmp3 = NULL;
			arr = (_tmp3 = g_strdup ("[]"), (arr = (g_free (arr), NULL)), _tmp3);
		}
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp6 = vala_ccode_variable_declarator_new_with_initializer ((_tmp5 = g_strdup_printf ("%s%s", (_tmp4 = vala_constant_get_cname (c)), arr)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_constant_get_initializer (c))))))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		(_tmp5 = (g_free (_tmp5), NULL));
		(_tmp4 = (g_free (_tmp4), NULL));
		vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
		if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (c))) {
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
		} else {
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
		}
		(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		(arr = (g_free (arr), NULL));
	}
}


static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FIELD (f));
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
	lhs = NULL;
	st = NULL;
	if (vala_symbol_get_access (((ValaSymbol*) f)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeStruct* _tmp1;
		ValaCCodeStruct* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		st = (_tmp1 = (_tmp0 = self->priv->instance_struct, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp1);
		if (vala_field_get_instance (f)) {
			ValaCCodeExpression* _tmp4;
			char* _tmp3;
			ValaCCodeIdentifier* _tmp2;
			_tmp4 = NULL;
			_tmp3 = NULL;
			_tmp2 = NULL;
			lhs = (_tmp4 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("self"))), (_tmp3 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp4);
			(_tmp3 = (g_free (_tmp3), NULL));
			(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		} else {
			char* _tmp5;
			ValaCCodeDeclaration* _tmp6;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp8;
			char* _tmp7;
			ValaCCodeDeclaration* _tmp10;
			char* _tmp9;
			char* _tmp11;
			ValaCCodeVariableDeclarator* _tmp12;
			ValaCCodeVariableDeclarator* var_decl;
			ValaCCodeExpression* _tmp15;
			char* _tmp14;
			_tmp5 = NULL;
			_tmp6 = NULL;
			cdecl_ = (_tmp6 = vala_ccode_declaration_new ((_tmp5 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6);
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp8 = vala_ccode_variable_declarator_new ((_tmp7 = vala_field_get_cname (f))))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
			(_tmp7 = (g_free (_tmp7), NULL));
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
			_tmp10 = NULL;
			_tmp9 = NULL;
			cdecl_ = (_tmp10 = vala_ccode_declaration_new ((_tmp9 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp10);
			(_tmp9 = (g_free (_tmp9), NULL));
			_tmp11 = NULL;
			_tmp12 = NULL;
			var_decl = (_tmp12 = vala_ccode_variable_declarator_new ((_tmp11 = vala_field_get_cname (f))), (_tmp11 = (g_free (_tmp11), NULL)), _tmp12);
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp13;
				ValaCCodeExpression* init;
				_tmp13 = NULL;
				init = (_tmp13 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_field_get_initializer (f)))), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
				if (vala_code_generator_is_constant_ccode_expression (self, init)) {
					vala_ccode_variable_declarator_set_initializer (var_decl, init);
				}
				(init == NULL ? NULL : (init = (g_object_unref (init), NULL)));
			}
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (var_decl));
			vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
			_tmp15 = NULL;
			_tmp14 = NULL;
			lhs = (_tmp15 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp14 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp15);
			(_tmp14 = (g_free (_tmp14), NULL));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
		}
	} else {
		if (vala_symbol_get_access (((ValaSymbol*) f)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_instance (f)) {
				ValaCCodeStruct* _tmp17;
				ValaCCodeStruct* _tmp16;
				ValaCCodeExpression* _tmp21;
				char* _tmp20;
				ValaCCodeMemberAccess* _tmp19;
				ValaCCodeIdentifier* _tmp18;
				_tmp17 = NULL;
				_tmp16 = NULL;
				st = (_tmp17 = (_tmp16 = self->priv->instance_priv_struct, (_tmp16 == NULL ? NULL : g_object_ref (_tmp16))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp17);
				_tmp21 = NULL;
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp18 = NULL;
				lhs = (_tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp20 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp21);
				(_tmp20 = (g_free (_tmp20), NULL));
				(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
				(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
			} else {
				char* _tmp22;
				ValaCCodeDeclaration* _tmp23;
				ValaCCodeDeclaration* cdecl_;
				char* _tmp24;
				ValaCCodeVariableDeclarator* _tmp25;
				ValaCCodeVariableDeclarator* var_decl;
				ValaCCodeExpression* _tmp28;
				char* _tmp27;
				_tmp22 = NULL;
				_tmp23 = NULL;
				cdecl_ = (_tmp23 = vala_ccode_declaration_new ((_tmp22 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE))), (_tmp22 = (g_free (_tmp22), NULL)), _tmp23);
				_tmp24 = NULL;
				_tmp25 = NULL;
				var_decl = (_tmp25 = vala_ccode_variable_declarator_new ((_tmp24 = vala_field_get_cname (f))), (_tmp24 = (g_free (_tmp24), NULL)), _tmp25);
				if (vala_field_get_initializer (f) != NULL) {
					ValaCCodeExpression* _tmp26;
					ValaCCodeExpression* init;
					_tmp26 = NULL;
					init = (_tmp26 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_field_get_initializer (f)))), (_tmp26 == NULL ? NULL : g_object_ref (_tmp26)));
					if (vala_code_generator_is_constant_ccode_expression (self, init)) {
						vala_ccode_variable_declarator_set_initializer (var_decl, init);
					}
					(init == NULL ? NULL : (init = (g_object_unref (init), NULL)));
				}
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (var_decl));
				vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
				_tmp28 = NULL;
				_tmp27 = NULL;
				lhs = (_tmp28 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp27 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp28);
				(_tmp27 = (g_free (_tmp27), NULL));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
			}
		}
	}
	if (vala_field_get_instance (f)) {
		char* _tmp30;
		char* _tmp29;
		_tmp30 = NULL;
		_tmp29 = NULL;
		vala_ccode_struct_add_field (st, (_tmp29 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE)), (_tmp30 = vala_field_get_cname (f)));
		(_tmp30 = (g_free (_tmp30), NULL));
		(_tmp29 = (g_free (_tmp29), NULL));
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f)) {
			ValaArray* _tmp31;
			ValaArray* arr;
			/* create fields to store array dimensions*/
			_tmp31 = NULL;
			arr = (_tmp31 = VALA_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))), (_tmp31 == NULL ? NULL : g_object_ref (_tmp31)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaTypeReference* len_type;
					char* _tmp33;
					char* _tmp32;
					len_type = vala_type_reference_new ();
					vala_type_reference_set_data_type (len_type, vala_type_reference_get_data_type (self->priv->int_type));
					_tmp33 = NULL;
					_tmp32 = NULL;
					vala_ccode_struct_add_field (st, (_tmp32 = vala_type_reference_get_cname (len_type, FALSE, FALSE)), (_tmp33 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) f)), dim)));
					(_tmp33 = (g_free (_tmp33), NULL));
					(_tmp32 = (g_free (_tmp32), NULL));
					(len_type == NULL ? NULL : (len_type = (g_object_unref (len_type), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp34;
			ValaCCodeExpression* rhs;
			ValaCCodeExpressionStatement* _tmp37;
			ValaCCodeAssignment* _tmp36;
			_tmp34 = NULL;
			rhs = (_tmp34 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_field_get_initializer (f)))), (_tmp34 == NULL ? NULL : g_object_ref (_tmp34)));
			if (vala_type_reference_get_data_type (vala_field_get_type_reference (f)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_field_get_initializer (f))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_field_get_initializer (f))) != vala_type_reference_get_data_type (vala_field_get_type_reference (f))) {
				ValaCCodeExpression* _tmp35;
				/* FIXME: use C cast if debugging disabled*/
				_tmp35 = NULL;
				rhs = (_tmp35 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (rhs, vala_type_reference_get_data_type (vala_field_get_type_reference (f)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp35);
			}
			_tmp37 = NULL;
			_tmp36 = NULL;
			vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((_tmp37 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
			(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f) && VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))) {
				ValaArray* _tmp38;
				ValaArray* array;
				ValaMemberAccess* ma;
				GeeList* sizes;
				_tmp38 = NULL;
				array = (_tmp38 = VALA_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))), (_tmp38 == NULL ? NULL : g_object_ref (_tmp38)));
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) f)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (f));
				sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				{
					gint dim;
					dim = 0;
					for (dim = 1; dim <= vala_array_get_rank (array); dim++) {
						ValaCCodeExpression* array_len_lhs;
						ValaExpression* size;
						ValaCCodeExpressionStatement* _tmp40;
						ValaCCodeAssignment* _tmp39;
						array_len_lhs = vala_code_generator_get_array_length_cexpression (self, VALA_EXPRESSION (ma), dim);
						size = gee_list_get (((GeeList*) sizes), dim - 1);
						_tmp40 = NULL;
						_tmp39 = NULL;
						vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((_tmp40 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) size))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
						(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
						(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
						(array_len_lhs = (g_object_unref (array_len_lhs), NULL));
						(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
					}
				}
				(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(sizes == NULL ? NULL : (sizes = (g_object_unref (sizes), NULL)));
			}
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
		if (vala_type_reference_get_takes_ownership (vala_field_get_type_reference (f)) && self->priv->instance_dispose_fragment != NULL) {
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp42;
			ValaCCodeExpression* _tmp41;
			ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) f)), NULL);
			vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (f));
			_tmp42 = NULL;
			_tmp41 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((_tmp42 = vala_ccode_expression_statement_new ((_tmp41 = vala_code_generator_get_unref_expression (self, lhs, vala_field_get_type_reference (f), VALA_EXPRESSION (ma)))))));
			(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
			(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		}
	} else {
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp43;
			ValaCCodeExpression* rhs;
			_tmp43 = NULL;
			rhs = (_tmp43 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_field_get_initializer (f)))), (_tmp43 == NULL ? NULL : g_object_ref (_tmp43)));
			if (!vala_code_generator_is_constant_ccode_expression (self, rhs)) {
				if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) f)))) {
					ValaCCodeExpressionStatement* _tmp45;
					ValaCCodeAssignment* _tmp44;
					_tmp45 = NULL;
					_tmp44 = NULL;
					vala_ccode_fragment_append (self->priv->class_init_fragment, VALA_CCODE_NODE ((_tmp45 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
					(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
					(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
				} else {
					vala_code_node_set_error (VALA_CODE_NODE (f), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) f)), "Non-constant field initializers not supported in this context");
					(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
					(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					return;
				}
			}
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
	}
	(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
	(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
}


static gboolean vala_code_generator_is_constant_ccode_expression (ValaCodeGenerator* self, ValaCCodeExpression* cexpr)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), FALSE);
	return (VALA_IS_CCODE_CONSTANT (cexpr));
}


static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		ValaCCodeFormalParameter* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((_tmp1 = vala_ccode_formal_parameter_new (vala_symbol_get_name (((ValaSymbol*) p)), (_tmp0 = vala_type_reference_get_cname (vala_formal_parameter_get_type_reference (p), FALSE, !vala_type_reference_get_takes_ownership (vala_formal_parameter_get_type_reference (p))))))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		(_tmp0 = (g_free (_tmp0), NULL));
	}
}


static void vala_code_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaCodeGenerator * self;
	gint old_next_temp_var_id;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	old_next_temp_var_id = self->priv->next_temp_var_id;
	self->priv->next_temp_var_id = 0;
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
	self->priv->next_temp_var_id = old_next_temp_var_id;
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) prop)))) {
		char* _tmp0;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->priv->prop_enum, (_tmp0 = vala_property_get_upper_case_cname (prop)), NULL);
		(_tmp0 = (g_free (_tmp0), NULL));
	}
}


static void vala_code_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaCodeGenerator * self;
	ValaProperty* _tmp0;
	ValaProperty* prop;
	ValaTypeReference* _tmp3;
	ValaDataType* _tmp4;
	ValaDataType* t;
	ValaTypeReference* this_type;
	char* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFormalParameter* cselfparam;
	char* _tmp7;
	ValaCCodeFormalParameter* _tmp8;
	ValaCCodeFormalParameter* cvalueparam;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	_tmp0 = NULL;
	prop = (_tmp0 = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (vala_property_accessor_get_readable (acc)) {
		ValaTypeReference* _tmp1;
		_tmp1 = NULL;
		self->priv->current_return_type = (_tmp1 = g_object_ref (vala_property_get_type_reference (prop)), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp1);
	} else {
		ValaTypeReference* _tmp2;
		/* void*/
		_tmp2 = NULL;
		self->priv->current_return_type = (_tmp2 = vala_type_reference_new (), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp2);
	}
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	self->priv->current_return_type = (_tmp3 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp3);
	_tmp4 = NULL;
	t = (_tmp4 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) prop))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
	this_type = vala_type_reference_new ();
	vala_type_reference_set_data_type (this_type, t);
	_tmp5 = NULL;
	_tmp6 = NULL;
	cselfparam = (_tmp6 = vala_ccode_formal_parameter_new ("self", (_tmp5 = vala_type_reference_get_cname (this_type, FALSE, FALSE))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6);
	_tmp7 = NULL;
	_tmp8 = NULL;
	cvalueparam = (_tmp8 = vala_ccode_formal_parameter_new ("value", (_tmp7 = vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, TRUE))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
	if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
		ValaCCodeBlock* block;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp12;
			char* _tmp11;
			char* _tmp10;
			char* _tmp9;
			_tmp12 = NULL;
			_tmp11 = NULL;
			_tmp10 = NULL;
			_tmp9 = NULL;
			self->priv->function = (_tmp12 = vala_ccode_function_new ((_tmp10 = g_strdup_printf ("%s_get_%s", (_tmp9 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL)), vala_symbol_get_name (((ValaSymbol*) prop)))), (_tmp11 = vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp12);
			(_tmp11 = (g_free (_tmp11), NULL));
			(_tmp10 = (g_free (_tmp10), NULL));
			(_tmp9 = (g_free (_tmp9), NULL));
		} else {
			ValaCCodeFunction* _tmp15;
			char* _tmp14;
			char* _tmp13;
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp13 = NULL;
			self->priv->function = (_tmp15 = vala_ccode_function_new ((_tmp14 = g_strdup_printf ("%s_set_%s", (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL)), vala_symbol_get_name (((ValaSymbol*) prop)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp15);
			(_tmp14 = (g_free (_tmp14), NULL));
			(_tmp13 = (g_free (_tmp13), NULL));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (prop))) {
			ValaCCodeFunction* _tmp16;
			_tmp16 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp16 = vala_ccode_function_copy (self->priv->function))));
			(_tmp16 = (g_object_unref (_tmp16), NULL));
		} else {
			ValaCCodeFunction* _tmp17;
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp17 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp17 = vala_ccode_function_copy (self->priv->function))));
			(_tmp17 = (g_object_unref (_tmp17), NULL));
		}
		block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		vala_ccode_function_set_block (self->priv->function, block);
		if (vala_property_accessor_get_readable (acc)) {
			char* _tmp18;
			ValaCCodeDeclaration* _tmp19;
			ValaCCodeDeclaration* decl;
			ValaCCodeVariableDeclarator* _tmp20;
			ValaCCodeIdentifier* _tmp21;
			ValaCCodeFunctionCall* _tmp22;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp23;
			ValaCCodeFunctionCall* _tmp24;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp25;
			ValaCCodeConstant* _tmp26;
			ValaCCodeUnaryExpression* _tmp28;
			ValaCCodeIdentifier* _tmp27;
			ValaCCodeConstant* _tmp29;
			ValaCCodeExpressionStatement* _tmp30;
			ValaCCodeReturnStatement* _tmp32;
			ValaCCodeIdentifier* _tmp31;
			/* declare temporary variable to save the property value*/
			_tmp18 = NULL;
			_tmp19 = NULL;
			decl = (_tmp19 = vala_ccode_declaration_new ((_tmp18 = vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (_tmp18 = (g_free (_tmp18), NULL)), _tmp19);
			_tmp20 = NULL;
			vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((_tmp20 = vala_ccode_variable_declarator_new ("value"))));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (decl));
			_tmp21 = NULL;
			_tmp22 = NULL;
			ccall = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ("g_object_get")))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), _tmp22);
			_tmp23 = NULL;
			_tmp24 = NULL;
			ccast = (_tmp24 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL))), _tmp24);
			_tmp25 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("self"))));
			(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_get*/
			_tmp26 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp26 = vala_property_get_canonical_cconstant (prop))));
			(_tmp26 = (g_object_unref (_tmp26), NULL));
			_tmp28 = NULL;
			_tmp27 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("value")))))));
			(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
			(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
			_tmp29 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("NULL"))));
			(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
			_tmp30 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp30 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
			_tmp32 = NULL;
			_tmp31 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp32 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("value")))))));
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
			(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp33;
			ValaCCodeFunctionCall* _tmp34;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp35;
			ValaCCodeFunctionCall* _tmp36;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp37;
			ValaCCodeConstant* _tmp38;
			ValaCCodeIdentifier* _tmp39;
			ValaCCodeConstant* _tmp40;
			ValaCCodeExpressionStatement* _tmp41;
			_tmp33 = NULL;
			_tmp34 = NULL;
			ccall = (_tmp34 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("g_object_set")))), (_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL))), _tmp34);
			_tmp35 = NULL;
			_tmp36 = NULL;
			ccast = (_tmp36 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL))), _tmp36);
			_tmp37 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("self"))));
			(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_set*/
			_tmp38 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp38 = vala_property_get_canonical_cconstant (prop))));
			(_tmp38 = (g_object_unref (_tmp38), NULL));
			_tmp39 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("value"))));
			(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
			_tmp40 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_constant_new ("NULL"))));
			(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
			_tmp41 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp41 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean is_virtual;
		char* prefix;
		is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
		prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL);
		if (is_virtual) {
			char* _tmp42;
			_tmp42 = NULL;
			prefix = (_tmp42 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp42);
		}
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp45;
			char* _tmp44;
			char* _tmp43;
			_tmp45 = NULL;
			_tmp44 = NULL;
			_tmp43 = NULL;
			self->priv->function = (_tmp45 = vala_ccode_function_new ((_tmp43 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (((ValaSymbol*) prop)))), (_tmp44 = vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp45);
			(_tmp44 = (g_free (_tmp44), NULL));
			(_tmp43 = (g_free (_tmp43), NULL));
		} else {
			ValaCCodeFunction* _tmp47;
			char* _tmp46;
			_tmp47 = NULL;
			_tmp46 = NULL;
			self->priv->function = (_tmp47 = vala_ccode_function_new ((_tmp46 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (((ValaSymbol*) prop)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp47);
			(_tmp46 = (g_free (_tmp46), NULL));
		}
		if (is_virtual) {
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (!is_virtual) {
			if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (prop))) {
				ValaCCodeFunction* _tmp48;
				_tmp48 = NULL;
				vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp48 = vala_ccode_function_copy (self->priv->function))));
				(_tmp48 = (g_object_unref (_tmp48), NULL));
			} else {
				ValaCCodeFunction* _tmp49;
				vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp49 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp49 = vala_ccode_function_copy (self->priv->function))));
				(_tmp49 = (g_object_unref (_tmp49), NULL));
			}
		}
		if (vala_property_accessor_get_body (acc) != NULL) {
			ValaCCodeStatement* _tmp50;
			vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_property_accessor_get_body (acc)))));
			_tmp50 = NULL;
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp50 = vala_code_generator_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self"))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(prefix = (g_free (prefix), NULL));
	}
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
	(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	(cselfparam == NULL ? NULL : (cselfparam = (g_object_unref (cselfparam), NULL)));
	(cvalueparam == NULL ? NULL : (cvalueparam = (g_object_unref (cvalueparam), NULL)));
}


static void vala_code_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaCodeGenerator * self;
	ValaClass* _tmp0;
	ValaClass* cl;
	ValaCCodeFunction* _tmp3;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFunction* _tmp7;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeDeclaration* _tmp11;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeDeclaration* _tmp13;
	ValaCCodeVariableDeclarator* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp18;
	char* _tmp17;
	ValaCCodeIdentifier* _tmp21;
	char* _tmp20;
	char* _tmp19;
	ValaCCodeFunctionCall* _tmp22;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* _tmp25;
	ValaCCodeAssignment* _tmp24;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeFunctionCall* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeAssignment* _tmp32;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeFunctionCall* _tmp36;
	ValaCCodeMemberAccess* _tmp35;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeExpressionStatement* _tmp42;
	ValaCCodeAssignment* _tmp41;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeFunctionCall* _tmp45;
	ValaCCodeIdentifier* _tmp44;
	char* _tmp43;
	ValaCCodeIdentifier* _tmp46;
	ValaCCodeDeclaration* _tmp49;
	char* _tmp48;
	char* _tmp47;
	ValaCCodeVariableDeclarator* _tmp50;
	ValaCCodeReturnStatement* _tmp54;
	ValaCCodeIdentifier* _tmp53;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	self->priv->current_method_inner_error = FALSE;
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) c))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->function = (_tmp3 = vala_ccode_function_new ((_tmp2 = g_strdup_printf ("%s_constructor", (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "GObject *"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp3);
	(_tmp2 = (g_free (_tmp2), NULL));
	(_tmp1 = (g_free (_tmp1), NULL));
	vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (_tmp4 = vala_ccode_formal_parameter_new ("type", "GType")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (_tmp5 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (_tmp6 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp7 = vala_ccode_function_copy (self->priv->function))));
	(_tmp7 = (g_object_unref (_tmp7), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GObject *");
	_tmp8 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp8 = vala_ccode_variable_declarator_new ("obj"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%sClass *", (_tmp9 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp11);
	(_tmp10 = (g_free (_tmp10), NULL));
	(_tmp9 = (g_free (_tmp9), NULL));
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new ("klass"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp13 = NULL;
	cdecl_ = (_tmp13 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp13);
	_tmp14 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp14 = vala_ccode_variable_declarator_new ("parent_class"))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp15 = NULL;
	_tmp16 = NULL;
	ccall = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("g_type_class_peek")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16);
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ((_tmp17 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	(_tmp17 = (g_free (_tmp17), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	_tmp22 = NULL;
	ccast = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("%s_CLASS", (_tmp19 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), (_tmp19 = (g_free (_tmp19), NULL)), _tmp22);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("klass"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	_tmp27 = NULL;
	_tmp26 = NULL;
	ccall = (_tmp27 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp27);
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("klass"))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	_tmp30 = NULL;
	_tmp29 = NULL;
	ccast = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), _tmp30);
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("parent_class"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	ccall = (_tmp36 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("parent_class"))), "constructor")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp36);
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	_tmp37 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("type"))));
	(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	_tmp38 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("n_construct_properties"))));
	(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("construct_properties"))));
	(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp42 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("obj"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
	(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	ccall = (_tmp45 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new ((_tmp43 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp45);
	(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
	(_tmp43 = (g_free (_tmp43), NULL));
	_tmp46 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("obj"))));
	(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
	_tmp49 = NULL;
	_tmp48 = NULL;
	_tmp47 = NULL;
	cdecl_ = (_tmp49 = vala_ccode_declaration_new ((_tmp48 = g_strdup_printf ("%s *", (_tmp47 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp49);
	(_tmp48 = (g_free (_tmp48), NULL));
	(_tmp47 = (g_free (_tmp47), NULL));
	_tmp50 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp50 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (self->priv->current_method_inner_error) {
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp52;
		ValaCCodeConstant* _tmp51;
		/* always separate error parameter and inner_error local variable
		 * as error may be set to NULL but we're always interested in inner errors
		 */
		cdecl_ = vala_ccode_declaration_new ("GError *");
		_tmp52 = NULL;
		_tmp51 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp52 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_constant_new ("NULL")))))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	}
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_constructor_get_body (c))));
	_tmp54 = NULL;
	_tmp53 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp54 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new ("obj")))))));
	(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
	(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
	vala_ccode_function_set_block (self->priv->function, cblock);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) c))) != NULL) {
		ValaCCodeComment* _tmp55;
		_tmp55 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp55 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) c)))))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static void vala_code_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self;
	ValaSymbol* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	_tmp0 = NULL;
	self->priv->current_symbol = (_tmp0 = VALA_SYMBOL (g_object_ref (b)), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp0);
}


static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self;
	GeeCollection* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* _tmp7;
	ValaSymbol* _tmp6;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				vala_symbol_set_active (VALA_SYMBOL (decl), FALSE);
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	{
		GeeCollection* stmt_collection;
		GeeIterator* stmt_it;
		stmt_collection = vala_block_get_statements (b);
		stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
		while (gee_iterator_next (stmt_it)) {
			ValaCodeNode* stmt;
			stmt = gee_iterator_get (stmt_it);
			{
				ValaSourceReference* _tmp0;
				ValaSourceReference* src;
				_tmp0 = NULL;
				src = (_tmp0 = vala_code_node_get_source_reference (stmt), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
				if (src != NULL && vala_source_reference_get_comment (src) != NULL) {
					ValaCCodeComment* _tmp1;
					_tmp1 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp1 = vala_ccode_comment_new (vala_source_reference_get_comment (src)))));
					(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
				}
				if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
					{
						GeeCollection* cstmt_collection;
						GeeIterator* cstmt_it;
						cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
						cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
						while (gee_iterator_next (cstmt_it)) {
							ValaCCodeStatement* cstmt;
							cstmt = gee_iterator_get (cstmt_it);
							{
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
								(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
							}
						}
						(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
						(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
					}
				} else {
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
				}
				(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
				(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
			}
		}
		(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
		(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
	}
	if (vala_code_generator_get_memory_management (self)) {
		{
			GeeCollection* decl_collection;
			GeeIterator* decl_it;
			decl_collection = local_vars;
			decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
			while (gee_iterator_next (decl_it)) {
				ValaVariableDeclarator* decl;
				decl = gee_iterator_get (decl_it);
				{
					if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
						ValaMemberAccess* ma;
						ValaCCodeExpressionStatement* _tmp5;
						ValaCCodeExpression* _tmp4;
						ValaCCodeIdentifier* _tmp3;
						char* _tmp2;
						ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
						vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
						_tmp5 = NULL;
						_tmp4 = NULL;
						_tmp3 = NULL;
						_tmp2 = NULL;
						vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp5 = vala_ccode_expression_statement_new ((_tmp4 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
						(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
						(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
						(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
						(_tmp2 = (g_free (_tmp2), NULL));
						(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					}
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				}
			}
			(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
		}
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (b), VALA_CCODE_NODE (cblock));
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->priv->current_symbol = (_tmp7 = (_tmp6 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp7);
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
}


static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeEmptyStatement* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_EMPTY_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = g_object_new (VALA_TYPE_CCODE_EMPTY_STATEMENT, NULL))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_DECLARATION_STATEMENT (stmt));
	/* split declaration statement as var declarators
	 * might have different types */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				char* _tmp0;
				ValaCCodeDeclaration* _tmp1;
				ValaCCodeDeclaration* cdecl_;
				_tmp0 = NULL;
				_tmp1 = NULL;
				cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (((ValaCodeNode*) decl)))));
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				if (vala_variable_declarator_get_initializer (decl) != NULL && vala_expression_get_can_fail (vala_variable_declarator_get_initializer (decl))) {
					vala_code_generator_add_simple_check (self, VALA_CODE_NODE (vala_variable_declarator_get_initializer (decl)), cfrag);
				}
				/* try to initialize uninitialized variables */
				if (vala_variable_declarator_get_initializer (decl) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					char* _tmp2;
					gboolean _tmp3;
					_tmp2 = NULL;
					if ((_tmp3 = (_tmp2 = vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) != NULL, (_tmp2 = (g_free (_tmp2), NULL)), _tmp3)) {
						ValaCCodeConstant* _tmp5;
						char* _tmp4;
						_tmp5 = NULL;
						_tmp4 = NULL;
						vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (((ValaCodeNode*) decl)))), VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ((_tmp4 = vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))))));
						(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
						(_tmp4 = (g_free (_tmp4), NULL));
					} else {
						ValaStruct* _tmp6;
						ValaStruct* st;
						ValaCCodeIdentifier* _tmp7;
						ValaCCodeFunctionCall* _tmp8;
						ValaCCodeFunctionCall* czero;
						ValaCCodeUnaryExpression* _tmp11;
						ValaCCodeIdentifier* _tmp10;
						char* _tmp9;
						ValaCCodeConstant* _tmp12;
						ValaCCodeIdentifier* _tmp15;
						char* _tmp14;
						char* _tmp13;
						ValaCCodeExpressionStatement* _tmp16;
						_tmp6 = NULL;
						st = (_tmp6 = VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
						/* memset needs string.h */
						self->priv->string_h_needed = TRUE;
						_tmp7 = NULL;
						_tmp8 = NULL;
						czero = (_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("memset")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
						_tmp11 = NULL;
						_tmp10 = NULL;
						_tmp9 = NULL;
						vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)))))))))));
						(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
						(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
						(_tmp9 = (g_free (_tmp9), NULL));
						_tmp12 = NULL;
						vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_constant_new ("0"))));
						(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
						_tmp15 = NULL;
						_tmp14 = NULL;
						_tmp13 = NULL;
						vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = g_strdup_printf ("sizeof (%s)", (_tmp13 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, FALSE))))))));
						(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
						(_tmp14 = (g_free (_tmp14), NULL));
						(_tmp13 = (g_free (_tmp13), NULL));
						_tmp16 = NULL;
						vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
						(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
						(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
						(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
					}
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
		}
		(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_variable_declarator_get_initializer (decl) != NULL) {
					vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_variable_declarator_get_initializer (decl)->temp_vars));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (self->priv->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static char* vala_code_generator_get_variable_cname (ValaCodeGenerator* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (gee_collection_contains (GEE_COLLECTION (self->priv->c_keywords), name)) {
		return g_strconcat (name, "_", NULL);
	} else {
		return g_strdup (name);
	}
}


static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* rhs;
	ValaCCodeVariableDeclarator* _tmp18;
	char* _tmp17;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (decl));
	vala_code_node_accept_children (VALA_CODE_NODE (decl), VALA_CODE_VISITOR (self));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
		ValaArray* _tmp0;
		ValaArray* arr;
		/* create variables to store array dimensions*/
		_tmp0 = NULL;
		arr = (_tmp0 = VALA_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				char* _tmp1;
				ValaVariableDeclarator* _tmp2;
				ValaVariableDeclarator* len_decl;
				ValaTypeReference* _tmp3;
				_tmp1 = NULL;
				_tmp2 = NULL;
				len_decl = (_tmp2 = vala_variable_declarator_new ((_tmp1 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)), dim)), NULL, NULL), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
				_tmp3 = NULL;
				vala_variable_declarator_set_type_reference (len_decl, (_tmp3 = vala_type_reference_new ()));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				vala_type_reference_set_data_type (vala_variable_declarator_get_type_reference (len_decl), vala_type_reference_get_data_type (self->priv->int_type));
				gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, len_decl);
				(len_decl == NULL ? NULL : (len_decl = (g_object_unref (len_decl), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	rhs = NULL;
	if (vala_variable_declarator_get_initializer (decl) != NULL) {
		ValaCCodeExpression* _tmp5;
		ValaCCodeExpression* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		rhs = (_tmp5 = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_variable_declarator_get_initializer (decl)))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp5);
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) {
			ValaCCodeExpression* _tmp6;
			/* FIXME: use C cast if debugging disabled*/
			_tmp6 = NULL;
			rhs = (_tmp6 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (rhs, vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp6);
		}
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaArray* _tmp7;
			ValaArray* arr;
			ValaCCodeCommaExpression* ccomma;
			ValaVariableDeclarator* temp_decl;
			ValaCCodeAssignment* _tmp9;
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeIdentifier* _tmp13;
			ValaCCodeExpression* _tmp15;
			ValaCCodeCommaExpression* _tmp14;
			_tmp7 = NULL;
			arr = (_tmp7 = VALA_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_variable_declarator_get_type_reference (decl), TRUE);
			gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
			_tmp9 = NULL;
			_tmp8 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
			(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					char* _tmp10;
					ValaCCodeIdentifier* _tmp11;
					ValaCCodeIdentifier* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp12;
					_tmp10 = NULL;
					_tmp11 = NULL;
					lhs_array_len = (_tmp11 = vala_ccode_identifier_new ((_tmp10 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)), dim))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
					rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_variable_declarator_get_initializer (decl), dim);
					_tmp12 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_array_len), rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
					(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
				}
			}
			_tmp13 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
			(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
			_tmp15 = NULL;
			_tmp14 = NULL;
			rhs = (_tmp15 = VALA_CCODE_EXPRESSION ((_tmp14 = ccomma, (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp15);
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		}
	} else {
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaCCodeExpression* _tmp16;
			_tmp16 = NULL;
			rhs = (_tmp16 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp16);
		}
	}
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (decl), VALA_CCODE_NODE ((_tmp18 = vala_ccode_variable_declarator_new_with_initializer ((_tmp17 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)))), rhs))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	(_tmp17 = (g_free (_tmp17), NULL));
	vala_symbol_set_active (VALA_SYMBOL (decl), TRUE);
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_code_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_INITIALIZER_LIST (list));
	vala_code_node_accept_children (VALA_CODE_NODE (list), VALA_CODE_VISITOR (self));
	if (vala_expression_get_expected_type (((ValaExpression*) list)) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_expected_type (((ValaExpression*) list))))) {
	} else {
		ValaCCodeInitializerList* clist;
		/* TODO */
		clist = g_object_new (VALA_TYPE_CCODE_INITIALIZER_LIST, NULL);
		{
			GeeCollection* expr_collection;
			GeeIterator* expr_it;
			expr_collection = vala_initializer_list_get_initializers (list);
			expr_it = gee_iterable_iterator (GEE_ITERABLE (expr_collection));
			while (gee_iterator_next (expr_it)) {
				ValaExpression* expr;
				expr = gee_iterator_get (expr_it);
				{
					vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))));
					(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
				}
			}
			(expr_collection == NULL ? NULL : (expr_collection = (g_object_unref (expr_collection), NULL)));
			(expr_it == NULL ? NULL : (expr_it = (g_object_unref (expr_it), NULL)));
		}
		vala_code_node_set_ccodenode (VALA_CODE_NODE (list), VALA_CCODE_NODE (clist));
		(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
	}
}


static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership)
{
	char* _tmp0;
	ValaVariableDeclarator* _tmp1;
	ValaVariableDeclarator* decl;
	ValaTypeReference* _tmp2;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	decl = (_tmp1 = vala_variable_declarator_new ((_tmp0 = g_strdup_printf ("_tmp%d", self->priv->next_temp_var_id)), NULL, NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_variable_declarator_set_type_reference (decl, (_tmp2 = vala_type_reference_copy (type)));
	(_tmp2 = (g_object_unref (_tmp2), NULL));
	vala_type_reference_set_is_ref (vala_variable_declarator_get_type_reference (decl), FALSE);
	vala_type_reference_set_is_out (vala_variable_declarator_get_type_reference (decl), FALSE);
	vala_type_reference_set_takes_ownership (vala_variable_declarator_get_type_reference (decl), takes_ownership);
	self->priv->next_temp_var_id++;
	return decl;
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_dup_func_expression (ValaCodeGenerator* self, ValaTypeReference* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	if (vala_type_reference_get_data_type (type) != NULL) {
		char* dup_function;
		gpointer _tmp6;
		dup_function = NULL;
		if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
			char* _tmp0;
			_tmp0 = NULL;
			dup_function = (_tmp0 = vala_data_type_get_ref_function (vala_type_reference_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), _tmp0);
		} else {
			char* _tmp2;
			if (vala_type_reference_get_data_type (type) != vala_type_reference_get_data_type (self->priv->string_type)) {
				char* _tmp1;
				/* duplicating non-reference counted structs may cause side-effects (and performance issues)*/
				_tmp1 = NULL;
				vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp1 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_symbol_get_name (((ValaSymbol*) vala_type_reference_get_data_type (type))))));
				(_tmp1 = (g_free (_tmp1), NULL));
			}
			_tmp2 = NULL;
			dup_function = (_tmp2 = vala_data_type_get_dup_function (vala_type_reference_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), _tmp2);
			if (dup_function == NULL) {
				char* _tmp4;
				char* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) vala_type_reference_get_data_type (type))), (_tmp4 = g_strdup_printf ("The type `%s` doesn't contain a copy function", (_tmp3 = vala_symbol_get_full_name (VALA_SYMBOL (vala_type_reference_get_data_type (type)))))));
				(_tmp4 = (g_free (_tmp4), NULL));
				(_tmp3 = (g_free (_tmp3), NULL));
			}
		}
		if (NULL != dup_function) {
			ValaCCodeIdentifier* _tmp5;
			_tmp5 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (dup_function), (dup_function = (g_free (dup_function), NULL)), _tmp5));
		}
		return VALA_CCODE_EXPRESSION ((_tmp6 = NULL, (dup_function = (g_free (dup_function), NULL)), _tmp6));
		(dup_function = (g_free (dup_function), NULL));
	} else {
		if (vala_type_reference_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->priv->current_type_symbol)) {
			char* _tmp7;
			char* _tmp8;
			char* func_name;
			ValaCCodeMemberAccess* _tmp10;
			ValaCCodeIdentifier* _tmp9;
			ValaCCodeMemberAccess* _tmp11;
			ValaCCodeMemberAccess* _tmp12;
			_tmp7 = NULL;
			_tmp8 = NULL;
			func_name = (_tmp8 = g_strdup_printf ("%s_dup_func", (_tmp7 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) vala_type_reference_get_type_parameter (type))), -1))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
			_tmp10 = NULL;
			_tmp9 = NULL;
			_tmp11 = NULL;
			_tmp12 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp12 = (_tmp11 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), _tmp11), (func_name = (g_free (func_name), NULL)), _tmp12));
			(func_name = (g_free (func_name), NULL));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	if (vala_type_reference_get_data_type (type) != NULL) {
		char* unref_function;
		ValaCCodeIdentifier* _tmp5;
		unref_function = NULL;
		if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
			char* _tmp0;
			_tmp0 = NULL;
			unref_function = (_tmp0 = vala_data_type_get_unref_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp0);
		} else {
			char* _tmp1;
			_tmp1 = NULL;
			unref_function = (_tmp1 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp1);
		}
		if (unref_function == NULL) {
			char* _tmp3;
			char* _tmp2;
			gpointer _tmp4;
			_tmp3 = NULL;
			_tmp2 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) vala_type_reference_get_data_type (type))), (_tmp3 = g_strdup_printf ("The type `%s` doesn't contain a free function", (_tmp2 = vala_symbol_get_full_name (VALA_SYMBOL (vala_type_reference_get_data_type (type)))))));
			(_tmp3 = (g_free (_tmp3), NULL));
			(_tmp2 = (g_free (_tmp2), NULL));
			return VALA_CCODE_EXPRESSION ((_tmp4 = NULL, (unref_function = (g_free (unref_function), NULL)), _tmp4));
		}
		_tmp5 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (unref_function), (unref_function = (g_free (unref_function), NULL)), _tmp5));
		(unref_function = (g_free (unref_function), NULL));
	} else {
		if (vala_type_reference_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->priv->current_type_symbol)) {
			char* _tmp6;
			char* _tmp7;
			char* func_name;
			ValaCCodeMemberAccess* _tmp9;
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeMemberAccess* _tmp10;
			ValaCCodeMemberAccess* _tmp11;
			_tmp6 = NULL;
			_tmp7 = NULL;
			func_name = (_tmp7 = g_strdup_printf ("%s_destroy_func", (_tmp6 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) vala_type_reference_get_type_parameter (type))), -1))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp10 = NULL;
			_tmp11 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp11 = (_tmp10 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp10), (func_name = (g_free (func_name), NULL)), _tmp11));
			(func_name = (g_free (func_name), NULL));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type, ValaExpression* expr)
{
	ValaCCodeConstant* _tmp1;
	ValaCCodeBinaryExpression* _tmp2;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeExpression* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeConstant* _tmp25;
	ValaCCodeAssignment* cassign;
	char* _tmp26;
	gboolean _tmp27;
	ValaCCodeParenthesizedExpression* _tmp30;
	ValaCCodeConstant* _tmp29;
	ValaCCodeConditionalExpression* _tmp31;
	ValaCCodeConditionalExpression* _tmp32;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cvar), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr), NULL);
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	if (vala_type_reference_get_is_null (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	cisnull = (_tmp2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_constant_new ("NULL")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	if (vala_type_reference_get_data_type (type) == NULL) {
		ValaCCodeConstant* _tmp5;
		ValaCCodeExpression* _tmp4;
		ValaCCodeBinaryExpression* _tmp6;
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* _tmp7;
		if (!(VALA_IS_CLASS (self->priv->current_type_symbol)) || !vala_data_type_is_subtype_of (VALA_DATA_TYPE (self->priv->current_class), self->priv->gobject_type)) {
			ValaCCodeConstant* _tmp3;
			_tmp3 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ("NULL"), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp3));
		}
		/* unref functions are optional for type parameters*/
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp6 = NULL;
		cunrefisnull = (_tmp6 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (_tmp4 = vala_code_generator_get_destroy_func_expression (self, type)), VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("NULL")))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp6);
		_tmp7 = NULL;
		cisnull = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cunrefisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp7);
		(cunrefisnull == NULL ? NULL : (cunrefisnull = (g_object_unref (cunrefisnull), NULL)));
	}
	_tmp8 = NULL;
	_tmp9 = NULL;
	ccall = (_tmp9 = vala_ccode_function_call_new ((_tmp8 = vala_code_generator_get_destroy_func_expression (self, type))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	if (vala_type_reference_get_data_type (type) == self->priv->glist_type || vala_type_reference_get_data_type (type) == self->priv->gslist_type) {
		gboolean takes_ownership;
		ValaCCodeExpression* destroy_func_expression;
		takes_ownership = FALSE;
		destroy_func_expression = NULL;
		{
			GeeList* type_arg_collection;
			GeeIterator* type_arg_it;
			type_arg_collection = vala_type_reference_get_type_arguments (type);
			type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
			while (gee_iterator_next (type_arg_it)) {
				ValaTypeReference* type_arg;
				type_arg = gee_iterator_get (type_arg_it);
				{
					takes_ownership = vala_type_reference_get_takes_ownership (type_arg);
					if (takes_ownership) {
						ValaCCodeExpression* _tmp10;
						_tmp10 = NULL;
						destroy_func_expression = (_tmp10 = vala_code_generator_get_destroy_func_expression (self, type_arg), (destroy_func_expression == NULL ? NULL : (destroy_func_expression = (g_object_unref (destroy_func_expression), NULL))), _tmp10);
					}
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
			(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
			(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
		}
		if (takes_ownership) {
			ValaCCodeFunctionCall* cunrefcall;
			ValaCCodeCastExpression* _tmp15;
			ValaCCodeConstant* _tmp16;
			cunrefcall = NULL;
			if (vala_type_reference_get_data_type (type) == self->priv->glist_type) {
				ValaCCodeFunctionCall* _tmp12;
				ValaCCodeIdentifier* _tmp11;
				_tmp12 = NULL;
				_tmp11 = NULL;
				cunrefcall = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("g_list_foreach")))), (cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL))), _tmp12);
				(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
			} else {
				ValaCCodeFunctionCall* _tmp14;
				ValaCCodeIdentifier* _tmp13;
				_tmp14 = NULL;
				_tmp13 = NULL;
				cunrefcall = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_slist_foreach")))), (cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL))), _tmp14);
				(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
			}
			vala_ccode_function_call_add_argument (cunrefcall, cvar);
			_tmp15 = NULL;
			vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_cast_expression_new (destroy_func_expression, "GFunc"))));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			_tmp16 = NULL;
			vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_constant_new ("NULL"))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cunrefcall));
			(cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL)));
		}
		(destroy_func_expression == NULL ? NULL : (destroy_func_expression = (g_object_unref (destroy_func_expression), NULL)));
	} else {
		if (vala_type_reference_get_data_type (type) == self->priv->gstring_type) {
			ValaCCodeConstant* _tmp17;
			_tmp17 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("TRUE"))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
		} else {
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (type))) {
				ValaArray* _tmp18;
				ValaArray* arr;
				_tmp18 = NULL;
				arr = (_tmp18 = VALA_ARRAY (vala_type_reference_get_data_type (type)), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
				if (vala_array_get_element_type (arr) == NULL || vala_data_type_is_reference_type (vala_array_get_element_type (arr))) {
					gboolean first;
					ValaCCodeExpression* csizeexpr;
					ValaCCodeIdentifier* _tmp22;
					ValaTypeReference* element_type;
					ValaCCodeCastExpression* _tmp24;
					ValaCCodeExpression* _tmp23;
					self->priv->requires_array_free = TRUE;
					first = TRUE;
					csizeexpr = NULL;
					{
						gint dim;
						dim = 0;
						for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
							if (first) {
								ValaCCodeExpression* _tmp19;
								_tmp19 = NULL;
								csizeexpr = (_tmp19 = vala_code_generator_get_array_length_cexpression (self, expr, dim), (csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL))), _tmp19);
								first = FALSE;
							} else {
								ValaCCodeExpression* _tmp21;
								ValaCCodeExpression* _tmp20;
								_tmp21 = NULL;
								_tmp20 = NULL;
								csizeexpr = (_tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, (_tmp20 = vala_code_generator_get_array_length_cexpression (self, expr, dim)))), (csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL))), _tmp21);
								(_tmp20 = (g_object_unref (_tmp20), NULL));
							}
						}
					}
					_tmp22 = NULL;
					vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("_vala_array_free"))));
					(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
					vala_ccode_function_call_add_argument (ccall, csizeexpr);
					element_type = vala_type_reference_new ();
					vala_type_reference_set_data_type (element_type, vala_array_get_element_type (arr));
					vala_type_reference_set_type_parameter (element_type, vala_array_get_element_type_parameter (arr));
					_tmp24 = NULL;
					_tmp23 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_cast_expression_new ((_tmp23 = vala_code_generator_get_destroy_func_expression (self, element_type)), "GDestroyNotify"))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					(csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL)));
					(element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL)));
				}
				(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
			}
		}
	}
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
	_tmp25 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("NULL"))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	cassign = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (ccomma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	/* g_free (NULL) is allowed*/
	_tmp26 = NULL;
	if ((_tmp27 = vala_type_reference_get_non_null (type) || (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type)) && g_utf8_collate ((_tmp26 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type))), "g_free") == 0), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27)) {
		ValaCCodeParenthesizedExpression* _tmp28;
		_tmp28 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp28));
	}
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp31 = NULL;
	_tmp32 = NULL;
	return VALA_CCODE_EXPRESSION ((_tmp32 = (_tmp31 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign))))), (_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), _tmp31), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp32));
	(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
}


static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr)
{
	ValaCodeGenerator * self;
	ValaVariableDeclarator* full_expr_decl;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeIdentifier* _tmp4;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
		gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
		return;
	}
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	gee_collection_clear (GEE_COLLECTION (expr->temp_vars));
	{
		GeeArrayList* decl1_collection;
		GeeIterator* decl1_it;
		decl1_collection = self->priv->temp_vars;
		decl1_it = gee_iterable_iterator (GEE_ITERABLE (decl1_collection));
		while (gee_iterator_next (decl1_it)) {
			ValaVariableDeclarator* decl1;
			decl1 = gee_iterator_get (decl1_it);
			{
				gee_collection_add (GEE_COLLECTION (expr->temp_vars), decl1);
				(decl1 == NULL ? NULL : (decl1 = (g_object_unref (decl1), NULL)));
			}
		}
		(decl1_it == NULL ? NULL : (decl1_it = (g_object_unref (decl1_it), NULL)));
	}
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
	if (gee_collection_get_size (((GeeCollection*) (GEE_LIST (self->priv->temp_ref_vars)))) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	full_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	gee_collection_add (GEE_COLLECTION (expr->temp_vars), full_expr_decl);
	expr_list = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) full_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	{
		GeeArrayList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->temp_ref_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp3;
				ValaCCodeIdentifier* _tmp2;
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_ccode_comma_expression_append_expression (expr_list, (_tmp3 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) decl))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	_tmp4 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) full_expr_decl))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (expr_list));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
	(full_expr_decl == NULL ? NULL : (full_expr_decl = (g_object_unref (full_expr_decl), NULL)));
	(expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL)));
}


static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GeeCollection* temp_vars)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	g_return_if_fail (temp_vars == NULL || GEE_IS_COLLECTION (temp_vars));
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = temp_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				char* _tmp0;
				ValaCCodeDeclaration* _tmp1;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* vardecl;
				_tmp0 = NULL;
				_tmp1 = NULL;
				cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), TRUE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
				vardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name (((ValaSymbol*) decl)));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (vardecl));
				if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					ValaCCodeConstant* _tmp2;
					_tmp2 = NULL;
					vala_ccode_variable_declarator_set_initializer (vardecl, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("NULL"))));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				}
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(vardecl == NULL ? NULL : (vardecl = (g_object_unref (vardecl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
}


static void vala_code_generator_add_simple_check (ValaCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag)
{
	ValaCCodeFragment* cprint_frag;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccritical;
	ValaCCodeConstant* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeConstant* _tmp4;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeExpressionStatement* _tmp7;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* cclear;
	ValaCCodeUnaryExpression* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeExpressionStatement* _tmp12;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_NODE (node));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	cprint_frag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccritical = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_critical")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("\"file %s: line %d: uncaught error: %s\""))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ("__FILE__"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("__LINE__"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("inner_error"))), "message"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp7 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((_tmp7 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccritical)))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	_tmp9 = NULL;
	cclear = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_clear_error")))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (cclear, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("inner_error")))))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((_tmp12 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cclear)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	if (self->priv->current_try != NULL) {
		ValaCCodeBlock* cerror_block;
		ValaCCodeConstant* _tmp23;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeBinaryExpression* _tmp24;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeIfStatement* _tmp25;
		/* surrounding try found
		 TODO might be the wrong one when using nested try statements*/
		cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		{
			GeeCollection* clause_collection;
			GeeIterator* clause_it;
			clause_collection = vala_try_statement_get_catch_clauses (self->priv->current_try);
			clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
			while (gee_iterator_next (clause_it)) {
				ValaCatchClause* clause;
				clause = gee_iterator_get (clause_it);
				{
					char* _tmp14;
					char* _tmp13;
					ValaCCodeGotoStatement* _tmp15;
					ValaCCodeGotoStatement* cgoto_stmt;
					/* go to catch clause if error domain matches*/
					_tmp14 = NULL;
					_tmp13 = NULL;
					_tmp15 = NULL;
					cgoto_stmt = (_tmp15 = vala_ccode_goto_statement_new ((_tmp14 = g_strdup_printf ("__catch%d_%s", self->priv->current_try_id, (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause))), NULL))))), (_tmp14 = (g_free (_tmp14), NULL)), (_tmp13 = (g_free (_tmp13), NULL)), _tmp15);
					if (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause)) == self->priv->gerror_type) {
						/* general catch clause*/
						vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cgoto_stmt));
					} else {
						ValaCCodeIdentifier* _tmp19;
						char* _tmp18;
						ValaCCodeMemberAccess* _tmp17;
						ValaCCodeIdentifier* _tmp16;
						ValaCCodeBinaryExpression* _tmp20;
						ValaCCodeBinaryExpression* ccond;
						ValaCCodeBlock* cgoto_block;
						ValaCCodeIfStatement* _tmp21;
						_tmp19 = NULL;
						_tmp18 = NULL;
						_tmp17 = NULL;
						_tmp16 = NULL;
						_tmp20 = NULL;
						ccond = (_tmp20 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("inner_error"))), "domain"))), VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause)), NULL)))))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), (_tmp18 = (g_free (_tmp18), NULL)), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), _tmp20);
						cgoto_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
						vala_ccode_block_add_statement (cgoto_block, VALA_CCODE_NODE (cgoto_stmt));
						_tmp21 = NULL;
						vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp21 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cgoto_block), NULL))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
						(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
						(cgoto_block == NULL ? NULL : (cgoto_block = (g_object_unref (cgoto_block), NULL)));
					}
					(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
					(cgoto_stmt == NULL ? NULL : (cgoto_stmt = (g_object_unref (cgoto_stmt), NULL)));
				}
			}
			(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
			(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
		}
		/* print critical message if no catch clause matches*/
		vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
		/* check error domain if expression failed*/
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp24 = NULL;
		ccond = (_tmp24 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ("NULL")))), (_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL))), (_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL))), _tmp24);
		_tmp25 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp25 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
		(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
	} else {
		GeeCollection* _tmp26;
		gboolean _tmp27;
		_tmp26 = NULL;
		if ((_tmp27 = self->priv->current_method != NULL && gee_collection_get_size ((_tmp26 = vala_method_get_error_domains (self->priv->current_method))) > 0, (_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL))), _tmp27)) {
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeFunctionCall* _tmp29;
			ValaCCodeFunctionCall* cpropagate;
			ValaCCodeIdentifier* _tmp30;
			ValaCCodeIdentifier* _tmp31;
			ValaCCodeBlock* cerror_block;
			ValaCCodeExpressionStatement* _tmp32;
			ValaCCodeConstant* _tmp37;
			ValaCCodeIdentifier* _tmp36;
			ValaCCodeBinaryExpression* _tmp38;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* _tmp39;
			/* current method can fail, propagate error
			 TODO ensure one of the error domains matches*/
			_tmp28 = NULL;
			_tmp29 = NULL;
			cpropagate = (_tmp29 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("g_propagate_error")))), (_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL))), _tmp29);
			_tmp30 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("error"))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
			_tmp31 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("inner_error"))));
			(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			_tmp32 = NULL;
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp32 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cpropagate)))));
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
			if (self->priv->current_return_type != NULL && vala_type_reference_get_data_type (self->priv->current_return_type) != NULL) {
				ValaCCodeReturnStatement* _tmp34;
				ValaCCodeExpression* _tmp33;
				_tmp34 = NULL;
				_tmp33 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp34 = vala_ccode_return_statement_new ((_tmp33 = vala_code_generator_default_value_for_type (self, vala_type_reference_get_data_type (self->priv->current_return_type)))))));
				(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
				(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
			} else {
				ValaCCodeReturnStatement* _tmp35;
				_tmp35 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp35 = vala_ccode_return_statement_new (NULL))));
				(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
			}
			_tmp37 = NULL;
			_tmp36 = NULL;
			_tmp38 = NULL;
			ccond = (_tmp38 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("NULL")))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), (_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL))), _tmp38);
			_tmp39 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp39 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
			(cpropagate == NULL ? NULL : (cpropagate = (g_object_unref (cpropagate), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		} else {
			ValaCCodeBlock* cerror_block;
			ValaCCodeConstant* _tmp41;
			ValaCCodeIdentifier* _tmp40;
			ValaCCodeBinaryExpression* _tmp42;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* _tmp43;
			/* TODO improve check and move to semantic analyzer*/
			vala_report_warning (vala_code_node_get_source_reference (node), "unhandled error");
			cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			/* print critical message*/
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
			/* check error domain if expression failed*/
			_tmp41 = NULL;
			_tmp40 = NULL;
			_tmp42 = NULL;
			ccond = (_tmp42 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("NULL")))), (_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL))), (_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL))), _tmp42);
			_tmp43 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp43 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		}
	}
	(cprint_frag == NULL ? NULL : (cprint_frag = (g_object_unref (cprint_frag), NULL)));
	(ccritical == NULL ? NULL : (ccritical = (g_object_unref (ccritical), NULL)));
	(cclear == NULL ? NULL : (cclear = (g_object_unref (cclear), NULL)));
}


static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeExpressionStatement* _tmp0;
	ValaCCodeFragment* cfrag;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_EXPRESSION_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_expression_statement_get_expression (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) stmt)) && vala_expression_get_can_fail (vala_expression_statement_get_expression (stmt))) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) stmt)));
		vala_code_generator_add_simple_check (self, VALA_CODE_NODE (vala_expression_statement_get_expression (stmt)), cfrag);
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
		(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	}
	/* free temporary objects */
	if (!vala_code_generator_get_memory_management (self)) {
		gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
		gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
		return;
	}
	if (gee_collection_get_size (((GeeCollection*) (GEE_LIST (self->priv->temp_vars)))) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) stmt)));
	{
		GeeArrayList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->temp_ref_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp3;
				ValaCCodeExpression* _tmp2;
				ValaCCodeIdentifier* _tmp1;
				ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp1 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp3 = vala_ccode_expression_statement_new ((_tmp2 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) decl))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GeeCollection* temp_vars)
{
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_STATEMENT (stmt));
	g_return_if_fail (temp_vars == NULL || GEE_IS_COLLECTION (temp_vars));
	/* declare temporary variables */
	if (gee_collection_get_size (temp_vars) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, temp_vars);
	/* FIXME cast to CodeNode shouldn't be necessary as Statement requires CodeNode*/
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((VALA_CODE_NODE (stmt))));
	vala_code_node_set_ccodenode ((VALA_CODE_NODE (stmt)), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_IF_STATEMENT (stmt));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_true_statement (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_false_statement (stmt))))))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIfStatement* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp1 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_if_statement_get_true_statement (stmt)))), NULL))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_if_statement_get_condition (stmt)->temp_vars));
}


static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaVariableDeclarator* temp_decl;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeFragment* cswitchblock;
	ValaCCodeExpressionStatement* _tmp0;
	GeeCollection* default_statements;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_SWITCH_STATEMENT (stmt));
	/* we need a temporary variable to save the property value*/
	temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_switch_statement_get_expression (stmt)), TRUE);
	gee_list_insert (GEE_LIST (vala_switch_statement_get_expression (stmt)->temp_vars), 0, temp_decl);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
	cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_switch_statement_get_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	cswitchblock = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	_tmp0 = NULL;
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cswitchblock));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_switch_statement_get_expression (stmt)->temp_vars));
	default_statements = NULL;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GeeCollection* section_collection;
		GeeIterator* section_it;
		section_collection = vala_switch_statement_get_sections (stmt);
		section_it = gee_iterable_iterator (GEE_ITERABLE (section_collection));
		while (gee_iterator_next (section_it)) {
			ValaSwitchSection* section;
			section = gee_iterator_get (section_it);
			{
				if (vala_switch_section_has_default_label (section)) {
					GeeCollection* _tmp1;
					_tmp1 = NULL;
					default_statements = (_tmp1 = vala_switch_section_get_statements (section), (default_statements == NULL ? NULL : (default_statements = (g_object_unref (default_statements), NULL))), _tmp1);
				} else {
					ValaCCodeBinaryExpression* cor;
					ValaCCodeBlock* cblock;
					ValaCCodeConstant* _tmp5;
					ValaCCodeDoStatement* _tmp6;
					ValaCCodeDoStatement* cdo;
					ValaCCodeIfStatement* cif;
					ValaCCodeIfStatement* _tmp10;
					ValaCCodeIfStatement* _tmp9;
					cor = NULL;
					{
						GeeCollection* label_collection;
						GeeIterator* label_it;
						label_collection = vala_switch_section_get_labels (section);
						label_it = gee_iterable_iterator (GEE_ITERABLE (label_collection));
						while (gee_iterator_next (label_it)) {
							ValaSwitchLabel* label;
							label = gee_iterator_get (label_it);
							{
								ValaCCodeBinaryExpression* ccmp;
								ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_switch_label_get_expression (label)))));
								if (cor == NULL) {
									ValaCCodeBinaryExpression* _tmp3;
									ValaCCodeBinaryExpression* _tmp2;
									_tmp3 = NULL;
									_tmp2 = NULL;
									cor = (_tmp3 = (_tmp2 = ccmp, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), _tmp3);
								} else {
									ValaCCodeBinaryExpression* _tmp4;
									_tmp4 = NULL;
									cor = (_tmp4 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cor), VALA_CCODE_EXPRESSION (ccmp)), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), _tmp4);
								}
								(label == NULL ? NULL : (label = (g_object_unref (label), NULL)));
								(ccmp == NULL ? NULL : (ccmp = (g_object_unref (ccmp), NULL)));
							}
						}
						(label_collection == NULL ? NULL : (label_collection = (g_object_unref (label_collection), NULL)));
						(label_it == NULL ? NULL : (label_it = (g_object_unref (label_it), NULL)));
					}
					cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
					{
						GeeCollection* body_stmt_collection;
						GeeIterator* body_stmt_it;
						body_stmt_collection = vala_switch_section_get_statements (section);
						body_stmt_it = gee_iterable_iterator (GEE_ITERABLE (body_stmt_collection));
						while (gee_iterator_next (body_stmt_it)) {
							ValaCodeNode* body_stmt;
							body_stmt = gee_iterator_get (body_stmt_it);
							{
								if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))) {
									{
										GeeCollection* cstmt_collection;
										GeeIterator* cstmt_it;
										cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))));
										cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
										while (gee_iterator_next (cstmt_it)) {
											ValaCCodeStatement* cstmt;
											cstmt = gee_iterator_get (cstmt_it);
											{
												vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
												(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
											}
										}
										(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
										(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
									}
								} else {
									vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (body_stmt))));
								}
								(body_stmt == NULL ? NULL : (body_stmt = (g_object_unref (body_stmt), NULL)));
							}
						}
						(body_stmt_collection == NULL ? NULL : (body_stmt_collection = (g_object_unref (body_stmt_collection), NULL)));
						(body_stmt_it == NULL ? NULL : (body_stmt_it = (g_object_unref (body_stmt_it), NULL)));
					}
					_tmp5 = NULL;
					_tmp6 = NULL;
					cdo = (_tmp6 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("0")))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6);
					cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cor), VALA_CCODE_STATEMENT (cdo), NULL);
					if (coldif != NULL) {
						vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cif));
					} else {
						ValaCCodeStatement* _tmp8;
						ValaCCodeIfStatement* _tmp7;
						_tmp8 = NULL;
						_tmp7 = NULL;
						ctopstmt = (_tmp8 = VALA_CCODE_STATEMENT ((_tmp7 = cif, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), _tmp8);
					}
					_tmp10 = NULL;
					_tmp9 = NULL;
					coldif = (_tmp10 = (_tmp9 = cif, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9))), (coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL))), _tmp10);
					(cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL)));
					(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
					(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
					(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
				}
				(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
			}
		}
		(section_collection == NULL ? NULL : (section_collection = (g_object_unref (section_collection), NULL)));
		(section_it == NULL ? NULL : (section_it = (g_object_unref (section_it), NULL)));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeConstant* _tmp11;
		ValaCCodeDoStatement* _tmp12;
		ValaCCodeDoStatement* cdo;
		cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		{
			GeeCollection* body_stmt_collection;
			GeeIterator* body_stmt_it;
			body_stmt_collection = default_statements;
			body_stmt_it = gee_iterable_iterator (GEE_ITERABLE (body_stmt_collection));
			while (gee_iterator_next (body_stmt_it)) {
				ValaCodeNode* body_stmt;
				body_stmt = gee_iterator_get (body_stmt_it);
				{
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					(body_stmt == NULL ? NULL : (body_stmt = (g_object_unref (body_stmt), NULL)));
				}
			}
			(body_stmt_it == NULL ? NULL : (body_stmt_it = (g_object_unref (body_stmt_it), NULL)));
		}
		_tmp11 = NULL;
		_tmp12 = NULL;
		cdo = (_tmp12 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("0")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
		if (coldif == NULL) {
			ValaCCodeStatement* _tmp14;
			ValaCCodeDoStatement* _tmp13;
			/* there is only one section and that section
			 contains a default label*/
			_tmp14 = NULL;
			_tmp13 = NULL;
			ctopstmt = (_tmp14 = VALA_CCODE_STATEMENT ((_tmp13 = cdo, (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), _tmp14);
		} else {
			vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cdo));
		}
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
	}
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (ctopstmt));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
	(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
	(cswitchblock == NULL ? NULL : (cswitchblock = (g_object_unref (cswitchblock), NULL)));
	(default_statements == NULL ? NULL : (default_statements = (g_object_unref (default_statements), NULL)));
	(ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL)));
	(coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL)));
}


static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeWhileStatement* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_WHILE_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_while_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_while_statement_get_body (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_while_statement_get_condition (stmt)->temp_vars));
}


static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeDoStatement* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_DO_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_do_statement_get_body (stmt)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_do_statement_get_condition (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_do_statement_get_condition (stmt)->temp_vars));
}


static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeForStatement* cfor;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FOR_STATEMENT (stmt));
	cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_for_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_for_statement_get_body (stmt)))));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfor));
	{
		GeeCollection* init_expr_collection;
		GeeIterator* init_expr_it;
		init_expr_collection = vala_for_statement_get_initializer (stmt);
		init_expr_it = gee_iterable_iterator (GEE_ITERABLE (init_expr_collection));
		while (gee_iterator_next (init_expr_it)) {
			ValaExpression* init_expr;
			init_expr = gee_iterator_get (init_expr_it);
			{
				vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) init_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (init_expr->temp_vars));
				(init_expr == NULL ? NULL : (init_expr = (g_object_unref (init_expr), NULL)));
			}
		}
		(init_expr_collection == NULL ? NULL : (init_expr_collection = (g_object_unref (init_expr_collection), NULL)));
		(init_expr_it == NULL ? NULL : (init_expr_it = (g_object_unref (init_expr_it), NULL)));
	}
	{
		GeeCollection* it_expr_collection;
		GeeIterator* it_expr_it;
		it_expr_collection = vala_for_statement_get_iterator (stmt);
		it_expr_it = gee_iterable_iterator (GEE_ITERABLE (it_expr_collection));
		while (gee_iterator_next (it_expr_it)) {
			ValaExpression* it_expr;
			it_expr = gee_iterator_get (it_expr_it);
			{
				vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) it_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (it_expr->temp_vars));
				(it_expr == NULL ? NULL : (it_expr = (g_object_unref (it_expr), NULL)));
			}
		}
		(it_expr_collection == NULL ? NULL : (it_expr_collection = (g_object_unref (it_expr_collection), NULL)));
		(it_expr_it == NULL ? NULL : (it_expr_it = (g_object_unref (it_expr_it), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_for_statement_get_condition (stmt)->temp_vars));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
}


static void vala_code_generator_real_visit_begin_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (stmt));
	vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_variable_declarator (stmt)), TRUE);
	vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_collection_variable_declarator (stmt)), TRUE);
	if (vala_foreach_statement_get_iterator_variable_declarator (stmt) != NULL) {
		vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_iterator_variable_declarator (stmt)), TRUE);
	}
}


static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeBlock* cblock;
	ValaCCodeForStatement* cfor;
	ValaCCodeFragment* cfrag;
	ValaVariableDeclarator* _tmp0;
	ValaVariableDeclarator* collection_backup;
	char* _tmp1;
	ValaCCodeDeclaration* _tmp2;
	ValaCCodeDeclaration* ccoldecl;
	ValaCCodeVariableDeclarator* _tmp3;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (stmt));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cfor = NULL;
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (vala_foreach_statement_get_collection (stmt)->temp_vars));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
	_tmp0 = NULL;
	collection_backup = (_tmp0 = vala_foreach_statement_get_collection_variable_declarator (stmt), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccoldecl = (_tmp2 = vala_ccode_declaration_new ((_tmp1 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (collection_backup), FALSE, FALSE))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_declaration_add_declarator (ccoldecl, VALA_CCODE_DECLARATOR ((_tmp3 = vala_ccode_variable_declarator_new_with_initializer (vala_symbol_get_name (((ValaSymbol*) collection_backup)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_collection (stmt))))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (ccoldecl));
	if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) stmt)) && vala_expression_get_can_fail (vala_foreach_statement_get_collection (stmt))) {
		ValaCCodeFragment* cfrag;
		/* exception handling*/
		cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
		vala_code_generator_add_simple_check (self, VALA_CODE_NODE (vala_foreach_statement_get_collection (stmt)), cfrag);
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
		(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cblock));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))))) {
		ValaArray* _tmp4;
		ValaArray* arr;
		ValaCCodeExpression* array_len;
		_tmp4 = NULL;
		arr = (_tmp4 = VALA_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
		array_len = vala_code_generator_get_array_length_cexpression (self, vala_foreach_statement_get_collection (stmt), 1);
		/* the array has no length parameter i.e. is NULL-terminated array */
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name;
			char* _tmp5;
			ValaCCodeDeclaration* _tmp6;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp7;
			ValaCCodeBlock* cbody;
			char* _tmp8;
			ValaCCodeIdentifier* _tmp9;
			ValaCCodeExpression* element_expr;
			char* _tmp13;
			ValaCCodeDeclaration* _tmp14;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp15;
			ValaCCodeConstant* _tmp18;
			ValaCCodeIdentifier* _tmp17;
			char* _tmp16;
			ValaCCodeBinaryExpression* _tmp19;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp22;
			ValaCCodeIdentifier* _tmp21;
			ValaCCodeIdentifier* _tmp20;
			ValaCCodeAssignment* _tmp27;
			ValaCCodeBinaryExpression* _tmp26;
			ValaCCodeConstant* _tmp25;
			ValaCCodeIdentifier* _tmp24;
			ValaCCodeIdentifier* _tmp23;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp5 = NULL;
			_tmp6 = NULL;
			citdecl = (_tmp6 = vala_ccode_declaration_new ((_tmp5 = vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6);
			_tmp7 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp7 = vala_ccode_variable_declarator_new (it_name))));
			(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			_tmp8 = NULL;
			_tmp9 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ((_tmp8 = g_strdup_printf ("*%s", it_name))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9));
			if (vala_type_reference_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp10;
				ValaCCodeDeclaration* clendecl;
				ValaCCodeVariableDeclarator* _tmp12;
				char* _tmp11;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp10 = NULL;
				element_expr = (_tmp10 = vala_code_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp10);
				clendecl = vala_ccode_declaration_new ("int");
				_tmp12 = NULL;
				_tmp11 = NULL;
				vala_ccode_declaration_add_declarator (clendecl, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ((_tmp11 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) collection_backup)), 1)), array_len))));
				(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
				(_tmp11 = (g_free (_tmp11), NULL));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (clendecl));
				cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
				vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(clendecl == NULL ? NULL : (clendecl = (g_object_unref (clendecl), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp13 = NULL;
			_tmp14 = NULL;
			cdecl_ = (_tmp14 = vala_ccode_declaration_new ((_tmp13 = vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
			_tmp15 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp15 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_body (stmt))));
			_tmp18 = NULL;
			_tmp17 = NULL;
			_tmp16 = NULL;
			_tmp19 = NULL;
			ccond = (_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = g_strdup_printf ("*%s", it_name))))), VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("NULL")))), (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp19);
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp22 = NULL;
			_tmp21 = NULL;
			_tmp20 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
			(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
			_tmp27 = NULL;
			_tmp26 = NULL;
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
			(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
			(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp28;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp30;
			ValaCCodeIdentifier* _tmp29;
			ValaCCodeElementAccess* _tmp31;
			ValaCCodeExpression* element_expr;
			char* _tmp33;
			ValaCCodeDeclaration* _tmp34;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp35;
			ValaCCodeConstant* _tmp36;
			ValaCCodeBinaryExpression* _tmp37;
			ValaCCodeBinaryExpression* ccond_ind1;
			ValaCCodeIdentifier* _tmp38;
			ValaCCodeBinaryExpression* _tmp39;
			ValaCCodeBinaryExpression* ccond_ind2;
			ValaCCodeBinaryExpression* ccond_ind;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp57;
			ValaCCodeConstant* _tmp56;
			ValaCCodeIdentifier* _tmp55;
			ValaCCodeAssignment* _tmp62;
			ValaCCodeBinaryExpression* _tmp61;
			ValaCCodeConstant* _tmp60;
			ValaCCodeIdentifier* _tmp59;
			ValaCCodeIdentifier* _tmp58;
			/* the array has a length parameter */
			it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			citdecl = vala_ccode_declaration_new ("int");
			_tmp28 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp28 = vala_ccode_variable_declarator_new (it_name))));
			(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			_tmp30 = NULL;
			_tmp29 = NULL;
			_tmp31 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new (it_name)))), (_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), _tmp31));
			if (vala_type_reference_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp32;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp32 = NULL;
				element_expr = (_tmp32 = vala_code_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp32);
				cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
				vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp33 = NULL;
			_tmp34 = NULL;
			cdecl_ = (_tmp34 = vala_ccode_declaration_new ((_tmp33 = vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (_tmp33 = (g_free (_tmp33), NULL)), _tmp34);
			_tmp35 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp35 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_body (stmt))));
			_tmp36 = NULL;
			_tmp37 = NULL;
			ccond_ind1 = (_tmp37 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_constant_new ("-1")))), (_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL))), _tmp37);
			_tmp38 = NULL;
			_tmp39 = NULL;
			ccond_ind2 = (_tmp39 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new (it_name))), array_len), (_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL))), _tmp39);
			ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_ind1), VALA_CCODE_EXPRESSION (ccond_ind2));
			/* only check for null if the containers elements are of reference-type */
			ccond = NULL;
			if (vala_data_type_is_reference_type (vala_array_get_element_type (arr))) {
				ValaCCodeConstant* _tmp40;
				ValaCCodeBinaryExpression* _tmp41;
				ValaCCodeBinaryExpression* ccond_term1;
				ValaCCodeConstant* _tmp45;
				ValaCCodeElementAccess* _tmp44;
				ValaCCodeIdentifier* _tmp43;
				ValaCCodeIdentifier* _tmp42;
				ValaCCodeBinaryExpression* _tmp46;
				ValaCCodeBinaryExpression* ccond_term2;
				ValaCCodeBinaryExpression* ccond_term;
				ValaCCodeBinaryExpression* _tmp49;
				ValaCCodeParenthesizedExpression* _tmp48;
				ValaCCodeParenthesizedExpression* _tmp47;
				_tmp40 = NULL;
				_tmp41 = NULL;
				ccond_term1 = (_tmp41 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_constant_new ("-1")))), (_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL))), _tmp41);
				_tmp45 = NULL;
				_tmp44 = NULL;
				_tmp43 = NULL;
				_tmp42 = NULL;
				_tmp46 = NULL;
				ccond_term2 = (_tmp46 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new (it_name)))))), VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_constant_new ("NULL")))), (_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL))), (_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL))), (_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL))), (_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL))), _tmp46);
				ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_term1), VALA_CCODE_EXPRESSION (ccond_term2));
				_tmp49 = NULL;
				_tmp48 = NULL;
				_tmp47 = NULL;
				ccond = (_tmp49 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_ind)))), VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_term))))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), _tmp49);
				(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
				(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
				(ccond_term1 == NULL ? NULL : (ccond_term1 = (g_object_unref (ccond_term1), NULL)));
				(ccond_term2 == NULL ? NULL : (ccond_term2 = (g_object_unref (ccond_term2), NULL)));
				(ccond_term == NULL ? NULL : (ccond_term = (g_object_unref (ccond_term), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp50;
				ValaCCodeFunctionCall* _tmp51;
				ValaCCodeFunctionCall* cassert;
				ValaCCodeExpressionStatement* _tmp52;
				ValaCCodeBinaryExpression* _tmp54;
				ValaCCodeBinaryExpression* _tmp53;
				/* assert when trying to iterate over value-type arrays of unknown length */
				_tmp50 = NULL;
				_tmp51 = NULL;
				cassert = (_tmp51 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_identifier_new ("g_assert")))), (_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL))), _tmp51);
				vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (ccond_ind1));
				_tmp52 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp52 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)))));
				(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
				_tmp54 = NULL;
				_tmp53 = NULL;
				ccond = (_tmp54 = (_tmp53 = ccond_ind2, (_tmp53 == NULL ? NULL : g_object_ref (_tmp53))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), _tmp54);
				(cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL)));
			}
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp57 = NULL;
			_tmp56 = NULL;
			_tmp55 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
			(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
			(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
			_tmp62 = NULL;
			_tmp61 = NULL;
			_tmp60 = NULL;
			_tmp59 = NULL;
			_tmp58 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
			(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
			(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
			(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
			(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond_ind1 == NULL ? NULL : (ccond_ind1 = (g_object_unref (ccond_ind1), NULL)));
			(ccond_ind2 == NULL ? NULL : (ccond_ind2 = (g_object_unref (ccond_ind2), NULL)));
			(ccond_ind == NULL ? NULL : (ccond_ind = (g_object_unref (ccond_ind), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		(array_len = (g_object_unref (array_len), NULL));
	} else {
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->glist_type || vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->gslist_type) {
			char* it_name;
			char* _tmp63;
			ValaCCodeDeclaration* _tmp64;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp65;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp66;
			ValaCCodeMemberAccess* _tmp67;
			ValaCCodeExpression* element_expr;
			ValaCCodeExpression* _tmp68;
			char* _tmp70;
			ValaCCodeDeclaration* _tmp71;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp72;
			ValaCCodeConstant* _tmp74;
			ValaCCodeIdentifier* _tmp73;
			ValaCCodeBinaryExpression* _tmp75;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp78;
			ValaCCodeIdentifier* _tmp77;
			ValaCCodeIdentifier* _tmp76;
			ValaCCodeAssignment* _tmp82;
			ValaCCodeMemberAccess* _tmp81;
			ValaCCodeIdentifier* _tmp80;
			ValaCCodeIdentifier* _tmp79;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp63 = NULL;
			_tmp64 = NULL;
			citdecl = (_tmp64 = vala_ccode_declaration_new ((_tmp63 = vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE))), (_tmp63 = (g_free (_tmp63), NULL)), _tmp64);
			_tmp65 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp65 = vala_ccode_variable_declarator_new (it_name))));
			(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			_tmp66 = NULL;
			_tmp67 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new (it_name))), "data"), (_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL))), _tmp67));
			_tmp68 = NULL;
			element_expr = (_tmp68 = vala_code_generator_convert_from_generic_pointer (self, element_expr, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp68);
			if (vala_type_reference_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp69;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp69 = NULL;
				element_expr = (_tmp69 = vala_code_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp69);
				cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
				vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp70 = NULL;
			_tmp71 = NULL;
			cdecl_ = (_tmp71 = vala_ccode_declaration_new ((_tmp70 = vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (_tmp70 = (g_free (_tmp70), NULL)), _tmp71);
			_tmp72 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp72 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_body (stmt))));
			_tmp74 = NULL;
			_tmp73 = NULL;
			_tmp75 = NULL;
			ccond = (_tmp75 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_constant_new ("NULL")))), (_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL))), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), _tmp75);
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp78 = NULL;
			_tmp77 = NULL;
			_tmp76 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
			(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
			(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
			_tmp82 = NULL;
			_tmp81 = NULL;
			_tmp80 = NULL;
			_tmp79 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new (it_name))), "next"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
			(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
			(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
			(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->iterable_type || vala_data_type_is_subtype_of (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))), self->priv->iterable_type)) {
				char* it_name;
				char* _tmp84;
				char* _tmp83;
				ValaCCodeDeclaration* _tmp85;
				ValaCCodeDeclaration* citdecl;
				ValaMethod* it_method;
				ValaCCodeIdentifier* _tmp87;
				char* _tmp86;
				ValaCCodeFunctionCall* _tmp88;
				ValaCCodeFunctionCall* it_ccall;
				ValaInstanceCast* _tmp90;
				ValaCCodeIdentifier* _tmp89;
				ValaCCodeVariableDeclarator* _tmp91;
				ValaCCodeBlock* cbody;
				ValaMethod* get_method;
				ValaCCodeIdentifier* _tmp93;
				char* _tmp92;
				ValaCCodeFunctionCall* _tmp94;
				ValaCCodeFunctionCall* get_ccall;
				ValaCCodeIdentifier* _tmp95;
				ValaCCodeFunctionCall* _tmp96;
				ValaCCodeExpression* element_expr;
				ValaCCodeExpression* _tmp97;
				GeeList* _tmp98;
				GeeIterator* _tmp99;
				GeeIterator* type_arg_it;
				ValaTypeReference* _tmp100;
				ValaTypeReference* _tmp101;
				ValaTypeReference* it_type;
				char* _tmp103;
				ValaCCodeDeclaration* _tmp104;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp105;
				ValaMethod* next_method;
				ValaCCodeIdentifier* _tmp107;
				char* _tmp106;
				ValaCCodeFunctionCall* _tmp108;
				ValaCCodeFunctionCall* next_ccall;
				ValaCCodeIdentifier* _tmp109;
				ValaCCodeWhileStatement* _tmp110;
				it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
				_tmp84 = NULL;
				_tmp83 = NULL;
				_tmp85 = NULL;
				citdecl = (_tmp85 = vala_ccode_declaration_new ((_tmp84 = g_strconcat ((_tmp83 = vala_data_type_get_cname (self->priv->iterator_type, FALSE)), "*", NULL))), (_tmp84 = (g_free (_tmp84), NULL)), (_tmp83 = (g_free (_tmp83), NULL)), _tmp85);
				it_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) self->priv->iterable_type)), "iterator"));
				_tmp87 = NULL;
				_tmp86 = NULL;
				_tmp88 = NULL;
				it_ccall = (_tmp88 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_identifier_new ((_tmp86 = vala_method_get_cname (it_method)))))), (_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL))), (_tmp86 = (g_free (_tmp86), NULL)), _tmp88);
				_tmp90 = NULL;
				_tmp89 = NULL;
				vala_ccode_function_call_add_argument (it_ccall, VALA_CCODE_EXPRESSION ((_tmp90 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) collection_backup))))), self->priv->iterable_type))));
				(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
				(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
				_tmp91 = NULL;
				vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp91 = vala_ccode_variable_declarator_new_with_initializer (it_name, VALA_CCODE_EXPRESSION (it_ccall)))));
				(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
				cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
				get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) self->priv->iterator_type)), "get"));
				_tmp93 = NULL;
				_tmp92 = NULL;
				_tmp94 = NULL;
				get_ccall = (_tmp94 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_identifier_new ((_tmp92 = vala_method_get_cname (get_method)))))), (_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL))), (_tmp92 = (g_free (_tmp92), NULL)), _tmp94);
				_tmp95 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new (it_name))));
				(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
				_tmp96 = NULL;
				element_expr = VALA_CCODE_EXPRESSION ((_tmp96 = get_ccall, (_tmp96 == NULL ? NULL : g_object_ref (_tmp96))));
				_tmp97 = NULL;
				element_expr = (_tmp97 = vala_code_generator_convert_from_generic_pointer (self, element_expr, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp97);
				_tmp98 = NULL;
				_tmp99 = NULL;
				type_arg_it = (_tmp99 = gee_iterable_iterator (GEE_ITERABLE ((_tmp98 = vala_type_reference_get_type_arguments (vala_method_get_return_type (it_method))))), (_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL))), _tmp99);
				gee_iterator_next (type_arg_it);
				_tmp100 = NULL;
				_tmp101 = NULL;
				it_type = (_tmp101 = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), VALA_SYMBOL (it_method), (_tmp100 = gee_iterator_get (type_arg_it)), VALA_CODE_NODE (stmt)), (_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL))), _tmp101);
				if (vala_type_reference_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt)) && !vala_type_reference_get_takes_ownership (it_type)) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp102;
					ValaCCodeFragment* cfrag;
					ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
					vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
					_tmp102 = NULL;
					element_expr = (_tmp102 = vala_code_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp102);
					cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
					vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
					vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
					gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
				}
				_tmp103 = NULL;
				_tmp104 = NULL;
				cdecl_ = (_tmp104 = vala_ccode_declaration_new ((_tmp103 = vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (_tmp103 = (g_free (_tmp103), NULL)), _tmp104);
				_tmp105 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp105 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
				(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
				vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_foreach_statement_get_body (stmt))));
				next_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) self->priv->iterator_type)), "next"));
				_tmp107 = NULL;
				_tmp106 = NULL;
				_tmp108 = NULL;
				next_ccall = (_tmp108 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_identifier_new ((_tmp106 = vala_method_get_cname (next_method)))))), (_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL))), (_tmp106 = (g_free (_tmp106), NULL)), _tmp108);
				_tmp109 = NULL;
				vala_ccode_function_call_add_argument (next_ccall, VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_identifier_new (it_name))));
				(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
				_tmp110 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp110 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (next_ccall), VALA_CCODE_STATEMENT (cbody)))));
				(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
				(it_name = (g_free (it_name), NULL));
				(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
				(it_method == NULL ? NULL : (it_method = (g_object_unref (it_method), NULL)));
				(it_ccall == NULL ? NULL : (it_ccall = (g_object_unref (it_ccall), NULL)));
				(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
				(get_method == NULL ? NULL : (get_method = (g_object_unref (get_method), NULL)));
				(get_ccall == NULL ? NULL : (get_ccall = (g_object_unref (get_ccall), NULL)));
				(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
				(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
				(it_type == NULL ? NULL : (it_type = (g_object_unref (it_type), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(next_method == NULL ? NULL : (next_method = (g_object_unref (next_method), NULL)));
				(next_ccall == NULL ? NULL : (next_ccall = (g_object_unref (next_ccall), NULL)));
			}
		}
	}
	if (vala_code_generator_get_memory_management (self)) {
		{
			GeeCollection* decl_collection;
			GeeIterator* decl_it;
			decl_collection = vala_block_get_local_variables (VALA_BLOCK (stmt));
			decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
			while (gee_iterator_next (decl_it)) {
				ValaVariableDeclarator* decl;
				decl = gee_iterator_get (decl_it);
				{
					if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
						ValaMemberAccess* ma;
						ValaCCodeExpressionStatement* _tmp114;
						ValaCCodeExpression* _tmp113;
						ValaCCodeIdentifier* _tmp112;
						char* _tmp111;
						ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
						vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
						_tmp114 = NULL;
						_tmp113 = NULL;
						_tmp112 = NULL;
						_tmp111 = NULL;
						vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp114 = vala_ccode_expression_statement_new ((_tmp113 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp112 = vala_ccode_identifier_new ((_tmp111 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
						(_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL)));
						(_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL)));
						(_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL)));
						(_tmp111 = (g_free (_tmp111), NULL));
						(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					}
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				}
			}
			(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
			(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
		}
	}
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(collection_backup == NULL ? NULL : (collection_backup = (g_object_unref (collection_backup), NULL)));
	(ccoldecl == NULL ? NULL : (ccoldecl = (g_object_unref (ccoldecl), NULL)));
}


static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeBreakStatement* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BREAK_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_code_generator_create_local_free (self, VALA_CODE_NODE (stmt), TRUE);
}


static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeContinueStatement* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CONTINUE_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = g_object_new (VALA_TYPE_CCODE_CONTINUE_STATEMENT, NULL))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_code_generator_create_local_free (self, VALA_CODE_NODE (stmt), TRUE);
}


static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop)
{
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeCollection* local_vars;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (sym == NULL || VALA_IS_SYMBOL (sym));
	g_return_if_fail (cfrag == NULL || VALA_IS_CCODE_FRAGMENT (cfrag));
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_symbol_get_active (((ValaSymbol*) decl)) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp4;
					ValaCCodeExpression* _tmp3;
					ValaCCodeIdentifier* _tmp2;
					char* _tmp1;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					_tmp4 = NULL;
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp4 = vala_ccode_expression_statement_new ((_tmp3 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
					(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					(_tmp1 = (g_free (_tmp1), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	if (stop_at_loop) {
		if (VALA_IS_DO_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b))) || VALA_IS_WHILE_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b))) || VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b))) || VALA_IS_FOREACH_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b))) || VALA_IS_SWITCH_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) b)))) {
			(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
			(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
			return;
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_code_generator_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	}
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
}


static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaCodeNode* stmt, gboolean stop_at_loop)
{
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (stmt == NULL || VALA_IS_CODE_NODE (stmt));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_local_free (self, self->priv->current_symbol, cfrag, stop_at_loop);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (stmt));
	vala_code_node_set_ccodenode (stmt, VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop)
{
	gboolean found;
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeCollection* local_vars;
	gboolean _tmp4;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), FALSE);
	g_return_val_if_fail (ccomma == NULL || VALA_IS_CCODE_COMMA_EXPRESSION (ccomma), FALSE);
	found = FALSE;
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_symbol_get_active (((ValaSymbol*) decl)) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp3;
					ValaCCodeIdentifier* _tmp2;
					char* _tmp1;
					found = TRUE;
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (_tmp3 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					(_tmp1 = (g_free (_tmp1), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		found = vala_code_generator_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop) || found;
	}
	return (_tmp4 = found, (b == NULL ? NULL : (b = (g_object_unref (b), NULL))), (local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL))), _tmp4);
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
}


static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaVariableDeclarator* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeIdentifier* _tmp2;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	return_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) return_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	if (!vala_code_generator_append_local_free_expr (self, self->priv->current_symbol, ccomma, FALSE)) {
		(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		return;
	}
	/* no local variables need to be freed */
	_tmp2 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) return_expr_decl))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
	gee_collection_add (GEE_COLLECTION (expr->temp_vars), return_expr_decl);
	(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
}


static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)) && VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))) {
			ValaVariableDeclarator* _tmp0;
			ValaVariableDeclarator* decl;
			_tmp0 = NULL;
			decl = (_tmp0 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership */
				vala_expression_set_ref_sink (vala_return_statement_get_return_expression (stmt), TRUE);
				/* don't ref expression*/
				vala_expression_set_ref_missing (vala_return_statement_get_return_expression (stmt), FALSE);
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_return_statement_new (NULL))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		vala_code_generator_create_local_free (self, VALA_CODE_NODE (stmt), FALSE);
	} else {
		ValaSymbol* return_expression_symbol;
		ValaCCodeReturnStatement* _tmp13;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)) && VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))) {
			ValaVariableDeclarator* _tmp1;
			ValaVariableDeclarator* decl;
			_tmp1 = NULL;
			decl = (_tmp1 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				ValaSymbol* _tmp3;
				ValaVariableDeclarator* _tmp2;
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership 
				 don't unref expression*/
				_tmp3 = NULL;
				_tmp2 = NULL;
				return_expression_symbol = (_tmp3 = VALA_SYMBOL ((_tmp2 = decl, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)))), (return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL))), _tmp3);
				vala_symbol_set_active (return_expression_symbol, FALSE);
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
		/* return array length if appropriate*/
		if (self->priv->current_method != NULL && !vala_method_get_no_array_length (self->priv->current_method) && VALA_IS_ARRAY (vala_type_reference_get_data_type (self->priv->current_return_type))) {
			ValaVariableDeclarator* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp5;
			ValaCCodeIdentifier* _tmp4;
			ValaArray* _tmp6;
			ValaArray* arr;
			ValaCCodeIdentifier* _tmp11;
			return_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)), TRUE);
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			_tmp5 = NULL;
			_tmp4 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) return_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_return_statement_get_return_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
			_tmp6 = NULL;
			arr = (_tmp6 = VALA_ARRAY (vala_type_reference_get_data_type (self->priv->current_return_type)), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeIdentifier* _tmp8;
					char* _tmp7;
					ValaCCodeUnaryExpression* _tmp9;
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* _tmp10;
					_tmp8 = NULL;
					_tmp7 = NULL;
					_tmp9 = NULL;
					len_l = (_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = vala_code_generator_get_array_length_cname (self, "result", dim)))))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
					len_r = vala_code_generator_get_array_length_cexpression (self, vala_return_statement_get_return_expression (stmt), dim);
					_tmp10 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (len_l), len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
					(len_l == NULL ? NULL : (len_l = (g_object_unref (len_l), NULL)));
					(len_r = (g_object_unref (len_r), NULL));
				}
			}
			_tmp11 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) return_expr_decl))))));
			(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE (ccomma));
			gee_collection_add (GEE_COLLECTION (vala_return_statement_get_return_expression (stmt)->temp_vars), return_expr_decl);
			(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_code_generator_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		if (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt))) != vala_type_reference_get_data_type (self->priv->current_return_type)) {
			/* cast required */
			if ((VALA_IS_CLASS (vala_type_reference_get_data_type (self->priv->current_return_type)) && vala_data_type_is_subtype_of (VALA_DATA_TYPE ((VALA_CLASS (vala_type_reference_get_data_type (self->priv->current_return_type)))), self->priv->gobject_type)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (self->priv->current_return_type))) {
				ValaInstanceCast* _tmp12;
				_tmp12 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE ((_tmp12 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_return_statement_get_return_expression (stmt)))), vala_type_reference_get_data_type (self->priv->current_return_type)))));
				(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
			}
		}
		_tmp13 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp13 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))))))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_return_statement_get_return_expression (stmt)->temp_vars));
		if (return_expression_symbol != NULL) {
			vala_symbol_set_active (return_expression_symbol, TRUE);
		}
		(return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL)));
	}
}


static void vala_code_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeExpressionStatement* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_THROW_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	if (vala_code_generator_get_memory_management (self)) {
		/* declare temporary objects */
		vala_code_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->priv->temp_vars));
	}
	_tmp0 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_throw_statement_get_error_expression (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	if (vala_code_generator_get_memory_management (self)) {
		{
			GeeArrayList* decl_collection;
			GeeIterator* decl_it;
			decl_collection = self->priv->temp_ref_vars;
			decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
			while (gee_iterator_next (decl_it)) {
				ValaVariableDeclarator* decl;
				decl = gee_iterator_get (decl_it);
				{
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp3;
					ValaCCodeExpression* _tmp2;
					ValaCCodeIdentifier* _tmp1;
					/* free temporary objects */
					ma = vala_member_access_new_simple (vala_symbol_get_name (((ValaSymbol*) decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp3 = vala_ccode_expression_statement_new ((_tmp2 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) decl))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
			}
			(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
		}
	}
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
	if (self->priv->current_return_type != NULL && vala_type_reference_get_data_type (self->priv->current_return_type) != NULL) {
		ValaCCodeReturnStatement* _tmp5;
		ValaCCodeExpression* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp5 = vala_ccode_return_statement_new ((_tmp4 = vala_code_generator_default_value_for_type (self, vala_type_reference_get_data_type (self->priv->current_return_type)))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	} else {
		ValaCCodeReturnStatement* _tmp6;
		_tmp6 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp6 = vala_ccode_return_statement_new (NULL))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaTryStatement* _tmp0;
	ValaTryStatement* old_try;
	gint old_try_id;
	ValaTryStatement* _tmp1;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp5;
	char* _tmp4;
	ValaTryStatement* _tmp8;
	ValaTryStatement* _tmp7;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_TRY_STATEMENT (stmt));
	_tmp0 = NULL;
	old_try = (_tmp0 = self->priv->current_try, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	old_try_id = self->priv->current_try_id;
	_tmp1 = NULL;
	self->priv->current_try = (_tmp1 = g_object_ref (stmt), (self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL))), _tmp1);
	self->priv->current_try_id = self->priv->next_try_id++;
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_try_statement_get_body (stmt))));
	{
		GeeCollection* clause_collection;
		GeeIterator* clause_it;
		clause_collection = vala_try_statement_get_catch_clauses (stmt);
		clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
		while (gee_iterator_next (clause_it)) {
			ValaCatchClause* clause;
			clause = gee_iterator_get (clause_it);
			{
				ValaCCodeGotoStatement* _tmp3;
				char* _tmp2;
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp3 = vala_ccode_goto_statement_new ((_tmp2 = g_strdup_printf ("__finally%d", self->priv->current_try_id))))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 = (g_free (_tmp2), NULL));
				vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) clause)));
				(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
			}
		}
		(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
		(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp5 = vala_ccode_label_new ((_tmp4 = g_strdup_printf ("__finally%d", self->priv->current_try_id))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_try_statement_get_finally_body (stmt))));
	} else {
		ValaCCodeEmptyStatement* _tmp6;
		/* avoid gcc error: label at end of compound statement*/
		_tmp6 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp6 = g_object_new (VALA_TYPE_CCODE_EMPTY_STATEMENT, NULL))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	_tmp8 = NULL;
	_tmp7 = NULL;
	self->priv->current_try = (_tmp8 = (_tmp7 = old_try, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL))), _tmp8);
	self->priv->current_try_id = old_try_id;
	(old_try == NULL ? NULL : (old_try = (g_object_unref (old_try), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeExpressionStatement* _tmp8;
	ValaCCodeAssignment* _tmp7;
	ValaCCodeConstant* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (clause));
	vala_code_node_accept_children (VALA_CODE_NODE (clause), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp2 = vala_ccode_label_new ((_tmp1 = g_strdup_printf ("__catch%d_%s", self->priv->current_try_id, (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause))), NULL))))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	(_tmp1 = (g_free (_tmp1), NULL));
	(_tmp0 = (g_free (_tmp0), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GError *");
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp4 = vala_ccode_variable_declarator_new_with_initializer (vala_catch_clause_get_variable_name (clause), VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("inner_error")))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp8 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_catch_clause_get_body (clause))));
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cblock));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (clause), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
}


static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


/**
 * Visit operation called for lock statements.
 *
 * @param stmt a lock statement
 */
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* _tmp0;
	ValaExpression* inner_node;
	ValaCCodeExpression* _tmp9;
	char* _tmp8;
	ValaCCodeMemberAccess* _tmp7;
	ValaCCodeFunctionCall* _tmp13;
	ValaCCodeIdentifier* _tmp12;
	char* _tmp11;
	ValaMethod* _tmp10;
	ValaCCodeExpressionStatement* _tmp14;
	ValaCCodeFunctionCall* _tmp18;
	ValaCCodeIdentifier* _tmp17;
	char* _tmp16;
	ValaMethod* _tmp15;
	ValaCCodeExpressionStatement* _tmp19;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (stmt));
	cn = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	l = NULL;
	fc = NULL;
	_tmp0 = NULL;
	inner_node = (_tmp0 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (inner_node == NULL) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		l = (_tmp1 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp1);
	} else {
		if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != self->priv->current_type_symbol) {
			ValaCCodeExpression* _tmp4;
			ValaCCodeIdentifier* _tmp3;
			char* _tmp2;
			_tmp4 = NULL;
			_tmp3 = NULL;
			_tmp2 = NULL;
			l = (_tmp4 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), NULL))))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp4);
			(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
			(_tmp2 = (g_free (_tmp2), NULL));
			vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (l)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) inner_node))));
		} else {
			ValaCCodeExpression* _tmp6;
			ValaCCodeExpression* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			l = (_tmp6 = (_tmp5 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) inner_node))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp6);
		}
	}
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	l = (_tmp9 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_member_access_new_pointer (l, "priv"))), (_tmp8 = vala_code_generator_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp9);
	(_tmp8 = (g_free (_tmp8), NULL));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp10 = NULL;
	fc = (_tmp13 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ((_tmp11 = vala_method_get_cname ((_tmp10 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) vala_type_reference_get_data_type (self->priv->mutex_type))), "lock")))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp13);
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	(_tmp11 = (g_free (_tmp11), NULL));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	_tmp14 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((_tmp14 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_lock_statement_get_body (stmt))));
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	fc = (_tmp18 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_method_get_cname ((_tmp15 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) vala_type_reference_get_data_type (self->priv->mutex_type))), "unlock")))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp18);
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	(_tmp16 = (g_free (_tmp16), NULL));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	_tmp19 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cn));
	(cn == NULL ? NULL : (cn = (g_object_unref (cn), NULL)));
	(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(inner_node == NULL ? NULL : (inner_node = (g_object_unref (inner_node), NULL)));
}


/**
 * Visit operations called for array creation expresions.
 *
 * @param expr an array creation expression
 */
static void vala_code_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* gnew;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	gboolean first;
	ValaCCodeExpression* cexpr;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (expr));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	_tmp1 = NULL;
	gnew = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_new0")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (gnew, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_type_reference_get_cname (vala_array_creation_expression_get_element_type (expr), FALSE, FALSE))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	(_tmp2 = (g_free (_tmp2), NULL));
	first = TRUE;
	cexpr = NULL;
	{
		GeeList* size_collection;
		GeeIterator* size_it;
		size_collection = vala_array_creation_expression_get_sizes (expr);
		size_it = gee_iterable_iterator (GEE_ITERABLE (size_collection));
		while (gee_iterator_next (size_it)) {
			ValaExpression* size;
			size = gee_iterator_get (size_it);
			{
				ValaCCodeExpression* csize;
				csize = NULL;
				if (vala_type_reference_get_data_type (vala_array_creation_expression_get_element_type (expr)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_array_creation_expression_get_element_type (expr)))) {
					ValaCCodeExpression* _tmp5;
					ValaCCodeConstant* _tmp4;
					/* add extra item to have array NULL-terminated for all reference types*/
					_tmp5 = NULL;
					_tmp4 = NULL;
					csize = (_tmp5 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) size))), VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("1"))))), (csize == NULL ? NULL : (csize = (g_object_unref (csize), NULL))), _tmp5);
					(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
				} else {
					ValaCCodeExpression* _tmp7;
					ValaCCodeExpression* _tmp6;
					_tmp7 = NULL;
					_tmp6 = NULL;
					csize = (_tmp7 = (_tmp6 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) size))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (csize == NULL ? NULL : (csize = (g_object_unref (csize), NULL))), _tmp7);
				}
				if (first) {
					ValaCCodeExpression* _tmp9;
					ValaCCodeExpression* _tmp8;
					_tmp9 = NULL;
					_tmp8 = NULL;
					cexpr = (_tmp9 = (_tmp8 = csize, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp9);
					first = FALSE;
				} else {
					ValaCCodeExpression* _tmp10;
					_tmp10 = NULL;
					cexpr = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, csize)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp10);
				}
				(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
				(csize == NULL ? NULL : (csize = (g_object_unref (csize), NULL)));
			}
		}
		(size_collection == NULL ? NULL : (size_collection = (g_object_unref (size_collection), NULL)));
		(size_it == NULL ? NULL : (size_it = (g_object_unref (size_it), NULL)));
	}
	vala_ccode_function_call_add_argument (gnew, cexpr);
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaVariableDeclarator* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		ValaCCodeAssignment* _tmp11;
		/* FIXME rank > 1 not supported yet*/
		if (vala_array_creation_expression_get_rank (expr) > 1) {
			vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), "Creating arrays with rank greater than 1 with initializers is not supported yet");
		}
		ce = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		temp_var = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (((ValaExpression*) expr)), TRUE);
		name_cnode = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_var)));
		i = 0;
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_var);
		_tmp11 = NULL;
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (gnew), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		{
			GeeCollection* e_collection;
			GeeIterator* e_it;
			e_collection = vala_initializer_list_get_initializers (vala_array_creation_expression_get_initializer_list (expr));
			e_it = gee_iterable_iterator (GEE_ITERABLE (e_collection));
			while (gee_iterator_next (e_it)) {
				ValaExpression* e;
				e = gee_iterator_get (e_it);
				{
					ValaCCodeAssignment* _tmp15;
					ValaCCodeElementAccess* _tmp14;
					ValaCCodeConstant* _tmp13;
					char* _tmp12;
					_tmp15 = NULL;
					_tmp14 = NULL;
					_tmp13 = NULL;
					_tmp12 = NULL;
					vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ((_tmp12 = g_strdup_printf ("%i", i)))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) e))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
					(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
					(_tmp12 = (g_free (_tmp12), NULL));
					i++;
					(e == NULL ? NULL : (e = (g_object_unref (e), NULL)));
				}
			}
			(e_collection == NULL ? NULL : (e_collection = (g_object_unref (e_collection), NULL)));
			(e_it == NULL ? NULL : (e_it = (g_object_unref (e_it), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION (name_cnode));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ce));
		(ce == NULL ? NULL : (ce = (g_object_unref (ce), NULL)));
		(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
		(name_cnode == NULL ? NULL : (name_cnode = (g_object_unref (name_cnode), NULL)));
	} else {
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (gnew));
	}
	(gnew == NULL ? NULL : (gnew = (g_object_unref (gnew), NULL)));
	(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
}


static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BOOLEAN_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new ((vala_boolean_literal_get_value (expr) ? "TRUE" : "FALSE")))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CHARACTER_LITERAL (expr));
	if (vala_character_literal_get_char (expr) >= 0x20 && vala_character_literal_get_char (expr) < 0x80) {
		ValaCCodeConstant* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_character_literal_get_value (expr)))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeConstant* _tmp2;
		char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp2 = vala_ccode_constant_new ((_tmp1 = g_strdup_printf ("%uU", vala_character_literal_get_char (expr)))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		(_tmp1 = (g_free (_tmp1), NULL));
	}
}


static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_INTEGER_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_integer_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_REAL_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_real_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_STRING_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_string_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_NULL_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new ("NULL"))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_LITERAL_EXPRESSION (expr));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), vala_code_node_get_ccodenode (((ValaCodeNode*) vala_literal_expression_get_literal (expr))));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeParenthesizedExpression* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_parenthesized_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim)
{
	gboolean is_out;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (array_expr), NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* _tmp0;
		ValaUnaryExpression* unary_expr;
		_tmp0 = NULL;
		unary_expr = (_tmp0 = VALA_UNARY_EXPRESSION (array_expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	} else {
		if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (array_expr)) {
			ValaReferenceTransferExpression* _tmp1;
			ValaReferenceTransferExpression* reftransfer_expr;
			_tmp1 = NULL;
			reftransfer_expr = (_tmp1 = VALA_REFERENCE_TRANSFER_EXPRESSION (array_expr), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			array_expr = vala_reference_transfer_expression_get_inner (reftransfer_expr);
			(reftransfer_expr == NULL ? NULL : (reftransfer_expr = (g_object_unref (reftransfer_expr), NULL)));
		}
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GeeList* size;
		ValaExpression* length_expr;
		ValaCCodeExpression* _tmp2;
		ValaCCodeExpression* _tmp3;
		size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		length_expr = gee_list_get (((GeeList*) size), dim - 1);
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) length_expr))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp3);
		(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
		(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
	} else {
		if (VALA_IS_INVOCATION_EXPRESSION (array_expr)) {
			ValaInvocationExpression* _tmp4;
			ValaInvocationExpression* invocation_expr;
			GeeList* size;
			ValaCCodeExpression* _tmp5;
			_tmp4 = NULL;
			invocation_expr = (_tmp4 = VALA_INVOCATION_EXPRESSION (array_expr), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
			size = vala_invocation_expression_get_array_sizes (invocation_expr);
			_tmp5 = NULL;
			return (_tmp5 = gee_list_get (((GeeList*) size), dim - 1), (invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL))), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), _tmp5);
			(invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL)));
			(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr))) {
					ValaFormalParameter* _tmp6;
					ValaFormalParameter* param;
					_tmp6 = NULL;
					param = (_tmp6 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr)), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
					if (!vala_formal_parameter_get_no_array_length (param)) {
						char* _tmp7;
						ValaCCodeIdentifier* _tmp8;
						ValaCCodeIdentifier* length_expr;
						_tmp7 = NULL;
						_tmp8 = NULL;
						length_expr = (_tmp8 = vala_ccode_identifier_new ((_tmp7 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) param)), dim))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
						if (is_out) {
							ValaCCodeUnaryExpression* _tmp9;
							_tmp9 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp9));
						} else {
							ValaCCodeIdentifier* _tmp10;
							_tmp10 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp10 = length_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp10));
						}
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					if (VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (array_expr))) {
						ValaVariableDeclarator* _tmp11;
						ValaVariableDeclarator* decl;
						char* _tmp12;
						ValaCCodeIdentifier* _tmp13;
						ValaCCodeIdentifier* length_expr;
						_tmp11 = NULL;
						decl = (_tmp11 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (array_expr)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
						_tmp12 = NULL;
						_tmp13 = NULL;
						length_expr = (_tmp13 = vala_ccode_identifier_new ((_tmp12 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) decl)), dim))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13);
						if (is_out) {
							ValaCCodeUnaryExpression* _tmp14;
							_tmp14 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp14));
						} else {
							ValaCCodeIdentifier* _tmp15;
							_tmp15 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp15 = length_expr, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), _tmp15));
						}
						(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
							ValaField* _tmp16;
							ValaField* field;
							_tmp16 = NULL;
							field = (_tmp16 = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
							if (!vala_field_get_no_array_length (field)) {
								char* length_cname;
								ValaMemberAccess* _tmp17;
								ValaMemberAccess* ma;
								ValaCCodeExpression* pub_inst;
								ValaDataType* base_type;
								ValaCCodeExpression* length_expr;
								length_cname = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) field)), dim);
								_tmp17 = NULL;
								ma = (_tmp17 = VALA_MEMBER_ACCESS (array_expr), (_tmp17 == NULL ? NULL : g_object_ref (_tmp17)));
								pub_inst = NULL;
								base_type = NULL;
								length_expr = NULL;
								if (vala_member_access_get_inner (ma) == NULL) {
									ValaCCodeExpression* _tmp18;
									_tmp18 = NULL;
									pub_inst = (_tmp18 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp18);
									if (self->priv->current_type_symbol != NULL) {
										ValaDataType* _tmp20;
										ValaDataType* _tmp19;
										/* base type is available if this is a type method */
										_tmp20 = NULL;
										_tmp19 = NULL;
										base_type = (_tmp20 = (_tmp19 = VALA_DATA_TYPE (self->priv->current_type_symbol), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp20);
									}
								} else {
									ValaCCodeExpression* _tmp22;
									ValaCCodeExpression* _tmp21;
									_tmp22 = NULL;
									_tmp21 = NULL;
									pub_inst = (_tmp22 = (_tmp21 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp22);
									if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
										ValaDataType* _tmp24;
										ValaDataType* _tmp23;
										_tmp24 = NULL;
										_tmp23 = NULL;
										base_type = (_tmp24 = (_tmp23 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp24);
									}
								}
								if (vala_field_get_instance (field)) {
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									typed_inst = NULL;
									if (vala_symbol_get_parent_symbol (((ValaSymbol*) field)) != VALA_SYMBOL (base_type)) {
										ValaCCodeExpression* _tmp27;
										ValaCCodeIdentifier* _tmp26;
										char* _tmp25;
										/* FIXME: use C cast if debugging disabled*/
										_tmp27 = NULL;
										_tmp26 = NULL;
										_tmp25 = NULL;
										typed_inst = (_tmp27 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ((_tmp25 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) field)))), NULL))))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), _tmp27);
										(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
										(_tmp25 = (g_free (_tmp25), NULL));
										vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
									} else {
										ValaCCodeExpression* _tmp29;
										ValaCCodeExpression* _tmp28;
										_tmp29 = NULL;
										_tmp28 = NULL;
										typed_inst = (_tmp29 = (_tmp28 = pub_inst, (_tmp28 == NULL ? NULL : g_object_ref (_tmp28))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), _tmp29);
									}
									inst = NULL;
									if (vala_symbol_get_access (((ValaSymbol*) field)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
										ValaCCodeExpression* _tmp30;
										_tmp30 = NULL;
										inst = (_tmp30 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp30);
									} else {
										ValaCCodeExpression* _tmp32;
										ValaCCodeExpression* _tmp31;
										_tmp32 = NULL;
										_tmp31 = NULL;
										inst = (_tmp32 = (_tmp31 = typed_inst, (_tmp31 == NULL ? NULL : g_object_ref (_tmp31))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp32);
									}
									if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) field)))))) {
										ValaCCodeExpression* _tmp33;
										_tmp33 = NULL;
										length_expr = (_tmp33 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp33);
									} else {
										ValaCCodeExpression* _tmp34;
										_tmp34 = NULL;
										length_expr = (_tmp34 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, length_cname, FALSE)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp34);
									}
									(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
									(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
								} else {
									ValaCCodeExpression* _tmp35;
									_tmp35 = NULL;
									length_expr = (_tmp35 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp35);
								}
								if (is_out) {
									ValaCCodeUnaryExpression* _tmp36;
									_tmp36 = NULL;
									return VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), _tmp36));
								} else {
									ValaCCodeExpression* _tmp37;
									_tmp37 = NULL;
									return (_tmp37 = length_expr, (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), _tmp37);
								}
								(length_cname = (g_free (length_cname), NULL));
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
								(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
								(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
								(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
							}
							(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
						}
					}
				}
			}
		}
	}
	if (!is_out) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1"));
	} else {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
}


/* allow arrays with unknown length even for value types
 * as else it may be impossible to bind some libraries
 * users of affected libraries should explicitly set
 * the array length as early as possible
 * by setting the virtual length field of the array
 */
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr)
{
	ValaCodeGenerator * self;
	GeeList* indices;
	gint rank;
	ValaDataType* _tmp0;
	ValaDataType* container_type;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp3;
	ValaExpression* _tmp2;
	ValaCCodeExpression* _tmp4;
	ValaCCodeExpression* cindex;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (expr));
	indices = vala_element_access_get_indices (expr);
	rank = gee_collection_get_size (((GeeCollection*) indices));
	_tmp0 = NULL;
	container_type = (_tmp0 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_element_access_get_container (expr))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	ccontainer = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_element_access_get_container (expr)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp4 = NULL;
	cindex = (_tmp4 = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (_tmp2 = gee_list_get (((GeeList*) indices), 0))))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp4);
	if (container_type == vala_type_reference_get_data_type (self->priv->string_type)) {
		ValaCCodeIdentifier* _tmp5;
		ValaCCodeFunctionCall* _tmp6;
		ValaCCodeFunctionCall* coffsetcall;
		ValaCCodeIdentifier* _tmp7;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeFunctionCall* ccall;
		/* access to unichar in a string*/
		_tmp5 = NULL;
		_tmp6 = NULL;
		coffsetcall = (_tmp6 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6);
		vala_ccode_function_call_add_argument (coffsetcall, ccontainer);
		vala_ccode_function_call_add_argument (coffsetcall, cindex);
		_tmp7 = NULL;
		_tmp8 = NULL;
		ccall = (_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("g_utf8_get_char")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (coffsetcall));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
		(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	} else {
		if (container_type != NULL && self->priv->list_type != NULL && self->priv->map_type != NULL && (container_type == self->priv->list_type || vala_data_type_is_subtype_of (container_type, self->priv->list_type) || container_type == self->priv->map_type || vala_data_type_is_subtype_of (container_type, self->priv->map_type))) {
			ValaMethod* get_method;
			GeeCollection* get_params;
			GeeIterator* get_params_it;
			ValaFormalParameter* get_param;
			ValaCCodeIdentifier* _tmp11;
			char* _tmp10;
			ValaCCodeFunctionCall* _tmp12;
			ValaCCodeFunctionCall* get_ccall;
			ValaCCodeCastExpression* _tmp15;
			char* _tmp14;
			char* _tmp13;
			ValaCCodeExpression* _tmp16;
			get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) container_type)), "get"));
			get_params = vala_invokable_get_parameters (VALA_INVOKABLE (get_method));
			get_params_it = gee_iterable_iterator (GEE_ITERABLE (get_params));
			gee_iterator_next (get_params_it);
			get_param = gee_iterator_get (get_params_it);
			if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (get_param)) != NULL) {
				ValaTypeReference* index_type;
				ValaCCodeExpression* _tmp9;
				index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_element_access_get_container (expr)), VALA_SYMBOL (get_method), vala_formal_parameter_get_type_reference (get_param), VALA_CODE_NODE (expr));
				_tmp9 = NULL;
				cindex = (_tmp9 = vala_code_generator_convert_to_generic_pointer (self, cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp9);
				(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
			}
			_tmp11 = NULL;
			_tmp10 = NULL;
			_tmp12 = NULL;
			get_ccall = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ((_tmp10 = vala_method_get_cname (get_method)))))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_ccode_function_call_add_argument (get_ccall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_cast_expression_new (ccontainer, (_tmp14 = g_strconcat ((_tmp13 = vala_data_type_get_cname (container_type, FALSE)), "*", NULL))))));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			(_tmp14 = (g_free (_tmp14), NULL));
			(_tmp13 = (g_free (_tmp13), NULL));
			vala_ccode_function_call_add_argument (get_ccall, cindex);
			_tmp16 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp16 = vala_code_generator_convert_from_generic_pointer (self, VALA_CCODE_EXPRESSION (get_ccall), vala_expression_get_static_type (((ValaExpression*) expr))))));
			(_tmp16 = (g_object_unref (_tmp16), NULL));
			(get_method == NULL ? NULL : (get_method = (g_object_unref (get_method), NULL)));
			(get_params == NULL ? NULL : (get_params = (g_object_unref (get_params), NULL)));
			(get_params_it == NULL ? NULL : (get_params_it = (g_object_unref (get_params_it), NULL)));
			(get_param == NULL ? NULL : (get_param = (g_object_unref (get_param), NULL)));
			(get_ccall == NULL ? NULL : (get_ccall = (g_object_unref (get_ccall), NULL)));
		} else {
			ValaCCodeElementAccess* _tmp23;
			{
				gint i;
				i = 0;
				for (i = 1; i < rank; i++) {
					ValaCCodeExpression* _tmp18;
					ValaCCodeParenthesizedExpression* _tmp17;
					ValaCCodeBinaryExpression* _tmp19;
					ValaCCodeBinaryExpression* cmul;
					ValaCCodeExpression* _tmp22;
					ValaCCodeParenthesizedExpression* _tmp21;
					ValaExpression* _tmp20;
					/* access to element in an array*/
					_tmp18 = NULL;
					_tmp17 = NULL;
					_tmp19 = NULL;
					cmul = (_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_parenthesized_expression_new (cindex))), (_tmp18 = vala_code_generator_get_array_length_cexpression (self, vala_element_access_get_container (expr), i + 1))), (_tmp18 = (g_object_unref (_tmp18), NULL)), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp19);
					_tmp22 = NULL;
					_tmp21 = NULL;
					_tmp20 = NULL;
					cindex = (_tmp22 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (cmul), VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (_tmp20 = gee_list_get (((GeeList*) indices), i)))))))))), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp22);
					(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
					(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
					(cmul == NULL ? NULL : (cmul = (g_object_unref (cmul), NULL)));
				}
			}
			_tmp23 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp23 = vala_ccode_element_access_new (ccontainer, cindex))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		}
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
	(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
}


static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr)
{
	ValaCodeGenerator * self;
	ValaInstanceCast* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BASE_ACCESS (expr));
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp1 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("self"))), vala_type_reference_get_data_type (vala_expression_get_static_type (((ValaExpression*) expr)))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr)
{
	ValaCodeGenerator * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp7;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_POSTFIX_EXPRESSION (expr));
	ma = vala_code_generator_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* _tmp0;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeAssignment* _tmp2;
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeBinaryOperator op;
		ValaCCodeConstant* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeBinaryExpression* _tmp5;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp6;
		/* property postfix expression*/
		_tmp0 = NULL;
		prop = (_tmp0 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) ma))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		/* assign current value to temp variable*/
		temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_property_get_type_reference (prop), TRUE);
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_postfix_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		/* increment/decrement property*/
		op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_BINARY_OPERATOR_PLUS : VALA_CCODE_BINARY_OPERATOR_MINUS);
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		cexpr = (_tmp5 = vala_ccode_binary_expression_new (op, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("1")))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp5);
		ccall = vala_code_generator_get_property_set_call (self, prop, ma, VALA_CCODE_EXPRESSION (cexpr));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
		/* return previous value*/
		_tmp6 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		return;
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT : VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT);
	_tmp7 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp7 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_postfix_expression_get_inner (expr))))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaMemberAccess* _tmp3;
	ValaMemberAccess* ma;
	gpointer _tmp5;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* _tmp0;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* _tmp1;
		_tmp0 = NULL;
		pe = (_tmp0 = VALA_PARENTHESIZED_EXPRESSION (expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		_tmp1 = NULL;
		return (_tmp1 = vala_code_generator_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL))), _tmp1);
		(pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL)));
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return VALA_MEMBER_ACCESS (NULL);
	}
	_tmp3 = NULL;
	ma = (_tmp3 = VALA_MEMBER_ACCESS (expr), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) ma)))) {
		return ma;
	}
	return VALA_MEMBER_ACCESS ((_tmp5 = NULL, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp5));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaCCodeExpression* dupexpr;
	ValaCCodeFunctionCall* ccall;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	dupexpr = vala_code_generator_get_dup_func_expression (self, vala_expression_get_static_type (expr));
	if (NULL == dupexpr) {
		gpointer _tmp0;
		return VALA_CCODE_EXPRESSION ((_tmp0 = NULL, (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), _tmp0));
	}
	ccall = vala_ccode_function_call_new (dupexpr);
	if (vala_type_reference_get_non_null (vala_expression_get_static_type (expr)) && vala_type_reference_get_type_parameter (vala_expression_get_static_type (expr)) == NULL) {
		ValaCCodeFunctionCall* _tmp1;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))));
		_tmp1 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp1 = ccall, (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), _tmp1));
	} else {
		ValaVariableDeclarator* decl;
		ValaCCodeIdentifier* ctemp;
		ValaCCodeConstant* _tmp2;
		ValaCCodeBinaryExpression* _tmp3;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp10;
		ValaCCodeExpression* cifnull;
		ValaCCodeConditionalExpression* _tmp18;
		ValaCCodeCommaExpression* _tmp19;
		decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), FALSE);
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, decl);
		ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) decl)));
		_tmp2 = NULL;
		_tmp3 = NULL;
		cisnull = (_tmp3 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("NULL")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) == NULL) {
			ValaCCodeConstant* _tmp7;
			ValaCCodeExpression* _tmp6;
			ValaCCodeBinaryExpression* _tmp8;
			ValaCCodeBinaryExpression* cdupisnull;
			ValaCCodeBinaryExpression* _tmp9;
			if (!(VALA_IS_CLASS (self->priv->current_type_symbol))) {
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp5;
				_tmp4 = NULL;
				_tmp5 = NULL;
				return (_tmp5 = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp5);
			}
			/* dup functions are optional for type parameters*/
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp8 = NULL;
			cdupisnull = (_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (_tmp6 = vala_code_generator_get_dup_func_expression (self, vala_expression_get_static_type (expr))), VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("NULL")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp8);
			_tmp9 = NULL;
			cisnull = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cdupisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp9);
			(cdupisnull == NULL ? NULL : (cdupisnull = (g_object_unref (cdupisnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ctemp));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		_tmp10 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) == self->priv->glist_type) {
			gboolean is_ref;
			gboolean is_class;
			gboolean is_interface;
			is_ref = FALSE;
			is_class = FALSE;
			is_interface = FALSE;
			{
				GeeList* type_arg_collection;
				GeeIterator* type_arg_it;
				type_arg_collection = vala_type_reference_get_type_arguments (vala_expression_get_static_type (expr));
				type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
				while (gee_iterator_next (type_arg_it)) {
					ValaTypeReference* type_arg;
					type_arg = gee_iterator_get (type_arg_it);
					{
						is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
						(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
					}
				}
				(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
				(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
			}
			if (is_ref && (is_class || is_interface)) {
				ValaCCodeIdentifier* _tmp11;
				ValaCCodeFunctionCall* _tmp12;
				ValaCCodeFunctionCall* crefcall;
				ValaCCodeIdentifier* _tmp13;
				ValaCCodeConstant* _tmp14;
				_tmp11 = NULL;
				_tmp12 = NULL;
				crefcall = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("g_list_foreach")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION (ctemp));
				_tmp13 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("(GFunc) g_object_ref"))));
				(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
				_tmp14 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ("NULL"))));
				(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (crefcall));
				(crefcall == NULL ? NULL : (crefcall = (g_object_unref (crefcall), NULL)));
			}
		}
		cifnull = NULL;
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) != NULL) {
			ValaCCodeExpression* _tmp15;
			_tmp15 = NULL;
			cifnull = (_tmp15 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), _tmp15);
		} else {
			ValaCCodeExpression* _tmp17;
			ValaCCodeIdentifier* _tmp16;
			/* the value might be non-null even when the dup function is null,
			 so we may not just use NULL for type parameters*/
			_tmp17 = NULL;
			_tmp16 = NULL;
			cifnull = (_tmp17 = VALA_CCODE_EXPRESSION ((_tmp16 = ctemp, (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)))), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), _tmp17);
		}
		_tmp18 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), cifnull, VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		_tmp19 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp19 = ccomma, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp19));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
		(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL)));
	}
	(dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (vala_expression_get_static_type (expr) != NULL && vala_type_reference_get_transfers_ownership (vala_expression_get_static_type (expr)) && vala_type_reference_get_floating_reference (vala_expression_get_static_type (expr))) {
		ValaCCodeIdentifier* _tmp0;
		ValaCCodeFunctionCall* _tmp1;
		ValaCCodeFunctionCall* csink;
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		_tmp0 = NULL;
		_tmp1 = NULL;
		csink = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_object_ref_sink")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
		vala_ccode_function_call_add_argument (csink, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csink));
		(csink == NULL ? NULL : (csink = (g_object_unref (csink), NULL)));
	}
	if (vala_expression_get_ref_leaked (expr)) {
		ValaVariableDeclarator* decl;
		ValaCCodeParenthesizedExpression* _tmp5;
		ValaCCodeAssignment* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		char* _tmp2;
		decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, decl);
		gee_list_insert (GEE_LIST (self->priv->temp_ref_vars), 0, decl);
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp5 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 = (g_free (_tmp2), NULL));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	} else {
		if (vala_expression_get_ref_missing (expr)) {
			ValaCCodeExpression* _tmp6;
			_tmp6 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp6 = vala_code_generator_get_ref_expression (self, expr))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (expr));
	if (vala_expression_get_symbol_reference (((ValaExpression*) expr)) == NULL) {
		/* no creation method*/
		if (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->glist_type || vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->gslist_type) {
			ValaCCodeConstant* _tmp0;
			/* NULL is an empty list*/
			_tmp0 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new ("NULL"))));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && vala_data_type_is_subtype_of (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->priv->gobject_type)) {
				ValaCCodeIdentifier* _tmp1;
				ValaCCodeFunctionCall* _tmp2;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* _tmp4;
				char* _tmp3;
				ValaCCodeConstant* _tmp5;
				_tmp1 = NULL;
				_tmp2 = NULL;
				ccall = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_object_new")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr))))))));
				(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
				(_tmp3 = (g_free (_tmp3), NULL));
				_tmp5 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("NULL"))));
				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeFunctionCall* _tmp7;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* _tmp9;
				char* _tmp8;
				ValaCCodeConstant* _tmp10;
				_tmp6 = NULL;
				_tmp7 = NULL;
				ccall = (_tmp7 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("g_new0")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
				_tmp9 = NULL;
				_tmp8 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ((_tmp8 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE))))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				(_tmp8 = (g_free (_tmp8), NULL));
				_tmp10 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_constant_new ("1"))));
				(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			}
		}
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
			ValaMethod* _tmp11;
			ValaMethod* m;
			GeeCollection* params;
			ValaCCodeIdentifier* _tmp13;
			char* _tmp12;
			ValaCCodeFunctionCall* _tmp14;
			ValaCCodeFunctionCall* ccall;
			gboolean ellipsis;
			gint i;
			GeeIterator* params_it;
			/* use creation method*/
			_tmp11 = NULL;
			m = (_tmp11 = VALA_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
			params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
			_tmp13 = NULL;
			_tmp12 = NULL;
			_tmp14 = NULL;
			ccall = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ((_tmp12 = vala_method_get_cname (m)))))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp14);
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && vala_data_type_is_subtype_of (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->priv->gobject_type)) {
				{
					GeeList* type_arg_collection;
					GeeIterator* type_arg_it;
					type_arg_collection = vala_type_reference_get_type_arguments (vala_object_creation_expression_get_type_reference (expr));
					type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
					while (gee_iterator_next (type_arg_it)) {
						ValaTypeReference* type_arg;
						type_arg = gee_iterator_get (type_arg_it);
						{
							if (vala_type_reference_get_takes_ownership (type_arg)) {
								ValaCCodeExpression* _tmp15;
								ValaCCodeExpression* _tmp16;
								_tmp15 = NULL;
								vala_ccode_function_call_add_argument (ccall, (_tmp15 = vala_code_generator_get_dup_func_expression (self, type_arg)));
								(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
								_tmp16 = NULL;
								vala_ccode_function_call_add_argument (ccall, (_tmp16 = vala_code_generator_get_destroy_func_expression (self, type_arg)));
								(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
							} else {
								ValaCCodeConstant* _tmp17;
								ValaCCodeConstant* _tmp18;
								_tmp17 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("NULL"))));
								(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
								_tmp18 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("NULL"))));
								(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
							}
							(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
						}
					}
					(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
					(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
				}
			}
			ellipsis = FALSE;
			i = 1;
			params_it = gee_iterable_iterator (GEE_ITERABLE (params));
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = vala_object_creation_expression_get_argument_list (expr);
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = gee_iterator_get (arg_it);
					{
						ValaCCodeExpression* _tmp19;
						ValaCCodeExpression* cexpr;
						_tmp19 = NULL;
						cexpr = (_tmp19 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) arg))), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19)));
						if (gee_iterator_next (params_it)) {
							ValaFormalParameter* param;
							param = gee_iterator_get (params_it);
							ellipsis = vala_formal_parameter_get_ellipsis (param);
							if (!vala_formal_parameter_get_ellipsis (param) && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
								ValaCCodeIdentifier* _tmp21;
								char* _tmp20;
								ValaCCodeFunctionCall* _tmp22;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeExpression* _tmp24;
								ValaCCodeFunctionCall* _tmp23;
								/* FIXME: use C cast if debugging disabled*/
								_tmp21 = NULL;
								_tmp20 = NULL;
								_tmp22 = NULL;
								ccall = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL)))))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), _tmp22);
								vala_ccode_function_call_add_argument (ccall, cexpr);
								_tmp24 = NULL;
								_tmp23 = NULL;
								cexpr = (_tmp24 = VALA_CCODE_EXPRESSION ((_tmp23 = ccall, (_tmp23 == NULL ? NULL : g_object_ref (_tmp23)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp24);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							}
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
						vala_ccode_function_call_add_argument (ccall, cexpr);
						i++;
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			while (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				param = gee_iterator_get (params_it);
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp25;
					_tmp25 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), (_tmp25 = g_strdup_printf ("no default expression for argument %d", i)));
					(_tmp25 = (g_free (_tmp25), NULL));
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_formal_parameter_get_default_expression (param)))));
				i++;
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
			if (vala_expression_get_can_fail (((ValaExpression*) expr))) {
				ValaCCodeUnaryExpression* _tmp27;
				ValaCCodeIdentifier* _tmp26;
				/* method can fail*/
				self->priv->current_method_inner_error = TRUE;
				_tmp27 = NULL;
				_tmp26 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("inner_error")))))));
				(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
			}
			if (ellipsis) {
				ValaCCodeConstant* _tmp28;
				/* ensure variable argument list ends with NULL*/
				_tmp28 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_constant_new ("NULL"))));
				(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
		} else {
			if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
				ValaEnumValue* _tmp29;
				ValaEnumValue* ev;
				ValaEnum* _tmp30;
				ValaEnum* en;
				ValaCCodeIdentifier* _tmp31;
				ValaCCodeFunctionCall* _tmp32;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* _tmp33;
				ValaCCodeIdentifier* _tmp35;
				char* _tmp34;
				ValaCCodeIdentifier* _tmp37;
				char* _tmp36;
				/* error code*/
				_tmp29 = NULL;
				ev = (_tmp29 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp29 == NULL ? NULL : g_object_ref (_tmp29)));
				_tmp30 = NULL;
				en = (_tmp30 = VALA_ENUM (vala_symbol_get_parent_symbol (((ValaSymbol*) ev))), (_tmp30 == NULL ? NULL : g_object_ref (_tmp30)));
				_tmp31 = NULL;
				_tmp32 = NULL;
				ccall = (_tmp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("g_set_error")))), (_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL))), _tmp32);
				_tmp33 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("error"))));
				(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
				_tmp35 = NULL;
				_tmp34 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ((_tmp34 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (en), NULL))))));
				(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
				(_tmp34 = (g_free (_tmp34), NULL));
				_tmp37 = NULL;
				_tmp36 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ((_tmp36 = vala_enum_value_get_cname (ev))))));
				(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
				(_tmp36 = (g_free (_tmp36), NULL));
				{
					GeeCollection* arg_collection;
					GeeIterator* arg_it;
					arg_collection = vala_object_creation_expression_get_argument_list (expr);
					arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
					while (gee_iterator_next (arg_it)) {
						ValaExpression* arg;
						arg = gee_iterator_get (arg_it);
						{
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) arg))));
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						}
					}
					(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
					(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
				}
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
				(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
				(en == NULL ? NULL : (en = (g_object_unref (en), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			} else {
				g_assert (FALSE);
			}
		}
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_SIZEOF_EXPRESSION (expr));
	_tmp0 = NULL;
	_tmp1 = NULL;
	csizeof = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("sizeof")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_sizeof_expression_get_type_reference (expr)), FALSE))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	(_tmp2 = (g_free (_tmp2), NULL));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csizeof));
	(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
}


static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* _tmp1;
	char* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_TYPEOF_EXPRESSION (expr));
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_typeof_expression_get_type_reference (expr))))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 = (g_free (_tmp0), NULL));
}


static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_UNARY_EXPRESSION (expr));
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_unary_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (expr));
	if ((VALA_IS_CLASS (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr))) && vala_data_type_is_subtype_of (VALA_DATA_TYPE ((VALA_CLASS (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr))))), self->priv->gobject_type)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)))) {
		/* GObject cast*/
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			ValaCCodeCommaExpression* ccomma;
			ValaVariableDeclarator* temp_decl;
			ValaCCodeIdentifier* ctemp;
			ValaCCodeAssignment* cinit;
			ValaCCodeFunctionCall* ccheck;
			char* _tmp0;
			ValaCCodeCastExpression* _tmp1;
			ValaCCodeCastExpression* ccast;
			ValaCCodeConstant* cnull;
			ValaCCodeConditionalExpression* _tmp2;
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_cast_expression_get_inner (expr)), TRUE);
			gee_collection_add (GEE_COLLECTION (self->priv->temp_vars), temp_decl);
			ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
			cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_cast_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			ccheck = vala_code_generator_create_type_check (VALA_CCODE_NODE (ctemp), vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)));
			_tmp0 = NULL;
			_tmp1 = NULL;
			ccast = (_tmp1 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ctemp), (_tmp0 = vala_type_reference_get_cname (vala_cast_expression_get_type_reference (expr), FALSE, FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
			cnull = vala_ccode_constant_new ("NULL");
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cinit));
			_tmp2 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_EXPRESSION (cnull)))));
			(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
			(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		} else {
			ValaInstanceCast* _tmp3;
			_tmp3 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp3 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_cast_expression_get_inner (expr)))), vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr))))));
			(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		}
	} else {
		ValaCCodeCastExpression* _tmp5;
		char* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp5 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_cast_expression_get_inner (expr)))), (_tmp4 = vala_type_reference_get_cname (vala_cast_expression_get_type_reference (expr), FALSE, FALSE))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 = (g_free (_tmp4), NULL));
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_POINTER_INDIRECTION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_pointer_indirection_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_addressof_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeCommaExpression* ccomma;
	ValaVariableDeclarator* temp_decl;
	ValaCCodeIdentifier* cvar;
	ValaCCodeAssignment* _tmp0;
	ValaCCodeAssignment* _tmp2;
	ValaCCodeConstant* _tmp1;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (expr));
	/* (tmp = var, var = null, tmp) */
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (((ValaExpression*) expr)), TRUE);
	gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
	cvar = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cvar), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvar));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(cvar == NULL ? NULL : (cvar = (g_object_unref (cvar), NULL)));
}


static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeBinaryOperator op;
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryExpression* _tmp6;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_BINARY_EXPRESSION (expr));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp0 = NULL;
	cleft = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_binary_expression_get_left (expr)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	cright = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_binary_expression_get_right (expr)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
		if (vala_expression_get_static_type (vala_binary_expression_get_left (expr)) != NULL && vala_expression_get_static_type (vala_binary_expression_get_right (expr)) != NULL && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) && vala_data_type_is_subtype_of (VALA_DATA_TYPE ((VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))))), self->priv->gobject_type) && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))) && vala_data_type_is_subtype_of (VALA_DATA_TYPE ((VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))))), self->priv->gobject_type)) {
			ValaClass* _tmp2;
			ValaClass* left_cl;
			ValaClass* _tmp3;
			ValaClass* right_cl;
			_tmp2 = NULL;
			left_cl = (_tmp2 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
			_tmp3 = NULL;
			right_cl = (_tmp3 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
			if (left_cl != right_cl) {
				if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (left_cl), VALA_DATA_TYPE (right_cl))) {
					ValaCCodeExpression* _tmp4;
					_tmp4 = NULL;
					cleft = (_tmp4 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cleft, VALA_DATA_TYPE (right_cl))), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), _tmp4);
				} else {
					if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (right_cl), VALA_DATA_TYPE (left_cl))) {
						ValaCCodeExpression* _tmp5;
						_tmp5 = NULL;
						cright = (_tmp5 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cright, VALA_DATA_TYPE (left_cl))), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), _tmp5);
					}
				}
			}
			(left_cl == NULL ? NULL : (left_cl = (g_object_unref (left_cl), NULL)));
			(right_cl == NULL ? NULL : (right_cl = (g_object_unref (right_cl), NULL)));
		}
	}
	_tmp6 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp6 = vala_ccode_binary_expression_new (op, cleft, cright))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
	(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
}


static ValaCCodeFunctionCall* vala_code_generator_create_type_check (ValaCCodeNode* ccodenode, ValaDataType* type)
{
	ValaCCodeIdentifier* _tmp1;
	char* _tmp0;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* ccheck;
	g_return_val_if_fail (VALA_IS_CCODE_NODE (ccodenode), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	ccheck = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_data_type_get_upper_case_cname (type, "IS_")))))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (ccodenode));
	return ccheck;
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_TYPE_CHECK (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_code_generator_create_type_check (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_type_check_get_expression (expr))), vala_type_reference_get_data_type (vala_type_check_get_type_reference (expr))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConditionalExpression* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_conditional_expression_get_condition (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_conditional_expression_get_true_expression (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_conditional_expression_get_false_expression (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* _tmp1;
	char* _tmp0;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (l));
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (l), VALA_CCODE_NODE ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_method_get_cname (vala_lambda_expression_get_method (l)))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 = (g_free (_tmp0), NULL));
}


static ValaCCodeExpression* vala_code_generator_convert_from_generic_pointer (ValaCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type)
{
	ValaCCodeExpression* result;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (actual_type), NULL);
	result = g_object_ref (cexpr);
	if (VALA_IS_STRUCT (vala_type_reference_get_data_type (actual_type))) {
		ValaStruct* _tmp0;
		ValaStruct* st;
		_tmp0 = NULL;
		st = (_tmp0 = VALA_STRUCT (vala_type_reference_get_data_type (actual_type)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
			ValaCCodeIdentifier* _tmp1;
			ValaCCodeFunctionCall* _tmp2;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp4;
			ValaCCodeFunctionCall* _tmp3;
			_tmp1 = NULL;
			_tmp2 = NULL;
			cconv = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("GPOINTER_TO_UINT")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp4 = NULL;
			_tmp3 = NULL;
			result = (_tmp4 = VALA_CCODE_EXPRESSION ((_tmp3 = cconv, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)))), (result = (g_object_unref (result), NULL)), _tmp4);
			(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
		} else {
			if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* _tmp5;
				ValaCCodeFunctionCall* _tmp6;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp8;
				ValaCCodeFunctionCall* _tmp7;
				_tmp5 = NULL;
				_tmp6 = NULL;
				cconv = (_tmp6 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("GPOINTER_TO_INT")))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp8 = NULL;
				_tmp7 = NULL;
				result = (_tmp8 = VALA_CCODE_EXPRESSION ((_tmp7 = cconv, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)))), (result = (g_object_unref (result), NULL)), _tmp8);
				(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	}
	return result;
	(result = (g_object_unref (result), NULL));
}


static ValaCCodeExpression* vala_code_generator_convert_to_generic_pointer (ValaCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type)
{
	ValaCCodeExpression* result;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (actual_type), NULL);
	result = g_object_ref (cexpr);
	if (VALA_IS_STRUCT (vala_type_reference_get_data_type (actual_type))) {
		ValaStruct* _tmp0;
		ValaStruct* st;
		_tmp0 = NULL;
		st = (_tmp0 = VALA_STRUCT (vala_type_reference_get_data_type (actual_type)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
			ValaCCodeIdentifier* _tmp1;
			ValaCCodeFunctionCall* _tmp2;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp4;
			ValaCCodeFunctionCall* _tmp3;
			_tmp1 = NULL;
			_tmp2 = NULL;
			cconv = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("GUINT_TO_POINTER")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp4 = NULL;
			_tmp3 = NULL;
			result = (_tmp4 = VALA_CCODE_EXPRESSION ((_tmp3 = cconv, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)))), (result = (g_object_unref (result), NULL)), _tmp4);
			(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
		} else {
			if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* _tmp5;
				ValaCCodeFunctionCall* _tmp6;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp8;
				ValaCCodeFunctionCall* _tmp7;
				_tmp5 = NULL;
				_tmp6 = NULL;
				cconv = (_tmp6 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("GINT_TO_POINTER")))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp8 = NULL;
				_tmp7 = NULL;
				result = (_tmp8 = VALA_CCODE_EXPRESSION ((_tmp7 = cconv, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)))), (result = (g_object_unref (result), NULL)), _tmp8);
				(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	}
	return result;
	(result = (g_object_unref (result), NULL));
}


static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a)
{
	ValaCodeGenerator * self;
	ValaMemberAccess* ma;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_ASSIGNMENT (a));
	ma = NULL;
	if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (a))) {
		ValaMemberAccess* _tmp1;
		ValaMemberAccess* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		ma = (_tmp1 = (_tmp0 = VALA_MEMBER_ACCESS (vala_assignment_get_left (a)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp1);
	}
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))) {
		ValaProperty* _tmp2;
		ValaProperty* prop;
		_tmp2 = NULL;
		prop = (_tmp2 = VALA_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (a))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop)) && VALA_IS_CLASS (self->priv->current_type_symbol) && self->priv->in_creation_method) {
			ValaCCodeIdentifier* cpointer;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeMemberAccess* cnamemember;
			ValaCCodeConstant* _tmp3;
			ValaCCodeAssignment* _tmp4;
			ValaCCodeAssignment* cnameassign;
			ValaCCodeMemberAccess* _tmp5;
			ValaCCodeUnaryExpression* _tmp6;
			ValaCCodeUnaryExpression* gvaluearg;
			ValaCCodeIdentifier* _tmp7;
			ValaCCodeFunctionCall* _tmp8;
			ValaCCodeFunctionCall* cvalueinit;
			ValaCCodeIdentifier* _tmp10;
			char* _tmp9;
			ValaCCodeIdentifier* _tmp11;
			ValaCCodeFunctionCall* _tmp12;
			ValaCCodeFunctionCall* cvalueset;
			ValaCCodeUnaryExpression* _tmp13;
			/* this property is used as a construction parameter*/
			cpointer = vala_ccode_identifier_new ("__params_it");
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			/* set name in array for current parameter*/
			cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
			_tmp3 = NULL;
			_tmp4 = NULL;
			cnameassign = (_tmp4 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION ((_tmp3 = vala_property_get_canonical_cconstant (prop))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp3 = (g_object_unref (_tmp3), NULL)), _tmp4);
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cnameassign));
			_tmp5 = NULL;
			_tmp6 = NULL;
			gvaluearg = (_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6);
			/* initialize GValue in array for current parameter*/
			_tmp7 = NULL;
			_tmp8 = NULL;
			cvalueinit = (_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("g_value_init")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
			_tmp10 = NULL;
			_tmp9 = NULL;
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))))))));
			(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
			(_tmp9 = (g_free (_tmp9), NULL));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
			/* set GValue for current parameter*/
			_tmp11 = NULL;
			_tmp12 = NULL;
			cvalueset = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop))))), (_tmp11 = (g_object_unref (_tmp11), NULL)), _tmp12);
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_right (a)))));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
			/* move pointer to next parameter in array*/
			_tmp13 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
			(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma));
			(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
			(cnameassign == NULL ? NULL : (cnameassign = (g_object_unref (cnameassign), NULL)));
			(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
			(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
			(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
		} else {
			ValaCCodeExpression* _tmp14;
			ValaCCodeExpression* cexpr;
			ValaCCodeFunctionCall* ccall;
			_tmp14 = NULL;
			cexpr = (_tmp14 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_right (a)))), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
			if (!vala_property_get_no_accessor_method (prop) && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a)))) {
				ValaCCodeIdentifier* _tmp16;
				char* _tmp15;
				ValaCCodeFunctionCall* _tmp17;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeExpression* _tmp19;
				ValaCCodeFunctionCall* _tmp18;
				/* cast is necessary */
				_tmp16 = NULL;
				_tmp15 = NULL;
				_tmp17 = NULL;
				ccast = (_tmp17 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ((_tmp15 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), NULL)))))), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), (_tmp15 = (g_free (_tmp15), NULL)), _tmp17);
				vala_ccode_function_call_add_argument (ccast, cexpr);
				_tmp19 = NULL;
				_tmp18 = NULL;
				cexpr = (_tmp19 = VALA_CCODE_EXPRESSION ((_tmp18 = ccast, (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp19);
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
			if (vala_assignment_get_operator (a) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
				ValaCCodeBinaryOperator cop;
				ValaCCodeExpression* _tmp21;
				ValaCCodeParenthesizedExpression* _tmp20;
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
							cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
								cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
									cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
										cop = VALA_CCODE_BINARY_OPERATOR_MUL;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
											cop = VALA_CCODE_BINARY_OPERATOR_DIV;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
												cop = VALA_CCODE_BINARY_OPERATOR_MOD;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
												} else {
													if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
														cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp21 = NULL;
				_tmp20 = NULL;
				cexpr = (_tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (cop, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a)))), VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_parenthesized_expression_new (cexpr))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp21);
				(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
			}
			ccall = vala_code_generator_get_property_set_call (self, prop, ma, cexpr);
			/* assignments are expressions, so return the current property value, except if we're sure that it can't be used*/
			if (!(VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) a))))) {
				ValaCCodeCommaExpression* ccomma;
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
				/* update property*/
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) ma))));
				/* current property value*/
				vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			} else {
				vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccall));
			}
			(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	} else {
		if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))) {
			ValaSignal* _tmp22;
			ValaSignal* sig;
			ValaMethod* _tmp23;
			ValaMethod* m;
			char* connect_func;
			gboolean disconnect;
			ValaCCodeIdentifier* _tmp29;
			ValaCCodeFunctionCall* _tmp30;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeCastExpression* _tmp49;
			ValaCCodeIdentifier* _tmp48;
			char* _tmp47;
			_tmp22 = NULL;
			sig = (_tmp22 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (a))), (_tmp22 == NULL ? NULL : g_object_ref (_tmp22)));
			_tmp23 = NULL;
			m = (_tmp23 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (a))), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23)));
			connect_func = NULL;
			disconnect = FALSE;
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
				if (VALA_IS_DBUS_SIGNAL (sig)) {
					char* _tmp24;
					_tmp24 = NULL;
					connect_func = (_tmp24 = g_strdup ("dbus_g_proxy_connect_signal"), (connect_func = (g_free (connect_func), NULL)), _tmp24);
				} else {
					char* _tmp25;
					_tmp25 = NULL;
					connect_func = (_tmp25 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), _tmp25);
					if (!vala_method_get_instance (m)) {
						char* _tmp26;
						_tmp26 = NULL;
						connect_func = (_tmp26 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), _tmp26);
					}
				}
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
					if (VALA_IS_DBUS_SIGNAL (sig)) {
						char* _tmp27;
						_tmp27 = NULL;
						connect_func = (_tmp27 = g_strdup ("dbus_g_proxy_disconnect_signal"), (connect_func = (g_free (connect_func), NULL)), _tmp27);
					} else {
						char* _tmp28;
						_tmp28 = NULL;
						connect_func = (_tmp28 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), _tmp28);
					}
					disconnect = TRUE;
				} else {
					vala_code_node_set_error (VALA_CODE_NODE (a), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) a)), "Specified compound assignment type for signals not supported.");
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(connect_func = (g_free (connect_func), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					return;
				}
			}
			_tmp29 = NULL;
			_tmp30 = NULL;
			ccall = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new (connect_func)))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), _tmp30);
			if (vala_member_access_get_inner (ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))));
			} else {
				ValaCCodeIdentifier* _tmp31;
				_tmp31 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("self"))));
				(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			}
			if (!disconnect || VALA_IS_DBUS_SIGNAL (sig)) {
				ValaCCodeConstant* _tmp32;
				_tmp32 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_signal_get_canonical_cconstant (sig))));
				(_tmp32 = (g_object_unref (_tmp32), NULL));
			} else {
				ValaCCodeConstant* _tmp33;
				ValaCCodeCommaExpression* ccomma;
				ValaVariableDeclarator* temp_decl;
				ValaCCodeIdentifier* _tmp34;
				ValaCCodeFunctionCall* _tmp35;
				ValaCCodeFunctionCall* parse_call;
				ValaCCodeConstant* _tmp36;
				ValaDataType* _tmp37;
				ValaDataType* decl_type;
				ValaCCodeIdentifier* _tmp39;
				char* _tmp38;
				ValaCCodeUnaryExpression* _tmp41;
				ValaCCodeIdentifier* _tmp40;
				ValaCCodeConstant* _tmp42;
				ValaCCodeConstant* _tmp43;
				ValaCCodeIdentifier* _tmp44;
				ValaCCodeConstant* _tmp45;
				ValaCCodeConstant* _tmp46;
				_tmp33 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA"))));
				(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
				/* get signal id*/
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->uint_type, TRUE);
				gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
				_tmp34 = NULL;
				_tmp35 = NULL;
				parse_call = (_tmp35 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("g_signal_parse_name")))), (_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL))), _tmp35);
				_tmp36 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp36 = vala_signal_get_canonical_cconstant (sig))));
				(_tmp36 = (g_object_unref (_tmp36), NULL));
				_tmp37 = NULL;
				decl_type = (_tmp37 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) sig))), (_tmp37 == NULL ? NULL : g_object_ref (_tmp37)));
				_tmp39 = NULL;
				_tmp38 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ((_tmp38 = vala_data_type_get_type_id (decl_type))))));
				(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
				(_tmp38 = (g_free (_tmp38), NULL));
				_tmp41 = NULL;
				_tmp40 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)))))))));
				(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
				(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
				_tmp42 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_constant_new ("NULL"))));
				(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
				_tmp43 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_constant_new ("FALSE"))));
				(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (parse_call));
				_tmp44 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
				(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccomma));
				_tmp45 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_constant_new ("0"))));
				(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
				_tmp46 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_constant_new ("NULL"))));
				(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
				(parse_call == NULL ? NULL : (parse_call = (g_object_unref (parse_call), NULL)));
				(decl_type == NULL ? NULL : (decl_type = (g_object_unref (decl_type), NULL)));
			}
			_tmp49 = NULL;
			_tmp48 = NULL;
			_tmp47 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new ((_tmp47 = vala_method_get_cname (m))))), "GCallback"))));
			(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
			(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
			(_tmp47 = (g_free (_tmp47), NULL));
			if (vala_method_get_instance (m)) {
				if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (a))) {
					ValaMemberAccess* _tmp50;
					ValaMemberAccess* right_ma;
					_tmp50 = NULL;
					right_ma = (_tmp50 = VALA_MEMBER_ACCESS (vala_assignment_get_right (a)), (_tmp50 == NULL ? NULL : g_object_ref (_tmp50)));
					if (vala_member_access_get_inner (right_ma) != NULL) {
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (right_ma)))));
					} else {
						ValaCCodeIdentifier* _tmp51;
						_tmp51 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("self"))));
						(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
					}
					(right_ma == NULL ? NULL : (right_ma = (g_object_unref (right_ma), NULL)));
				} else {
					if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (a))) {
						ValaCCodeIdentifier* _tmp52;
						_tmp52 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ("self"))));
						(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
					}
				}
				if (!disconnect) {
					if (VALA_IS_DBUS_SIGNAL (sig)) {
						ValaCCodeConstant* _tmp53;
						/* free_data_func*/
						_tmp53 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_constant_new ("NULL"))));
						(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
					} else {
						ValaCCodeConstant* _tmp54;
						/* connect_flags*/
						_tmp54 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_constant_new ("0"))));
						(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
					}
				}
			} else {
				ValaCCodeConstant* _tmp55;
				_tmp55 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_constant_new ("NULL"))));
				(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccall));
			if (VALA_IS_DBUS_SIGNAL (sig) && !disconnect) {
				gboolean first;
				ValaCCodeIdentifier* _tmp56;
				ValaCCodeFunctionCall* _tmp57;
				ValaCCodeFunctionCall* register_call;
				ValaCCodeIdentifier* _tmp59;
				char* _tmp58;
				ValaCCodeIdentifier* _tmp60;
				ValaCCodeIdentifier* _tmp61;
				ValaCCodeFunctionCall* _tmp62;
				ValaCCodeFunctionCall* add_call;
				ValaCCodeConstant* _tmp64;
				ValaCCodeIdentifier* _tmp75;
				ValaCCodeIdentifier* _tmp76;
				ValaCCodeCommaExpression* ccomma;
				first = TRUE;
				{
					GeeCollection* param_collection;
					GeeIterator* param_it;
					param_collection = vala_invokable_get_parameters (VALA_INVOKABLE (m));
					param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
					while (gee_iterator_next (param_it)) {
						ValaFormalParameter* param;
						param = gee_iterator_get (param_it);
						{
							if (first) {
								/* skip sender parameter*/
								first = FALSE;
								(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
								continue;
							}
							vala_signal_add_parameter (sig, param);
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
					}
					(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
					(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
				}
				vala_code_node_accept (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
				/* FIXME should only be done once per marshaller*/
				_tmp56 = NULL;
				_tmp57 = NULL;
				register_call = (_tmp57 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new ("dbus_g_object_register_marshaller")))), (_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL))), _tmp57);
				_tmp59 = NULL;
				_tmp58 = NULL;
				vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ((_tmp58 = vala_code_generator_get_signal_marshaller_function (self, sig, NULL))))));
				(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
				(_tmp58 = (g_free (_tmp58), NULL));
				_tmp60 = NULL;
				vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_identifier_new ("G_TYPE_NONE"))));
				(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
				_tmp61 = NULL;
				_tmp62 = NULL;
				add_call = (_tmp62 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_identifier_new ("dbus_g_proxy_add_signal")))), (_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL))), _tmp62);
				if (vala_member_access_get_inner (ma) != NULL) {
					vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))));
				} else {
					ValaCCodeIdentifier* _tmp63;
					_tmp63 = NULL;
					vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_identifier_new ("self"))));
					(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
				}
				_tmp64 = NULL;
				vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp64 = vala_signal_get_canonical_cconstant (sig))));
				(_tmp64 = (g_object_unref (_tmp64), NULL));
				first = TRUE;
				{
					GeeCollection* param_collection;
					GeeIterator* param_it;
					param_collection = vala_invokable_get_parameters (VALA_INVOKABLE (m));
					param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
					while (gee_iterator_next (param_it)) {
						ValaFormalParameter* param;
						param = gee_iterator_get (param_it);
						{
							if (first) {
								/* skip sender parameter*/
								first = FALSE;
								(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
								continue;
							}
							if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_array_get_element_type ((VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))) != vala_type_reference_get_data_type (self->priv->string_type)) {
								ValaArray* _tmp65;
								ValaArray* array;
								ValaCCodeIdentifier* _tmp66;
								ValaCCodeFunctionCall* _tmp67;
								ValaCCodeFunctionCall* carray_type;
								ValaCCodeConstant* _tmp68;
								ValaCCodeIdentifier* _tmp70;
								char* _tmp69;
								_tmp65 = NULL;
								array = (_tmp65 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp65 == NULL ? NULL : g_object_ref (_tmp65)));
								_tmp66 = NULL;
								_tmp67 = NULL;
								carray_type = (_tmp67 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL))), _tmp67);
								_tmp68 = NULL;
								vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_constant_new ("\"GArray\""))));
								(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
								_tmp70 = NULL;
								_tmp69 = NULL;
								vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new ((_tmp69 = vala_data_type_get_type_id (vala_array_get_element_type (array)))))));
								(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
								(_tmp69 = (g_free (_tmp69), NULL));
								vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION (carray_type));
								vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION (carray_type));
								(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
								(carray_type == NULL ? NULL : (carray_type = (g_object_unref (carray_type), NULL)));
							} else {
								ValaCCodeIdentifier* _tmp72;
								char* _tmp71;
								ValaCCodeIdentifier* _tmp74;
								char* _tmp73;
								_tmp72 = NULL;
								_tmp71 = NULL;
								vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_identifier_new ((_tmp71 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
								(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
								(_tmp71 = (g_free (_tmp71), NULL));
								_tmp74 = NULL;
								_tmp73 = NULL;
								vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ((_tmp73 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
								(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
								(_tmp73 = (g_free (_tmp73), NULL));
							}
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
					}
					(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
					(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
				}
				_tmp75 = NULL;
				vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
				_tmp76 = NULL;
				vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (register_call));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (add_call));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma));
				(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
				(add_call == NULL ? NULL : (add_call = (g_object_unref (add_call), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			}
			(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(connect_func = (g_free (connect_func), NULL));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (a)) && !(VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (a))))))))) {
				ValaCCodeExpression* _tmp77;
				ValaCCodeExpression* rhs;
				ValaElementAccess* _tmp83;
				ValaElementAccess* expr;
				ValaDataType* _tmp84;
				ValaDataType* container_type;
				GeeCollection* indices;
				GeeIterator* indices_it;
				ValaCCodeExpression* _tmp85;
				ValaCCodeExpression* ccontainer;
				ValaCCodeExpression* _tmp87;
				ValaExpression* _tmp86;
				ValaCCodeExpression* _tmp88;
				ValaCCodeExpression* cindex;
				/* custom element access*/
				_tmp77 = NULL;
				rhs = (_tmp77 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_right (a)))), (_tmp77 == NULL ? NULL : g_object_ref (_tmp77)));
				if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) {
					ValaCCodeIdentifier* _tmp79;
					char* _tmp78;
					ValaCCodeFunctionCall* _tmp80;
					ValaCCodeFunctionCall* ccast;
					ValaCCodeExpression* _tmp82;
					ValaCCodeFunctionCall* _tmp81;
					_tmp79 = NULL;
					_tmp78 = NULL;
					_tmp80 = NULL;
					ccast = (_tmp80 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new ((_tmp78 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))), NULL)))))), (_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL))), (_tmp78 = (g_free (_tmp78), NULL)), _tmp80);
					vala_ccode_function_call_add_argument (ccast, rhs);
					_tmp82 = NULL;
					_tmp81 = NULL;
					rhs = (_tmp82 = VALA_CCODE_EXPRESSION ((_tmp81 = ccast, (_tmp81 == NULL ? NULL : g_object_ref (_tmp81)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp82);
					(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
				}
				_tmp83 = NULL;
				expr = (_tmp83 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (a)), (_tmp83 == NULL ? NULL : g_object_ref (_tmp83)));
				_tmp84 = NULL;
				container_type = (_tmp84 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_element_access_get_container (expr))), (_tmp84 == NULL ? NULL : g_object_ref (_tmp84)));
				indices = GEE_COLLECTION (vala_element_access_get_indices (expr));
				indices_it = gee_iterable_iterator (GEE_ITERABLE (indices));
				gee_iterator_next (indices_it);
				_tmp85 = NULL;
				ccontainer = (_tmp85 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_element_access_get_container (expr)))), (_tmp85 == NULL ? NULL : g_object_ref (_tmp85)));
				_tmp87 = NULL;
				_tmp86 = NULL;
				_tmp88 = NULL;
				cindex = (_tmp88 = (_tmp87 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (_tmp86 = gee_iterator_get (indices_it))))), (_tmp87 == NULL ? NULL : g_object_ref (_tmp87))), (_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL))), _tmp88);
				if (container_type != NULL && self->priv->list_type != NULL && self->priv->map_type != NULL && (container_type == self->priv->list_type || vala_data_type_is_subtype_of (container_type, self->priv->list_type) || container_type == self->priv->map_type || vala_data_type_is_subtype_of (container_type, self->priv->map_type))) {
					ValaMethod* set_method;
					GeeCollection* set_params;
					GeeIterator* set_params_it;
					ValaFormalParameter* set_param;
					ValaCCodeIdentifier* _tmp91;
					char* _tmp90;
					ValaCCodeFunctionCall* _tmp92;
					ValaCCodeFunctionCall* set_ccall;
					ValaCCodeCastExpression* _tmp95;
					char* _tmp94;
					char* _tmp93;
					ValaCCodeExpression* _tmp96;
					set_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) container_type)), "set"));
					set_params = vala_invokable_get_parameters (VALA_INVOKABLE (set_method));
					set_params_it = gee_iterable_iterator (GEE_ITERABLE (set_params));
					gee_iterator_next (set_params_it);
					set_param = gee_iterator_get (set_params_it);
					if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (set_param)) != NULL) {
						ValaTypeReference* index_type;
						ValaCCodeExpression* _tmp89;
						index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_element_access_get_container (expr)), VALA_SYMBOL (set_method), vala_formal_parameter_get_type_reference (set_param), VALA_CODE_NODE (a));
						_tmp89 = NULL;
						cindex = (_tmp89 = vala_code_generator_convert_to_generic_pointer (self, cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp89);
						(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
					}
					_tmp91 = NULL;
					_tmp90 = NULL;
					_tmp92 = NULL;
					set_ccall = (_tmp92 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_identifier_new ((_tmp90 = vala_method_get_cname (set_method)))))), (_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL))), (_tmp90 = (g_free (_tmp90), NULL)), _tmp92);
					_tmp95 = NULL;
					_tmp94 = NULL;
					_tmp93 = NULL;
					vala_ccode_function_call_add_argument (set_ccall, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_cast_expression_new (ccontainer, (_tmp94 = g_strconcat ((_tmp93 = vala_data_type_get_cname (container_type, FALSE)), "*", NULL))))));
					(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
					(_tmp94 = (g_free (_tmp94), NULL));
					(_tmp93 = (g_free (_tmp93), NULL));
					vala_ccode_function_call_add_argument (set_ccall, cindex);
					_tmp96 = NULL;
					vala_ccode_function_call_add_argument (set_ccall, (_tmp96 = vala_code_generator_convert_to_generic_pointer (self, rhs, vala_expression_get_static_type (((ValaExpression*) expr)))));
					(_tmp96 = (g_object_unref (_tmp96), NULL));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (set_ccall));
					(set_method == NULL ? NULL : (set_method = (g_object_unref (set_method), NULL)));
					(set_params == NULL ? NULL : (set_params = (g_object_unref (set_params), NULL)));
					(set_params_it == NULL ? NULL : (set_params_it = (g_object_unref (set_params_it), NULL)));
					(set_param == NULL ? NULL : (set_param = (g_object_unref (set_param), NULL)));
					(set_ccall == NULL ? NULL : (set_ccall = (g_object_unref (set_ccall), NULL)));
				} else {
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) a)), "internal error: unsupported element access");
					vala_code_node_set_error (VALA_CODE_NODE (a), TRUE);
				}
				(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
				(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
				(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
				(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
				(indices_it == NULL ? NULL : (indices_it = (g_object_unref (indices_it), NULL)));
				(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
				(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
			} else {
				ValaCCodeExpression* _tmp97;
				ValaCCodeExpression* rhs;
				gboolean unref_old;
				gboolean array;
				ValaCCodeAssignmentOperator cop;
				ValaCCodeAssignment* _tmp111;
				_tmp97 = NULL;
				rhs = (_tmp97 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_right (a)))), (_tmp97 == NULL ? NULL : g_object_ref (_tmp97)));
				if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) {
					ValaCCodeIdentifier* _tmp99;
					char* _tmp98;
					ValaCCodeFunctionCall* _tmp100;
					ValaCCodeFunctionCall* ccast;
					ValaCCodeExpression* _tmp102;
					ValaCCodeFunctionCall* _tmp101;
					_tmp99 = NULL;
					_tmp98 = NULL;
					_tmp100 = NULL;
					ccast = (_tmp100 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp99 = vala_ccode_identifier_new ((_tmp98 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))), NULL)))))), (_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL))), (_tmp98 = (g_free (_tmp98), NULL)), _tmp100);
					vala_ccode_function_call_add_argument (ccast, rhs);
					_tmp102 = NULL;
					_tmp101 = NULL;
					rhs = (_tmp102 = VALA_CCODE_EXPRESSION ((_tmp101 = ccast, (_tmp101 == NULL ? NULL : g_object_ref (_tmp101)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp102);
					(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
				}
				unref_old = (vala_code_generator_get_memory_management (self) && vala_type_reference_get_takes_ownership (vala_expression_get_static_type (vala_assignment_get_left (a))));
				array = FALSE;
				if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))))) {
					array = !(VALA_IS_CCODE_CONSTANT (vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1)));
				}
				if (unref_old || array) {
					ValaCCodeCommaExpression* ccomma;
					ValaVariableDeclarator* temp_decl;
					ValaCCodeAssignment* _tmp104;
					ValaCCodeIdentifier* _tmp103;
					ValaCCodeIdentifier* _tmp108;
					ValaCCodeExpression* _tmp110;
					ValaCCodeCommaExpression* _tmp109;
					ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
					temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_assignment_get_left (a)), TRUE);
					gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
					_tmp104 = NULL;
					_tmp103 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
					(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
					if (unref_old) {
						ValaCCodeExpression* _tmp105;
						/* unref old value */
						_tmp105 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (_tmp105 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a)))), vala_expression_get_static_type (vala_assignment_get_left (a)), vala_assignment_get_left (a))));
						(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
					}
					if (array) {
						ValaArray* _tmp106;
						ValaArray* arr;
						_tmp106 = NULL;
						arr = (_tmp106 = VALA_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))), (_tmp106 == NULL ? NULL : g_object_ref (_tmp106)));
						{
							gint dim;
							dim = 0;
							for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
								ValaCCodeExpression* lhs_array_len;
								ValaCCodeExpression* rhs_array_len;
								ValaCCodeAssignment* _tmp107;
								lhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), dim);
								rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_right (a), dim);
								_tmp107 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
								(lhs_array_len = (g_object_unref (lhs_array_len), NULL));
								(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
							}
						}
						(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
					}
					_tmp108 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
					(_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL)));
					_tmp110 = NULL;
					_tmp109 = NULL;
					rhs = (_tmp110 = VALA_CCODE_EXPRESSION ((_tmp109 = ccomma, (_tmp109 == NULL ? NULL : g_object_ref (_tmp109)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp110);
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
				}
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
												cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
													cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
												} else {
													if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
														cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp111 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE ((_tmp111 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a)))), rhs, cop))));
				(_tmp111 == NULL ? NULL : (_tmp111 = (g_object_unref (_tmp111), NULL)));
				if (unref_old && VALA_IS_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a))))) {
					ValaCCodeElementAccess* _tmp112;
					ValaCCodeElementAccess* cea;
					/* ensure that index expression in element access doesn't get evaluated more than once
					 except when it's a simple expression*/
					_tmp112 = NULL;
					cea = (_tmp112 = VALA_CCODE_ELEMENT_ACCESS (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_assignment_get_left (a)))), (_tmp112 == NULL ? NULL : g_object_ref (_tmp112)));
					if (!(VALA_IS_CCODE_CONSTANT (vala_ccode_element_access_get_index (cea)) || VALA_IS_CCODE_IDENTIFIER (vala_ccode_element_access_get_index (cea)))) {
						ValaVariableDeclarator* index_temp_decl;
						ValaCCodeCommaExpression* ccomma;
						ValaCCodeAssignment* _tmp114;
						ValaCCodeIdentifier* _tmp113;
						ValaCCodeIdentifier* _tmp115;
						index_temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
						gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, index_temp_decl);
						ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
						_tmp114 = NULL;
						_tmp113 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp114 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp113 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) index_temp_decl))))), vala_ccode_element_access_get_index (cea), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
						(_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL)));
						(_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL)));
						vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) a))));
						_tmp115 = NULL;
						vala_ccode_element_access_set_index (cea, VALA_CCODE_EXPRESSION ((_tmp115 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) index_temp_decl))))));
						(_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL)));
						vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma));
						(index_temp_decl == NULL ? NULL : (index_temp_decl = (g_object_unref (index_temp_decl), NULL)));
						(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					}
					(cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL)));
				}
				(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
			}
		}
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr)
{
	ValaClass* _tmp0;
	ValaClass* cl;
	char* set_func;
	ValaProperty* base_property;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpression* instance;
	gboolean req_cast;
	ValaCCodeFunctionCall* _tmp20;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (ma), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) prop))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	set_func = g_strdup ("g_object_set");
	base_property = g_object_ref (prop);
	if (!vala_property_get_no_accessor_method (prop)) {
		ValaDataType* _tmp5;
		ValaDataType* base_property_type;
		char* _tmp7;
		char* _tmp6;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* _tmp2;
			ValaProperty* _tmp1;
			_tmp2 = NULL;
			_tmp1 = NULL;
			base_property = (_tmp2 = (_tmp1 = vala_property_get_base_property (prop), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (base_property = (g_object_unref (base_property), NULL)), _tmp2);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* _tmp4;
				ValaProperty* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				base_property = (_tmp4 = (_tmp3 = vala_property_get_base_interface_property (prop), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (base_property = (g_object_unref (base_property), NULL)), _tmp4);
			}
		}
		_tmp5 = NULL;
		base_property_type = (_tmp5 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) base_property))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
		_tmp7 = NULL;
		_tmp6 = NULL;
		set_func = (_tmp7 = g_strdup_printf ("%s_set_%s", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (((ValaSymbol*) base_property))), (set_func = (g_free (set_func), NULL)), _tmp7);
		(_tmp6 = (g_free (_tmp6), NULL));
		(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
	}
	_tmp8 = NULL;
	_tmp9 = NULL;
	ccall = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new (set_func)))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	/* target instance is first argument */
	instance = NULL;
	req_cast = FALSE;
	if (vala_member_access_get_inner (ma) == NULL) {
		ValaCCodeExpression* _tmp10;
		_tmp10 = NULL;
		instance = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp10);
		/* require casts for inherited properties */
		req_cast = (vala_symbol_get_parent_symbol (((ValaSymbol*) base_property)) != self->priv->current_type_symbol);
	} else {
		ValaCCodeExpression* _tmp12;
		ValaCCodeExpression* _tmp11;
		_tmp12 = NULL;
		_tmp11 = NULL;
		instance = (_tmp12 = (_tmp11 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp12);
		/* require casts if the type of the used instance is
		 * different than the type which declared the property */
		req_cast = vala_symbol_get_parent_symbol (((ValaSymbol*) base_property)) != VALA_SYMBOL (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
	}
	if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) prop)))))) {
		ValaCCodeIdentifier* _tmp14;
		char* _tmp13;
		ValaCCodeFunctionCall* _tmp15;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeExpression* _tmp17;
		ValaCCodeFunctionCall* _tmp16;
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp15 = NULL;
		ccast = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) base_property)))), NULL)))))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), (_tmp13 = (g_free (_tmp13), NULL)), _tmp15);
		vala_ccode_function_call_add_argument (ccast, instance);
		_tmp17 = NULL;
		_tmp16 = NULL;
		instance = (_tmp17 = VALA_CCODE_EXPRESSION ((_tmp16 = ccast, (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp17);
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, instance);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp18;
		/* property name is second argument of g_object_set */
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_property_get_canonical_cconstant (prop))));
		(_tmp18 = (g_object_unref (_tmp18), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp19;
		_tmp19 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("NULL"))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	}
	_tmp20 = NULL;
	return (_tmp20 = ccall, (cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL))), (set_func = (g_free (set_func), NULL)), (base_property = (g_object_unref (base_property), NULL)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp20);
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(set_func = (g_free (set_func), NULL));
	(base_property = (g_object_unref (base_property), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
}


static void vala_code_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaCodeGenerator * self;
	ValaSymbol* _tmp0;
	ValaSymbol* old_symbol;
	ValaSymbol* _tmp1;
	ValaSymbol* old_type_symbol;
	ValaClass* _tmp2;
	ValaClass* old_class;
	ValaCCodeStruct* _tmp3;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeStruct* _tmp4;
	ValaCCodeStruct* old_type_struct;
	ValaCCodeStruct* _tmp5;
	ValaCCodeStruct* old_instance_priv_struct;
	ValaCCodeEnum* _tmp6;
	ValaCCodeEnum* old_prop_enum;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* old_class_init_fragment;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* old_instance_init_fragment;
	ValaCCodeFragment* _tmp9;
	ValaCCodeFragment* old_instance_dispose_fragment;
	ValaSymbol* _tmp10;
	ValaSymbol* _tmp11;
	ValaClass* _tmp12;
	gboolean is_gobject;
	char* _tmp13;
	gboolean _tmp14;
	ValaCCodeStruct* _tmp19;
	char* _tmp18;
	char* _tmp17;
	ValaCCodeStruct* _tmp22;
	char* _tmp21;
	char* _tmp20;
	ValaCCodeStruct* _tmp25;
	char* _tmp24;
	char* _tmp23;
	ValaCCodeEnum* _tmp26;
	char* _tmp28;
	char* _tmp27;
	ValaCCodeFragment* _tmp29;
	ValaCCodeFragment* _tmp30;
	ValaCCodeFragment* _tmp31;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	char* _tmp40;
	char* _tmp41;
	char* macro;
	ValaSymbol* _tmp131;
	ValaSymbol* _tmp130;
	ValaClass* _tmp133;
	ValaClass* _tmp132;
	ValaCCodeStruct* _tmp135;
	ValaCCodeStruct* _tmp134;
	ValaCCodeStruct* _tmp137;
	ValaCCodeStruct* _tmp136;
	ValaCCodeStruct* _tmp139;
	ValaCCodeStruct* _tmp138;
	ValaCCodeEnum* _tmp141;
	ValaCCodeEnum* _tmp140;
	ValaCCodeFragment* _tmp143;
	ValaCCodeFragment* _tmp142;
	ValaCCodeFragment* _tmp145;
	ValaCCodeFragment* _tmp144;
	ValaCCodeFragment* _tmp147;
	ValaCCodeFragment* _tmp146;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp0 = NULL;
	old_symbol = (_tmp0 = self->priv->current_symbol, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_type_symbol = (_tmp1 = self->priv->current_type_symbol, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_class = (_tmp2 = self->priv->current_class, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	old_instance_struct = (_tmp3 = self->priv->instance_struct, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	_tmp4 = NULL;
	old_type_struct = (_tmp4 = self->priv->type_struct, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
	_tmp5 = NULL;
	old_instance_priv_struct = (_tmp5 = self->priv->instance_priv_struct, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
	_tmp6 = NULL;
	old_prop_enum = (_tmp6 = self->priv->prop_enum, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
	_tmp7 = NULL;
	old_class_init_fragment = (_tmp7 = self->priv->class_init_fragment, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	_tmp8 = NULL;
	old_instance_init_fragment = (_tmp8 = self->priv->instance_init_fragment, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
	_tmp9 = NULL;
	old_instance_dispose_fragment = (_tmp9 = self->priv->instance_dispose_fragment, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
	_tmp10 = NULL;
	self->priv->current_symbol = (_tmp10 = VALA_SYMBOL (g_object_ref (cl)), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp10);
	_tmp11 = NULL;
	self->priv->current_type_symbol = (_tmp11 = VALA_SYMBOL (g_object_ref (cl)), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), _tmp11);
	_tmp12 = NULL;
	self->priv->current_class = (_tmp12 = g_object_ref (cl), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), _tmp12);
	is_gobject = vala_data_type_is_subtype_of (VALA_DATA_TYPE (cl), self->priv->gobject_type);
	_tmp13 = NULL;
	if ((_tmp14 = g_utf8_strlen ((_tmp13 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)), -1) < 3, (_tmp13 = (g_free (_tmp13), NULL)), _tmp14)) {
		char* _tmp16;
		char* _tmp15;
		vala_code_node_set_error (VALA_CODE_NODE (cl), TRUE);
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) cl)), (_tmp16 = g_strdup_printf ("Class name `%s' is too short", (_tmp15 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))));
		(_tmp16 = (g_free (_tmp16), NULL));
		(_tmp15 = (g_free (_tmp15), NULL));
		(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
		(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
		(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
		(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
		(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
		(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
		(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
		(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (g_object_unref (old_class_init_fragment), NULL)));
		(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
		(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
		return;
	}
	if (vala_class_get_is_static (cl)) {
		(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
		(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
		(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
		(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
		(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
		(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
		(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
		(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (g_object_unref (old_class_init_fragment), NULL)));
		(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
		(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
		return;
	}
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	self->priv->instance_struct = (_tmp19 = vala_ccode_struct_new ((_tmp18 = g_strdup_printf ("_%s", (_tmp17 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), _tmp19);
	(_tmp18 = (g_free (_tmp18), NULL));
	(_tmp17 = (g_free (_tmp17), NULL));
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->priv->type_struct = (_tmp22 = vala_ccode_struct_new ((_tmp21 = g_strdup_printf ("_%sClass", (_tmp20 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), _tmp22);
	(_tmp21 = (g_free (_tmp21), NULL));
	(_tmp20 = (g_free (_tmp20), NULL));
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	self->priv->instance_priv_struct = (_tmp25 = vala_ccode_struct_new ((_tmp24 = g_strdup_printf ("_%sPrivate", (_tmp23 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), _tmp25);
	(_tmp24 = (g_free (_tmp24), NULL));
	(_tmp23 = (g_free (_tmp23), NULL));
	_tmp26 = NULL;
	self->priv->prop_enum = (_tmp26 = vala_ccode_enum_new (NULL), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), _tmp26);
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_enum_add_value (self->priv->prop_enum, (_tmp28 = g_strdup_printf ("%s_DUMMY_PROPERTY", (_tmp27 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), NULL);
	(_tmp28 = (g_free (_tmp28), NULL));
	(_tmp27 = (g_free (_tmp27), NULL));
	_tmp29 = NULL;
	self->priv->class_init_fragment = (_tmp29 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->class_init_fragment == NULL ? NULL : (self->priv->class_init_fragment = (g_object_unref (self->priv->class_init_fragment), NULL))), _tmp29);
	_tmp30 = NULL;
	self->priv->instance_init_fragment = (_tmp30 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), _tmp30);
	_tmp31 = NULL;
	self->priv->instance_dispose_fragment = (_tmp31 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), _tmp31);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (((ValaSymbol*) cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp33;
		ValaCCodeFragment* _tmp32;
		ValaCCodeFragment* _tmp35;
		ValaCCodeFragment* _tmp34;
		_tmp33 = NULL;
		_tmp32 = NULL;
		decl_frag = (_tmp33 = (_tmp32 = self->priv->header_type_declaration, (_tmp32 == NULL ? NULL : g_object_ref (_tmp32))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp33);
		_tmp35 = NULL;
		_tmp34 = NULL;
		def_frag = (_tmp35 = (_tmp34 = self->priv->header_type_definition, (_tmp34 == NULL ? NULL : g_object_ref (_tmp34))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp35);
	} else {
		ValaCCodeFragment* _tmp37;
		ValaCCodeFragment* _tmp36;
		ValaCCodeFragment* _tmp39;
		ValaCCodeFragment* _tmp38;
		_tmp37 = NULL;
		_tmp36 = NULL;
		decl_frag = (_tmp37 = (_tmp36 = self->priv->source_type_member_declaration, (_tmp36 == NULL ? NULL : g_object_ref (_tmp36))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp37);
		_tmp39 = NULL;
		_tmp38 = NULL;
		def_frag = (_tmp39 = (_tmp38 = self->priv->source_type_member_declaration, (_tmp38 == NULL ? NULL : g_object_ref (_tmp38))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp39);
	}
	_tmp40 = NULL;
	_tmp41 = NULL;
	macro = (_tmp41 = g_strdup_printf ("(%s_get_type ())", (_tmp40 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))), (_tmp40 = (g_free (_tmp40), NULL)), _tmp41);
	if (is_gobject) {
		ValaCCodeNewline* _tmp42;
		ValaCCodeMacroReplacement* _tmp44;
		char* _tmp43;
		char* _tmp47;
		char* _tmp46;
		char* _tmp45;
		ValaCCodeMacroReplacement* _tmp50;
		char* _tmp49;
		char* _tmp48;
		char* _tmp53;
		char* _tmp52;
		char* _tmp51;
		ValaCCodeMacroReplacement* _tmp56;
		char* _tmp55;
		char* _tmp54;
		char* _tmp58;
		char* _tmp57;
		ValaCCodeMacroReplacement* _tmp61;
		char* _tmp60;
		char* _tmp59;
		char* _tmp63;
		char* _tmp62;
		ValaCCodeMacroReplacement* _tmp66;
		char* _tmp65;
		char* _tmp64;
		char* _tmp69;
		char* _tmp68;
		char* _tmp67;
		ValaCCodeMacroReplacement* _tmp72;
		char* _tmp71;
		char* _tmp70;
		ValaCCodeNewline* _tmp73;
		_tmp42 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp42 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
		_tmp44 = NULL;
		_tmp43 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp44 = vala_ccode_macro_replacement_new ((_tmp43 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), macro))));
		(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
		(_tmp43 = (g_free (_tmp43), NULL));
		_tmp47 = NULL;
		_tmp46 = NULL;
		_tmp45 = NULL;
		macro = (_tmp47 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (_tmp45 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (_tmp46 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp47);
		(_tmp46 = (g_free (_tmp46), NULL));
		(_tmp45 = (g_free (_tmp45), NULL));
		_tmp50 = NULL;
		_tmp49 = NULL;
		_tmp48 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp50 = vala_ccode_macro_replacement_new ((_tmp49 = g_strdup_printf ("%s(obj)", (_tmp48 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), macro))));
		(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
		(_tmp49 = (g_free (_tmp49), NULL));
		(_tmp48 = (g_free (_tmp48), NULL));
		_tmp53 = NULL;
		_tmp52 = NULL;
		_tmp51 = NULL;
		macro = (_tmp53 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", (_tmp51 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (_tmp52 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp53);
		(_tmp52 = (g_free (_tmp52), NULL));
		(_tmp51 = (g_free (_tmp51), NULL));
		_tmp56 = NULL;
		_tmp55 = NULL;
		_tmp54 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp56 = vala_ccode_macro_replacement_new ((_tmp55 = g_strdup_printf ("%s_CLASS(klass)", (_tmp54 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), macro))));
		(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
		(_tmp55 = (g_free (_tmp55), NULL));
		(_tmp54 = (g_free (_tmp54), NULL));
		_tmp58 = NULL;
		_tmp57 = NULL;
		macro = (_tmp58 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (_tmp57 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), _tmp58);
		(_tmp57 = (g_free (_tmp57), NULL));
		_tmp61 = NULL;
		_tmp60 = NULL;
		_tmp59 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp61 = vala_ccode_macro_replacement_new ((_tmp60 = g_strdup_printf ("%s(obj)", (_tmp59 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_")))), macro))));
		(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
		(_tmp60 = (g_free (_tmp60), NULL));
		(_tmp59 = (g_free (_tmp59), NULL));
		_tmp63 = NULL;
		_tmp62 = NULL;
		macro = (_tmp63 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", (_tmp62 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), _tmp63);
		(_tmp62 = (g_free (_tmp62), NULL));
		_tmp66 = NULL;
		_tmp65 = NULL;
		_tmp64 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp66 = vala_ccode_macro_replacement_new ((_tmp65 = g_strdup_printf ("%s_CLASS(klass)", (_tmp64 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_")))), macro))));
		(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
		(_tmp65 = (g_free (_tmp65), NULL));
		(_tmp64 = (g_free (_tmp64), NULL));
		_tmp69 = NULL;
		_tmp68 = NULL;
		_tmp67 = NULL;
		macro = (_tmp69 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", (_tmp67 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (_tmp68 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp69);
		(_tmp68 = (g_free (_tmp68), NULL));
		(_tmp67 = (g_free (_tmp67), NULL));
		_tmp72 = NULL;
		_tmp71 = NULL;
		_tmp70 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp72 = vala_ccode_macro_replacement_new ((_tmp71 = g_strdup_printf ("%s_GET_CLASS(obj)", (_tmp70 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), macro))));
		(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
		(_tmp71 = (g_free (_tmp71), NULL));
		(_tmp70 = (g_free (_tmp70), NULL));
		_tmp73 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp73 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
	}
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) cl)))) == NULL) {
		ValaCCodeTypeDefinition* _tmp77;
		ValaCCodeVariableDeclarator* _tmp76;
		char* _tmp75;
		char* _tmp74;
		_tmp77 = NULL;
		_tmp76 = NULL;
		_tmp75 = NULL;
		_tmp74 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp77 = vala_ccode_type_definition_new ((_tmp74 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_struct))), VALA_CCODE_DECLARATOR ((_tmp76 = vala_ccode_variable_declarator_new ((_tmp75 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
		(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
		(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
		(_tmp75 = (g_free (_tmp75), NULL));
		(_tmp74 = (g_free (_tmp74), NULL));
	}
	if (is_gobject) {
		ValaCCodeTypeDefinition* _tmp87;
		ValaCCodeVariableDeclarator* _tmp86;
		char* _tmp85;
		char* _tmp84;
		char* _tmp83;
		char* _tmp88;
		char* _tmp90;
		char* _tmp89;
		char* _tmp92;
		char* _tmp91;
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) cl)))) == NULL) {
			ValaCCodeTypeDefinition* _tmp82;
			ValaCCodeVariableDeclarator* _tmp81;
			char* _tmp80;
			char* _tmp79;
			char* _tmp78;
			_tmp82 = NULL;
			_tmp81 = NULL;
			_tmp80 = NULL;
			_tmp79 = NULL;
			_tmp78 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp82 = vala_ccode_type_definition_new ((_tmp78 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct))), VALA_CCODE_DECLARATOR ((_tmp81 = vala_ccode_variable_declarator_new ((_tmp80 = g_strdup_printf ("%sClass", (_tmp79 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))))));
			(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
			(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
			(_tmp80 = (g_free (_tmp80), NULL));
			(_tmp79 = (g_free (_tmp79), NULL));
			(_tmp78 = (g_free (_tmp78), NULL));
		}
		_tmp87 = NULL;
		_tmp86 = NULL;
		_tmp85 = NULL;
		_tmp84 = NULL;
		_tmp83 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp87 = vala_ccode_type_definition_new ((_tmp83 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_priv_struct))), VALA_CCODE_DECLARATOR ((_tmp86 = vala_ccode_variable_declarator_new ((_tmp85 = g_strdup_printf ("%sPrivate", (_tmp84 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))))));
		(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
		(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
		(_tmp85 = (g_free (_tmp85), NULL));
		(_tmp84 = (g_free (_tmp84), NULL));
		(_tmp83 = (g_free (_tmp83), NULL));
		_tmp88 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_struct, (_tmp88 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)), "parent");
		(_tmp88 = (g_free (_tmp88), NULL));
		_tmp90 = NULL;
		_tmp89 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_struct, (_tmp90 = g_strdup_printf ("%sPrivate *", (_tmp89 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), "priv");
		(_tmp90 = (g_free (_tmp90), NULL));
		(_tmp89 = (g_free (_tmp89), NULL));
		_tmp92 = NULL;
		_tmp91 = NULL;
		vala_ccode_struct_add_field (self->priv->type_struct, (_tmp92 = g_strdup_printf ("%sClass", (_tmp91 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)))), "parent");
		(_tmp92 = (g_free (_tmp92), NULL));
		(_tmp91 = (g_free (_tmp91), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) cl))) != NULL) {
		ValaCCodeComment* _tmp93;
		_tmp93 = NULL;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp93 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) cl)))))));
		(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
	}
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->instance_struct));
	if (is_gobject) {
		GeeCollection* _tmp94;
		gboolean _tmp95;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->type_struct));
		/* only add the *Private struct if it is not empty, i.e. we actually have private data */
		_tmp94 = NULL;
		if ((_tmp95 = vala_class_get_has_private_fields (cl) || gee_collection_get_size ((_tmp94 = vala_class_get_type_parameters (cl))) > 0, (_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL))), _tmp95)) {
			char* _tmp98;
			char* _tmp97;
			char* _tmp96;
			ValaCCodeMacroReplacement* _tmp101;
			char* _tmp100;
			char* _tmp99;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->instance_priv_struct));
			_tmp98 = NULL;
			_tmp97 = NULL;
			_tmp96 = NULL;
			macro = (_tmp98 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", (_tmp96 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (_tmp97 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp98);
			(_tmp97 = (g_free (_tmp97), NULL));
			(_tmp96 = (g_free (_tmp96), NULL));
			_tmp101 = NULL;
			_tmp100 = NULL;
			_tmp99 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp101 = vala_ccode_macro_replacement_new ((_tmp100 = g_strdup_printf ("%s_GET_PRIVATE(o)", (_tmp99 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), macro))));
			(_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL)));
			(_tmp100 = (g_free (_tmp100), NULL));
			(_tmp99 = (g_free (_tmp99), NULL));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->prop_enum));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
	if (is_gobject) {
		GeeCollection* _tmp102;
		gboolean _tmp103;
		GeeCollection* _tmp104;
		gboolean _tmp105;
		GeeCollection* _tmp106;
		gboolean _tmp107;
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp110;
		_tmp102 = NULL;
		if ((_tmp103 = vala_code_generator_class_has_readable_properties (self, cl) || gee_collection_get_size ((_tmp102 = vala_class_get_type_parameters (cl))) > 0, (_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL))), _tmp103)) {
			vala_code_generator_add_get_property_function (self, cl);
		}
		_tmp104 = NULL;
		if ((_tmp105 = vala_code_generator_class_has_writable_properties (self, cl) || gee_collection_get_size ((_tmp104 = vala_class_get_type_parameters (cl))) > 0, (_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL))), _tmp105)) {
			vala_code_generator_add_set_property_function (self, cl);
		}
		vala_code_generator_add_class_init_function (self, cl);
		{
			GeeCollection* base_type_collection;
			GeeIterator* base_type_it;
			base_type_collection = vala_class_get_base_types (cl);
			base_type_it = gee_iterable_iterator (GEE_ITERABLE (base_type_collection));
			while (gee_iterator_next (base_type_it)) {
				ValaTypeReference* base_type;
				base_type = gee_iterator_get (base_type_it);
				{
					if (VALA_IS_INTERFACE (vala_type_reference_get_data_type (base_type))) {
						vala_code_generator_add_interface_init_function (self, cl, VALA_INTERFACE (vala_type_reference_get_data_type (base_type)));
					}
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (g_object_unref (base_type_collection), NULL)));
			(base_type_it == NULL ? NULL : (base_type_it = (g_object_unref (base_type_it), NULL)));
		}
		vala_code_generator_add_instance_init_function (self, cl);
		_tmp106 = NULL;
		if ((_tmp107 = (vala_code_generator_get_memory_management (self) && gee_collection_get_size ((_tmp106 = vala_class_get_fields (cl))) > 0) || vala_class_get_destructor (cl) != NULL, (_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL))), _tmp107)) {
			vala_code_generator_add_dispose_function (self, cl);
		}
		type_fun = vala_class_register_function_new (cl);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), self->priv->in_plugin);
		if (vala_symbol_get_access (((ValaSymbol*) cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFragment* _tmp108;
			_tmp108 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp108 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
			(_tmp108 = (g_object_unref (_tmp108), NULL));
		} else {
			ValaCCodeFragment* _tmp109;
			_tmp109 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp109 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
			(_tmp109 = (g_object_unref (_tmp109), NULL));
		}
		_tmp110 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp110 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(_tmp110 = (g_object_unref (_tmp110), NULL));
		if (self->priv->in_plugin) {
			ValaCCodeIdentifier* _tmp113;
			char* _tmp112;
			char* _tmp111;
			ValaCCodeFunctionCall* _tmp114;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* _tmp115;
			ValaCCodeExpressionStatement* _tmp116;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			_tmp113 = NULL;
			_tmp112 = NULL;
			_tmp111 = NULL;
			_tmp114 = NULL;
			register_call = (_tmp114 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp113 = vala_ccode_identifier_new ((_tmp112 = g_strdup_printf ("%s_register_type", (_tmp111 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))))))), (_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL))), (_tmp112 = (g_free (_tmp112), NULL)), (_tmp111 = (g_free (_tmp111), NULL)), _tmp114);
			_tmp115 = NULL;
			vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp115 = vala_ccode_identifier_new (self->priv->module_init_param_name))));
			(_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL)));
			_tmp116 = NULL;
			vala_ccode_fragment_append (self->priv->module_init_fragment, VALA_CCODE_NODE ((_tmp116 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
			(_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL)));
			(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
		}
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	} else {
		if (vala_class_get_default_construction_method (cl) != NULL) {
			char* _tmp118;
			char* _tmp117;
			ValaCCodeFunction* _tmp119;
			ValaCCodeFunction* function;
			ValaCCodeFormalParameter* _tmp122;
			char* _tmp121;
			char* _tmp120;
			ValaCCodeFunction* _tmp123;
			ValaCCodeBlock* cblock;
			ValaCCodeIdentifier* _tmp124;
			ValaCCodeFunctionCall* _tmp125;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp127;
			char* _tmp126;
			ValaCCodeIdentifier* _tmp128;
			ValaCCodeExpressionStatement* _tmp129;
			_tmp118 = NULL;
			_tmp117 = NULL;
			_tmp119 = NULL;
			function = (_tmp119 = vala_ccode_function_new ((_tmp118 = g_strconcat ((_tmp117 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (cl))), "free", NULL)), "void"), (_tmp118 = (g_free (_tmp118), NULL)), (_tmp117 = (g_free (_tmp117), NULL)), _tmp119);
			if (vala_symbol_get_access (((ValaSymbol*) cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp122 = NULL;
			_tmp121 = NULL;
			_tmp120 = NULL;
			vala_ccode_function_add_parameter (function, (_tmp122 = vala_ccode_formal_parameter_new ("self", (_tmp121 = g_strconcat ((_tmp120 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)), "*", NULL)))));
			(_tmp122 == NULL ? NULL : (_tmp122 = (g_object_unref (_tmp122), NULL)));
			(_tmp121 = (g_free (_tmp121), NULL));
			(_tmp120 = (g_free (_tmp120), NULL));
			_tmp123 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp123 = vala_ccode_function_copy (function))));
			(_tmp123 = (g_object_unref (_tmp123), NULL));
			cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
			_tmp124 = NULL;
			_tmp125 = NULL;
			ccall = (_tmp125 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_identifier_new ("g_slice_free")))), (_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL))), _tmp125);
			_tmp127 = NULL;
			_tmp126 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_identifier_new ((_tmp126 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))));
			(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
			(_tmp126 = (g_free (_tmp126), NULL));
			_tmp128 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_identifier_new ("self"))));
			(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
			_tmp129 = NULL;
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp129 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
			vala_ccode_function_set_block (function, cblock);
			vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (function));
			(function == NULL ? NULL : (function = (g_object_unref (function), NULL)));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
	}
	_tmp131 = NULL;
	_tmp130 = NULL;
	self->priv->current_type_symbol = (_tmp131 = (_tmp130 = old_type_symbol, (_tmp130 == NULL ? NULL : g_object_ref (_tmp130))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), _tmp131);
	_tmp133 = NULL;
	_tmp132 = NULL;
	self->priv->current_class = (_tmp133 = (_tmp132 = old_class, (_tmp132 == NULL ? NULL : g_object_ref (_tmp132))), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), _tmp133);
	_tmp135 = NULL;
	_tmp134 = NULL;
	self->priv->instance_struct = (_tmp135 = (_tmp134 = old_instance_struct, (_tmp134 == NULL ? NULL : g_object_ref (_tmp134))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), _tmp135);
	_tmp137 = NULL;
	_tmp136 = NULL;
	self->priv->type_struct = (_tmp137 = (_tmp136 = old_type_struct, (_tmp136 == NULL ? NULL : g_object_ref (_tmp136))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), _tmp137);
	_tmp139 = NULL;
	_tmp138 = NULL;
	self->priv->instance_priv_struct = (_tmp139 = (_tmp138 = old_instance_priv_struct, (_tmp138 == NULL ? NULL : g_object_ref (_tmp138))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), _tmp139);
	_tmp141 = NULL;
	_tmp140 = NULL;
	self->priv->prop_enum = (_tmp141 = (_tmp140 = old_prop_enum, (_tmp140 == NULL ? NULL : g_object_ref (_tmp140))), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), _tmp141);
	_tmp143 = NULL;
	_tmp142 = NULL;
	self->priv->class_init_fragment = (_tmp143 = (_tmp142 = old_class_init_fragment, (_tmp142 == NULL ? NULL : g_object_ref (_tmp142))), (self->priv->class_init_fragment == NULL ? NULL : (self->priv->class_init_fragment = (g_object_unref (self->priv->class_init_fragment), NULL))), _tmp143);
	_tmp145 = NULL;
	_tmp144 = NULL;
	self->priv->instance_init_fragment = (_tmp145 = (_tmp144 = old_instance_init_fragment, (_tmp144 == NULL ? NULL : g_object_ref (_tmp144))), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), _tmp145);
	_tmp147 = NULL;
	_tmp146 = NULL;
	self->priv->instance_dispose_fragment = (_tmp147 = (_tmp146 = old_instance_dispose_fragment, (_tmp146 == NULL ? NULL : g_object_ref (_tmp146))), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), _tmp147);
	(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
	(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
	(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
	(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
	(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
	(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (g_object_unref (old_class_init_fragment), NULL)));
	(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
	(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
	(macro = (g_free (macro), NULL));
}


static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp9;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp17;
	GeeCollection* _tmp18;
	gboolean _tmp19;
	ValaCCodeFunctionCall* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeIdentifier* _tmp29;
	GeeCollection* _tmp30;
	gboolean _tmp31;
	GeeCollection* _tmp38;
	gboolean _tmp39;
	GeeCollection* _tmp55;
	gboolean _tmp56;
	GeeCollection* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	class_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_class_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (class_init, (_tmp5 = vala_ccode_formal_parameter_new ("klass", (_tmp4 = g_strdup_printf ("%sClass *", (_tmp3 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	(_tmp3 = (g_free (_tmp3), NULL));
	vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	vala_ccode_function_set_block (class_init, init_block);
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	parent_var_decl = (_tmp8 = vala_ccode_variable_declarator_new ((_tmp7 = g_strdup_printf ("%s_parent_class", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))), (_tmp7 = (g_free (_tmp7), NULL)), (_tmp6 = (g_free (_tmp6), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	_tmp11 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("klass"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp16 = NULL;
	parent_assignment = (_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = g_strdup_printf ("%s_parent_class", (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), (_tmp14 = (g_free (_tmp14), NULL)), (_tmp13 = (g_free (_tmp13), NULL)), _tmp16);
	_tmp17 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	/* add struct for private fields */
	_tmp18 = NULL;
	if ((_tmp19 = vala_class_get_has_private_fields (cl) || gee_collection_get_size ((_tmp18 = vala_class_get_type_parameters (cl))) > 0, (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp19)) {
		ValaCCodeFunctionCall* _tmp21;
		ValaCCodeIdentifier* _tmp20;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeConstant* _tmp25;
		char* _tmp24;
		char* _tmp23;
		ValaCCodeExpressionStatement* _tmp26;
		_tmp21 = NULL;
		_tmp20 = NULL;
		ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_type_class_add_private")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp21);
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("klass"))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ((_tmp24 = g_strdup_printf ("sizeof (%sPrivate)", (_tmp23 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		(_tmp24 = (g_free (_tmp24), NULL));
		(_tmp23 = (g_free (_tmp23), NULL));
		_tmp26 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp26 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	}
	/* set property handlers */
	_tmp28 = NULL;
	_tmp27 = NULL;
	ccall = (_tmp28 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp28);
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("klass"))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	if ((_tmp31 = vala_code_generator_class_has_readable_properties (self, cl) || gee_collection_get_size ((_tmp30 = vala_class_get_type_parameters (cl))) > 0, (_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL))), _tmp31)) {
		ValaCCodeExpressionStatement* _tmp37;
		ValaCCodeAssignment* _tmp36;
		ValaCCodeIdentifier* _tmp35;
		char* _tmp34;
		char* _tmp33;
		ValaCCodeMemberAccess* _tmp32;
		_tmp37 = NULL;
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp37 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "get_property"))), VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ((_tmp34 = g_strdup_printf ("%s_get_property", (_tmp33 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		(_tmp34 = (g_free (_tmp34), NULL));
		(_tmp33 = (g_free (_tmp33), NULL));
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	}
	_tmp38 = NULL;
	if ((_tmp39 = vala_code_generator_class_has_writable_properties (self, cl) || gee_collection_get_size ((_tmp38 = vala_class_get_type_parameters (cl))) > 0, (_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL))), _tmp39)) {
		ValaCCodeExpressionStatement* _tmp45;
		ValaCCodeAssignment* _tmp44;
		ValaCCodeIdentifier* _tmp43;
		char* _tmp42;
		char* _tmp41;
		ValaCCodeMemberAccess* _tmp40;
		_tmp45 = NULL;
		_tmp44 = NULL;
		_tmp43 = NULL;
		_tmp42 = NULL;
		_tmp41 = NULL;
		_tmp40 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp45 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "set_property"))), VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ((_tmp42 = g_strdup_printf ("%s_set_property", (_tmp41 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
		(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
		(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
		(_tmp42 = (g_free (_tmp42), NULL));
		(_tmp41 = (g_free (_tmp41), NULL));
		(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
	}
	/* set constructor */
	if (vala_class_get_constructor (cl) != NULL) {
		ValaCCodeIdentifier* _tmp46;
		ValaCCodeFunctionCall* _tmp47;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* _tmp48;
		ValaCCodeExpressionStatement* _tmp54;
		ValaCCodeAssignment* _tmp53;
		ValaCCodeIdentifier* _tmp52;
		char* _tmp51;
		char* _tmp50;
		ValaCCodeMemberAccess* _tmp49;
		_tmp46 = NULL;
		_tmp47 = NULL;
		ccast = (_tmp47 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL))), _tmp47);
		_tmp48 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new ("klass"))));
		(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
		_tmp54 = NULL;
		_tmp53 = NULL;
		_tmp52 = NULL;
		_tmp51 = NULL;
		_tmp50 = NULL;
		_tmp49 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp54 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "constructor"))), VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ((_tmp51 = g_strdup_printf ("%s_constructor", (_tmp50 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
		(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
		(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		(_tmp51 = (g_free (_tmp51), NULL));
		(_tmp50 = (g_free (_tmp50), NULL));
		(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	/* set dispose function */
	_tmp55 = NULL;
	if ((_tmp56 = vala_code_generator_get_memory_management (self) && gee_collection_get_size ((_tmp55 = vala_class_get_fields (cl))) > 0, (_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL))), _tmp56)) {
		ValaCCodeIdentifier* _tmp57;
		ValaCCodeFunctionCall* _tmp58;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* _tmp59;
		ValaCCodeExpressionStatement* _tmp65;
		ValaCCodeAssignment* _tmp64;
		ValaCCodeIdentifier* _tmp63;
		char* _tmp62;
		char* _tmp61;
		ValaCCodeMemberAccess* _tmp60;
		_tmp57 = NULL;
		_tmp58 = NULL;
		ccast = (_tmp58 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL))), _tmp58);
		_tmp59 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("klass"))));
		(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
		_tmp65 = NULL;
		_tmp64 = NULL;
		_tmp63 = NULL;
		_tmp62 = NULL;
		_tmp61 = NULL;
		_tmp60 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp65 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose"))), VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_identifier_new ((_tmp62 = g_strdup_printf ("%s_dispose", (_tmp61 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
		(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
		(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
		(_tmp62 = (g_free (_tmp62), NULL));
		(_tmp61 = (g_free (_tmp61), NULL));
		(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	{
		GeeCollection* m_collection;
		GeeIterator* m_it;
		m_collection = vala_class_get_methods (cl);
		m_it = gee_iterable_iterator (GEE_ITERABLE (m_collection));
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			m = gee_iterator_get (m_it);
			{
				ValaSymbol* _tmp66;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* _tmp69;
				char* _tmp68;
				char* _tmp67;
				ValaCCodeFunctionCall* _tmp70;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeIdentifier* _tmp71;
				ValaCCodeExpressionStatement* _tmp76;
				ValaCCodeAssignment* _tmp75;
				ValaCCodeIdentifier* _tmp74;
				char* _tmp73;
				ValaCCodeMemberAccess* _tmp72;
				/* connect overridden methods */
				if (vala_method_get_base_method (m) == NULL) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				_tmp66 = NULL;
				base_type = (_tmp66 = vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_method (m))), (_tmp66 == NULL ? NULL : g_object_ref (_tmp66)));
				_tmp69 = NULL;
				_tmp68 = NULL;
				_tmp67 = NULL;
				_tmp70 = NULL;
				ccast = (_tmp70 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new ((_tmp68 = g_strdup_printf ("%s_CLASS", (_tmp67 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE ((VALA_CLASS (base_type))), NULL)))))))), (_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL))), (_tmp68 = (g_free (_tmp68), NULL)), (_tmp67 = (g_free (_tmp67), NULL)), _tmp70);
				_tmp71 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new ("klass"))));
				(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
				_tmp76 = NULL;
				_tmp75 = NULL;
				_tmp74 = NULL;
				_tmp73 = NULL;
				_tmp72 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp76 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), vala_method_get_vfunc_name (vala_method_get_base_method (m))))), VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ((_tmp73 = vala_method_get_real_cname (m))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
				(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
				(_tmp73 = (g_free (_tmp73), NULL));
				(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
		(m_it == NULL ? NULL : (m_it = (g_object_unref (m_it), NULL)));
	}
	{
		GeeCollection* type_param_collection;
		GeeIterator* type_param_it;
		type_param_collection = vala_class_get_type_parameters (cl);
		type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
		while (gee_iterator_next (type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = gee_iterator_get (type_param_it);
			{
				char* func_name;
				char* enum_value;
				ValaCCodeConstant* func_name_constant;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeFunctionCall* cspec;
				char* _tmp78;
				char* _tmp77;
				ValaCCodeConstant* _tmp81;
				char* _tmp80;
				char* _tmp79;
				char* _tmp84;
				char* _tmp83;
				char* _tmp82;
				ValaCCodeFunctionCall* _tmp86;
				ValaCCodeIdentifier* _tmp85;
				ValaCCodeConstant* _tmp87;
				ValaCCodeFunctionCall* _tmp89;
				ValaCCodeIdentifier* _tmp88;
				ValaCCodeConstant* _tmp90;
				ValaCCodeConstant* _tmp91;
				ValaCCodeConstant* _tmp92;
				ValaCCodeExpressionStatement* _tmp93;
				char* _tmp95;
				char* _tmp94;
				ValaCCodeConstant* _tmp98;
				char* _tmp97;
				char* _tmp96;
				char* _tmp101;
				char* _tmp100;
				char* _tmp99;
				ValaCCodeFunctionCall* _tmp103;
				ValaCCodeIdentifier* _tmp102;
				ValaCCodeConstant* _tmp104;
				ValaCCodeFunctionCall* _tmp106;
				ValaCCodeIdentifier* _tmp105;
				ValaCCodeConstant* _tmp107;
				ValaCCodeConstant* _tmp108;
				ValaCCodeConstant* _tmp109;
				ValaCCodeExpressionStatement* _tmp110;
				/* create dup_func and destroy_func properties for generic types */
				func_name = NULL;
				enum_value = NULL;
				func_name_constant = NULL;
				cinst = NULL;
				cspec = NULL;
				_tmp78 = NULL;
				_tmp77 = NULL;
				func_name = (_tmp78 = g_strdup_printf ("%s_dup_func", (_tmp77 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp78);
				(_tmp77 = (g_free (_tmp77), NULL));
				_tmp81 = NULL;
				_tmp80 = NULL;
				_tmp79 = NULL;
				func_name_constant = (_tmp81 = vala_ccode_constant_new ((_tmp80 = g_strdup_printf ("\"%s-dup-func\"", (_tmp79 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), _tmp81);
				(_tmp80 = (g_free (_tmp80), NULL));
				(_tmp79 = (g_free (_tmp79), NULL));
				_tmp84 = NULL;
				_tmp83 = NULL;
				_tmp82 = NULL;
				enum_value = (_tmp84 = g_utf8_strup ((_tmp83 = g_strdup_printf ("%s_%s", (_tmp82 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp84);
				(_tmp83 = (g_free (_tmp83), NULL));
				(_tmp82 = (g_free (_tmp82), NULL));
				_tmp86 = NULL;
				_tmp85 = NULL;
				cinst = (_tmp86 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), _tmp86);
				(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
				_tmp87 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_constant_new (enum_value))));
				(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
				_tmp89 = NULL;
				_tmp88 = NULL;
				cspec = (_tmp89 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), _tmp89);
				(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
				_tmp90 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_constant_new ("\"dup func\""))));
				(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
				_tmp91 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_constant_new ("\"dup func\""))));
				(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
				_tmp92 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE"))));
				(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
				_tmp93 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp93 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
				vala_ccode_enum_add_value (self->priv->prop_enum, enum_value, NULL);
				vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GBoxedCopyFunc", func_name);
				_tmp95 = NULL;
				_tmp94 = NULL;
				func_name = (_tmp95 = g_strdup_printf ("%s_destroy_func", (_tmp94 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp95);
				(_tmp94 = (g_free (_tmp94), NULL));
				_tmp98 = NULL;
				_tmp97 = NULL;
				_tmp96 = NULL;
				func_name_constant = (_tmp98 = vala_ccode_constant_new ((_tmp97 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp96 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), _tmp98);
				(_tmp97 = (g_free (_tmp97), NULL));
				(_tmp96 = (g_free (_tmp96), NULL));
				_tmp101 = NULL;
				_tmp100 = NULL;
				_tmp99 = NULL;
				enum_value = (_tmp101 = g_utf8_strup ((_tmp100 = g_strdup_printf ("%s_%s", (_tmp99 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp101);
				(_tmp100 = (g_free (_tmp100), NULL));
				(_tmp99 = (g_free (_tmp99), NULL));
				_tmp103 = NULL;
				_tmp102 = NULL;
				cinst = (_tmp103 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), _tmp103);
				(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
				_tmp104 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_constant_new (enum_value))));
				(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
				_tmp106 = NULL;
				_tmp105 = NULL;
				cspec = (_tmp106 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), _tmp106);
				(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
				_tmp107 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_constant_new ("\"destroy func\""))));
				(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
				_tmp108 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_constant_new ("\"destroy func\""))));
				(_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL)));
				_tmp109 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE"))));
				(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
				_tmp110 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp110 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
				vala_ccode_enum_add_value (self->priv->prop_enum, enum_value, NULL);
				vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GDestroyNotify", func_name);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				(func_name = (g_free (func_name), NULL));
				(enum_value = (g_free (enum_value), NULL));
				(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
			}
		}
		(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
		(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
	}
	/* create properties */
	props = vala_class_get_properties (cl);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				if (vala_property_get_overrides (prop) || vala_property_get_base_interface_property (prop) != NULL) {
					ValaCCodeIdentifier* _tmp111;
					ValaCCodeFunctionCall* _tmp112;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* _tmp114;
					char* _tmp113;
					ValaCCodeConstant* _tmp115;
					ValaCCodeExpressionStatement* _tmp116;
					_tmp111 = NULL;
					_tmp112 = NULL;
					cinst = (_tmp112 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp111 = vala_ccode_identifier_new ("g_object_class_override_property")))), (_tmp111 == NULL ? NULL : (_tmp111 = (g_object_unref (_tmp111), NULL))), _tmp112);
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp114 = NULL;
					_tmp113 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp114 = vala_ccode_constant_new ((_tmp113 = vala_property_get_upper_case_cname (prop))))));
					(_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL)));
					(_tmp113 = (g_free (_tmp113), NULL));
					_tmp115 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp115 = vala_property_get_canonical_cconstant (prop))));
					(_tmp115 = (g_object_unref (_tmp115), NULL));
					_tmp116 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp116 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp117;
					ValaCCodeFunctionCall* _tmp118;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* _tmp120;
					char* _tmp119;
					ValaCCodeFunctionCall* _tmp121;
					ValaCCodeExpressionStatement* _tmp122;
					_tmp117 = NULL;
					_tmp118 = NULL;
					cinst = (_tmp118 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp117 = vala_ccode_identifier_new ("g_object_class_install_property")))), (_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL))), _tmp118);
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp120 = NULL;
					_tmp119 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp120 = vala_ccode_constant_new ((_tmp119 = vala_property_get_upper_case_cname (prop))))));
					(_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL)));
					(_tmp119 = (g_free (_tmp119), NULL));
					_tmp121 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp121 = vala_code_generator_get_param_spec (self, prop))));
					(_tmp121 = (g_object_unref (_tmp121), NULL));
					_tmp122 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp122 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp122 == NULL ? NULL : (_tmp122 = (g_object_unref (_tmp122), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	{
		GeeCollection* sig_collection;
		GeeIterator* sig_it;
		sig_collection = vala_class_get_signals (cl);
		sig_it = gee_iterable_iterator (GEE_ITERABLE (sig_collection));
		while (gee_iterator_next (sig_it)) {
			ValaSignal* sig;
			sig = gee_iterator_get (sig_it);
			{
				ValaCCodeExpressionStatement* _tmp124;
				ValaCCodeFunctionCall* _tmp123;
				/* create signals */
				_tmp124 = NULL;
				_tmp123 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp124 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp123 = vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (cl))))))));
				(_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL)));
				(_tmp123 = (g_object_unref (_tmp123), NULL));
				(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			}
		}
		(sig_collection == NULL ? NULL : (sig_collection = (g_object_unref (sig_collection), NULL)));
		(sig_it == NULL ? NULL : (sig_it = (g_object_unref (sig_it), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (self->priv->class_init_fragment));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (class_init));
	(class_init == NULL ? NULL : (class_init = (g_object_unref (class_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface)
{
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* _tmp6;
	char* _tmp5;
	char* _tmp4;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* _tmp8;
	char* _tmp7;
	char* _tmp9;
	char* parent_iface_var;
	char* _tmp11;
	char* _tmp10;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp19;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	iface_init = (_tmp3 = vala_ccode_function_new ((_tmp2 = g_strdup_printf ("%s_%s_interface_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))), "void"), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (iface_init, (_tmp6 = vala_ccode_formal_parameter_new ("iface", (_tmp5 = g_strdup_printf ("%s *", (_tmp4 = vala_interface_get_type_cname (iface)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 = (g_free (_tmp5), NULL));
	(_tmp4 = (g_free (_tmp4), NULL));
	vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	vala_ccode_function_set_block (iface_init, init_block);
	ccall = NULL;
	/* save pointer to parent vtable */
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	parent_iface_var = (_tmp9 = g_strdup_printf ("%s_%s_parent_iface", (_tmp7 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (_tmp8 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp12 = NULL;
	parent_decl = (_tmp12 = vala_ccode_declaration_new ((_tmp11 = g_strconcat ((_tmp10 = vala_interface_get_type_cname (iface)), "*", NULL))), (_tmp11 = (g_free (_tmp11), NULL)), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	_tmp13 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("NULL"))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	_tmp15 = NULL;
	_tmp14 = NULL;
	ccall = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_type_interface_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp15);
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("iface"))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	_tmp18 = NULL;
	parent_assignment = (_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new (parent_iface_var))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	{
		GeeCollection* m_collection;
		GeeIterator* m_it;
		m_collection = vala_class_get_methods (cl);
		m_it = gee_iterable_iterator (GEE_ITERABLE (m_collection));
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			m = gee_iterator_get (m_it);
			{
				ValaSymbol* _tmp20;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* ciface;
				ValaCCodeExpressionStatement* _tmp25;
				ValaCCodeAssignment* _tmp24;
				ValaCCodeIdentifier* _tmp23;
				char* _tmp22;
				ValaCCodeMemberAccess* _tmp21;
				if (vala_method_get_base_interface_method (m) == NULL) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				_tmp20 = NULL;
				base_type = (_tmp20 = vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_interface_method (m))), (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)));
				if (base_type != VALA_SYMBOL (iface)) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
					continue;
				}
				ciface = vala_ccode_identifier_new ("iface");
				_tmp25 = NULL;
				_tmp24 = NULL;
				_tmp23 = NULL;
				_tmp22 = NULL;
				_tmp21 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_method_get_vfunc_name (vala_method_get_base_interface_method (m))))), VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ((_tmp22 = vala_method_get_real_cname (m))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				(_tmp22 = (g_free (_tmp22), NULL));
				(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (g_object_unref (ciface), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
		(m_it == NULL ? NULL : (m_it = (g_object_unref (m_it), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (iface_init));
	(iface_init == NULL ? NULL : (iface_init = (g_object_unref (iface_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_iface_var = (g_free (parent_iface_var), NULL));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
}


static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	GeeCollection* _tmp6;
	gboolean _tmp7;
	ValaSymbol* init_sym;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	instance_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (instance_init, (_tmp5 = vala_ccode_formal_parameter_new ("self", (_tmp4 = g_strdup_printf ("%s *", (_tmp3 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	(_tmp3 = (g_free (_tmp3), NULL));
	vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	vala_ccode_function_set_block (instance_init, init_block);
	_tmp6 = NULL;
	if ((_tmp7 = vala_class_get_has_private_fields (cl) || gee_collection_get_size ((_tmp6 = vala_class_get_type_parameters (cl))) > 0, (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7)) {
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		char* _tmp8;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp12;
		ValaCCodeExpressionStatement* _tmp16;
		ValaCCodeAssignment* _tmp15;
		ValaCCodeMemberAccess* _tmp14;
		ValaCCodeIdentifier* _tmp13;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp11 = NULL;
		ccall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = g_strdup_printf ("%s_GET_PRIVATE", (_tmp8 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), (_tmp8 = (g_free (_tmp8), NULL)), _tmp11);
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("self"))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))), "priv"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (self->priv->instance_init_fragment));
	init_sym = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) cl)), "init");
	if (init_sym != NULL) {
		ValaMethod* _tmp17;
		ValaMethod* init_fun;
		_tmp17 = NULL;
		init_fun = (_tmp17 = VALA_METHOD (init_sym), (_tmp17 == NULL ? NULL : g_object_ref (_tmp17)));
		vala_ccode_block_add_statement (init_block, vala_code_node_get_ccodenode (((ValaCodeNode*) vala_method_get_body (init_fun))));
		(init_fun == NULL ? NULL : (init_fun = (g_object_unref (init_fun), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (instance_init));
	(instance_init == NULL ? NULL : (instance_init = (g_object_unref (instance_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(init_sym == NULL ? NULL : (init_sym = (g_object_unref (init_sym), NULL)));
}


static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl)
{
	ValaCCodeFunction* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFunction* _tmp4;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* _tmp6;
	char* _tmp5;
	ValaCCodeFunctionCall* _tmp7;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp8;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeDeclaration* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeVariableDeclarator* _tmp16;
	ValaCCodeDeclaration* _tmp17;
	ValaCCodeVariableDeclarator* _tmp18;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeIdentifier* _tmp22;
	char* _tmp21;
	ValaCCodeIdentifier* _tmp25;
	char* _tmp24;
	char* _tmp23;
	ValaCCodeFunctionCall* _tmp26;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeAssignment* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeFunctionCall* _tmp31;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeFunctionCall* _tmp34;
	ValaCCodeIdentifier* _tmp33;
	ValaCCodeExpressionStatement* _tmp37;
	ValaCCodeAssignment* _tmp36;
	ValaCCodeIdentifier* _tmp35;
	ValaCCodeFunctionCall* _tmp40;
	ValaCCodeMemberAccess* _tmp39;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeIdentifier* _tmp41;
	ValaCCodeExpressionStatement* _tmp42;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_dispose", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp2);
	(_tmp1 = (g_free (_tmp1), NULL));
	(_tmp0 = (g_free (_tmp0), NULL));
	vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (_tmp3 = vala_ccode_formal_parameter_new ("obj", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp4 = vala_ccode_function_copy (self->priv->function))));
	(_tmp4 = (g_object_unref (_tmp4), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	ccall = (_tmp7 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ((_tmp5 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp7);
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("obj"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (vala_class_get_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_destructor_get_body (vala_class_get_destructor (cl)))))));
	}
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	cdecl_ = (_tmp15 = vala_ccode_declaration_new ((_tmp14 = g_strdup_printf ("%sClass *", (_tmp13 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp15);
	(_tmp14 = (g_free (_tmp14), NULL));
	(_tmp13 = (g_free (_tmp13), NULL));
	_tmp16 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp16 = vala_ccode_variable_declarator_new ("klass"))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp17 = NULL;
	cdecl_ = (_tmp17 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp17);
	_tmp18 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp18 = vala_ccode_variable_declarator_new ("parent_class"))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp20 = NULL;
	_tmp19 = NULL;
	ccall = (_tmp20 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("g_type_class_peek")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp20);
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	(_tmp21 = (g_free (_tmp21), NULL));
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp26 = NULL;
	ccast = (_tmp26 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = g_strdup_printf ("%s_CLASS", (_tmp23 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))))), (_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL))), (_tmp24 = (g_free (_tmp24), NULL)), (_tmp23 = (g_free (_tmp23), NULL)), _tmp26);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp29 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("klass"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	_tmp31 = NULL;
	_tmp30 = NULL;
	ccall = (_tmp31 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp31);
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	_tmp32 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("klass"))));
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	_tmp34 = NULL;
	_tmp33 = NULL;
	ccast = (_tmp34 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), _tmp34);
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	_tmp37 = NULL;
	_tmp36 = NULL;
	_tmp35 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp37 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ("parent_class"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	_tmp40 = NULL;
	_tmp39 = NULL;
	_tmp38 = NULL;
	ccall = (_tmp40 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("parent_class"))), "dispose")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp40);
	(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
	(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("obj"))));
	(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
	_tmp42 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp42 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	vala_ccode_function_set_block (self->priv->function, cblock);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type_reference), NULL);
	if (vala_type_reference_get_data_type (type_reference) != NULL) {
		char* _tmp0;
		ValaCCodeIdentifier* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_data_type_get_set_value_function (vala_type_reference_get_data_type (type_reference)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	} else {
		return vala_ccode_identifier_new ("g_value_set_pointer");
	}
}


static gboolean vala_code_generator_class_has_readable_properties (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = vala_class_get_properties (cl);
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				if (vala_property_get_get_accessor (prop) != NULL && !vala_property_get_is_abstract (prop)) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL))), (prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL))), _tmp0);
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	return FALSE;
}


static gboolean vala_code_generator_class_has_writable_properties (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = vala_class_get_properties (cl);
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				if (vala_property_get_set_accessor (prop) != NULL && !vala_property_get_is_abstract (prop)) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL))), (prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL))), _tmp0);
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	return FALSE;
}


static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp8;
	char* _tmp7;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp12;
	char* _tmp11;
	ValaCCodeDeclaration* _tmp13;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeSwitchStatement* _tmp16;
	ValaCCodeSwitchStatement* cswitch;
	GeeCollection* props;
	ValaCCodeStatement* _tmp29;
	ValaCCodeBreakStatement* _tmp30;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	get_prop = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_get_property", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp5 = vala_ccode_formal_parameter_new ("value", "GValue *")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	ccall = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("object"))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	cdecl_ = (_tmp13 = vala_ccode_declaration_new ((_tmp12 = g_strdup_printf ("%s *", (_tmp11 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), _tmp13);
	_tmp14 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp14 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp15 = NULL;
	_tmp16 = NULL;
	cswitch = (_tmp16 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("property_id")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16);
	props = vala_class_get_properties (cl);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeIdentifier* _tmp19;
				char* _tmp18;
				ValaCCodeCaseStatement* _tmp20;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* _tmp22;
				char* _tmp21;
				ValaCCodeFunctionCall* _tmp23;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* _tmp24;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* _tmp25;
				ValaCCodeIdentifier* _tmp26;
				ValaCCodeExpressionStatement* _tmp27;
				ValaCCodeBreakStatement* _tmp28;
				if (vala_property_get_get_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				if (is_virtual) {
					char* _tmp17;
					_tmp17 = NULL;
					prefix = (_tmp17 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp17);
				}
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp20 = NULL;
				ccase = (_tmp20 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_property_get_upper_case_cname (prop)))))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), (_tmp18 = (g_free (_tmp18), NULL)), _tmp20);
				_tmp22 = NULL;
				_tmp21 = NULL;
				_tmp23 = NULL;
				ccall = (_tmp23 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (((ValaSymbol*) prop)))))))), (_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL))), (_tmp21 = (g_free (_tmp21), NULL)), _tmp23);
				_tmp24 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("self"))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				csetcall = vala_ccode_function_call_new (NULL);
				_tmp25 = NULL;
				vala_ccode_function_call_set_call (csetcall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop)))));
				(_tmp25 = (g_object_unref (_tmp25), NULL));
				_tmp26 = NULL;
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("value"))));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION (ccall));
				_tmp27 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp27 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (csetcall)))));
				(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
				_tmp28 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp28 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(csetcall == NULL ? NULL : (csetcall = (g_object_unref (csetcall), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	_tmp29 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, (_tmp29 = vala_code_generator_get_invalid_property_id_warn_statement (self)));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, VALA_CCODE_STATEMENT ((_tmp30 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	vala_ccode_function_set_block (get_prop, block);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (get_prop));
	(get_prop == NULL ? NULL : (get_prop = (g_object_unref (get_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp8;
	char* _tmp7;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp12;
	char* _tmp11;
	ValaCCodeDeclaration* _tmp13;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeSwitchStatement* _tmp16;
	ValaCCodeSwitchStatement* cswitch;
	GeeCollection* props;
	ValaCCodeStatement* _tmp31;
	ValaCCodeBreakStatement* _tmp32;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	set_prop = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_set_property", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp5 = vala_ccode_formal_parameter_new ("value", "const GValue *")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	ccall = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("object"))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	cdecl_ = (_tmp13 = vala_ccode_declaration_new ((_tmp12 = g_strdup_printf ("%s *", (_tmp11 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), _tmp13);
	_tmp14 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp14 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp15 = NULL;
	_tmp16 = NULL;
	cswitch = (_tmp16 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("property_id")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16);
	props = vala_class_get_properties (cl);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeIdentifier* _tmp19;
				char* _tmp18;
				ValaCCodeCaseStatement* _tmp20;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* _tmp22;
				char* _tmp21;
				ValaCCodeFunctionCall* _tmp23;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* _tmp24;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* _tmp28;
				ValaCCodeExpressionStatement* _tmp29;
				ValaCCodeBreakStatement* _tmp30;
				if (vala_property_get_set_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				if (is_virtual) {
					char* _tmp17;
					_tmp17 = NULL;
					prefix = (_tmp17 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp17);
				}
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp20 = NULL;
				ccase = (_tmp20 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_property_get_upper_case_cname (prop)))))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), (_tmp18 = (g_free (_tmp18), NULL)), _tmp20);
				_tmp22 = NULL;
				_tmp21 = NULL;
				_tmp23 = NULL;
				ccall = (_tmp23 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (((ValaSymbol*) prop)))))))), (_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL))), (_tmp21 = (g_free (_tmp21), NULL)), _tmp23);
				_tmp24 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("self"))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				cgetcall = vala_ccode_function_call_new (NULL);
				if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != NULL) {
					ValaCCodeIdentifier* _tmp26;
					char* _tmp25;
					_tmp26 = NULL;
					_tmp25 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ((_tmp25 = vala_data_type_get_get_value_function (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))))))));
					(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
					(_tmp25 = (g_free (_tmp25), NULL));
				} else {
					ValaCCodeIdentifier* _tmp27;
					_tmp27 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("g_value_get_pointer"))));
					(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
				}
				_tmp28 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("value"))));
				(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cgetcall));
				_tmp29 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp29 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
				(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
				_tmp30 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp30 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	_tmp31 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, (_tmp31 = vala_code_generator_get_invalid_property_id_warn_statement (self)));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	_tmp32 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, VALA_CCODE_STATEMENT ((_tmp32 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	{
		GeeCollection* type_param_collection;
		GeeIterator* type_param_it;
		type_param_collection = vala_class_get_type_parameters (cl);
		type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
		while (gee_iterator_next (type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = gee_iterator_get (type_param_it);
			{
				char* _tmp33;
				char* _tmp34;
				char* func_name;
				char* _tmp36;
				char* _tmp35;
				char* _tmp37;
				char* enum_value;
				ValaCCodeIdentifier* _tmp38;
				ValaCCodeCaseStatement* _tmp39;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeMemberAccess* _tmp41;
				ValaCCodeIdentifier* _tmp40;
				ValaCCodeMemberAccess* _tmp42;
				ValaCCodeMemberAccess* cfield;
				ValaCCodeIdentifier* _tmp43;
				ValaCCodeFunctionCall* _tmp44;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* _tmp45;
				ValaCCodeExpressionStatement* _tmp47;
				ValaCCodeAssignment* _tmp46;
				ValaCCodeBreakStatement* _tmp48;
				/* destroy func properties for generic types */
				_tmp33 = NULL;
				_tmp34 = NULL;
				func_name = (_tmp34 = g_strdup_printf ("%s_destroy_func", (_tmp33 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (_tmp33 = (g_free (_tmp33), NULL)), _tmp34);
				_tmp36 = NULL;
				_tmp35 = NULL;
				_tmp37 = NULL;
				enum_value = (_tmp37 = g_utf8_strup ((_tmp36 = g_strdup_printf ("%s_%s", (_tmp35 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (_tmp36 = (g_free (_tmp36), NULL)), (_tmp35 = (g_free (_tmp35), NULL)), _tmp37);
				_tmp38 = NULL;
				_tmp39 = NULL;
				ccase = (_tmp39 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new (enum_value)))), (_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL))), _tmp39);
				_tmp41 = NULL;
				_tmp40 = NULL;
				_tmp42 = NULL;
				cfield = (_tmp42 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL))), (_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL))), _tmp42);
				_tmp43 = NULL;
				_tmp44 = NULL;
				cgetcall = (_tmp44 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("g_value_get_pointer")))), (_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL))), _tmp44);
				_tmp45 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("value"))));
				(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
				_tmp47 = NULL;
				_tmp46 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp47 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
				(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
				_tmp48 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp48 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				(func_name = (g_free (func_name), NULL));
				(enum_value = (g_free (enum_value), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
		(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
	}
	vala_ccode_function_set_block (set_prop, block);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (set_prop));
	(set_prop == NULL ? NULL : (set_prop = (g_object_unref (set_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static ValaCCodeStatement* vala_code_generator_get_invalid_property_id_warn_statement (ValaCodeGenerator* self)
{
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cwarn;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeExpressionStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	/* warn on invalid property id*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	cwarn = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("object"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("property_id"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("pspec"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp5 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cwarn)), (cwarn == NULL ? NULL : (cwarn = (g_object_unref (cwarn), NULL))), _tmp5));
	(cwarn == NULL ? NULL : (cwarn = (g_object_unref (cwarn), NULL)));
}


static void vala_code_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaCodeGenerator * self;
	ValaSymbol* _tmp0;
	ValaSymbol* _tmp1;
	char* _tmp2;
	gboolean _tmp3;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaSymbol* _tmp53;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	_tmp0 = NULL;
	self->priv->current_symbol = (_tmp0 = VALA_SYMBOL (g_object_ref (iface)), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp0);
	_tmp1 = NULL;
	self->priv->current_type_symbol = (_tmp1 = VALA_SYMBOL (g_object_ref (iface)), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), _tmp1);
	_tmp2 = NULL;
	if ((_tmp3 = g_utf8_strlen ((_tmp2 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)), -1) < 3, (_tmp2 = (g_free (_tmp2), NULL)), _tmp3)) {
		char* _tmp5;
		char* _tmp4;
		vala_code_node_set_error (VALA_CODE_NODE (iface), TRUE);
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) iface)), (_tmp5 = g_strdup_printf ("Interface name `%s' is too short", (_tmp4 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))));
		(_tmp5 = (g_free (_tmp5), NULL));
		(_tmp4 = (g_free (_tmp4), NULL));
		return;
	}
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (((ValaSymbol*) iface)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp7;
		ValaCCodeFragment* _tmp6;
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp8;
		_tmp7 = NULL;
		_tmp6 = NULL;
		decl_frag = (_tmp7 = (_tmp6 = self->priv->header_type_declaration, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp7);
		_tmp9 = NULL;
		_tmp8 = NULL;
		def_frag = (_tmp9 = (_tmp8 = self->priv->header_type_definition, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp9);
	} else {
		ValaCCodeFragment* _tmp11;
		ValaCCodeFragment* _tmp10;
		ValaCCodeFragment* _tmp13;
		ValaCCodeFragment* _tmp12;
		_tmp11 = NULL;
		_tmp10 = NULL;
		decl_frag = (_tmp11 = (_tmp10 = self->priv->source_type_member_declaration, (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp11);
		_tmp13 = NULL;
		_tmp12 = NULL;
		def_frag = (_tmp13 = (_tmp12 = self->priv->source_type_member_declaration, (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp13);
	}
	if (!vala_interface_get_is_static (iface) && !vala_interface_get_declaration_only (iface)) {
		ValaCCodeStruct* _tmp16;
		char* _tmp15;
		char* _tmp14;
		ValaCCodeNewline* _tmp17;
		char* _tmp18;
		char* _tmp19;
		char* macro;
		ValaCCodeMacroReplacement* _tmp21;
		char* _tmp20;
		char* _tmp24;
		char* _tmp23;
		char* _tmp22;
		ValaCCodeMacroReplacement* _tmp27;
		char* _tmp26;
		char* _tmp25;
		char* _tmp29;
		char* _tmp28;
		ValaCCodeMacroReplacement* _tmp32;
		char* _tmp31;
		char* _tmp30;
		char* _tmp35;
		char* _tmp34;
		char* _tmp33;
		ValaCCodeMacroReplacement* _tmp38;
		char* _tmp37;
		char* _tmp36;
		ValaCCodeNewline* _tmp39;
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		self->priv->type_struct = (_tmp16 = vala_ccode_struct_new ((_tmp15 = g_strdup_printf ("_%s", (_tmp14 = vala_interface_get_type_cname (iface))))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), _tmp16);
		(_tmp15 = (g_free (_tmp15), NULL));
		(_tmp14 = (g_free (_tmp14), NULL));
		_tmp17 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp17 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
		_tmp18 = NULL;
		_tmp19 = NULL;
		macro = (_tmp19 = g_strdup_printf ("(%s_get_type ())", (_tmp18 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (_tmp18 = (g_free (_tmp18), NULL)), _tmp19);
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp21 = vala_ccode_macro_replacement_new ((_tmp20 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), macro))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		(_tmp20 = (g_free (_tmp20), NULL));
		_tmp24 = NULL;
		_tmp23 = NULL;
		_tmp22 = NULL;
		macro = (_tmp24 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (_tmp22 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (_tmp23 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), (macro = (g_free (macro), NULL)), _tmp24);
		(_tmp23 = (g_free (_tmp23), NULL));
		(_tmp22 = (g_free (_tmp22), NULL));
		_tmp27 = NULL;
		_tmp26 = NULL;
		_tmp25 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp27 = vala_ccode_macro_replacement_new ((_tmp26 = g_strdup_printf ("%s(obj)", (_tmp25 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))), macro))));
		(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
		(_tmp26 = (g_free (_tmp26), NULL));
		(_tmp25 = (g_free (_tmp25), NULL));
		_tmp29 = NULL;
		_tmp28 = NULL;
		macro = (_tmp29 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (_tmp28 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"))), (macro = (g_free (macro), NULL)), _tmp29);
		(_tmp28 = (g_free (_tmp28), NULL));
		_tmp32 = NULL;
		_tmp31 = NULL;
		_tmp30 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp32 = vala_ccode_macro_replacement_new ((_tmp31 = g_strdup_printf ("%s(obj)", (_tmp30 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "IS_")))), macro))));
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		(_tmp31 = (g_free (_tmp31), NULL));
		(_tmp30 = (g_free (_tmp30), NULL));
		_tmp35 = NULL;
		_tmp34 = NULL;
		_tmp33 = NULL;
		macro = (_tmp35 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", (_tmp33 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (_tmp34 = vala_interface_get_type_cname (iface))), (macro = (g_free (macro), NULL)), _tmp35);
		(_tmp34 = (g_free (_tmp34), NULL));
		(_tmp33 = (g_free (_tmp33), NULL));
		_tmp38 = NULL;
		_tmp37 = NULL;
		_tmp36 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp38 = vala_ccode_macro_replacement_new ((_tmp37 = g_strdup_printf ("%s_GET_INTERFACE(obj)", (_tmp36 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))), macro))));
		(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
		(_tmp37 = (g_free (_tmp37), NULL));
		(_tmp36 = (g_free (_tmp36), NULL));
		_tmp39 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp39 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) iface)))) == NULL) {
			ValaCCodeTypeDefinition* _tmp44;
			ValaCCodeVariableDeclarator* _tmp43;
			char* _tmp42;
			char* _tmp41;
			char* _tmp40;
			ValaCCodeTypeDefinition* _tmp48;
			ValaCCodeVariableDeclarator* _tmp47;
			char* _tmp46;
			char* _tmp45;
			_tmp44 = NULL;
			_tmp43 = NULL;
			_tmp42 = NULL;
			_tmp41 = NULL;
			_tmp40 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp44 = vala_ccode_type_definition_new ((_tmp41 = g_strdup_printf ("struct _%s", (_tmp40 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp43 = vala_ccode_variable_declarator_new ((_tmp42 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))))));
			(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			(_tmp42 = (g_free (_tmp42), NULL));
			(_tmp41 = (g_free (_tmp41), NULL));
			(_tmp40 = (g_free (_tmp40), NULL));
			_tmp48 = NULL;
			_tmp47 = NULL;
			_tmp46 = NULL;
			_tmp45 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp48 = vala_ccode_type_definition_new ((_tmp45 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct))), VALA_CCODE_DECLARATOR ((_tmp47 = vala_ccode_variable_declarator_new ((_tmp46 = vala_interface_get_type_cname (iface)))))))));
			(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
			(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
			(_tmp46 = (g_free (_tmp46), NULL));
			(_tmp45 = (g_free (_tmp45), NULL));
		}
		vala_ccode_struct_add_field (self->priv->type_struct, "GTypeInterface", "parent");
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) iface))) != NULL) {
			ValaCCodeComment* _tmp49;
			_tmp49 = NULL;
			vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp49 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) iface)))))));
			(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
		}
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->type_struct));
		(macro = (g_free (macro), NULL));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
	if (!vala_interface_get_is_static (iface) && !vala_interface_get_declaration_only (iface)) {
		ValaInterfaceRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp52;
		vala_code_generator_add_interface_base_init_function (self, iface);
		type_fun = vala_interface_register_function_new (iface);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), FALSE);
		if (vala_symbol_get_access (((ValaSymbol*) iface)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFragment* _tmp50;
			_tmp50 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp50 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
			(_tmp50 = (g_object_unref (_tmp50), NULL));
		} else {
			ValaCCodeFragment* _tmp51;
			_tmp51 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp51 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
			(_tmp51 = (g_object_unref (_tmp51), NULL));
		}
		_tmp52 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp52 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(_tmp52 = (g_object_unref (_tmp52), NULL));
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	_tmp53 = NULL;
	self->priv->current_type_symbol = (_tmp53 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), _tmp53);
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
}


static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop)
{
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* _tmp0;
	ValaCCodeConstant* _tmp1;
	ValaCCodeConstant* _tmp2;
	char* pflags;
	ValaCCodeConstant* _tmp39;
	ValaCCodeFunctionCall* _tmp40;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	cspec = vala_ccode_function_call_new (NULL);
	_tmp0 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp0 = vala_property_get_canonical_cconstant (prop))));
	(_tmp0 = (g_object_unref (_tmp0), NULL));
	_tmp1 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_constant_new ("\"foo\""))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("\"bar\""))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	if ((VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) && vala_data_type_is_subtype_of (VALA_DATA_TYPE ((VALA_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))))), self->priv->gobject_type)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeIdentifier* _tmp5;
		char* _tmp4;
		_tmp3 = NULL;
		vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("g_param_spec_object"))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), "TYPE_"))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 = (g_free (_tmp4), NULL));
	} else {
		if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->string_type)) {
			ValaCCodeIdentifier* _tmp6;
			ValaCCodeConstant* _tmp7;
			_tmp6 = NULL;
			vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("g_param_spec_string"))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
			_tmp7 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("NULL"))));
			(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaCCodeIdentifier* _tmp8;
				ValaCCodeConstant* _tmp9;
				ValaCCodeConstant* _tmp10;
				ValaCCodeConstant* _tmp11;
				_tmp8 = NULL;
				vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_param_spec_int"))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				_tmp9 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("G_MININT"))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				_tmp10 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_constant_new ("G_MAXINT"))));
				(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
				_tmp11 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("0"))));
				(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
			} else {
				if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeIdentifier* _tmp12;
					ValaCCodeConstant* _tmp13;
					ValaCCodeConstant* _tmp14;
					ValaCCodeConstant* _tmp15;
					_tmp12 = NULL;
					vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("g_param_spec_uint"))));
					(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
					_tmp13 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("0"))));
					(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
					_tmp14 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ("G_MAXUINT"))));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
					_tmp15 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("0U"))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
				} else {
					if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->long_type)) {
						ValaCCodeIdentifier* _tmp16;
						ValaCCodeConstant* _tmp17;
						ValaCCodeConstant* _tmp18;
						ValaCCodeConstant* _tmp19;
						_tmp16 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("g_param_spec_long"))));
						(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
						_tmp17 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("G_MINLONG"))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
						_tmp18 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("G_MAXLONG"))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
						_tmp19 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("0L"))));
						(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
					} else {
						if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							ValaCCodeIdentifier* _tmp20;
							ValaCCodeConstant* _tmp21;
							ValaCCodeConstant* _tmp22;
							ValaCCodeConstant* _tmp23;
							_tmp20 = NULL;
							vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_param_spec_ulong"))));
							(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
							_tmp21 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("0"))));
							(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
							_tmp22 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ("G_MAXULONG"))));
							(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
							_tmp23 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ("0UL"))));
							(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
						} else {
							if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								ValaCCodeIdentifier* _tmp24;
								ValaCCodeConstant* _tmp25;
								_tmp24 = NULL;
								vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("g_param_spec_boolean"))));
								(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
								_tmp25 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("FALSE"))));
								(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
							} else {
								if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->float_type)) {
									ValaCCodeIdentifier* _tmp26;
									ValaCCodeConstant* _tmp27;
									ValaCCodeConstant* _tmp28;
									ValaCCodeConstant* _tmp29;
									_tmp26 = NULL;
									vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("g_param_spec_float"))));
									(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
									_tmp27 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
									(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
									_tmp28 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_constant_new ("G_MAXFLOAT"))));
									(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
									_tmp29 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("0.0F"))));
									(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
								} else {
									if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->double_type)) {
										ValaCCodeIdentifier* _tmp30;
										ValaCCodeConstant* _tmp31;
										ValaCCodeConstant* _tmp32;
										ValaCCodeConstant* _tmp33;
										_tmp30 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("g_param_spec_double"))));
										(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
										_tmp31 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
										(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
										_tmp32 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
										(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
										_tmp33 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_constant_new ("0.0"))));
										(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
									} else {
										ValaCCodeIdentifier* _tmp34;
										_tmp34 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
										(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* _tmp35;
		_tmp35 = NULL;
		pflags = (_tmp35 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), _tmp35);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* _tmp36;
		_tmp36 = NULL;
		pflags = (_tmp36 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), _tmp36);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* _tmp37;
				_tmp37 = NULL;
				pflags = (_tmp37 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), _tmp37);
			} else {
				char* _tmp38;
				_tmp38 = NULL;
				pflags = (_tmp38 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), _tmp38);
			}
		}
	}
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_constant_new (pflags))));
	(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
	_tmp40 = NULL;
	return (_tmp40 = cspec, (pflags = (g_free (pflags), NULL)), _tmp40);
	(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
	(pflags = (g_free (pflags), NULL));
}


static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type)
{
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* _tmp3;
	char* _tmp2;
	ValaCCodeIdentifier* _tmp5;
	char* _tmp4;
	ValaCCodeConstant* _tmp6;
	ValaCCodeConstant* _tmp7;
	ValaCCodeConstant* _tmp8;
	ValaCCodeConstant* _tmp9;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeCollection* params;
	gint params_len;
	ValaCCodeConstant* _tmp15;
	char* _tmp14;
	ValaCCodeFunctionCall* _tmp19;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csignew = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_signal_new")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ((_tmp2 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (((ValaSymbol*) sig))))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	(_tmp2 = (g_free (_tmp2), NULL));
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_data_type_get_upper_case_cname (type, "TYPE_"))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	marshaller = vala_code_generator_get_signal_marshaller_function (self, sig, NULL);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	params_len = gee_collection_get_size (params);
	if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* _tmp10;
		_tmp10 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	} else {
		if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
			ValaCCodeConstant* _tmp11;
			_tmp11 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("G_TYPE_NONE"))));
			(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		} else {
			ValaCCodeConstant* _tmp13;
			char* _tmp12;
			_tmp13 = NULL;
			_tmp12 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ((_tmp12 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_signal_get_return_type (sig))))))));
			(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
			(_tmp12 = (g_free (_tmp12), NULL));
		}
	}
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ((_tmp14 = g_strdup_printf ("%d", params_len))))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	(_tmp14 = (g_free (_tmp14), NULL));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (param)) != NULL) {
					ValaCCodeConstant* _tmp16;
					_tmp16 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
					(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
				} else {
					ValaCCodeConstant* _tmp18;
					char* _tmp17;
					_tmp18 = NULL;
					_tmp17 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ((_tmp17 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					(_tmp17 = (g_free (_tmp17), NULL));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	_tmp19 = NULL;
	return (_tmp19 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp19);
	(csignew == NULL ? NULL : (csignew = (g_object_unref (csignew), NULL)));
	(marshaller = (g_free (marshaller), NULL));
	(marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface)
{
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* _tmp6;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeConstant* _tmp9;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeIfStatement* _tmp13;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	GeeCollection* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	base_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_base_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (base_init, (_tmp5 = vala_ccode_formal_parameter_new ("iface", (_tmp4 = g_strdup_printf ("%sIface *", (_tmp3 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	(_tmp3 = (g_free (_tmp3), NULL));
	vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	/* make sure not to run the initialization code twice */
	_tmp6 = NULL;
	vala_ccode_function_set_block (base_init, (_tmp6 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	_tmp8 = NULL;
	decl = (_tmp8 = vala_ccode_declaration_new ((_tmp7 = vala_type_reference_get_cname (self->priv->bool_type, FALSE, FALSE))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
	vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | (VALA_CCODE_MODIFIERS_STATIC));
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer ("initialized", VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("FALSE")))))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (decl));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	cif = (_tmp13 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("initialized")))))), VALA_CCODE_STATEMENT (init_block), NULL), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp13);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (cif));
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("initialized"))), VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("TRUE"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	/* create properties */
	props = vala_interface_get_properties (iface);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				ValaCCodeIdentifier* _tmp18;
				ValaCCodeFunctionCall* _tmp19;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeIdentifier* _tmp20;
				ValaCCodeFunctionCall* _tmp21;
				ValaCCodeExpressionStatement* _tmp22;
				_tmp18 = NULL;
				_tmp19 = NULL;
				cinst = (_tmp19 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("g_object_interface_install_property")))), (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp19);
				_tmp20 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("iface"))));
				(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
				_tmp21 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp21 = vala_code_generator_get_param_spec (self, prop))));
				(_tmp21 = (g_object_unref (_tmp21), NULL));
				_tmp22 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp22 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	{
		GeeCollection* sig_collection;
		GeeIterator* sig_it;
		sig_collection = vala_interface_get_signals (iface);
		sig_it = gee_iterable_iterator (GEE_ITERABLE (sig_collection));
		while (gee_iterator_next (sig_it)) {
			ValaSignal* sig;
			sig = gee_iterator_get (sig_it);
			{
				ValaCCodeExpressionStatement* _tmp24;
				ValaCCodeFunctionCall* _tmp23;
				/* create signals */
				_tmp24 = NULL;
				_tmp23 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp24 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (iface))))))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				(_tmp23 = (g_object_unref (_tmp23), NULL));
				(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			}
		}
		(sig_collection == NULL ? NULL : (sig_collection = (g_object_unref (sig_collection), NULL)));
		(sig_it == NULL ? NULL : (sig_it = (g_object_unref (sig_it), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (base_init));
	(base_init == NULL ? NULL : (base_init = (g_object_unref (base_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeCollection* params;
	ValaMemberAccess* _tmp0;
	ValaMemberAccess* ma;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	GeeIterator* params_it;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_INVOCATION_EXPRESSION (expr));
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	if (!(VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)))) {
		vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), "unsupported method invocation");
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		return;
	}
	_tmp0 = NULL;
	ma = (_tmp0 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (VALA_IS_INVOKABLE (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr)))) {
		ValaInvokable* _tmp1;
		ValaInvokable* i;
		GeeCollection* _tmp2;
		_tmp1 = NULL;
		i = (_tmp1 = VALA_INVOKABLE (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		_tmp2 = NULL;
		params = (_tmp2 = vala_invokable_get_parameters (i), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp2);
		if (VALA_IS_METHOD (i)) {
			ValaMethod* _tmp4;
			ValaMethod* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			m = (_tmp4 = (_tmp3 = VALA_METHOD (i), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), _tmp4);
		} else {
			if (VALA_IS_SIGNAL (i)) {
				ValaCCodeFunctionCall* _tmp6;
				ValaCCodeFunctionCall* _tmp5;
				_tmp6 = NULL;
				_tmp5 = NULL;
				ccall = (_tmp6 = (_tmp5 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_invocation_expression_get_call (expr)))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp6);
			}
		}
		(i == NULL ? NULL : (i = (g_object_unref (i), NULL)));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArray* _tmp7;
		ValaArray* array;
		ValaCCodeIdentifier* _tmp9;
		char* _tmp8;
		_tmp7 = NULL;
		array = (_tmp7 = VALA_ARRAY (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
		_tmp9 = NULL;
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ((_tmp8 = vala_data_type_get_cname (VALA_DATA_TYPE (array), FALSE))))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		(_tmp8 = (g_free (_tmp8), NULL));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			self->priv->requires_array_move = TRUE;
		}
	}
	/* explicitly use strong reference as ccall gets unrefed
	 * at end of inner block
	 */
	instance = NULL;
	if (m != NULL && vala_method_get_instance (m)) {
		ValaMethod* _tmp10;
		ValaMethod* base_method;
		gboolean req_cast;
		_tmp10 = NULL;
		base_method = (_tmp10 = m, (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaMethod* _tmp12;
			ValaMethod* _tmp11;
			_tmp12 = NULL;
			_tmp11 = NULL;
			base_method = (_tmp12 = (_tmp11 = vala_method_get_base_interface_method (m), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp12);
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* _tmp14;
				ValaMethod* _tmp13;
				_tmp14 = NULL;
				_tmp13 = NULL;
				base_method = (_tmp14 = (_tmp13 = vala_method_get_base_method (m), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp14);
			}
		}
		req_cast = FALSE;
		if (vala_member_access_get_inner (ma) == NULL) {
			ValaCCodeExpression* _tmp15;
			_tmp15 = NULL;
			instance = (_tmp15 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp15);
			/* require casts for overriden and inherited methods */
			req_cast = vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL || (vala_symbol_get_parent_symbol (((ValaSymbol*) m)) != NULL && vala_symbol_get_parent_symbol (((ValaSymbol*) m)) != self->priv->current_type_symbol);
		} else {
			ValaCCodeExpression* _tmp17;
			ValaCCodeExpression* _tmp16;
			_tmp17 = NULL;
			_tmp16 = NULL;
			instance = (_tmp17 = (_tmp16 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp17);
			/* reqiure casts if the type of the used instance is
			 * different than the type which declared the method */
			req_cast = vala_symbol_get_parent_symbol (((ValaSymbol*) base_method)) != NULL && vala_symbol_get_parent_symbol (((ValaSymbol*) base_method)) != VALA_SYMBOL (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
		}
		if (vala_method_get_instance_by_reference (m) && (vala_member_access_get_inner (ma) != NULL || vala_symbol_get_parent_symbol (((ValaSymbol*) m)) != self->priv->current_type_symbol)) {
			ValaCCodeExpression* _tmp18;
			_tmp18 = NULL;
			instance = (_tmp18 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp18);
		}
		if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) m)))))) {
			ValaCCodeIdentifier* _tmp20;
			char* _tmp19;
			ValaCCodeFunctionCall* _tmp21;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeExpression* _tmp23;
			ValaCCodeFunctionCall* _tmp22;
			/* FIXME: use C cast if debugging disabled*/
			_tmp20 = NULL;
			_tmp19 = NULL;
			_tmp21 = NULL;
			ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ((_tmp19 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) base_method)))), NULL)))))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp21);
			vala_ccode_function_call_add_argument (ccall, instance);
			_tmp23 = NULL;
			_tmp22 = NULL;
			instance = (_tmp23 = VALA_CCODE_EXPRESSION ((_tmp22 = ccall, (_tmp22 == NULL ? NULL : g_object_ref (_tmp22)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp23);
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_call_add_argument (ccall, instance);
		}
		(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArray* _tmp24;
		ValaArray* array;
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeFunctionCall* _tmp26;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp28;
		char* _tmp27;
		_tmp24 = NULL;
		array = (_tmp24 = VALA_ARRAY (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24)));
		_tmp25 = NULL;
		_tmp26 = NULL;
		csizeof = (_tmp26 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("sizeof")))), (_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL))), _tmp26);
		_tmp28 = NULL;
		_tmp27 = NULL;
		vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ((_tmp27 = vala_data_type_get_cname (VALA_DATA_TYPE (array), FALSE))))));
		(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
		(_tmp27 = (g_free (_tmp27), NULL));
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (csizeof));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
	} else {
		if (VALA_IS_DBUS_METHOD (m)) {
			gboolean found_out;
			ValaExpression* callback;
			ValaCCodeConstant* _tmp32;
			char* _tmp31;
			found_out = FALSE;
			callback = NULL;
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = vala_invocation_expression_get_argument_list (expr);
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = gee_iterator_get (arg_it);
					{
						if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
							ValaExpression* _tmp30;
							ValaExpression* _tmp29;
							/* callback*/
							if (callback != NULL) {
								vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), "only one reply callback may be specified in invocation of DBus method");
								vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
								(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
								(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
								(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
								(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
								(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
								(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
								(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
								return;
							} else {
								if (found_out) {
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), "out argument and reply callback conflict in invocation of DBus method");
									vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
									(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
									(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
									(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
									(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
									(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
									(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
									(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
									return;
								}
							}
							_tmp30 = NULL;
							_tmp29 = NULL;
							callback = (_tmp30 = (_tmp29 = arg, (_tmp29 == NULL ? NULL : g_object_ref (_tmp29))), (callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL))), _tmp30);
						} else {
							if (VALA_IS_UNARY_EXPRESSION (arg) && vala_unary_expression_get_operator ((VALA_UNARY_EXPRESSION (arg))) == VALA_UNARY_OPERATOR_OUT) {
								/* out arg*/
								if (callback != NULL) {
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), "out argument and reply callback conflict in invocation of DBus method");
									vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
									(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
									(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
									(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
									(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
									(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
									(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
									(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
									return;
								}
								found_out = TRUE;
							} else {
								/* in arg*/
								if (callback != NULL || found_out) {
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), "in argument must not follow out argument or reply callback in invocation of DBus method");
									vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
									(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
									(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
									(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
									(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
									(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
									(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
									(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
									return;
								}
							}
						}
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			_tmp32 = NULL;
			_tmp31 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_constant_new ((_tmp31 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (((ValaSymbol*) m))))))));
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
			(_tmp31 = (g_free (_tmp31), NULL));
			if (callback != NULL) {
				ValaMethod* _tmp33;
				ValaMethod* reply_method;
				char* _tmp35;
				char* _tmp34;
				ValaCCodeFunction* _tmp36;
				ValaCCodeFunction* cb_fun;
				ValaCCodeFormalParameter* _tmp37;
				ValaCCodeFormalParameter* _tmp38;
				ValaCCodeFormalParameter* _tmp39;
				ValaCCodeBlock* _tmp40;
				ValaCCodeDeclaration* cerrdecl;
				ValaCCodeVariableDeclarator* _tmp42;
				ValaCCodeConstant* _tmp41;
				ValaCCodeIdentifier* _tmp43;
				ValaCCodeFunctionCall* _tmp44;
				ValaCCodeFunctionCall* cend_call;
				ValaCCodeIdentifier* _tmp45;
				ValaCCodeIdentifier* _tmp46;
				ValaCCodeUnaryExpression* _tmp48;
				ValaCCodeIdentifier* _tmp47;
				ValaCCodeFunctionCall* creply_call;
				ValaCCodeIdentifier* _tmp49;
				GeeCollection* _tmp50;
				gint _tmp51;
				gint param_count;
				gint i;
				ValaCCodeIdentifier* _tmp72;
				ValaCCodeExpressionStatement* _tmp73;
				ValaCCodeIdentifier* _tmp74;
				ValaCCodeExpressionStatement* _tmp75;
				ValaCCodeIdentifier* _tmp76;
				ValaCCodeConstant* _tmp77;
				ValaCCodeConstant* _tmp78;
				_tmp33 = NULL;
				reply_method = (_tmp33 = VALA_METHOD (vala_expression_get_symbol_reference (callback)), (_tmp33 == NULL ? NULL : g_object_ref (_tmp33)));
				_tmp35 = NULL;
				_tmp34 = NULL;
				_tmp36 = NULL;
				cb_fun = (_tmp36 = vala_ccode_function_new ((_tmp35 = g_strdup_printf ("_%s_cb", (_tmp34 = vala_method_get_cname (reply_method)))), "void"), (_tmp35 = (g_free (_tmp35), NULL)), (_tmp34 = (g_free (_tmp34), NULL)), _tmp36);
				vala_ccode_function_set_modifiers (cb_fun, VALA_CCODE_MODIFIERS_STATIC);
				_tmp37 = NULL;
				vala_ccode_function_add_parameter (cb_fun, (_tmp37 = vala_ccode_formal_parameter_new ("proxy", "DBusGProxy*")));
				(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
				_tmp38 = NULL;
				vala_ccode_function_add_parameter (cb_fun, (_tmp38 = vala_ccode_formal_parameter_new ("call", "DBusGProxyCall*")));
				(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
				_tmp39 = NULL;
				vala_ccode_function_add_parameter (cb_fun, (_tmp39 = vala_ccode_formal_parameter_new ("user_data", "void*")));
				(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
				_tmp40 = NULL;
				vala_ccode_function_set_block (cb_fun, (_tmp40 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
				(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
				cerrdecl = vala_ccode_declaration_new ("GError*");
				_tmp42 = NULL;
				_tmp41 = NULL;
				vala_ccode_declaration_add_declarator (cerrdecl, VALA_CCODE_DECLARATOR ((_tmp42 = vala_ccode_variable_declarator_new_with_initializer ("error", VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("NULL")))))));
				(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
				(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
				vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cerrdecl));
				_tmp43 = NULL;
				_tmp44 = NULL;
				cend_call = (_tmp44 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("dbus_g_proxy_end_call")))), (_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL))), _tmp44);
				_tmp45 = NULL;
				vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("proxy"))));
				(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
				_tmp46 = NULL;
				vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("call"))));
				(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
				_tmp48 = NULL;
				_tmp47 = NULL;
				vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_identifier_new ("error")))))));
				(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
				(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
				creply_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) callback))));
				_tmp49 = NULL;
				vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("user_data"))));
				(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
				_tmp50 = NULL;
				param_count = (_tmp51 = gee_collection_get_size ((_tmp50 = vala_invokable_get_parameters (VALA_INVOKABLE (reply_method)))), (_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL))), _tmp51);
				i = 0;
				{
					GeeCollection* param_collection;
					GeeIterator* param_it;
					param_collection = vala_invokable_get_parameters (VALA_INVOKABLE (reply_method));
					param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
					while (gee_iterator_next (param_it)) {
						ValaFormalParameter* param;
						param = gee_iterator_get (param_it);
						{
							if (((i = i + 1)) == param_count) {
								(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
								break;
							}
							/* error parameter*/
							if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_array_get_element_type ((VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))) != vala_type_reference_get_data_type (self->priv->string_type)) {
								ValaArray* _tmp52;
								ValaArray* array;
								ValaCCodeDeclaration* cdecl_;
								ValaCCodeVariableDeclarator* _tmp53;
								ValaCCodeExpression* _tmp54;
								ValaCCodeUnaryExpression* _tmp56;
								ValaCCodeIdentifier* _tmp55;
								ValaCCodeMemberAccess* _tmp58;
								ValaCCodeIdentifier* _tmp57;
								ValaCCodeMemberAccess* _tmp60;
								ValaCCodeIdentifier* _tmp59;
								_tmp52 = NULL;
								array = (_tmp52 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp52 == NULL ? NULL : g_object_ref (_tmp52)));
								cdecl_ = vala_ccode_declaration_new ("GArray*");
								_tmp53 = NULL;
								vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp53 = vala_ccode_variable_declarator_new (vala_symbol_get_name (((ValaSymbol*) param))))));
								(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
								vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
								_tmp54 = NULL;
								vala_ccode_function_call_add_argument (cend_call, (_tmp54 = vala_code_generator_get_dbus_array_type (self, array)));
								(_tmp54 = (g_object_unref (_tmp54), NULL));
								_tmp56 = NULL;
								_tmp55 = NULL;
								vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) param)))))))));
								(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
								(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
								_tmp58 = NULL;
								_tmp57 = NULL;
								vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) param))))), "len"))));
								(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
								(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
								_tmp60 = NULL;
								_tmp59 = NULL;
								vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) param))))), "data"))));
								(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
								(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
								(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
								(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
							} else {
								char* _tmp61;
								ValaCCodeDeclaration* _tmp62;
								ValaCCodeDeclaration* cdecl_;
								ValaCCodeVariableDeclarator* _tmp63;
								ValaCCodeIdentifier* _tmp65;
								char* _tmp64;
								ValaCCodeUnaryExpression* _tmp67;
								ValaCCodeIdentifier* _tmp66;
								ValaCCodeIdentifier* _tmp71;
								_tmp61 = NULL;
								_tmp62 = NULL;
								cdecl_ = (_tmp62 = vala_ccode_declaration_new ((_tmp61 = vala_type_reference_get_cname (vala_formal_parameter_get_type_reference (param), FALSE, FALSE))), (_tmp61 = (g_free (_tmp61), NULL)), _tmp62);
								_tmp63 = NULL;
								vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp63 = vala_ccode_variable_declarator_new (vala_symbol_get_name (((ValaSymbol*) param))))));
								(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
								vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
								_tmp65 = NULL;
								_tmp64 = NULL;
								vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_identifier_new ((_tmp64 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
								(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
								(_tmp64 = (g_free (_tmp64), NULL));
								_tmp67 = NULL;
								_tmp66 = NULL;
								vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) param)))))))));
								(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
								(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
								if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_array_get_element_type ((VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))) == vala_type_reference_get_data_type (self->priv->string_type)) {
									ValaCCodeIdentifier* _tmp68;
									ValaCCodeFunctionCall* _tmp69;
									ValaCCodeFunctionCall* cstrvlen;
									ValaCCodeIdentifier* _tmp70;
									/* special case string array*/
									_tmp68 = NULL;
									_tmp69 = NULL;
									cstrvlen = (_tmp69 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL))), _tmp69);
									_tmp70 = NULL;
									vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) param))))));
									(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
									vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION (cstrvlen));
									(cstrvlen == NULL ? NULL : (cstrvlen = (g_object_unref (cstrvlen), NULL)));
								}
								_tmp71 = NULL;
								vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) param))))));
								(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
								(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
							}
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
					}
					(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
					(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
				}
				_tmp72 = NULL;
				vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
				(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
				_tmp73 = NULL;
				vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp73 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cend_call)))));
				(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
				_tmp74 = NULL;
				vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ("error"))));
				(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
				_tmp75 = NULL;
				vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp75 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (creply_call)))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
				vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cb_fun));
				_tmp76 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new (vala_ccode_function_get_name (cb_fun)))));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				_tmp77 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_constant_new ("self"))));
				(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
				_tmp78 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_constant_new ("NULL"))));
				(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
				(reply_method == NULL ? NULL : (reply_method = (g_object_unref (reply_method), NULL)));
				(cb_fun == NULL ? NULL : (cb_fun = (g_object_unref (cb_fun), NULL)));
				(cerrdecl == NULL ? NULL : (cerrdecl = (g_object_unref (cerrdecl), NULL)));
				(cend_call == NULL ? NULL : (cend_call = (g_object_unref (cend_call), NULL)));
				(creply_call == NULL ? NULL : (creply_call = (g_object_unref (creply_call), NULL)));
			} else {
				if (found_out || vala_type_reference_get_data_type (vala_method_get_return_type (m)) != NULL) {
					ValaCCodeIdentifier* _tmp79;
					ValaCCodeUnaryExpression* _tmp81;
					ValaCCodeIdentifier* _tmp80;
					_tmp79 = NULL;
					vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new ("dbus_g_proxy_call"))));
					(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
					/* method can fail*/
					self->priv->current_method_inner_error = TRUE;
					_tmp81 = NULL;
					_tmp80 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new ("inner_error")))))));
					(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
					(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp82;
					_tmp82 = NULL;
					vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_identifier_new ("dbus_g_proxy_call_no_reply"))));
					(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
				}
			}
			(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
		}
	}
	ellipsis = FALSE;
	i = 1;
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	{
		GeeCollection* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaExpression* arg;
			arg = gee_iterator_get (arg_it);
			{
				ValaCCodeExpression* _tmp85;
				ValaCCodeExpression* cexpr;
				if (VALA_IS_DBUS_METHOD (m)) {
					ValaCCodeIdentifier* _tmp84;
					char* _tmp83;
					if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						break;
					}
					/* callback parameter*/
					_tmp84 = NULL;
					_tmp83 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_identifier_new ((_tmp83 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_expression_get_static_type (arg))))))));
					(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
					(_tmp83 = (g_free (_tmp83), NULL));
				}
				_tmp85 = NULL;
				cexpr = (_tmp85 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) arg))), (_tmp85 == NULL ? NULL : g_object_ref (_tmp85)));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = gee_iterator_get (params_it);
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
							if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaArray* _tmp86;
								ValaArray* arr;
								_tmp86 = NULL;
								arr = (_tmp86 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp86 == NULL ? NULL : g_object_ref (_tmp86)));
								{
									gint dim;
									dim = 0;
									for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
										ValaCCodeExpression* _tmp87;
										_tmp87 = NULL;
										vala_ccode_function_call_add_argument (ccall, (_tmp87 = vala_code_generator_get_array_length_cexpression (self, arg, dim)));
										(_tmp87 = (g_object_unref (_tmp87), NULL));
									}
								}
								(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
							}
							if (vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
								ValaCCodeIdentifier* _tmp89;
								char* _tmp88;
								ValaCCodeFunctionCall* _tmp90;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeExpression* _tmp92;
								ValaCCodeFunctionCall* _tmp91;
								/* FIXME: use C cast if debugging disabled*/
								_tmp89 = NULL;
								_tmp88 = NULL;
								_tmp90 = NULL;
								ccall = (_tmp90 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ((_tmp88 = vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL)))))), (_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL))), (_tmp88 = (g_free (_tmp88), NULL)), _tmp90);
								vala_ccode_function_call_add_argument (ccall, cexpr);
								_tmp92 = NULL;
								_tmp91 = NULL;
								cexpr = (_tmp92 = VALA_CCODE_EXPRESSION ((_tmp91 = ccall, (_tmp91 == NULL ? NULL : g_object_ref (_tmp91)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp92);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							}
						} else {
							if (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaCCodeExpression* _tmp94;
								char* _tmp93;
								_tmp94 = NULL;
								_tmp93 = NULL;
								cexpr = (_tmp94 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, (_tmp93 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), FALSE)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp94);
								(_tmp93 = (g_free (_tmp93), NULL));
							} else {
								if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (arg)))) {
									ValaCCodeExpression* _tmp95;
									_tmp95 = NULL;
									cexpr = (_tmp95 = vala_code_generator_convert_to_generic_pointer (self, cexpr, vala_expression_get_static_type (arg)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp95);
								}
							}
						}
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
				vala_ccode_function_call_add_argument (ccall, cexpr);
				i++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	while (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = gee_iterator_get (params_it);
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* _tmp96;
			_tmp96 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) expr)), (_tmp96 = g_strdup_printf ("no default expression for argument %d", i)));
			(_tmp96 = (g_free (_tmp96), NULL));
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_type_reference (param) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
			ValaArray* _tmp97;
			ValaArray* arr;
			_tmp97 = NULL;
			arr = (_tmp97 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp97 == NULL ? NULL : g_object_ref (_tmp97)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeExpression* _tmp98;
					_tmp98 = NULL;
					vala_ccode_function_call_add_argument (ccall, (_tmp98 = vala_code_generator_get_array_length_cexpression (self, vala_formal_parameter_get_default_expression (param), dim)));
					(_tmp98 = (g_object_unref (_tmp98), NULL));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_formal_parameter_get_default_expression (param)))));
		i++;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))) && !(VALA_IS_DBUS_METHOD (m))) {
		ValaArray* _tmp99;
		ValaArray* arr;
		_tmp99 = NULL;
		arr = (_tmp99 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (_tmp99 == NULL ? NULL : g_object_ref (_tmp99)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaVariableDeclarator* temp_decl;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp100;
					temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
					gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
					_tmp100 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp100 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* _tmp101;
					_tmp101 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp101 = vala_ccode_constant_new ("-1"))));
					(_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL)));
				}
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	if (self->priv->connection_type != NULL && vala_member_access_get_inner (ma) != NULL && vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))) == self->priv->connection_type && g_utf8_collate (vala_symbol_get_name (((ValaSymbol*) m)), "get_object") == 0) {
		ValaInterface* _tmp102;
		ValaInterface* dbus_iface;
		ValaAttribute* dbus_attr;
		ValaCCodeConstant* _tmp105;
		char* _tmp104;
		char* _tmp103;
		_tmp102 = NULL;
		dbus_iface = (_tmp102 = VALA_INTERFACE (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (_tmp102 == NULL ? NULL : g_object_ref (_tmp102)));
		dbus_attr = vala_code_node_get_attribute (VALA_CODE_NODE (dbus_iface), "DBusInterface");
		_tmp105 = NULL;
		_tmp104 = NULL;
		_tmp103 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_constant_new ((_tmp104 = g_strdup_printf ("\"%s\"", (_tmp103 = vala_attribute_get_string (dbus_attr, "name"))))))));
		(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
		(_tmp104 = (g_free (_tmp104), NULL));
		(_tmp103 = (g_free (_tmp103), NULL));
		(dbus_iface == NULL ? NULL : (dbus_iface = (g_object_unref (dbus_iface), NULL)));
		(dbus_attr == NULL ? NULL : (dbus_attr = (g_object_unref (dbus_attr), NULL)));
	} else {
		if (VALA_IS_DBUS_METHOD (m)) {
			ValaCCodeIdentifier* _tmp106;
			_tmp106 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp106 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
			(_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL)));
		}
	}
	if (vala_expression_get_can_fail (((ValaExpression*) expr)) && !(VALA_IS_DBUS_METHOD (m))) {
		ValaCCodeUnaryExpression* _tmp108;
		ValaCCodeIdentifier* _tmp107;
		/* method can fail*/
		self->priv->current_method_inner_error = TRUE;
		_tmp108 = NULL;
		_tmp107 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_identifier_new ("inner_error")))))));
		(_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL)));
		(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_call_add_argument (ccall, instance);
	} else {
		if (ellipsis) {
			/* ensure variable argument list ends with NULL
			 * except when using printf-style arguments */
			if ((m == NULL || !vala_method_get_printf_format (m)) && !(VALA_IS_DBUS_METHOD (m))) {
				ValaCCodeConstant* _tmp109;
				_tmp109 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_constant_new (vala_method_get_sentinel (m)))));
				(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
			}
		}
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* _tmp110;
		_tmp110 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp110 = vala_ccode_assignment_new (instance, VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_type_reference_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (((ValaExpression*) expr))) != NULL) {
			ValaCCodeExpression* _tmp111;
			_tmp111 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp111 = vala_code_generator_convert_from_generic_pointer (self, VALA_CCODE_EXPRESSION (ccall), vala_expression_get_static_type (((ValaExpression*) expr))))));
			(_tmp111 = (g_object_unref (_tmp111), NULL));
		} else {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
		}
		vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeCollection* _tmp112;
		GeeIterator* _tmp113;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp115;
		ValaExpression* _tmp114;
		ValaCCodeExpression* _tmp116;
		ValaCCodeExpression* new_size;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp117;
		ValaCCodeExpression* celems;
		char* _tmp119;
		char* _tmp118;
		ValaCCodeIdentifier* _tmp120;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* _tmp121;
		ValaCCodeParenthesizedExpression* _tmp122;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp123;
		ValaCCodeFunctionCall* _tmp124;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp125;
		ValaCCodeConstant* _tmp126;
		ValaCCodeBinaryExpression* _tmp127;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp128;
		ValaCCodeConditionalExpression* _tmp130;
		ValaCCodeConstant* _tmp129;
		ValaCCodeAssignment* _tmp132;
		ValaCCodeExpression* _tmp131;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp112 = NULL;
		_tmp113 = NULL;
		arg_it = (_tmp113 = gee_iterable_iterator (GEE_ITERABLE ((_tmp112 = vala_invocation_expression_get_argument_list (expr)))), (_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL))), _tmp113);
		gee_iterator_next (arg_it);
		_tmp115 = NULL;
		_tmp114 = NULL;
		_tmp116 = NULL;
		new_size = (_tmp116 = (_tmp115 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (_tmp114 = gee_iterator_get (arg_it))))), (_tmp115 == NULL ? NULL : g_object_ref (_tmp115))), (_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL))), _tmp116);
		temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
		gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
		/* memset needs string.h */
		self->priv->string_h_needed = TRUE;
		clen = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1);
		_tmp117 = NULL;
		celems = (_tmp117 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (ma)))), (_tmp117 == NULL ? NULL : g_object_ref (_tmp117)));
		_tmp119 = NULL;
		_tmp118 = NULL;
		_tmp120 = NULL;
		csizeof = (_tmp120 = vala_ccode_identifier_new ((_tmp119 = g_strdup_printf ("sizeof (%s)", (_tmp118 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), FALSE))))), (_tmp119 = (g_free (_tmp119), NULL)), (_tmp118 = (g_free (_tmp118), NULL)), _tmp120);
		_tmp121 = NULL;
		_tmp122 = NULL;
		cdelta = (_tmp122 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp121 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)))), (_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL))), _tmp122);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		_tmp123 = NULL;
		_tmp124 = NULL;
		czero = (_tmp124 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp123 = vala_ccode_identifier_new ("memset")))), (_tmp123 == NULL ? NULL : (_tmp123 = (g_object_unref (_tmp123), NULL))), _tmp124);
		_tmp125 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(_tmp125 == NULL ? NULL : (_tmp125 = (g_object_unref (_tmp125), NULL)));
		_tmp126 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_constant_new ("0"))));
		(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
		_tmp127 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		_tmp128 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) expr))));
		_tmp130 = NULL;
		_tmp129 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp130 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_constant_new ("NULL")))))));
		(_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL)));
		(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
		_tmp132 = NULL;
		_tmp131 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp132 = vala_ccode_assignment_new ((_tmp131 = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1)), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp132 == NULL ? NULL : (_tmp132 = (g_object_unref (_tmp132), NULL)));
		(_tmp131 = (g_object_unref (_tmp131), NULL));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen = (g_object_unref (clen), NULL));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (m == self->priv->substring_method) {
			ValaVariableDeclarator* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp133;
			ValaCCodeFunctionCall* _tmp134;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp135;
			ValaCCodeExpression* _tmp136;
			ValaCCodeIdentifier* _tmp137;
			ValaCCodeFunctionCall* _tmp138;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp139;
			ValaCCodeIdentifier* _tmp140;
			ValaCCodeFunctionCall* _tmp141;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp142;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp143;
			temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->string_type, TRUE);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
			gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp133 = NULL;
			_tmp134 = NULL;
			coffsetcall = (_tmp134 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp133 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp133 == NULL ? NULL : (_tmp133 = (g_object_unref (_tmp133), NULL))), _tmp134);
			/* full string*/
			_tmp135 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp135 = gee_list_get (((GeeList*) args), 0)));
			(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
			/* offset*/
			_tmp136 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp136 = gee_list_get (((GeeList*) args), 1)));
			(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
			_tmp137 = NULL;
			_tmp138 = NULL;
			coffsetcall2 = (_tmp138 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp137 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL))), _tmp138);
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			_tmp139 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (_tmp139 = gee_list_get (((GeeList*) args), 2)));
			(_tmp139 == NULL ? NULL : (_tmp139 = (g_object_unref (_tmp139), NULL)));
			_tmp140 = NULL;
			_tmp141 = NULL;
			cndupcall = (_tmp141 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_identifier_new ("g_strndup")))), (_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL))), _tmp141);
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp142 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((_tmp142 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp142 == NULL ? NULL : (_tmp142 = (g_object_unref (_tmp142), NULL)));
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			_tmp143 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp143 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp143 == NULL ? NULL : (_tmp143 = (g_object_unref (_tmp143), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (g_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (g_object_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (g_object_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		} else {
			if (VALA_IS_DBUS_METHOD (m) && vala_type_reference_get_data_type (vala_method_get_return_type (m)) != NULL) {
				/* synchronous D-Bus method call with reply*/
				if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))) && vala_array_get_element_type ((VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))))) != vala_type_reference_get_data_type (self->priv->string_type)) {
					ValaArray* _tmp144;
					ValaArray* array;
					ValaCCodeExpression* _tmp145;
					ValaTypeReference* garray_type_reference;
					ValaVariableDeclarator* temp_decl;
					ValaCCodeUnaryExpression* _tmp147;
					ValaCCodeIdentifier* _tmp146;
					ValaCCodeIdentifier* _tmp148;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeMemberAccess* _tmp150;
					ValaCCodeIdentifier* _tmp149;
					_tmp144 = NULL;
					array = (_tmp144 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (_tmp144 == NULL ? NULL : g_object_ref (_tmp144)));
					_tmp145 = NULL;
					vala_ccode_function_call_add_argument (ccall, (_tmp145 = vala_code_generator_get_dbus_array_type (self, array)));
					(_tmp145 = (g_object_unref (_tmp145), NULL));
					garray_type_reference = vala_type_reference_new ();
					vala_type_reference_set_data_type (garray_type_reference, self->priv->garray_type);
					temp_decl = vala_code_generator_get_temp_variable_declarator (self, garray_type_reference, TRUE);
					gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
					_tmp147 = NULL;
					_tmp146 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp147 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp146 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)))))))));
					(_tmp147 == NULL ? NULL : (_tmp147 = (g_object_unref (_tmp147), NULL)));
					(_tmp146 == NULL ? NULL : (_tmp146 = (g_object_unref (_tmp146), NULL)));
					_tmp148 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp148 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
					(_tmp148 == NULL ? NULL : (_tmp148 = (g_object_unref (_tmp148), NULL)));
					ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
					_tmp150 = NULL;
					_tmp149 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp149 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), "data"))));
					(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
					(_tmp149 == NULL ? NULL : (_tmp149 = (g_object_unref (_tmp149), NULL)));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
					if (!vala_method_get_no_array_length (m)) {
						ValaCCodeMemberAccess* _tmp152;
						ValaCCodeIdentifier* _tmp151;
						_tmp152 = NULL;
						_tmp151 = NULL;
						vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp152 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))), "len"))));
						(_tmp152 == NULL ? NULL : (_tmp152 = (g_object_unref (_tmp152), NULL)));
						(_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL)));
					} else {
						ValaCCodeConstant* _tmp153;
						_tmp153 = NULL;
						vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp153 = vala_ccode_constant_new ("-1"))));
						(_tmp153 == NULL ? NULL : (_tmp153 = (g_object_unref (_tmp153), NULL)));
					}
					(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
					(garray_type_reference == NULL ? NULL : (garray_type_reference = (g_object_unref (garray_type_reference), NULL)));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp155;
					char* _tmp154;
					ValaVariableDeclarator* temp_decl;
					ValaCCodeUnaryExpression* _tmp157;
					ValaCCodeIdentifier* _tmp156;
					ValaCCodeIdentifier* _tmp158;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeIdentifier* _tmp159;
					_tmp155 = NULL;
					_tmp154 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp155 = vala_ccode_identifier_new ((_tmp154 = vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_method_get_return_type (m))))))));
					(_tmp155 == NULL ? NULL : (_tmp155 = (g_object_unref (_tmp155), NULL)));
					(_tmp154 = (g_free (_tmp154), NULL));
					temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_method_get_return_type (m), TRUE);
					gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
					_tmp157 = NULL;
					_tmp156 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)))))))));
					(_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL)));
					(_tmp156 == NULL ? NULL : (_tmp156 = (g_object_unref (_tmp156), NULL)));
					_tmp158 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
					(_tmp158 == NULL ? NULL : (_tmp158 = (g_object_unref (_tmp158), NULL)));
					ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
					_tmp159 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp159 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
					(_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL)));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
					if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))) && vala_array_get_element_type ((VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))))) == vala_type_reference_get_data_type (self->priv->string_type)) {
						/* special case string array*/
						if (!vala_method_get_no_array_length (m)) {
							ValaCCodeIdentifier* _tmp160;
							ValaCCodeFunctionCall* _tmp161;
							ValaCCodeFunctionCall* cstrvlen;
							ValaCCodeIdentifier* _tmp162;
							_tmp160 = NULL;
							_tmp161 = NULL;
							cstrvlen = (_tmp161 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL))), _tmp161);
							_tmp162 = NULL;
							vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl))))));
							(_tmp162 == NULL ? NULL : (_tmp162 = (g_object_unref (_tmp162), NULL)));
							vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (cstrvlen));
							(cstrvlen == NULL ? NULL : (cstrvlen = (g_object_unref (cstrvlen), NULL)));
						} else {
							ValaCCodeConstant* _tmp163;
							_tmp163 = NULL;
							vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp163 = vala_ccode_constant_new ("-1"))));
							(_tmp163 == NULL ? NULL : (_tmp163 = (g_object_unref (_tmp163), NULL)));
						}
					}
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				}
			}
		}
	}
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_dbus_array_type (ValaCodeGenerator* self, ValaArray* array)
{
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* carray_type;
	ValaCCodeConstant* _tmp2;
	ValaCCodeIdentifier* _tmp4;
	char* _tmp3;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ARRAY (array), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	carray_type = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("\"GArray\""))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ((_tmp3 = vala_data_type_get_type_id (vala_array_get_element_type (array)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	(_tmp3 = (g_free (_tmp3), NULL));
	return VALA_CCODE_EXPRESSION (carray_type);
	(carray_type == NULL ? NULL : (carray_type = (g_object_unref (carray_type), NULL)));
}


static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	g_return_if_fail (pub_inst == NULL || VALA_IS_CCODE_EXPRESSION (pub_inst));
	g_return_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type));
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
		ValaMethod* _tmp0;
		ValaMethod* m;
		_tmp0 = NULL;
		m = (_tmp0 = VALA_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaInterface* _tmp1;
				ValaInterface* base_iface;
				char* _tmp3;
				char* _tmp2;
				char* _tmp4;
				char* parent_iface_var;
				ValaCCodeMemberAccess* _tmp6;
				ValaCCodeIdentifier* _tmp5;
				_tmp1 = NULL;
				base_iface = (_tmp1 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_interface_method (m)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp4 = NULL;
				parent_iface_var = (_tmp4 = g_strdup_printf ("%s_%s_parent_iface", (_tmp2 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->current_class), NULL)), (_tmp3 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_iface), NULL))), (_tmp3 = (g_free (_tmp3), NULL)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp4);
				_tmp6 = NULL;
				_tmp5 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (parent_iface_var))), vala_symbol_get_name (((ValaSymbol*) m))))));
				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				return;
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
			} else {
				if (vala_method_get_base_method (m) != NULL) {
					ValaClass* _tmp7;
					ValaClass* base_class;
					ValaCCodeIdentifier* _tmp10;
					char* _tmp9;
					char* _tmp8;
					ValaCCodeFunctionCall* _tmp11;
					ValaCCodeFunctionCall* vcast;
					ValaCCodeIdentifier* _tmp14;
					char* _tmp13;
					char* _tmp12;
					ValaCCodeMemberAccess* _tmp15;
					_tmp7 = NULL;
					base_class = (_tmp7 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_method (m)))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
					_tmp10 = NULL;
					_tmp9 = NULL;
					_tmp8 = NULL;
					_tmp11 = NULL;
					vcast = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = g_strdup_printf ("%s_CLASS", (_tmp8 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (base_class), NULL)))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), (_tmp8 = (g_free (_tmp8), NULL)), _tmp11);
					_tmp14 = NULL;
					_tmp13 = NULL;
					_tmp12 = NULL;
					vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = g_strdup_printf ("%s_parent_class", (_tmp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->current_class), NULL))))))));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
					(_tmp13 = (g_free (_tmp13), NULL));
					(_tmp12 = (g_free (_tmp12), NULL));
					_tmp15 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp15 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_symbol_get_name (((ValaSymbol*) m))))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					return;
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
				}
			}
		}
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaCCodeIdentifier* _tmp17;
			char* _tmp16;
			_tmp17 = NULL;
			_tmp16 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_method_get_cname (vala_method_get_base_interface_method (m)))))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
			(_tmp16 = (g_free (_tmp16), NULL));
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp19;
				char* _tmp18;
				_tmp19 = NULL;
				_tmp18 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_method_get_cname (vala_method_get_base_method (m)))))));
				(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
				(_tmp18 = (g_free (_tmp18), NULL));
			} else {
				ValaCCodeIdentifier* _tmp21;
				char* _tmp20;
				_tmp21 = NULL;
				_tmp20 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = vala_method_get_cname (m))))));
				(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
				(_tmp20 = (g_free (_tmp20), NULL));
			}
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
			ValaCCodeExpression* _tmp22;
			_tmp22 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp22 = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (expr), 1))));
			(_tmp22 = (g_object_unref (_tmp22), NULL));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
				ValaField* _tmp23;
				ValaField* f;
				_tmp23 = NULL;
				f = (_tmp23 = VALA_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23)));
				if (vala_field_get_instance (f)) {
					ValaCCodeExpression* typed_inst;
					ValaCCodeExpression* inst;
					typed_inst = NULL;
					if (vala_symbol_get_parent_symbol (((ValaSymbol*) f)) != VALA_SYMBOL (base_type)) {
						if (vala_code_context_get_debug (self->priv->context)) {
							ValaCCodeExpression* _tmp26;
							ValaCCodeIdentifier* _tmp25;
							char* _tmp24;
							_tmp26 = NULL;
							_tmp25 = NULL;
							_tmp24 = NULL;
							typed_inst = (_tmp26 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) f)))), NULL))))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), _tmp26);
							(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
							(_tmp24 = (g_free (_tmp24), NULL));
							vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
						} else {
							ValaCCodeExpression* _tmp29;
							char* _tmp28;
							char* _tmp27;
							_tmp29 = NULL;
							_tmp28 = NULL;
							_tmp27 = NULL;
							typed_inst = (_tmp29 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (pub_inst, (_tmp28 = g_strconcat ((_tmp27 = vala_data_type_get_cname ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) f)))), FALSE)), "*", NULL)))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), _tmp29);
							(_tmp28 = (g_free (_tmp28), NULL));
							(_tmp27 = (g_free (_tmp27), NULL));
						}
					} else {
						ValaCCodeExpression* _tmp31;
						ValaCCodeExpression* _tmp30;
						_tmp31 = NULL;
						_tmp30 = NULL;
						typed_inst = (_tmp31 = (_tmp30 = pub_inst, (_tmp30 == NULL ? NULL : g_object_ref (_tmp30))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), _tmp31);
					}
					inst = NULL;
					if (vala_symbol_get_access (((ValaSymbol*) f)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* _tmp32;
						_tmp32 = NULL;
						inst = (_tmp32 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp32);
					} else {
						ValaCCodeExpression* _tmp34;
						ValaCCodeExpression* _tmp33;
						_tmp34 = NULL;
						_tmp33 = NULL;
						inst = (_tmp34 = (_tmp33 = typed_inst, (_tmp33 == NULL ? NULL : g_object_ref (_tmp33))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp34);
					}
					if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) f)))))) {
						ValaCCodeMemberAccess* _tmp36;
						char* _tmp35;
						_tmp36 = NULL;
						_tmp35 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp36 = vala_ccode_member_access_new_pointer (inst, (_tmp35 = vala_field_get_cname (f))))));
						(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
						(_tmp35 = (g_free (_tmp35), NULL));
					} else {
						ValaCCodeMemberAccess* _tmp38;
						char* _tmp37;
						_tmp38 = NULL;
						_tmp37 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp38 = vala_ccode_member_access_new (inst, (_tmp37 = vala_field_get_cname (f)), FALSE))));
						(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
						(_tmp37 = (g_free (_tmp37), NULL));
					}
					(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp40;
					char* _tmp39;
					_tmp40 = NULL;
					_tmp39 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp40 = vala_ccode_identifier_new ((_tmp39 = vala_field_get_cname (f))))));
					(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
					(_tmp39 = (g_free (_tmp39), NULL));
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
					ValaConstant* _tmp41;
					ValaConstant* c;
					ValaCCodeIdentifier* _tmp43;
					char* _tmp42;
					_tmp41 = NULL;
					c = (_tmp41 = VALA_CONSTANT (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp41 == NULL ? NULL : g_object_ref (_tmp41)));
					_tmp43 = NULL;
					_tmp42 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp43 = vala_ccode_identifier_new ((_tmp42 = vala_constant_get_cname (c))))));
					(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
					(_tmp42 = (g_free (_tmp42), NULL));
					(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
						ValaProperty* _tmp44;
						ValaProperty* prop;
						_tmp44 = NULL;
						prop = (_tmp44 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp44 == NULL ? NULL : g_object_ref (_tmp44)));
						if (!vala_property_get_no_accessor_method (prop)) {
							ValaProperty* _tmp45;
							ValaProperty* base_property;
							ValaDataType* _tmp50;
							ValaDataType* base_property_type;
							ValaCCodeIdentifier* _tmp53;
							char* _tmp52;
							char* _tmp51;
							ValaCCodeFunctionCall* _tmp54;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeExpression* _tmp55;
							ValaCCodeExpression* typed_pub_inst;
							_tmp45 = NULL;
							base_property = (_tmp45 = prop, (_tmp45 == NULL ? NULL : g_object_ref (_tmp45)));
							if (vala_property_get_base_property (prop) != NULL) {
								ValaProperty* _tmp47;
								ValaProperty* _tmp46;
								_tmp47 = NULL;
								_tmp46 = NULL;
								base_property = (_tmp47 = (_tmp46 = vala_property_get_base_property (prop), (_tmp46 == NULL ? NULL : g_object_ref (_tmp46))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp47);
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaProperty* _tmp49;
									ValaProperty* _tmp48;
									_tmp49 = NULL;
									_tmp48 = NULL;
									base_property = (_tmp49 = (_tmp48 = vala_property_get_base_interface_property (prop), (_tmp48 == NULL ? NULL : g_object_ref (_tmp48))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp49);
								}
							}
							_tmp50 = NULL;
							base_property_type = (_tmp50 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) base_property))), (_tmp50 == NULL ? NULL : g_object_ref (_tmp50)));
							_tmp53 = NULL;
							_tmp52 = NULL;
							_tmp51 = NULL;
							_tmp54 = NULL;
							ccall = (_tmp54 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new ((_tmp52 = g_strdup_printf ("%s_get_%s", (_tmp51 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (((ValaSymbol*) base_property)))))))), (_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL))), (_tmp52 = (g_free (_tmp52), NULL)), (_tmp51 = (g_free (_tmp51), NULL)), _tmp54);
							_tmp55 = NULL;
							typed_pub_inst = (_tmp55 = pub_inst, (_tmp55 == NULL ? NULL : g_object_ref (_tmp55)));
							/* cast if necessary */
							if (base_property_type != base_type) {
								if (vala_code_context_get_debug (self->priv->context)) {
									ValaCCodeIdentifier* _tmp57;
									char* _tmp56;
									ValaCCodeFunctionCall* _tmp58;
									ValaCCodeFunctionCall* ccast;
									ValaCCodeExpression* _tmp60;
									ValaCCodeFunctionCall* _tmp59;
									_tmp57 = NULL;
									_tmp56 = NULL;
									_tmp58 = NULL;
									ccast = (_tmp58 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ((_tmp56 = vala_data_type_get_upper_case_cname (base_property_type, NULL)))))), (_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL))), (_tmp56 = (g_free (_tmp56), NULL)), _tmp58);
									vala_ccode_function_call_add_argument (ccast, pub_inst);
									_tmp60 = NULL;
									_tmp59 = NULL;
									typed_pub_inst = (_tmp60 = VALA_CCODE_EXPRESSION ((_tmp59 = ccast, (_tmp59 == NULL ? NULL : g_object_ref (_tmp59)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), _tmp60);
									(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
								} else {
									ValaCCodeExpression* _tmp63;
									char* _tmp62;
									char* _tmp61;
									_tmp63 = NULL;
									_tmp62 = NULL;
									_tmp61 = NULL;
									typed_pub_inst = (_tmp63 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (pub_inst, (_tmp62 = g_strconcat ((_tmp61 = vala_data_type_get_cname (base_property_type, FALSE)), "*", NULL)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), _tmp63);
									(_tmp62 = (g_free (_tmp62), NULL));
									(_tmp61 = (g_free (_tmp61), NULL));
								}
							}
							vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
							(base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL)));
							(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
						} else {
							ValaCCodeIdentifier* _tmp64;
							ValaCCodeFunctionCall* _tmp65;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp66;
							ValaCCodeFunctionCall* _tmp67;
							ValaCCodeFunctionCall* ccast;
							ValaCCodeConstant* _tmp68;
							ValaVariableDeclarator* temp_decl;
							ValaCCodeIdentifier* ctemp;
							ValaCCodeUnaryExpression* _tmp69;
							ValaCCodeConstant* _tmp70;
							ValaCCodeCommaExpression* ccomma;
							_tmp64 = NULL;
							_tmp65 = NULL;
							ccall = (_tmp65 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_identifier_new ("g_object_get")))), (_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL))), _tmp65);
							_tmp66 = NULL;
							_tmp67 = NULL;
							ccast = (_tmp67 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL))), _tmp67);
							vala_ccode_function_call_add_argument (ccast, pub_inst);
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
							/* property name is second argument of g_object_get*/
							_tmp68 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp68 = vala_property_get_canonical_cconstant (prop))));
							(_tmp68 = (g_object_unref (_tmp68), NULL));
							/* we need a temporary variable to save the property value*/
							temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (((ValaExpression*) expr)), TRUE);
							gee_list_insert (GEE_LIST (self->priv->temp_vars), 0, temp_decl);
							ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) temp_decl)));
							_tmp69 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
							(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
							_tmp70 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_constant_new ("NULL"))));
							(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
							ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
							(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
						}
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
							ValaEnumValue* _tmp71;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp73;
							char* _tmp72;
							_tmp71 = NULL;
							ev = (_tmp71 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp71 == NULL ? NULL : g_object_ref (_tmp71)));
							_tmp73 = NULL;
							_tmp72 = NULL;
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp73 = vala_ccode_constant_new ((_tmp72 = vala_enum_value_get_cname (ev))))));
							(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
							(_tmp72 = (g_free (_tmp72), NULL));
							(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
						} else {
							if (VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
								ValaVariableDeclarator* _tmp74;
								ValaVariableDeclarator* decl;
								ValaCCodeIdentifier* _tmp76;
								char* _tmp75;
								_tmp74 = NULL;
								decl = (_tmp74 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp74 == NULL ? NULL : g_object_ref (_tmp74)));
								_tmp76 = NULL;
								_tmp75 = NULL;
								vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp76 = vala_ccode_identifier_new ((_tmp75 = vala_code_generator_get_variable_cname (self, vala_symbol_get_name (((ValaSymbol*) decl))))))));
								(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
								(_tmp75 = (g_free (_tmp75), NULL));
								(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
									ValaFormalParameter* _tmp77;
									ValaFormalParameter* p;
									_tmp77 = NULL;
									p = (_tmp77 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp77 == NULL ? NULL : g_object_ref (_tmp77)));
									if (g_utf8_collate (vala_symbol_get_name (((ValaSymbol*) p)), "this") == 0) {
										vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (pub_inst));
									} else {
										if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (p)) || vala_type_reference_get_is_ref (vala_formal_parameter_get_type_reference (p))) {
											ValaCCodeIdentifier* _tmp79;
											char* _tmp78;
											_tmp79 = NULL;
											_tmp78 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp79 = vala_ccode_identifier_new ((_tmp78 = g_strdup_printf ("(*%s)", vala_symbol_get_name (((ValaSymbol*) p))))))));
											(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
											(_tmp78 = (g_free (_tmp78), NULL));
										} else {
											ValaCCodeIdentifier* _tmp80;
											_tmp80 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp80 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) p))))));
											(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
										}
									}
									(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) expr)))) {
										ValaSignal* _tmp81;
										ValaSignal* sig;
										ValaDataType* _tmp82;
										ValaDataType* cl;
										_tmp81 = NULL;
										sig = (_tmp81 = VALA_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) expr))), (_tmp81 == NULL ? NULL : g_object_ref (_tmp81)));
										_tmp82 = NULL;
										cl = (_tmp82 = VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) sig))), (_tmp82 == NULL ? NULL : g_object_ref (_tmp82)));
										if (vala_signal_get_has_emitter (sig)) {
											ValaCCodeIdentifier* _tmp85;
											char* _tmp84;
											char* _tmp83;
											ValaCCodeFunctionCall* _tmp86;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeExpression* _tmp87;
											ValaCCodeExpression* typed_pub_inst;
											_tmp85 = NULL;
											_tmp84 = NULL;
											_tmp83 = NULL;
											_tmp86 = NULL;
											ccall = (_tmp86 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_identifier_new ((_tmp84 = g_strdup_printf ("%s_%s", (_tmp83 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (((ValaSymbol*) sig)))))))), (_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL))), (_tmp84 = (g_free (_tmp84), NULL)), (_tmp83 = (g_free (_tmp83), NULL)), _tmp86);
											/* explicitly use strong reference as ccast
											 * gets unrefed at the end of the inner block
											 */
											_tmp87 = NULL;
											typed_pub_inst = (_tmp87 = pub_inst, (_tmp87 == NULL ? NULL : g_object_ref (_tmp87)));
											/* cast if necessary */
											if (cl != base_type) {
												ValaCCodeIdentifier* _tmp89;
												char* _tmp88;
												ValaCCodeFunctionCall* _tmp90;
												ValaCCodeFunctionCall* ccast;
												ValaCCodeExpression* _tmp92;
												ValaCCodeFunctionCall* _tmp91;
												/* FIXME: use C cast if debugging disabled*/
												_tmp89 = NULL;
												_tmp88 = NULL;
												_tmp90 = NULL;
												ccast = (_tmp90 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ((_tmp88 = vala_data_type_get_upper_case_cname (cl, NULL)))))), (_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL))), (_tmp88 = (g_free (_tmp88), NULL)), _tmp90);
												vala_ccode_function_call_add_argument (ccast, pub_inst);
												_tmp92 = NULL;
												_tmp91 = NULL;
												typed_pub_inst = (_tmp92 = VALA_CCODE_EXPRESSION ((_tmp91 = ccast, (_tmp91 == NULL ? NULL : g_object_ref (_tmp91)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), _tmp92);
												(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
											}
											vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
										} else {
											ValaCCodeIdentifier* _tmp93;
											ValaCCodeFunctionCall* _tmp94;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeIdentifier* _tmp95;
											ValaCCodeFunctionCall* _tmp96;
											ValaCCodeFunctionCall* ccast;
											ValaCCodeConstant* _tmp97;
											_tmp93 = NULL;
											_tmp94 = NULL;
											ccall = (_tmp94 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_identifier_new ("g_signal_emit_by_name")))), (_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL))), _tmp94);
											/* FIXME: use C cast if debugging disabled*/
											_tmp95 = NULL;
											_tmp96 = NULL;
											ccast = (_tmp96 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL))), _tmp96);
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
											_tmp97 = NULL;
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp97 = vala_signal_get_canonical_cconstant (sig))));
											(_tmp97 = (g_object_unref (_tmp97), NULL));
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) == NULL) {
		ValaCCodeExpression* _tmp0;
		_tmp0 = NULL;
		pub_inst = (_tmp0 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp0);
		if (self->priv->current_type_symbol != NULL) {
			ValaDataType* _tmp2;
			ValaDataType* _tmp1;
			/* base type is available if this is a type method */
			_tmp2 = NULL;
			_tmp1 = NULL;
			base_type = (_tmp2 = (_tmp1 = VALA_DATA_TYPE (self->priv->current_type_symbol), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp2);
			if (!vala_data_type_is_reference_type (base_type)) {
				ValaCCodeExpression* _tmp3;
				_tmp3 = NULL;
				pub_inst = (_tmp3 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("(*self)")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp3);
			}
		}
	} else {
		ValaCCodeExpression* _tmp5;
		ValaCCodeExpression* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		pub_inst = (_tmp5 = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_member_access_get_inner (expr)))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp5);
		if (vala_expression_get_static_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp7;
			ValaDataType* _tmp6;
			_tmp7 = NULL;
			_tmp6 = NULL;
			base_type = (_tmp7 = (_tmp6 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (expr))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp7);
		}
	}
	vala_code_generator_process_cmember (self, expr, pub_inst, base_type);
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
}


static void vala_code_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaCodeGenerator * self;
	ValaMethod* _tmp0;
	ValaMethod* old_method;
	ValaTypeReference* _tmp1;
	ValaTypeReference* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	ValaSymbol* _tmp2;
	ValaMethod* _tmp3;
	ValaTypeReference* _tmp5;
	ValaTypeReference* _tmp4;
	gboolean inner_error;
	ValaSymbol* _tmp11;
	ValaSymbol* _tmp10;
	ValaMethod* _tmp13;
	ValaMethod* _tmp12;
	ValaTypeReference* _tmp15;
	ValaTypeReference* _tmp14;
	ValaCCodeFunction* _tmp19;
	char* _tmp18;
	char* _tmp17;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFormalParameter* instance_param;
	GeeCollection* params;
	GeeCollection* _tmp45;
	gboolean _tmp46;
	gboolean visible;
	gboolean return_value;
	gboolean args_parameter;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_METHOD (m));
	_tmp0 = NULL;
	old_method = (_tmp0 = self->priv->current_method, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_return_type = (_tmp1 = self->priv->current_return_type, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	old_method_inner_error = self->priv->current_method_inner_error;
	old_next_temp_var_id = self->priv->next_temp_var_id;
	_tmp2 = NULL;
	self->priv->current_symbol = (_tmp2 = VALA_SYMBOL (g_object_ref (m)), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp2);
	_tmp3 = NULL;
	self->priv->current_method = (_tmp3 = g_object_ref (m), (self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL))), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->priv->current_return_type = (_tmp5 = (_tmp4 = vala_method_get_return_type (m), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp5);
	self->priv->current_method_inner_error = FALSE;
	self->priv->next_temp_var_id = 0;
	if (VALA_IS_CREATION_METHOD (m)) {
		self->priv->in_creation_method = TRUE;
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (VALA_IS_CLASS (self->priv->current_type_symbol) && vala_data_type_is_subtype_of (VALA_DATA_TYPE (self->priv->current_class), self->priv->gobject_type) && vala_method_get_body (m) != NULL) {
			ValaCCodeBlock* cblock;
			cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = gee_iterator_get (stmt_it);
					{
						ValaProperty* _tmp6;
						gboolean _tmp7;
						_tmp6 = NULL;
						if ((_tmp7 = vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp6 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeStatement* cstmt;
										cstmt = gee_iterator_get (cstmt_it);
										{
											vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			vala_code_generator_add_object_creation (self, cblock, vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0);
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = gee_iterator_get (stmt_it);
					{
						ValaProperty* _tmp8;
						gboolean _tmp9;
						_tmp8 = NULL;
						if ((_tmp9 = !vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp8 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeStatement* cstmt;
										cstmt = gee_iterator_get (cstmt_it);
										{
											vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)), VALA_CCODE_NODE (cblock));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		}
		self->priv->in_creation_method = FALSE;
	}
	inner_error = self->priv->current_method_inner_error;
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->priv->current_symbol = (_tmp11 = (_tmp10 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->priv->current_method = (_tmp13 = (_tmp12 = self->priv->current_method, (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL))), _tmp13);
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->priv->current_return_type = (_tmp15 = (_tmp14 = old_return_type, (_tmp14 == NULL ? NULL : g_object_ref (_tmp14))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp15);
	self->priv->current_method_inner_error = old_method_inner_error;
	self->priv->next_temp_var_id = old_next_temp_var_id;
	if (self->priv->current_type_symbol != NULL && VALA_IS_INTERFACE (self->priv->current_type_symbol)) {
		ValaInterface* _tmp16;
		ValaInterface* iface;
		_tmp16 = NULL;
		iface = (_tmp16 = VALA_INTERFACE (self->priv->current_type_symbol), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	self->priv->function = (_tmp19 = vala_ccode_function_new ((_tmp17 = vala_method_get_real_cname (m)), (_tmp18 = vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp19);
	(_tmp18 = (g_free (_tmp18), NULL));
	(_tmp17 = (g_free (_tmp17), NULL));
	vdeclarator = NULL;
	instance_param = NULL;
	if (vala_method_get_instance (m)) {
		ValaTypeReference* this_type;
		ValaDataType* _tmp20;
		this_type = vala_type_reference_new ();
		_tmp20 = NULL;
		vala_type_reference_set_data_type (this_type, (_tmp20 = vala_code_generator_find_parent_type (self, VALA_SYMBOL (m))));
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaTypeReference* base_type;
			ValaCCodeFormalParameter* _tmp22;
			char* _tmp21;
			base_type = vala_type_reference_new ();
			vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_interface_method (m)))));
			_tmp22 = NULL;
			_tmp21 = NULL;
			instance_param = (_tmp22 = vala_ccode_formal_parameter_new ("base", (_tmp21 = vala_type_reference_get_cname (base_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp22);
			(_tmp21 = (g_free (_tmp21), NULL));
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaTypeReference* base_type;
				ValaCCodeFormalParameter* _tmp24;
				char* _tmp23;
				base_type = vala_type_reference_new ();
				vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) vala_method_get_base_method (m)))));
				_tmp24 = NULL;
				_tmp23 = NULL;
				instance_param = (_tmp24 = vala_ccode_formal_parameter_new ("base", (_tmp23 = vala_type_reference_get_cname (base_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp24);
				(_tmp23 = (g_free (_tmp23), NULL));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (vala_method_get_instance_by_reference (m)) {
					ValaCCodeFormalParameter* _tmp26;
					char* _tmp25;
					_tmp26 = NULL;
					_tmp25 = NULL;
					instance_param = (_tmp26 = vala_ccode_formal_parameter_new ("*self", (_tmp25 = vala_type_reference_get_cname (this_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp26);
					(_tmp25 = (g_free (_tmp25), NULL));
				} else {
					ValaCCodeFormalParameter* _tmp28;
					char* _tmp27;
					_tmp28 = NULL;
					_tmp27 = NULL;
					instance_param = (_tmp28 = vala_ccode_formal_parameter_new ("self", (_tmp27 = vala_type_reference_get_cname (this_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp28);
					(_tmp27 = (g_free (_tmp27), NULL));
				}
			}
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_add_parameter (self->priv->function, instance_param);
		}
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			char* _tmp29;
			ValaCCodeDeclaration* _tmp30;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp31;
			_tmp29 = NULL;
			_tmp30 = NULL;
			vdecl = (_tmp30 = vala_ccode_declaration_new ((_tmp29 = vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE))), (_tmp29 = (g_free (_tmp29), NULL)), _tmp30);
			_tmp31 = NULL;
			vdeclarator = (_tmp31 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), _tmp31);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (self->priv->type_struct, vdecl);
			vala_ccode_function_declarator_add_parameter (vdeclarator, instance_param);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m) && VALA_IS_CLASS (self->priv->current_type_symbol) && vala_data_type_is_subtype_of (VALA_DATA_TYPE (self->priv->current_class), self->priv->gobject_type)) {
		{
			GeeCollection* type_param_collection;
			GeeIterator* type_param_it;
			type_param_collection = vala_class_get_type_parameters (self->priv->current_class);
			type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
			while (gee_iterator_next (type_param_it)) {
				ValaTypeParameter* type_param;
				type_param = gee_iterator_get (type_param_it);
				{
					ValaCCodeFormalParameter* _tmp34;
					char* _tmp33;
					char* _tmp32;
					ValaCCodeFormalParameter* _tmp37;
					char* _tmp36;
					char* _tmp35;
					/* memory management for generic types*/
					_tmp34 = NULL;
					_tmp33 = NULL;
					_tmp32 = NULL;
					vala_ccode_function_add_parameter (self->priv->function, (_tmp34 = vala_ccode_formal_parameter_new ((_tmp33 = g_strdup_printf ("%s_dup_func", (_tmp32 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1)))), "GBoxedCopyFunc")));
					(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
					(_tmp33 = (g_free (_tmp33), NULL));
					(_tmp32 = (g_free (_tmp32), NULL));
					_tmp37 = NULL;
					_tmp36 = NULL;
					_tmp35 = NULL;
					vala_ccode_function_add_parameter (self->priv->function, (_tmp37 = vala_ccode_formal_parameter_new ((_tmp36 = g_strdup_printf ("%s_destroy_func", (_tmp35 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1)))), "GDestroyNotify")));
					(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
					(_tmp36 = (g_free (_tmp36), NULL));
					(_tmp35 = (g_free (_tmp35), NULL));
					(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
			(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
		}
	}
	params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
					ValaArray* _tmp38;
					ValaArray* arr;
					char* length_ctype;
					_tmp38 = NULL;
					arr = (_tmp38 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp38 == NULL ? NULL : g_object_ref (_tmp38)));
					length_ctype = g_strdup ("int");
					if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
						char* _tmp39;
						_tmp39 = NULL;
						length_ctype = (_tmp39 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp39);
					}
					{
						gint dim;
						dim = 0;
						for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
							char* _tmp40;
							ValaCCodeFormalParameter* _tmp41;
							ValaCCodeFormalParameter* cparam;
							_tmp40 = NULL;
							_tmp41 = NULL;
							cparam = (_tmp41 = vala_ccode_formal_parameter_new ((_tmp40 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) param)), dim)), length_ctype), (_tmp40 = (g_free (_tmp40), NULL)), _tmp41);
							vala_ccode_function_add_parameter (self->priv->function, cparam);
							if (vdeclarator != NULL) {
								vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
							}
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
					(length_ctype = (g_free (length_ctype), NULL));
				}
				vala_ccode_function_add_parameter (self->priv->function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) param))));
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) param))));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	/* return array length if appropriate*/
	if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m)))) {
		ValaArray* _tmp42;
		ValaArray* arr;
		_tmp42 = NULL;
		arr = (_tmp42 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (_tmp42 == NULL ? NULL : g_object_ref (_tmp42)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				char* _tmp43;
				ValaCCodeFormalParameter* _tmp44;
				ValaCCodeFormalParameter* cparam;
				_tmp43 = NULL;
				_tmp44 = NULL;
				cparam = (_tmp44 = vala_ccode_formal_parameter_new ((_tmp43 = vala_code_generator_get_array_length_cname (self, "result", dim)), "int*"), (_tmp43 = (g_free (_tmp43), NULL)), _tmp44);
				vala_ccode_function_add_parameter (self->priv->function, cparam);
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
				}
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	if (vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_add_parameter (self->priv->function, instance_param);
	}
	_tmp45 = NULL;
	if ((_tmp46 = gee_collection_get_size ((_tmp45 = vala_method_get_error_domains (m))) > 0, (_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL))), _tmp46)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		vala_ccode_function_add_parameter (self->priv->function, cparam);
		if (vdeclarator != NULL) {
			vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
		}
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	visible = !vala_symbol_is_internal_symbol (VALA_SYMBOL (m));
	/* real function declaration and definition not needed
	 * for abstract methods */
	if (!vala_method_get_is_abstract (m)) {
		if (visible && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* _tmp47;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp47 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp47 = vala_ccode_function_copy (self->priv->function))));
			(_tmp47 = (g_object_unref (_tmp47), NULL));
		} else {
			ValaCCodeFunction* _tmp48;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp48 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp48 = vala_ccode_function_copy (self->priv->function))));
			(_tmp48 = (g_object_unref (_tmp48), NULL));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (((ValaCodeNode*) vala_method_get_body (m)))));
			cinit = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) m)))) {
				ValaClass* _tmp49;
				ValaClass* cl;
				_tmp49 = NULL;
				cl = (_tmp49 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (_tmp49 == NULL ? NULL : g_object_ref (_tmp49)));
				if (vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL) {
					ValaCCodeExpression* cself;
					char* _tmp61;
					char* _tmp60;
					ValaCCodeDeclaration* _tmp62;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp63;
					cself = NULL;
					if (vala_code_context_get_debug (self->priv->context)) {
						ValaCCodeIdentifier* _tmp51;
						char* _tmp50;
						ValaCCodeFunctionCall* _tmp52;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp53;
						ValaCCodeExpression* _tmp55;
						ValaCCodeFunctionCall* _tmp54;
						_tmp51 = NULL;
						_tmp50 = NULL;
						_tmp52 = NULL;
						ccall = (_tmp52 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ((_tmp50 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL))), (_tmp50 = (g_free (_tmp50), NULL)), _tmp52);
						_tmp53 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new ("base"))));
						(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
						_tmp55 = NULL;
						_tmp54 = NULL;
						cself = (_tmp55 = VALA_CCODE_EXPRESSION ((_tmp54 = ccall, (_tmp54 == NULL ? NULL : g_object_ref (_tmp54)))), (cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL))), _tmp55);
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					} else {
						ValaCCodeExpression* _tmp59;
						char* _tmp58;
						char* _tmp57;
						ValaCCodeIdentifier* _tmp56;
						_tmp59 = NULL;
						_tmp58 = NULL;
						_tmp57 = NULL;
						_tmp56 = NULL;
						cself = (_tmp59 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new ("base"))), (_tmp58 = g_strconcat ((_tmp57 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)), "*", NULL)))), (cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL))), _tmp59);
						(_tmp58 = (g_free (_tmp58), NULL));
						(_tmp57 = (g_free (_tmp57), NULL));
						(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
					}
					_tmp61 = NULL;
					_tmp60 = NULL;
					_tmp62 = NULL;
					cdecl_ = (_tmp62 = vala_ccode_declaration_new ((_tmp61 = g_strdup_printf ("%s *", (_tmp60 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (_tmp61 = (g_free (_tmp61), NULL)), (_tmp60 = (g_free (_tmp60), NULL)), _tmp62);
					_tmp63 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp63 = vala_ccode_variable_declarator_new_with_initializer ("self", cself))));
					(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_instance (m)) {
						ValaCCodeStatement* _tmp64;
						_tmp64 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp64 = vala_code_generator_create_method_type_check_statement (self, m, VALA_DATA_TYPE (cl), TRUE, "self"))));
						(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GeeCollection* param_collection;
				GeeIterator* param_it;
				param_collection = vala_invokable_get_parameters (VALA_INVOKABLE (m));
				param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					param = gee_iterator_get (param_it);
					{
						ValaDataType* _tmp65;
						ValaDataType* t;
						_tmp65 = NULL;
						t = (_tmp65 = vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), (_tmp65 == NULL ? NULL : g_object_ref (_tmp65)));
						if (t != NULL && vala_data_type_is_reference_type (t) && !vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
							ValaCCodeStatement* type_check;
							type_check = vala_code_generator_create_method_type_check_statement (self, m, t, vala_type_reference_get_non_null (vala_formal_parameter_get_type_reference (param)), vala_symbol_get_name (((ValaSymbol*) param)));
							if (type_check != NULL) {
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
							}
							(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
						}
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
				(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp67;
				ValaCCodeConstant* _tmp66;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp67 = NULL;
				_tmp66 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp67 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_constant_new ("NULL")))))));
				(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
				(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (((ValaCodeNode*) m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) m))) != NULL) {
				ValaCCodeComment* _tmp68;
				_tmp68 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp68 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) m)))))));
				(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
			}
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (VALA_IS_CLASS (self->priv->current_type_symbol) && vala_data_type_is_subtype_of (VALA_DATA_TYPE (self->priv->current_class), self->priv->gobject_type)) {
					gint n_params;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					if (n_params > 0) {
						ValaCCodeIdentifier* _tmp69;
						ValaCCodeFunctionCall* _tmp70;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp71;
						ValaCCodeConstant* _tmp73;
						char* _tmp72;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp74;
						ValaCCodeDeclaration* _tmp75;
						ValaCCodeVariableDeclarator* _tmp77;
						ValaCCodeIdentifier* _tmp76;
						/* declare construction parameter array*/
						_tmp69 = NULL;
						_tmp70 = NULL;
						cparamsinit = (_tmp70 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new ("g_new0")))), (_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL))), _tmp70);
						_tmp71 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new ("GParameter"))));
						(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
						_tmp73 = NULL;
						_tmp72 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_constant_new ((_tmp72 = g_strdup_printf ("%i", n_params))))));
						(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
						(_tmp72 = (g_free (_tmp72), NULL));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp74 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp74 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
						(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						_tmp75 = NULL;
						cdecl_ = (_tmp75 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp75);
						_tmp77 = NULL;
						_tmp76 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp77 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ("__params")))))));
						(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
						(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					{
						GeeCollection* type_param_collection;
						GeeIterator* type_param_it;
						type_param_collection = vala_class_get_type_parameters (self->priv->current_class);
						type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
						while (gee_iterator_next (type_param_it)) {
							ValaTypeParameter* type_param;
							type_param = gee_iterator_get (type_param_it);
							{
								char* func_name;
								ValaCCodeMemberAccess* cmember;
								ValaCCodeAssignment* cassign;
								char* _tmp79;
								char* _tmp78;
								ValaCCodeMemberAccess* _tmp82;
								ValaCCodeMemberAccess* _tmp81;
								ValaCCodeIdentifier* _tmp80;
								ValaCCodeAssignment* _tmp84;
								ValaCCodeIdentifier* _tmp83;
								ValaCCodeExpressionStatement* _tmp85;
								char* _tmp87;
								char* _tmp86;
								ValaCCodeMemberAccess* _tmp90;
								ValaCCodeMemberAccess* _tmp89;
								ValaCCodeIdentifier* _tmp88;
								ValaCCodeAssignment* _tmp92;
								ValaCCodeIdentifier* _tmp91;
								ValaCCodeExpressionStatement* _tmp93;
								/* dup and destroy func properties for generic types */
								func_name = NULL;
								cmember = NULL;
								cassign = NULL;
								_tmp79 = NULL;
								_tmp78 = NULL;
								func_name = (_tmp79 = g_strdup_printf ("%s_dup_func", (_tmp78 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp79);
								(_tmp78 = (g_free (_tmp78), NULL));
								_tmp82 = NULL;
								_tmp81 = NULL;
								_tmp80 = NULL;
								cmember = (_tmp82 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL))), _tmp82);
								(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
								(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
								_tmp84 = NULL;
								_tmp83 = NULL;
								cassign = (_tmp84 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cmember), VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new (func_name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp84);
								(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
								_tmp85 = NULL;
								vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp85 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassign)))));
								(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
								_tmp87 = NULL;
								_tmp86 = NULL;
								func_name = (_tmp87 = g_strdup_printf ("%s_destroy_func", (_tmp86 = g_utf8_strdown (vala_symbol_get_name (((ValaSymbol*) type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp87);
								(_tmp86 = (g_free (_tmp86), NULL));
								_tmp90 = NULL;
								_tmp89 = NULL;
								_tmp88 = NULL;
								cmember = (_tmp90 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL))), _tmp90);
								(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
								(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
								_tmp92 = NULL;
								_tmp91 = NULL;
								cassign = (_tmp92 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cmember), VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_identifier_new (func_name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp92);
								(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
								_tmp93 = NULL;
								vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp93 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassign)))));
								(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
								(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
								(func_name = (g_free (func_name), NULL));
								(cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL)));
								(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
							}
						}
						(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
						(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
					}
				} else {
					if (VALA_IS_CLASS (self->priv->current_type_symbol)) {
						ValaClass* _tmp94;
						ValaClass* cl;
						char* _tmp96;
						char* _tmp95;
						ValaCCodeDeclaration* _tmp97;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeIdentifier* _tmp98;
						ValaCCodeFunctionCall* _tmp99;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp101;
						char* _tmp100;
						ValaCCodeVariableDeclarator* _tmp102;
						_tmp94 = NULL;
						cl = (_tmp94 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (_tmp94 == NULL ? NULL : g_object_ref (_tmp94)));
						_tmp96 = NULL;
						_tmp95 = NULL;
						_tmp97 = NULL;
						cdecl_ = (_tmp97 = vala_ccode_declaration_new ((_tmp96 = g_strconcat ((_tmp95 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)), "*", NULL))), (_tmp96 = (g_free (_tmp96), NULL)), (_tmp95 = (g_free (_tmp95), NULL)), _tmp97);
						_tmp98 = NULL;
						_tmp99 = NULL;
						ccall = (_tmp99 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp98 = vala_ccode_identifier_new ("g_slice_new0")))), (_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL))), _tmp99);
						_tmp101 = NULL;
						_tmp100 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp101 = vala_ccode_identifier_new ((_tmp100 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))));
						(_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL)));
						(_tmp100 = (g_free (_tmp100), NULL));
						_tmp102 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp102 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
						(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					} else {
						ValaStruct* _tmp103;
						ValaStruct* st;
						char* _tmp105;
						char* _tmp104;
						ValaCCodeDeclaration* _tmp106;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeIdentifier* _tmp107;
						ValaCCodeFunctionCall* _tmp108;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp110;
						char* _tmp109;
						ValaCCodeVariableDeclarator* _tmp111;
						_tmp103 = NULL;
						st = (_tmp103 = VALA_STRUCT (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (_tmp103 == NULL ? NULL : g_object_ref (_tmp103)));
						_tmp105 = NULL;
						_tmp104 = NULL;
						_tmp106 = NULL;
						cdecl_ = (_tmp106 = vala_ccode_declaration_new ((_tmp105 = g_strconcat ((_tmp104 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)), "*", NULL))), (_tmp105 = (g_free (_tmp105), NULL)), (_tmp104 = (g_free (_tmp104), NULL)), _tmp106);
						_tmp107 = NULL;
						_tmp108 = NULL;
						ccall = (_tmp108 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_identifier_new ("g_slice_new0")))), (_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL))), _tmp108);
						_tmp110 = NULL;
						_tmp109 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_identifier_new ((_tmp109 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))))));
						(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
						(_tmp109 = (g_free (_tmp109), NULL));
						_tmp111 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp111 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
						(_tmp111 == NULL ? NULL : (_tmp111 = (g_object_unref (_tmp111), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					}
				}
			}
			if (vala_code_context_get_module_init_method (self->priv->context) == m && self->priv->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (self->priv->module_init_fragment));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		char* _tmp113;
		char* _tmp112;
		ValaCCodeFunction* _tmp114;
		ValaCCodeFunction* vfunc;
		ValaTypeReference* this_type;
		char* _tmp115;
		ValaCCodeFormalParameter* _tmp116;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp127;
		ValaCCodeMemberAccess* _tmp128;
		ValaCCodeFunctionCall* _tmp129;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp130;
		GeeCollection* params;
		GeeCollection* _tmp141;
		gboolean _tmp142;
		_tmp113 = NULL;
		_tmp112 = NULL;
		_tmp114 = NULL;
		vfunc = (_tmp114 = vala_ccode_function_new ((_tmp112 = vala_method_get_cname (m)), (_tmp113 = vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE))), (_tmp113 = (g_free (_tmp113), NULL)), (_tmp112 = (g_free (_tmp112), NULL)), _tmp114);
		this_type = vala_type_reference_new ();
		vala_type_reference_set_data_type (this_type, VALA_DATA_TYPE (vala_symbol_get_parent_symbol (((ValaSymbol*) m))));
		_tmp115 = NULL;
		_tmp116 = NULL;
		cparam = (_tmp116 = vala_ccode_formal_parameter_new ("self", (_tmp115 = vala_type_reference_get_cname (this_type, FALSE, FALSE))), (_tmp115 = (g_free (_tmp115), NULL)), _tmp116);
		vala_ccode_function_add_parameter (vfunc, cparam);
		vblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) m)))) {
			ValaInterface* _tmp117;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp121;
			ValaCCodeIdentifier* _tmp120;
			char* _tmp119;
			char* _tmp118;
			_tmp117 = NULL;
			iface = (_tmp117 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (_tmp117 == NULL ? NULL : g_object_ref (_tmp117)));
			_tmp121 = NULL;
			_tmp120 = NULL;
			_tmp119 = NULL;
			_tmp118 = NULL;
			vcast = (_tmp121 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp120 = vala_ccode_identifier_new ((_tmp119 = g_strdup_printf ("%s_GET_INTERFACE", (_tmp118 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp121);
			(_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL)));
			(_tmp119 = (g_free (_tmp119), NULL));
			(_tmp118 = (g_free (_tmp118), NULL));
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* _tmp122;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp126;
			ValaCCodeIdentifier* _tmp125;
			char* _tmp124;
			char* _tmp123;
			_tmp122 = NULL;
			cl = (_tmp122 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) m))), (_tmp122 == NULL ? NULL : g_object_ref (_tmp122)));
			_tmp126 = NULL;
			_tmp125 = NULL;
			_tmp124 = NULL;
			_tmp123 = NULL;
			vcast = (_tmp126 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_identifier_new ((_tmp124 = g_strdup_printf ("%s_GET_CLASS", (_tmp123 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp126);
			(_tmp125 == NULL ? NULL : (_tmp125 = (g_object_unref (_tmp125), NULL)));
			(_tmp124 = (g_free (_tmp124), NULL));
			(_tmp123 = (g_free (_tmp123), NULL));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		_tmp127 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_identifier_new ("self"))));
		(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
		_tmp128 = NULL;
		_tmp129 = NULL;
		vcall = (_tmp129 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_vfunc_name (m))))), (_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL))), _tmp129);
		_tmp130 = NULL;
		vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp130 = vala_ccode_identifier_new ("self"))));
		(_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL)));
		params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = params;
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = gee_iterator_get (param_it);
				{
					ValaCCodeIdentifier* _tmp136;
					if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
						ValaArray* _tmp131;
						ValaArray* arr;
						char* length_ctype;
						_tmp131 = NULL;
						arr = (_tmp131 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp131 == NULL ? NULL : g_object_ref (_tmp131)));
						length_ctype = g_strdup ("int");
						if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
							char* _tmp132;
							_tmp132 = NULL;
							length_ctype = (_tmp132 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp132);
						}
						{
							gint dim;
							dim = 0;
							for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
								char* _tmp133;
								ValaCCodeFormalParameter* _tmp134;
								ValaCCodeFormalParameter* cparam;
								ValaCCodeIdentifier* _tmp135;
								_tmp133 = NULL;
								_tmp134 = NULL;
								cparam = (_tmp134 = vala_ccode_formal_parameter_new ((_tmp133 = vala_code_generator_get_array_length_cname (self, vala_symbol_get_name (((ValaSymbol*) param)), dim)), length_ctype), (_tmp133 = (g_free (_tmp133), NULL)), _tmp134);
								vala_ccode_function_add_parameter (vfunc, cparam);
								_tmp135 = NULL;
								vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
								(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
								(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
							}
						}
						(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
						(length_ctype = (g_free (length_ctype), NULL));
					}
					vala_ccode_function_add_parameter (vfunc, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) param))));
					_tmp136 = NULL;
					vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp136 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) param))))));
					(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		/* return array length if appropriate*/
		if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m)))) {
			ValaArray* _tmp137;
			ValaArray* arr;
			_tmp137 = NULL;
			arr = (_tmp137 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (_tmp137 == NULL ? NULL : g_object_ref (_tmp137)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					char* _tmp138;
					ValaCCodeFormalParameter* _tmp139;
					ValaCCodeFormalParameter* cparam;
					ValaCCodeIdentifier* _tmp140;
					_tmp138 = NULL;
					_tmp139 = NULL;
					cparam = (_tmp139 = vala_ccode_formal_parameter_new ((_tmp138 = vala_code_generator_get_array_length_cname (self, "result", dim)), "int*"), (_tmp138 = (g_free (_tmp138), NULL)), _tmp139);
					vala_ccode_function_add_parameter (vfunc, cparam);
					_tmp140 = NULL;
					vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
					(_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL)));
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		_tmp141 = NULL;
		if ((_tmp142 = gee_collection_get_size ((_tmp141 = vala_method_get_error_domains (m))) > 0, (_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL))), _tmp142)) {
			ValaCCodeFormalParameter* cparam;
			ValaCCodeIdentifier* _tmp143;
			cparam = vala_ccode_formal_parameter_new ("error", "GError**");
			vala_ccode_function_add_parameter (vfunc, cparam);
			_tmp143 = NULL;
			vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp143 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
			(_tmp143 == NULL ? NULL : (_tmp143 = (g_object_unref (_tmp143), NULL)));
			(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		}
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
			ValaCCodeExpressionStatement* _tmp144;
			_tmp144 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp144 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(_tmp144 == NULL ? NULL : (_tmp144 = (g_object_unref (_tmp144), NULL)));
		} else {
			ValaCCodeReturnStatement* _tmp145;
			/* pass method return value */
			_tmp145 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp145 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL)));
		}
		if (visible) {
			ValaCCodeFunction* _tmp146;
			_tmp146 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp146 = vala_ccode_function_copy (vfunc))));
			(_tmp146 = (g_object_unref (_tmp146), NULL));
		} else {
			ValaCCodeFunction* _tmp147;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp147 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp147 = vala_ccode_function_copy (vfunc))));
			(_tmp147 = (g_object_unref (_tmp147), NULL));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeReturnStatement* creturn;
		ValaCCodeIdentifier* _tmp165;
		if (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0) {
			ValaCCodeIdentifier* _tmp149;
			ValaCCodeIdentifier* _tmp148;
			ValaCCodeBinaryExpression* _tmp150;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeBlock* cdofreeparam;
			ValaCCodeExpressionStatement* _tmp153;
			ValaCCodeUnaryExpression* _tmp152;
			ValaCCodeIdentifier* _tmp151;
			ValaCCodeIdentifier* _tmp154;
			ValaCCodeFunctionCall* _tmp155;
			ValaCCodeFunctionCall* cunsetcall;
			ValaCCodeUnaryExpression* _tmp158;
			ValaCCodeMemberAccess* _tmp157;
			ValaCCodeIdentifier* _tmp156;
			ValaCCodeExpressionStatement* _tmp159;
			ValaCCodeWhileStatement* _tmp160;
			ValaCCodeIdentifier* _tmp161;
			ValaCCodeFunctionCall* _tmp162;
			ValaCCodeFunctionCall* cfreeparams;
			ValaCCodeIdentifier* _tmp163;
			ValaCCodeExpressionStatement* _tmp164;
			_tmp149 = NULL;
			_tmp148 = NULL;
			_tmp150 = NULL;
			ccond = (_tmp150 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION ((_tmp148 = vala_ccode_identifier_new ("__params_it"))), VALA_CCODE_EXPRESSION ((_tmp149 = vala_ccode_identifier_new ("__params")))), (_tmp149 == NULL ? NULL : (_tmp149 = (g_object_unref (_tmp149), NULL))), (_tmp148 == NULL ? NULL : (_tmp148 = (g_object_unref (_tmp148), NULL))), _tmp150);
			cdofreeparam = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			_tmp153 = NULL;
			_tmp152 = NULL;
			_tmp151 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp153 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp152 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_identifier_new ("__params_it"))))))))));
			(_tmp153 == NULL ? NULL : (_tmp153 = (g_object_unref (_tmp153), NULL)));
			(_tmp152 == NULL ? NULL : (_tmp152 = (g_object_unref (_tmp152), NULL)));
			(_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL)));
			_tmp154 = NULL;
			_tmp155 = NULL;
			cunsetcall = (_tmp155 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp154 = vala_ccode_identifier_new ("g_value_unset")))), (_tmp154 == NULL ? NULL : (_tmp154 = (g_object_unref (_tmp154), NULL))), _tmp155);
			_tmp158 = NULL;
			_tmp157 = NULL;
			_tmp156 = NULL;
			vala_ccode_function_call_add_argument (cunsetcall, VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_identifier_new ("__params_it"))), "value")))))));
			(_tmp158 == NULL ? NULL : (_tmp158 = (g_object_unref (_tmp158), NULL)));
			(_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL)));
			(_tmp156 == NULL ? NULL : (_tmp156 = (g_object_unref (_tmp156), NULL)));
			_tmp159 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp159 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cunsetcall)))));
			(_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL)));
			_tmp160 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp160 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cdofreeparam)))));
			(_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL)));
			_tmp161 = NULL;
			_tmp162 = NULL;
			cfreeparams = (_tmp162 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp161 = vala_ccode_identifier_new ("g_free")))), (_tmp161 == NULL ? NULL : (_tmp161 = (g_object_unref (_tmp161), NULL))), _tmp162);
			_tmp163 = NULL;
			vala_ccode_function_call_add_argument (cfreeparams, VALA_CCODE_EXPRESSION ((_tmp163 = vala_ccode_identifier_new ("__params"))));
			(_tmp163 == NULL ? NULL : (_tmp163 = (g_object_unref (_tmp163), NULL)));
			_tmp164 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp164 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreeparams)))));
			(_tmp164 == NULL ? NULL : (_tmp164 = (g_object_unref (_tmp164), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cdofreeparam == NULL ? NULL : (cdofreeparam = (g_object_unref (cdofreeparam), NULL)));
			(cunsetcall == NULL ? NULL : (cunsetcall = (g_object_unref (cunsetcall), NULL)));
			(cfreeparams == NULL ? NULL : (cfreeparams = (g_object_unref (cfreeparams), NULL)));
		}
		creturn = vala_ccode_return_statement_new (NULL);
		_tmp165 = NULL;
		vala_ccode_return_statement_set_return_expression (creturn, VALA_CCODE_EXPRESSION ((_tmp165 = vala_ccode_identifier_new ("self"))));
		(_tmp165 == NULL ? NULL : (_tmp165 = (g_object_unref (_tmp165), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (creturn));
		(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_code_generator_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp166;
		ValaCCodeFormalParameter* _tmp167;
		ValaCCodeBlock* main_block;
		ValaCCodeExpressionStatement* _tmp174;
		ValaCCodeFunctionCall* _tmp173;
		ValaCCodeIdentifier* _tmp172;
		ValaCCodeIdentifier* _tmp175;
		ValaCCodeFunctionCall* _tmp176;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		_tmp166 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp166 = vala_ccode_formal_parameter_new ("argc", "int")));
		(_tmp166 == NULL ? NULL : (_tmp166 = (g_object_unref (_tmp166), NULL)));
		_tmp167 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp167 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(_tmp167 == NULL ? NULL : (_tmp167 = (g_object_unref (_tmp167), NULL)));
		main_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		if (vala_code_context_get_thread (self->priv->context)) {
			ValaCCodeIdentifier* _tmp168;
			ValaCCodeFunctionCall* _tmp169;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp170;
			ValaCCodeExpressionStatement* _tmp171;
			_tmp168 = NULL;
			_tmp169 = NULL;
			thread_init_call = (_tmp169 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp168 = vala_ccode_identifier_new ("g_thread_init")))), (_tmp168 == NULL ? NULL : (_tmp168 = (g_object_unref (_tmp168), NULL))), _tmp169);
			_tmp170 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, VALA_CCODE_EXPRESSION ((_tmp170 = vala_ccode_constant_new ("NULL"))));
			(_tmp170 == NULL ? NULL : (_tmp170 = (g_object_unref (_tmp170), NULL)));
			_tmp171 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp171 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (thread_init_call)))));
			(_tmp171 == NULL ? NULL : (_tmp171 = (g_object_unref (_tmp171), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (g_object_unref (thread_init_call), NULL)));
		}
		_tmp174 = NULL;
		_tmp173 = NULL;
		_tmp172 = NULL;
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp174 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp173 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp172 = vala_ccode_identifier_new ("g_type_init"))))))))));
		(_tmp174 == NULL ? NULL : (_tmp174 = (g_object_unref (_tmp174), NULL)));
		(_tmp173 == NULL ? NULL : (_tmp173 = (g_object_unref (_tmp173), NULL)));
		(_tmp172 == NULL ? NULL : (_tmp172 = (g_object_unref (_tmp172), NULL)));
		_tmp175 = NULL;
		_tmp176 = NULL;
		main_call = (_tmp176 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp175 = vala_ccode_identifier_new (vala_ccode_function_get_name (self->priv->function))))), (_tmp175 == NULL ? NULL : (_tmp175 = (g_object_unref (_tmp175), NULL))), _tmp176);
		if (args_parameter) {
			ValaCCodeIdentifier* _tmp177;
			ValaCCodeIdentifier* _tmp178;
			_tmp177 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp177 = vala_ccode_identifier_new ("argc"))));
			(_tmp177 == NULL ? NULL : (_tmp177 = (g_object_unref (_tmp177), NULL)));
			_tmp178 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp178 = vala_ccode_identifier_new ("argv"))));
			(_tmp178 == NULL ? NULL : (_tmp178 = (g_object_unref (_tmp178), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* _tmp179;
			_tmp179 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp179 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(_tmp179 == NULL ? NULL : (_tmp179 = (g_object_unref (_tmp179), NULL)));
		} else {
			ValaCCodeExpressionStatement* _tmp180;
			ValaCCodeReturnStatement* _tmp182;
			ValaCCodeConstant* _tmp181;
			/* method returns void, always use 0 as exit code*/
			_tmp180 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp180 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(_tmp180 == NULL ? NULL : (_tmp180 = (g_object_unref (_tmp180), NULL)));
			_tmp182 = NULL;
			_tmp181 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp182 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp181 = vala_ccode_constant_new ("0")))))));
			(_tmp182 == NULL ? NULL : (_tmp182 = (g_object_unref (_tmp182), NULL)));
			(_tmp181 == NULL ? NULL : (_tmp181 = (g_object_unref (_tmp181), NULL)));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (m), vala_type_reference_get_data_type (vala_method_get_return_type (m)), t, non_null, var_name);
}


static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (getter) {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), t, non_null, var_name);
	} else {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), NULL, t, non_null, var_name);
	}
}


static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name)
{
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* _tmp18;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (ret_type == NULL || VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	if ((VALA_IS_CLASS (t) && vala_data_type_is_subtype_of (VALA_DATA_TYPE ((VALA_CLASS (t))), self->priv->gobject_type)) || (VALA_IS_INTERFACE (t) && !vala_interface_get_declaration_only ((VALA_INTERFACE (t))))) {
		ValaCCodeIdentifier* _tmp1;
		char* _tmp0;
		ValaCCodeFunctionCall* _tmp2;
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeExpression* cexpr;
		_tmp1 = NULL;
		_tmp0 = NULL;
		_tmp2 = NULL;
		ctype_check = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_data_type_get_upper_case_cname (t, "IS_")))))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
		_tmp3 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (var_name))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		cexpr = VALA_CCODE_EXPRESSION ((_tmp4 = ctype_check, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))));
		if (!non_null) {
			ValaCCodeConstant* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeBinaryExpression* _tmp7;
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* _tmp8;
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp7 = NULL;
			cnull = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (var_name))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7);
			_tmp8 = NULL;
			cexpr = (_tmp8 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cnull), VALA_CCODE_EXPRESSION (ctype_check))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp8);
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL ? NULL : (ctype_check = (g_object_unref (ctype_check), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
	} else {
		if (!non_null) {
			gpointer _tmp9;
			return VALA_CCODE_STATEMENT ((_tmp9 = NULL, (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp9));
		} else {
			ValaCCodeConstant* _tmp11;
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeBinaryExpression* _tmp12;
			ValaCCodeBinaryExpression* cnonnull;
			_tmp11 = NULL;
			_tmp10 = NULL;
			_tmp12 = NULL;
			cnonnull = (_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new (var_name))), VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("NULL")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp12);
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (cnonnull));
			(cnonnull == NULL ? NULL : (cnonnull = (g_object_unref (cnonnull), NULL)));
		}
	}
	if (ret_type == NULL) {
		ValaCCodeIdentifier* _tmp13;
		/* void function */
		_tmp13 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp14;
		ValaCCodeExpression* cdefault;
		_tmp14 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		cdefault = vala_code_generator_default_value_for_type (self, ret_type);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp15;
			ValaCCodeExpressionStatement* _tmp16;
			ValaCCodeExpressionStatement* _tmp17;
			vala_report_warning (vala_code_node_get_source_reference (method_node), "not supported return type for runtime type checks");
			_tmp15 = NULL;
			_tmp16 = NULL;
			_tmp17 = NULL;
			return VALA_CCODE_STATEMENT ((_tmp17 = (_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("0")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp17));
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	_tmp18 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp18 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp18));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static ValaCCodeExpression* vala_code_generator_default_value_for_type (ValaCodeGenerator* self, ValaDataType* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	if (vala_data_type_is_reference_type (type) || VALA_IS_POINTER (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	} else {
		char* _tmp1;
		gboolean _tmp2;
		_tmp1 = NULL;
		if ((_tmp2 = (_tmp1 = vala_data_type_get_default_value (type)) != NULL, (_tmp1 = (g_free (_tmp1), NULL)), _tmp2)) {
			char* _tmp3;
			ValaCCodeConstant* _tmp4;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_data_type_get_default_value (type))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4));
		}
	}
	return VALA_CCODE_EXPRESSION (NULL);
}


static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaSymbol* sym)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), NULL);
	while (sym != NULL) {
		if (VALA_IS_DATA_TYPE (sym)) {
			ValaDataType* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_DATA_TYPE (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return VALA_DATA_TYPE (NULL);
}


static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


static void vala_code_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaCodeGenerator * self;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	if (vala_method_get_body (((ValaMethod*) m)) != NULL && VALA_IS_CLASS (self->priv->current_type_symbol) && vala_data_type_is_subtype_of (VALA_DATA_TYPE (self->priv->current_class), self->priv->gobject_type)) {
		gint n_params;
		n_params = 0;
		{
			GeeCollection* stmt_collection;
			GeeIterator* stmt_it;
			stmt_collection = vala_block_get_statements (vala_method_get_body (((ValaMethod*) m)));
			stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
			while (gee_iterator_next (stmt_it)) {
				ValaStatement* stmt;
				stmt = gee_iterator_get (stmt_it);
				{
					ValaProperty* _tmp0;
					gboolean _tmp1;
					ValaProperty* _tmp2;
					gboolean _tmp3;
					_tmp0 = NULL;
					if ((_tmp1 = !(VALA_IS_EXPRESSION_STATEMENT (stmt)) || (_tmp0 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))) == NULL, (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1)) {
						vala_code_node_set_error (VALA_CODE_NODE (m), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) stmt)), "class creation methods only allow property assignment statements");
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
						(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
						(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
						return;
					}
					_tmp2 = NULL;
					if ((_tmp3 = vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp2 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3)) {
						n_params++;
					}
					(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
				}
			}
			(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
			(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
		}
		vala_creation_method_set_n_construction_params (m, n_params);
	}
	vala_code_visitor_visit_method (VALA_CODE_VISITOR (self), VALA_METHOD (m));
}


static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter)
{
	GeeCollection* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArray* _tmp7;
	ValaArray* array_type;
	gboolean _tmp9;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_symbol_get_name (((ValaSymbol*) m)) == NULL || g_utf8_collate (vala_symbol_get_name (((ValaSymbol*) m)), "main") != 0) {
		return FALSE;
	}
	/* method must be called "main"*/
	if (vala_method_get_instance (m)) {
		return FALSE;
	}
	/* method must be static*/
	if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == vala_type_reference_get_data_type (self->priv->int_type)) {
			(*return_value) = TRUE;
		} else {
			return FALSE;
		}
	}
	/* return type must be void or int*/
	params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	if (gee_collection_get_size (params) == 0) {
		gboolean _tmp3;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (_tmp3 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp3);
	}
	if (gee_collection_get_size (params) > 1) {
		gboolean _tmp4;
		return (_tmp4 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp4);
	}
	/* method must not have more than one parameter*/
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	gee_iterator_next (params_it);
	param = gee_iterator_get (params_it);
	if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
		gboolean _tmp5;
		return (_tmp5 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp5);
	}
	/* parameter must not be an out parameter*/
	if (!(VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))) {
		gboolean _tmp6;
		return (_tmp6 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp6);
	}
	/* parameter must be an array*/
	_tmp7 = NULL;
	array_type = (_tmp7 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	if (vala_array_get_element_type (array_type) != vala_type_reference_get_data_type (self->priv->string_type)) {
		gboolean _tmp8;
		return (_tmp8 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp8);
	}
	/* parameter must be an array of strings*/
	(*args_parameter) = TRUE;
	return (_tmp9 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp9);
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
}


static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b, gboolean has_params)
{
	ValaClass* _tmp0;
	ValaClass* cl;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (self->priv->current_type_symbol), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccall = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_object_newv")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_data_type_get_type_id (VALA_DATA_TYPE (cl)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	(_tmp3 = (g_free (_tmp3), NULL));
	if (has_params) {
		ValaCCodeConstant* _tmp5;
		ValaCCodeConstant* _tmp6;
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("__params_it - __params"))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("__params"))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	} else {
		ValaCCodeConstant* _tmp7;
		ValaCCodeConstant* _tmp8;
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	}
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdeclaration = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup (("POINTER"));
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup (("VOID"));
		} else {
			return vala_data_type_get_marshaller_type_name (vala_type_reference_get_data_type (t));
		}
	}
}


static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix)
{
	char* signature;
	char* ret;
	GeeCollection* params;
	char* _tmp1;
	char* _tmp0;
	char* _tmp5;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	signature = vala_code_generator_get_signal_signature (self, sig);
	ret = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	if (prefix == NULL) {
		if (gee_collection_contains (GEE_COLLECTION (self->priv->predefined_marshal_set), signature)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	ret = (_tmp1 = g_strdup_printf ("%s_%s_", prefix, (_tmp0 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (ret = (g_free (ret), NULL)), _tmp1);
	(_tmp0 = (g_free (_tmp0), NULL));
	if (params == NULL) {
		char* _tmp2;
		_tmp2 = NULL;
		ret = (_tmp2 = g_strconcat (ret, "_VOID", NULL), (ret = (g_free (ret), NULL)), _tmp2);
	} else {
		{
			GeeCollection* p_collection;
			GeeIterator* p_it;
			p_collection = params;
			p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
			while (gee_iterator_next (p_it)) {
				ValaFormalParameter* p;
				p = gee_iterator_get (p_it);
				{
					char* _tmp4;
					char* _tmp3;
					_tmp4 = NULL;
					_tmp3 = NULL;
					ret = (_tmp4 = g_strdup_printf ("%s_%s", ret, (_tmp3 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (ret = (g_free (ret), NULL)), _tmp4);
					(_tmp3 = (g_free (_tmp3), NULL));
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
		}
	}
	_tmp5 = NULL;
	return (_tmp5 = ret, (signature = (g_free (signature), NULL)), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp5);
	(signature = (g_free (signature), NULL));
	(ret = (g_free (ret), NULL));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup ("gpointer");
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup ("void");
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (t)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (t))) {
				return g_strdup ("GObject *");
			} else {
				if (VALA_IS_STRUCT (vala_type_reference_get_data_type (t))) {
					if (vala_data_type_is_reference_type (VALA_DATA_TYPE ((VALA_STRUCT (vala_type_reference_get_data_type (t)))))) {
						return g_strdup ("gpointer");
					} else {
						return vala_data_type_get_cname (vala_type_reference_get_data_type (t), FALSE);
					}
				} else {
					if (VALA_IS_ENUM (vala_type_reference_get_data_type (t))) {
						return g_strdup ("gint");
					} else {
						if (VALA_IS_ARRAY (vala_type_reference_get_data_type (t))) {
							return g_strdup ("gpointer");
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig)
{
	char* signature;
	GeeCollection* params;
	char* _tmp1;
	char* _tmp0;
	char* _tmp7;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	signature = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	_tmp1 = NULL;
	_tmp0 = NULL;
	signature = (_tmp1 = g_strdup_printf ("%s:", (_tmp0 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (signature = (g_free (signature), NULL)), _tmp1);
	(_tmp0 = (g_free (_tmp0), NULL));
	if (params == NULL) {
		char* _tmp2;
		_tmp2 = NULL;
		signature = (_tmp2 = g_strconcat (signature, "VOID", NULL), (signature = (g_free (signature), NULL)), _tmp2);
	} else {
		gboolean first;
		first = TRUE;
		{
			GeeCollection* p_collection;
			GeeIterator* p_it;
			p_collection = params;
			p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
			while (gee_iterator_next (p_it)) {
				ValaFormalParameter* p;
				p = gee_iterator_get (p_it);
				{
					if (first) {
						char* _tmp4;
						char* _tmp3;
						_tmp4 = NULL;
						_tmp3 = NULL;
						signature = (_tmp4 = g_strconcat (signature, (_tmp3 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p))), NULL), (signature = (g_free (signature), NULL)), _tmp4);
						(_tmp3 = (g_free (_tmp3), NULL));
						first = FALSE;
					} else {
						char* _tmp6;
						char* _tmp5;
						_tmp6 = NULL;
						_tmp5 = NULL;
						signature = (_tmp6 = g_strdup_printf ("%s,%s", signature, (_tmp5 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (signature = (g_free (signature), NULL)), _tmp6);
						(_tmp5 = (g_free (_tmp5), NULL));
					}
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
		}
	}
	_tmp7 = NULL;
	return (_tmp7 = signature, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp7);
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static void vala_code_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaCodeGenerator * self;
	char* signature;
	GeeCollection* params;
	gint n_params;
	gint i;
	char* _tmp0;
	char* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFormalParameter* _tmp7;
	ValaCCodeFormalParameter* _tmp8;
	ValaCCodeFunction* _tmp9;
	ValaCCodeBlock* marshaller_body;
	char* _tmp10;
	ValaCCodeFunctionDeclarator* _tmp11;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* _tmp12;
	ValaCCodeFormalParameter* _tmp16;
	ValaCCodeTypeDefinition* _tmp18;
	char* _tmp17;
	char* _tmp19;
	ValaCCodeDeclaration* _tmp20;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* _tmp21;
	ValaCCodeDeclaration* _tmp22;
	ValaCCodeVariableDeclarator* _tmp25;
	ValaCCodeCastExpression* _tmp24;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeDeclaration* _tmp26;
	ValaCCodeVariableDeclarator* _tmp27;
	ValaCCodeVariableDeclarator* _tmp28;
	ValaCCodeFunctionCall* fc;
	ValaCCodeFunctionCall* _tmp39;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeBinaryExpression* _tmp43;
	ValaCCodeConstant* _tmp42;
	char* _tmp41;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeExpressionStatement* _tmp44;
	ValaCCodeIdentifier* _tmp45;
	ValaCCodeMemberAccess* _tmp46;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* _tmp48;
	ValaCCodeIdentifier* _tmp47;
	ValaCCodeMemberAccess* _tmp49;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* _tmp50;
	ValaCCodeFunctionCall* _tmp51;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* _tmp52;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* _tmp55;
	ValaCCodeAssignment* _tmp54;
	ValaCCodeIdentifier* _tmp53;
	ValaCCodeExpressionStatement* _tmp58;
	ValaCCodeAssignment* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* _tmp61;
	ValaCCodeAssignment* _tmp60;
	ValaCCodeIdentifier* _tmp59;
	ValaCCodeExpressionStatement* _tmp64;
	ValaCCodeAssignment* _tmp63;
	ValaCCodeIdentifier* _tmp62;
	ValaCCodeIfStatement* _tmp65;
	ValaCCodeCastExpression* _tmp73;
	char* _tmp72;
	ValaCCodeConditionalExpression* _tmp71;
	ValaCCodeMemberAccess* _tmp70;
	ValaCCodeIdentifier* _tmp69;
	ValaCCodeIdentifier* _tmp68;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeIdentifier* _tmp66;
	ValaCCodeAssignment* _tmp74;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* _tmp75;
	ValaCCodeFunctionCall* _tmp77;
	ValaCCodeIdentifier* _tmp76;
	ValaCCodeIdentifier* _tmp78;
	ValaCCodeIdentifier* _tmp87;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
	signature = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	_tmp0 = NULL;
	signature = (_tmp0 = vala_code_generator_get_signal_signature (self, sig), (signature = (g_free (signature), NULL)), _tmp0);
	if (gee_collection_contains (GEE_COLLECTION (self->priv->predefined_marshal_set), signature) || gee_collection_contains (GEE_COLLECTION (self->priv->user_marshal_set), signature)) {
		(signature = (g_free (signature), NULL));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		return;
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	signal_marshaller = (_tmp2 = vala_ccode_function_new ((_tmp1 = vala_code_generator_get_signal_marshaller_function (self, sig, NULL)), "void"), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp3 = vala_ccode_formal_parameter_new ("closure", "GClosure *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp4 = vala_ccode_formal_parameter_new ("return_value", "GValue *")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp5 = vala_ccode_formal_parameter_new ("n_param_values", "guint")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp6 = vala_ccode_formal_parameter_new ("param_values", "const GValue *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp7 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer")));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp8 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer")));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_declaration, VALA_CCODE_NODE ((_tmp9 = vala_ccode_function_copy (signal_marshaller))));
	(_tmp9 = (g_object_unref (_tmp9), NULL));
	marshaller_body = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp10 = NULL;
	_tmp11 = NULL;
	callback_decl = (_tmp11 = vala_ccode_function_declarator_new ((_tmp10 = vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp12 = vala_ccode_formal_parameter_new ("data1", "gpointer")));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	n_params = 1;
	{
		GeeCollection* p_collection;
		GeeIterator* p_it;
		p_collection = params;
		p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
		while (gee_iterator_next (p_it)) {
			ValaFormalParameter* p;
			p = gee_iterator_get (p_it);
			{
				ValaCCodeFormalParameter* _tmp15;
				char* _tmp14;
				char* _tmp13;
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp13 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp15 = vala_ccode_formal_parameter_new ((_tmp13 = g_strdup_printf ("arg_%d", n_params)), (_tmp14 = vala_code_generator_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_type_reference (p))))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
				(_tmp14 = (g_free (_tmp14), NULL));
				(_tmp13 = (g_free (_tmp13), NULL));
				n_params++;
				(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
			}
		}
		(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
	}
	_tmp16 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp16 = vala_ccode_formal_parameter_new ("data2", "gpointer")));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp18 = vala_ccode_type_definition_new ((_tmp17 = vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig))), VALA_CCODE_DECLARATOR (callback_decl)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	(_tmp17 = (g_free (_tmp17), NULL));
	_tmp19 = NULL;
	_tmp20 = NULL;
	var_decl = (_tmp20 = vala_ccode_declaration_new ((_tmp19 = vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp20);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp21 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp21 = vala_ccode_variable_declarator_new ("callback"))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	_tmp22 = NULL;
	var_decl = (_tmp22 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp22);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp25 = vala_ccode_variable_declarator_new_with_initializer ("cc", VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("closure"))), "GCClosure *")))))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	_tmp26 = NULL;
	var_decl = (_tmp26 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp26);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp27 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp27 = vala_ccode_variable_declarator_new ("data1"))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	_tmp28 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp28 = vala_ccode_variable_declarator_new ("data2"))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	fc = NULL;
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeDeclaration* _tmp30;
		char* _tmp29;
		ValaCCodeVariableDeclarator* _tmp31;
		ValaCCodeFunctionCall* _tmp33;
		ValaCCodeIdentifier* _tmp32;
		ValaCCodeBinaryExpression* _tmp36;
		ValaCCodeConstant* _tmp35;
		ValaCCodeIdentifier* _tmp34;
		ValaCCodeExpressionStatement* _tmp37;
		_tmp30 = NULL;
		_tmp29 = NULL;
		var_decl = (_tmp30 = vala_ccode_declaration_new ((_tmp29 = vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig)))), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp30);
		(_tmp29 = (g_free (_tmp29), NULL));
		_tmp31 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp31 = vala_ccode_variable_declarator_new ("v_return"))));
		(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
		_tmp33 = NULL;
		_tmp32 = NULL;
		fc = (_tmp33 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("g_return_if_fail")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp33);
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("return_value"))), VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("NULL")))))));
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
		_tmp37 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp37 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	}
	_tmp39 = NULL;
	_tmp38 = NULL;
	fc = (_tmp39 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("g_return_if_fail")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp39);
	(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("n_param_values"))), VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_constant_new ((_tmp41 = g_strdup_printf ("%i", n_params)))))))));
	(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
	(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	(_tmp41 = (g_free (_tmp41), NULL));
	(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
	_tmp44 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp44 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
	_tmp45 = NULL;
	_tmp46 = NULL;
	data = (_tmp46 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("closure"))), "data", TRUE), (_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL))), _tmp46);
	_tmp48 = NULL;
	_tmp47 = NULL;
	_tmp49 = NULL;
	param = (_tmp49 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_identifier_new ("param_values"))), "data[0]", TRUE))), "v_pointer", FALSE), (_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL))), (_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL))), _tmp49);
	_tmp50 = NULL;
	_tmp51 = NULL;
	cond = (_tmp51 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA")))), (_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL))), _tmp51);
	_tmp52 = NULL;
	vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ("closure"))));
	(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
	true_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp55 = NULL;
	_tmp54 = NULL;
	_tmp53 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((_tmp55 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new ("data1"))), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
	(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
	(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
	_tmp58 = NULL;
	_tmp57 = NULL;
	_tmp56 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((_tmp58 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new ("data2"))), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
	(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
	(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
	false_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp61 = NULL;
	_tmp60 = NULL;
	_tmp59 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((_tmp61 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("data1"))), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
	(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
	(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
	_tmp64 = NULL;
	_tmp63 = NULL;
	_tmp62 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((_tmp64 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("data2"))), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
	(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
	(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
	_tmp65 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp65 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (true_block), VALA_CCODE_STATEMENT (false_block)))));
	(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
	_tmp73 = NULL;
	_tmp72 = NULL;
	_tmp71 = NULL;
	_tmp70 = NULL;
	_tmp69 = NULL;
	_tmp68 = NULL;
	_tmp67 = NULL;
	_tmp66 = NULL;
	_tmp74 = NULL;
	c_assign = (_tmp74 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("callback"))), VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_identifier_new ("marshal_data"))), VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new ("marshal_data"))), VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new ("cc"))), "callback", TRUE)))))), (_tmp72 = vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), (_tmp72 = (g_free (_tmp72), NULL)), (_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL))), (_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL))), (_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL))), (_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL))), (_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL))), (_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL))), _tmp74);
	_tmp75 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp75 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (c_assign)))));
	(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
	_tmp77 = NULL;
	_tmp76 = NULL;
	fc = (_tmp77 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ("callback")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp77);
	(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
	_tmp78 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_identifier_new ("data1"))));
	(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
	i = 1;
	{
		GeeCollection* p_collection;
		GeeIterator* p_it;
		p_collection = params;
		p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
		while (gee_iterator_next (p_it)) {
			ValaFormalParameter* p;
			p = gee_iterator_get (p_it);
			{
				char* get_value_function;
				ValaCCodeIdentifier* _tmp81;
				ValaCCodeFunctionCall* _tmp82;
				ValaCCodeFunctionCall* inner_fc;
				ValaCCodeBinaryExpression* _tmp86;
				ValaCCodeIdentifier* _tmp85;
				char* _tmp84;
				ValaCCodeIdentifier* _tmp83;
				get_value_function = NULL;
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (p)) != NULL) {
					char* _tmp79;
					_tmp79 = NULL;
					get_value_function = (_tmp79 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), _tmp79);
				} else {
					char* _tmp80;
					_tmp80 = NULL;
					get_value_function = (_tmp80 = vala_data_type_get_get_value_function (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (p))), (get_value_function = (g_free (get_value_function), NULL)), _tmp80);
				}
				_tmp81 = NULL;
				_tmp82 = NULL;
				inner_fc = (_tmp82 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new (get_value_function)))), (_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL))), _tmp82);
				_tmp86 = NULL;
				_tmp85 = NULL;
				_tmp84 = NULL;
				_tmp83 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new ("param_values"))), VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_identifier_new ((_tmp84 = g_strdup_printf ("%i", i)))))))));
				(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
				(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
				(_tmp84 = (g_free (_tmp84), NULL));
				(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
				vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION (inner_fc));
				i++;
				(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				(get_value_function = (g_free (get_value_function), NULL));
				(inner_fc == NULL ? NULL : (inner_fc = (g_object_unref (inner_fc), NULL)));
			}
		}
		(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
	}
	_tmp87 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_identifier_new ("data2"))));
	(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeExpressionStatement* _tmp90;
		ValaCCodeAssignment* _tmp89;
		ValaCCodeIdentifier* _tmp88;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* _tmp100;
		ValaCCodeIdentifier* _tmp101;
		ValaCCodeExpressionStatement* _tmp102;
		_tmp90 = NULL;
		_tmp89 = NULL;
		_tmp88 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp90 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new ("v_return"))), VALA_CCODE_EXPRESSION (fc), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
		(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
		(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
		set_fc = NULL;
		if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
			ValaCCodeFunctionCall* _tmp92;
			ValaCCodeIdentifier* _tmp91;
			_tmp92 = NULL;
			_tmp91 = NULL;
			set_fc = (_tmp92 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_identifier_new ("g_value_set_pointer")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp92);
			(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_signal_get_return_type (sig))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))) {
				ValaCCodeFunctionCall* _tmp94;
				ValaCCodeIdentifier* _tmp93;
				_tmp94 = NULL;
				_tmp93 = NULL;
				set_fc = (_tmp94 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_identifier_new ("g_value_take_object")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp94);
				(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
			} else {
				if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == vala_type_reference_get_data_type (self->priv->string_type)) {
					ValaCCodeFunctionCall* _tmp96;
					ValaCCodeIdentifier* _tmp95;
					_tmp96 = NULL;
					_tmp95 = NULL;
					set_fc = (_tmp96 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new ("g_value_take_string")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp96);
					(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
				} else {
					ValaCCodeFunctionCall* _tmp99;
					ValaCCodeIdentifier* _tmp98;
					char* _tmp97;
					_tmp99 = NULL;
					_tmp98 = NULL;
					_tmp97 = NULL;
					set_fc = (_tmp99 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp98 = vala_ccode_identifier_new ((_tmp97 = vala_data_type_get_set_value_function (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))))))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp99);
					(_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL)));
					(_tmp97 = (g_free (_tmp97), NULL));
				}
			}
		}
		_tmp100 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((_tmp100 = vala_ccode_identifier_new ("return_value"))));
		(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
		_tmp101 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((_tmp101 = vala_ccode_identifier_new ("v_return"))));
		(_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL)));
		_tmp102 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp102 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (set_fc)))));
		(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
		(set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp103;
		_tmp103 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp103 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
	}
	vala_ccode_function_set_block (signal_marshaller, marshaller_body);
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_definition, VALA_CCODE_NODE (signal_marshaller));
	gee_collection_add (GEE_COLLECTION (self->priv->user_marshal_set), signature);
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(signal_marshaller == NULL ? NULL : (signal_marshaller = (g_object_unref (signal_marshaller), NULL)));
	(marshaller_body == NULL ? NULL : (marshaller_body = (g_object_unref (marshaller_body), NULL)));
	(callback_decl == NULL ? NULL : (callback_decl = (g_object_unref (callback_decl), NULL)));
	(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(data == NULL ? NULL : (data = (g_object_unref (data), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
	(true_block == NULL ? NULL : (true_block = (g_object_unref (true_block), NULL)));
	(false_block == NULL ? NULL : (false_block = (g_object_unref (false_block), NULL)));
	(c_assign == NULL ? NULL : (c_assign = (g_object_unref (c_assign), NULL)));
}


static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->priv->context) == NULL);
}


static ValaCCodeForStatement* vala_code_generator_get_vala_array_free_loop (ValaCodeGenerator* self, gboolean have_length)
{
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeCastExpression* _tmp1;
	ValaCCodeCastExpression* cptrarray;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeElementAccess* _tmp3;
	ValaCCodeElementAccess* cea;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeExpression* cforcond;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeConstant* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeAssignment* _tmp23;
	ValaCCodeBinaryExpression* _tmp22;
	ValaCCodeConstant* _tmp21;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeForStatement* _tmp24;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cptrarray = (_tmp1 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("array"))), "gpointer*"), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cea = (_tmp3 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (cptrarray), VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("i")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	cfreecall = (_tmp5 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("destroy_func")))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
	vala_ccode_function_call_add_argument (cfreecall, VALA_CCODE_EXPRESSION (cea));
	cforcond = NULL;
	if (have_length) {
		ValaCCodeConstant* _tmp6;
		ValaCCodeBinaryExpression* _tmp7;
		ValaCCodeBinaryExpression* cfreecond;
		ValaCCodeExpression* _tmp10;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeIdentifier* _tmp8;
		ValaCCodeIfStatement* _tmp12;
		ValaCCodeExpressionStatement* _tmp11;
		_tmp6 = NULL;
		_tmp7 = NULL;
		cfreecond = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (cea), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		cforcond = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("array_length"))))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp10);
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE ((_tmp12 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cfreecond), VALA_CCODE_STATEMENT ((_tmp11 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreecall)))), NULL))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		(cfreecond == NULL ? NULL : (cfreecond = (g_object_unref (cfreecond), NULL)));
	} else {
		ValaCCodeExpression* _tmp14;
		ValaCCodeConstant* _tmp13;
		ValaCCodeExpressionStatement* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		cforcond = (_tmp14 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (cea), VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("NULL"))))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp14);
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp15 = NULL;
		vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE ((_tmp15 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreecall)))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	}
	cfor = vala_ccode_for_statement_new (cforcond, VALA_CCODE_STATEMENT (cbody));
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	_tmp24 = NULL;
	return (_tmp24 = cfor, (cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL))), (cptrarray == NULL ? NULL : (cptrarray = (g_object_unref (cptrarray), NULL))), (cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL))), (cfreecall == NULL ? NULL : (cfreecall = (g_object_unref (cfreecall), NULL))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp24);
	(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
	(cptrarray == NULL ? NULL : (cptrarray = (g_object_unref (cptrarray), NULL)));
	(cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL)));
	(cfreecall == NULL ? NULL : (cfreecall = (g_object_unref (cfreecall), NULL)));
	(cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL)));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
}


static void vala_code_generator_append_vala_array_free (ValaCodeGenerator* self)
{
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFunction* _tmp3;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeConstant* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeBinaryExpression* _tmp7;
	ValaCCodeBinaryExpression* clencheck;
	ValaCCodeForStatement* _tmp9;
	ValaCCodeForStatement* _tmp8;
	ValaCCodeIfStatement* _tmp10;
	ValaCCodeIfStatement* ciflen;
	ValaCCodeConstant* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeBinaryExpression* _tmp16;
	ValaCCodeBinaryExpression* ccondfunc;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeIfStatement* _tmp18;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp23;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	fun = vala_ccode_function_new ("_vala_array_free", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("array_length", "gint")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp2 = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp3 = vala_ccode_function_copy (fun))));
	(_tmp3 = (g_object_unref (_tmp3), NULL));
	cdofree = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	citdecl = vala_ccode_declaration_new ("int");
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp4 = vala_ccode_variable_declarator_new ("i"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	vala_ccode_block_add_statement (cdofree, VALA_CCODE_NODE (citdecl));
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	clencheck = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("array_length"))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("0")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp10 = NULL;
	ciflen = (_tmp10 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (clencheck), VALA_CCODE_STATEMENT ((_tmp8 = vala_code_generator_get_vala_array_free_loop (self, TRUE))), VALA_CCODE_STATEMENT ((_tmp9 = vala_code_generator_get_vala_array_free_loop (self, FALSE)))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp10);
	vala_ccode_block_add_statement (cdofree, VALA_CCODE_NODE (ciflen));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	ccondarr = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("array"))), VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_constant_new ("NULL")))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp13);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp16 = NULL;
	ccondfunc = (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("destroy_func"))), VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("NULL")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), _tmp16);
	_tmp17 = NULL;
	_tmp18 = NULL;
	cif = (_tmp18 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccondarr), VALA_CCODE_EXPRESSION (ccondfunc)))), VALA_CCODE_STATEMENT (cdofree), NULL), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_ccode_function_set_block (fun, (_tmp19 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE (cif));
	_tmp20 = NULL;
	_tmp21 = NULL;
	carrfree = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_free")))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (carrfree, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("array"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp23 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (carrfree)))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (fun));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(cdofree == NULL ? NULL : (cdofree = (g_object_unref (cdofree), NULL)));
	(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
	(clencheck == NULL ? NULL : (clencheck = (g_object_unref (clencheck), NULL)));
	(ciflen == NULL ? NULL : (ciflen = (g_object_unref (ciflen), NULL)));
	(ccondarr == NULL ? NULL : (ccondarr = (g_object_unref (ccondarr), NULL)));
	(ccondfunc == NULL ? NULL : (ccondfunc = (g_object_unref (ccondfunc), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(carrfree == NULL ? NULL : (carrfree = (g_object_unref (carrfree), NULL)));
}


static void vala_code_generator_append_vala_array_move (ValaCodeGenerator* self)
{
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFunction* _tmp5;
	ValaCCodeIdentifier* array;
	ValaCCodeIdentifier* element_size;
	ValaCCodeIdentifier* length;
	ValaCCodeIdentifier* src;
	ValaCCodeIdentifier* dest;
	ValaCCodeBinaryExpression* _tmp6;
	ValaCCodeBinaryExpression* _tmp7;
	ValaCCodeBinaryExpression* src_address;
	ValaCCodeBinaryExpression* _tmp8;
	ValaCCodeBinaryExpression* _tmp9;
	ValaCCodeBinaryExpression* dest_address;
	ValaCCodeBinaryExpression* _tmp12;
	ValaCCodeParenthesizedExpression* _tmp11;
	ValaCCodeBinaryExpression* _tmp10;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* dest_end_address;
	ValaCCodeBlock* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeExpressionStatement* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* czero1;
	ValaCCodeConstant* _tmp21;
	ValaCCodeBinaryExpression* _tmp24;
	ValaCCodeParenthesizedExpression* _tmp23;
	ValaCCodeBinaryExpression* _tmp22;
	ValaCCodeBlock* czeroblock1;
	ValaCCodeExpressionStatement* _tmp25;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeFunctionCall* czero2;
	ValaCCodeConstant* _tmp28;
	ValaCCodeBinaryExpression* _tmp31;
	ValaCCodeParenthesizedExpression* _tmp30;
	ValaCCodeBinaryExpression* _tmp29;
	ValaCCodeBlock* czeroblock2;
	ValaCCodeExpressionStatement* _tmp32;
	ValaCCodeIfStatement* _tmp34;
	ValaCCodeBinaryExpression* _tmp33;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	self->priv->string_h_needed = TRUE;
	/* assumes that overwritten array elements are null before invocation
	 FIXME will leak memory if that's not the case*/
	fun = vala_ccode_function_new ("_vala_array_move", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("element_size", "gsize")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp2 = vala_ccode_formal_parameter_new ("src", "gint")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp3 = vala_ccode_formal_parameter_new ("dest", "gint")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp4 = vala_ccode_formal_parameter_new ("length", "gint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp5 = vala_ccode_function_copy (fun))));
	(_tmp5 = (g_object_unref (_tmp5), NULL));
	array = vala_ccode_identifier_new ("array");
	element_size = vala_ccode_identifier_new ("element_size");
	length = vala_ccode_identifier_new ("length");
	src = vala_ccode_identifier_new ("src");
	dest = vala_ccode_identifier_new ("dest");
	_tmp6 = NULL;
	_tmp7 = NULL;
	src_address = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (element_size))))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
	_tmp8 = NULL;
	_tmp9 = NULL;
	dest_address = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (element_size))))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp13 = NULL;
	dest_end_address = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (length))))))), VALA_CCODE_EXPRESSION (element_size))))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp13);
	_tmp14 = NULL;
	vala_ccode_function_set_block (fun, (_tmp14 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL)));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	_tmp15 = NULL;
	_tmp16 = NULL;
	ccall = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("g_memmove")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (dest_address));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (src_address));
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (length), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp18 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	_tmp20 = NULL;
	czero1 = (_tmp20 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("memset")))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp20);
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION (src_address));
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("0"))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (src))))))), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	czeroblock1 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp25 = NULL;
	vala_ccode_block_add_statement (czeroblock1, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero1)))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	_tmp26 = NULL;
	_tmp27 = NULL;
	czero2 = (_tmp27 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("memset")))), (_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL))), _tmp27);
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION (dest_end_address));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_constant_new ("0"))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (dest))))))), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	czeroblock2 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	_tmp32 = NULL;
	vala_ccode_block_add_statement (czeroblock2, VALA_CCODE_NODE ((_tmp32 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero2)))));
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	_tmp34 = NULL;
	_tmp33 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp34 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (dest)))), VALA_CCODE_STATEMENT (czeroblock1), VALA_CCODE_STATEMENT (czeroblock2)))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (fun));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	(element_size == NULL ? NULL : (element_size = (g_object_unref (element_size), NULL)));
	(length == NULL ? NULL : (length = (g_object_unref (length), NULL)));
	(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
	(dest == NULL ? NULL : (dest = (g_object_unref (dest), NULL)));
	(src_address == NULL ? NULL : (src_address = (g_object_unref (src_address), NULL)));
	(dest_address == NULL ? NULL : (dest_address = (g_object_unref (dest_address), NULL)));
	(dest_end_address == NULL ? NULL : (dest_end_address = (g_object_unref (dest_end_address), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(czero1 == NULL ? NULL : (czero1 = (g_object_unref (czero1), NULL)));
	(czeroblock1 == NULL ? NULL : (czeroblock1 = (g_object_unref (czeroblock1), NULL)));
	(czero2 == NULL ? NULL : (czero2 = (g_object_unref (czero2), NULL)));
	(czeroblock2 == NULL ? NULL : (czeroblock2 = (g_object_unref (czeroblock2), NULL)));
}


static void vala_code_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* _tmp0;
	ValaCCodeFragment* _tmp1;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* _tmp3;
	ValaCCodeFragment* _tmp4;
	ValaCCodeFragment* _tmp5;
	ValaCCodeFragment* _tmp6;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* _tmp9;
	GeeSet* _tmp10;
	ValaCCodeIncludeDirective* _tmp11;
	ValaCCodeIncludeDirective* _tmp12;
	ValaCCodeIncludeDirective* _tmp14;
	char* _tmp13;
	GeeList* used_includes;
	char* _tmp15;
	char* _tmp50;
	char* _tmp51;
	char* header_define;
	ValaCCodeComment* comment;
	char* _tmp55;
	ValaCCodeWriter* _tmp56;
	ValaCCodeWriter* writer;
	ValaCCodeOnceSection* once;
	ValaCCodeNewline* _tmp57;
	ValaCCodeNewline* _tmp58;
	ValaCCodeIdentifier* _tmp59;
	ValaCCodeNewline* _tmp60;
	ValaCCodeNewline* _tmp61;
	ValaCCodeNewline* _tmp62;
	ValaCCodeNewline* _tmp63;
	ValaCCodeNewline* _tmp64;
	ValaCCodeIdentifier* _tmp65;
	ValaCCodeNewline* _tmp66;
	ValaCCodeNewline* _tmp67;
	ValaCCodeWriter* _tmp69;
	char* _tmp68;
	ValaCCodeFragment* _tmp70;
	ValaCCodeFragment* _tmp71;
	ValaCCodeFragment* _tmp72;
	ValaCCodeFragment* _tmp73;
	ValaCCodeFragment* _tmp74;
	ValaCCodeFragment* _tmp75;
	ValaCCodeFragment* _tmp76;
	ValaCCodeFragment* _tmp77;
	ValaCCodeFragment* _tmp78;
	ValaCCodeFragment* _tmp79;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	_tmp0 = NULL;
	self->priv->header_begin = (_tmp0 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), _tmp0);
	_tmp1 = NULL;
	self->priv->header_type_declaration = (_tmp1 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), _tmp1);
	_tmp2 = NULL;
	self->priv->header_type_definition = (_tmp2 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), _tmp2);
	_tmp3 = NULL;
	self->priv->header_type_member_declaration = (_tmp3 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), _tmp3);
	_tmp4 = NULL;
	self->priv->source_begin = (_tmp4 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), _tmp4);
	_tmp5 = NULL;
	self->priv->source_include_directives = (_tmp5 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), _tmp5);
	_tmp6 = NULL;
	self->priv->source_type_member_declaration = (_tmp6 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), _tmp6);
	_tmp7 = NULL;
	self->priv->source_type_member_definition = (_tmp7 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), _tmp7);
	_tmp8 = NULL;
	self->priv->source_signal_marshaller_definition = (_tmp8 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), _tmp8);
	_tmp9 = NULL;
	self->priv->source_signal_marshaller_declaration = (_tmp9 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), _tmp9);
	_tmp10 = NULL;
	self->priv->user_marshal_set = (_tmp10 = GEE_SET (gee_hash_set_new (g_strdup, g_free, g_str_hash, g_str_equal)), (self->priv->user_marshal_set == NULL ? NULL : (self->priv->user_marshal_set = (g_object_unref (self->priv->user_marshal_set), NULL))), _tmp10);
	self->priv->next_temp_var_id = 0;
	self->priv->string_h_needed = FALSE;
	self->priv->requires_free_checked = FALSE;
	self->priv->requires_array_free = FALSE;
	self->priv->requires_array_move = FALSE;
	_tmp11 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((_tmp11 = vala_ccode_include_directive_new ("glib.h", FALSE))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((_tmp12 = vala_ccode_include_directive_new ("glib-object.h", FALSE))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp14 = vala_ccode_include_directive_new ((_tmp13 = vala_source_file_get_cheader_filename (source_file)), TRUE))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	(_tmp13 = (g_free (_tmp13), NULL));
	used_includes = GEE_LIST (gee_array_list_new (g_strdup, g_free, g_str_equal));
	gee_collection_add (GEE_COLLECTION (used_includes), "glib.h");
	gee_collection_add (GEE_COLLECTION (used_includes), "glib-object.h");
	_tmp15 = NULL;
	gee_collection_add (GEE_COLLECTION (used_includes), (_tmp15 = vala_source_file_get_cheader_filename (source_file)));
	(_tmp15 = (g_free (_tmp15), NULL));
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_header_external_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp16;
					_tmp16 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((_tmp16 = vala_ccode_include_directive_new (filename, FALSE))));
					(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_header_internal_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp17;
					_tmp17 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((_tmp17 = vala_code_generator_get_internal_include (self, filename))));
					(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_source_external_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp18;
					_tmp18 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp18 = vala_ccode_include_directive_new (filename, FALSE))));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_source_internal_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp19;
					_tmp19 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp19 = vala_code_generator_get_internal_include (self, filename))));
					(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GeeList* cycle_file_collection;
			GeeIterator* cycle_file_it;
			cycle_file_collection = vala_source_file_get_cycle (source_file)->files;
			cycle_file_it = gee_iterable_iterator (GEE_ITERABLE (cycle_file_collection));
			while (gee_iterator_next (cycle_file_it)) {
				ValaSourceFile* _tmp49;
				ValaSourceFile* cycle_file;
				_tmp49 = NULL;
				cycle_file = (_tmp49 = gee_iterator_get (cycle_file_it), (_tmp49 == NULL ? NULL : g_object_ref (_tmp49)));
				{
					{
						GeeCollection* node_collection;
						GeeIterator* node_it;
						node_collection = vala_source_file_get_nodes (cycle_file);
						node_it = gee_iterable_iterator (GEE_ITERABLE (node_collection));
						while (gee_iterator_next (node_it)) {
							ValaCodeNode* node;
							node = gee_iterator_get (node_it);
							{
								if (VALA_IS_STRUCT (node)) {
									ValaStruct* _tmp20;
									ValaStruct* st;
									ValaCCodeTypeDefinition* _tmp25;
									ValaCCodeVariableDeclarator* _tmp24;
									char* _tmp23;
									char* _tmp22;
									char* _tmp21;
									_tmp20 = NULL;
									st = (_tmp20 = VALA_STRUCT (node), (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)));
									_tmp25 = NULL;
									_tmp24 = NULL;
									_tmp23 = NULL;
									_tmp22 = NULL;
									_tmp21 = NULL;
									vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp25 = vala_ccode_type_definition_new ((_tmp22 = g_strdup_printf ("struct _%s", (_tmp21 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp24 = vala_ccode_variable_declarator_new ((_tmp23 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))))));
									(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
									(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
									(_tmp23 = (g_free (_tmp23), NULL));
									(_tmp22 = (g_free (_tmp22), NULL));
									(_tmp21 = (g_free (_tmp21), NULL));
									(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								} else {
									if (VALA_IS_CLASS (node)) {
										ValaClass* _tmp26;
										ValaClass* cl;
										ValaCCodeTypeDefinition* _tmp31;
										ValaCCodeVariableDeclarator* _tmp30;
										char* _tmp29;
										char* _tmp28;
										char* _tmp27;
										ValaCCodeTypeDefinition* _tmp37;
										ValaCCodeVariableDeclarator* _tmp36;
										char* _tmp35;
										char* _tmp34;
										char* _tmp33;
										char* _tmp32;
										_tmp26 = NULL;
										cl = (_tmp26 = VALA_CLASS (node), (_tmp26 == NULL ? NULL : g_object_ref (_tmp26)));
										_tmp31 = NULL;
										_tmp30 = NULL;
										_tmp29 = NULL;
										_tmp28 = NULL;
										_tmp27 = NULL;
										vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp31 = vala_ccode_type_definition_new ((_tmp28 = g_strdup_printf ("struct _%s", (_tmp27 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp30 = vala_ccode_variable_declarator_new ((_tmp29 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
										(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
										(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
										(_tmp29 = (g_free (_tmp29), NULL));
										(_tmp28 = (g_free (_tmp28), NULL));
										(_tmp27 = (g_free (_tmp27), NULL));
										_tmp37 = NULL;
										_tmp36 = NULL;
										_tmp35 = NULL;
										_tmp34 = NULL;
										_tmp33 = NULL;
										_tmp32 = NULL;
										vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp37 = vala_ccode_type_definition_new ((_tmp33 = g_strdup_printf ("struct _%sClass", (_tmp32 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp36 = vala_ccode_variable_declarator_new ((_tmp35 = g_strdup_printf ("%sClass", (_tmp34 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))))));
										(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
										(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
										(_tmp35 = (g_free (_tmp35), NULL));
										(_tmp34 = (g_free (_tmp34), NULL));
										(_tmp33 = (g_free (_tmp33), NULL));
										(_tmp32 = (g_free (_tmp32), NULL));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									} else {
										if (VALA_IS_INTERFACE (node)) {
											ValaInterface* _tmp38;
											ValaInterface* iface;
											ValaCCodeTypeDefinition* _tmp43;
											ValaCCodeVariableDeclarator* _tmp42;
											char* _tmp41;
											char* _tmp40;
											char* _tmp39;
											ValaCCodeTypeDefinition* _tmp48;
											ValaCCodeVariableDeclarator* _tmp47;
											char* _tmp46;
											char* _tmp45;
											char* _tmp44;
											_tmp38 = NULL;
											iface = (_tmp38 = VALA_INTERFACE (node), (_tmp38 == NULL ? NULL : g_object_ref (_tmp38)));
											_tmp43 = NULL;
											_tmp42 = NULL;
											_tmp41 = NULL;
											_tmp40 = NULL;
											_tmp39 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp43 = vala_ccode_type_definition_new ((_tmp40 = g_strdup_printf ("struct _%s", (_tmp39 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp42 = vala_ccode_variable_declarator_new ((_tmp41 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))))));
											(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
											(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
											(_tmp41 = (g_free (_tmp41), NULL));
											(_tmp40 = (g_free (_tmp40), NULL));
											(_tmp39 = (g_free (_tmp39), NULL));
											_tmp48 = NULL;
											_tmp47 = NULL;
											_tmp46 = NULL;
											_tmp45 = NULL;
											_tmp44 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp48 = vala_ccode_type_definition_new ((_tmp45 = g_strdup_printf ("struct _%s", (_tmp44 = vala_interface_get_type_cname (iface)))), VALA_CCODE_DECLARATOR ((_tmp47 = vala_ccode_variable_declarator_new ((_tmp46 = vala_interface_get_type_cname (iface)))))))));
											(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
											(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
											(_tmp46 = (g_free (_tmp46), NULL));
											(_tmp45 = (g_free (_tmp45), NULL));
											(_tmp44 = (g_free (_tmp44), NULL));
											(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
										}
									}
								}
								(node == NULL ? NULL : (node = (g_object_unref (node), NULL)));
							}
						}
						(node_collection == NULL ? NULL : (node_collection = (g_object_unref (node_collection), NULL)));
						(node_it == NULL ? NULL : (node_it = (g_object_unref (node_it), NULL)));
					}
					(cycle_file == NULL ? NULL : (cycle_file = (g_object_unref (cycle_file), NULL)));
				}
			}
			(cycle_file_it == NULL ? NULL : (cycle_file_it = (g_object_unref (cycle_file_it), NULL)));
		}
	}
	vala_source_file_accept_children (source_file, VALA_CODE_VISITOR (self));
	_tmp50 = NULL;
	_tmp51 = NULL;
	header_define = (_tmp51 = vala_code_generator_get_define_for_filename ((_tmp50 = vala_source_file_get_cheader_filename (source_file))), (_tmp50 = (g_free (_tmp50), NULL)), _tmp51);
	/* generate hardcoded "well-known" macros */
	if (self->priv->requires_free_checked) {
		ValaCCodeMacroReplacement* _tmp52;
		_tmp52 = NULL;
		vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((_tmp52 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))"))));
		(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
	}
	if (self->priv->requires_array_free) {
		vala_code_generator_append_vala_array_free (self);
	}
	if (self->priv->requires_array_move) {
		vala_code_generator_append_vala_array_move (self);
	}
	if (self->priv->string_h_needed) {
		ValaCCodeIncludeDirective* _tmp53;
		_tmp53 = NULL;
		vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp53 = vala_ccode_include_directive_new ("string.h", FALSE))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* _tmp54;
		_tmp54 = NULL;
		comment = (_tmp54 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL))), _tmp54);
	}
	_tmp55 = NULL;
	_tmp56 = NULL;
	writer = (_tmp56 = vala_ccode_writer_new ((_tmp55 = vala_source_file_get_cheader_filename (source_file))), (_tmp55 = (g_free (_tmp55), NULL)), _tmp56);
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_writer_write_newline (writer);
	once = vala_ccode_once_section_new (header_define);
	_tmp57 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp57 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_begin));
	_tmp58 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp58 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
	_tmp59 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp59 = vala_ccode_identifier_new ("G_BEGIN_DECLS"))));
	(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
	_tmp60 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp60 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
	_tmp61 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp61 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_declaration));
	_tmp62 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp62 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_definition));
	_tmp63 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp63 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_member_declaration));
	_tmp64 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp64 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
	_tmp65 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp65 = vala_ccode_identifier_new ("G_END_DECLS"))));
	(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
	_tmp66 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp66 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
	_tmp67 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp67 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
	vala_ccode_node_write (VALA_CCODE_NODE (once), writer);
	vala_ccode_writer_close (writer);
	_tmp69 = NULL;
	_tmp68 = NULL;
	writer = (_tmp69 = vala_ccode_writer_new ((_tmp68 = vala_source_file_get_csource_filename (source_file))), (writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL))), _tmp69);
	(_tmp68 = (g_free (_tmp68), NULL));
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_begin), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_include_directives), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	_tmp70 = NULL;
	self->priv->header_begin = (_tmp70 = NULL, (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), _tmp70);
	_tmp71 = NULL;
	self->priv->header_type_declaration = (_tmp71 = NULL, (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), _tmp71);
	_tmp72 = NULL;
	self->priv->header_type_definition = (_tmp72 = NULL, (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), _tmp72);
	_tmp73 = NULL;
	self->priv->header_type_member_declaration = (_tmp73 = NULL, (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), _tmp73);
	_tmp74 = NULL;
	self->priv->source_begin = (_tmp74 = NULL, (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), _tmp74);
	_tmp75 = NULL;
	self->priv->source_include_directives = (_tmp75 = NULL, (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), _tmp75);
	_tmp76 = NULL;
	self->priv->source_type_member_declaration = (_tmp76 = NULL, (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), _tmp76);
	_tmp77 = NULL;
	self->priv->source_type_member_definition = (_tmp77 = NULL, (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), _tmp77);
	_tmp78 = NULL;
	self->priv->source_signal_marshaller_definition = (_tmp78 = NULL, (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), _tmp78);
	_tmp79 = NULL;
	self->priv->source_signal_marshaller_declaration = (_tmp79 = NULL, (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), _tmp79);
	(used_includes == NULL ? NULL : (used_includes = (g_object_unref (used_includes), NULL)));
	(header_define = (g_free (header_define), NULL));
	(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
	(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
	(once == NULL ? NULL : (once = (g_object_unref (once), NULL)));
}


static char* vala_code_generator_get_define_for_filename (const char* filename)
{
	GString* define;
	char* i;
	const char* _tmp2;
	char* _tmp3;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	i = g_strdup (filename);
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		char* _tmp1;
		const char* _tmp0;
		c = g_utf8_get_char (i);
		if (g_unichar_isalnum (c) && c < 0x80) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		i = (_tmp1 = (_tmp0 = g_utf8_next_char (i), (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (i = (g_free (i), NULL)), _tmp1);
	}
	g_string_append (define, "__");
	_tmp2 = NULL;
	_tmp3 = NULL;
	return (_tmp3 = (_tmp2 = define->str, (_tmp2 == NULL ? NULL : g_strdup (_tmp2))), (define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL))), (i = (g_free (i), NULL)), _tmp3);
	(define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL)));
	(i = (g_free (i), NULL));
}


static void vala_code_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaCodeGenerator * self;
	ValaSymbol* _tmp0;
	ValaSymbol* old_type_symbol;
	ValaCCodeStruct* _tmp1;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* old_instance_dispose_fragment;
	ValaSymbol* _tmp3;
	ValaCCodeStruct* _tmp6;
	char* _tmp5;
	char* _tmp4;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaSymbol* _tmp36;
	ValaSymbol* _tmp35;
	ValaCCodeStruct* _tmp38;
	ValaCCodeStruct* _tmp37;
	ValaCCodeFragment* _tmp40;
	ValaCCodeFragment* _tmp39;
	self = ((ValaCodeGenerator*) base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	_tmp0 = NULL;
	old_type_symbol = (_tmp0 = self->priv->current_type_symbol, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_instance_struct = (_tmp1 = self->priv->instance_struct, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_instance_dispose_fragment = (_tmp2 = self->priv->instance_dispose_fragment, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	self->priv->current_type_symbol = (_tmp3 = VALA_SYMBOL (g_object_ref (st)), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), _tmp3);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->priv->instance_struct = (_tmp6 = vala_ccode_struct_new ((_tmp5 = g_strdup_printf ("_%s", (_tmp4 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), _tmp6);
	(_tmp5 = (g_free (_tmp5), NULL));
	(_tmp4 = (g_free (_tmp4), NULL));
	_tmp7 = NULL;
	self->priv->instance_dispose_fragment = (_tmp7 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), _tmp7);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (((ValaSymbol*) st)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp8;
		ValaCCodeFragment* _tmp11;
		ValaCCodeFragment* _tmp10;
		_tmp9 = NULL;
		_tmp8 = NULL;
		decl_frag = (_tmp9 = (_tmp8 = self->priv->header_type_declaration, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp9);
		_tmp11 = NULL;
		_tmp10 = NULL;
		def_frag = (_tmp11 = (_tmp10 = self->priv->header_type_definition, (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp11);
	} else {
		ValaCCodeFragment* _tmp13;
		ValaCCodeFragment* _tmp12;
		ValaCCodeFragment* _tmp15;
		ValaCCodeFragment* _tmp14;
		_tmp13 = NULL;
		_tmp12 = NULL;
		decl_frag = (_tmp13 = (_tmp12 = self->priv->source_type_member_declaration, (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp13);
		_tmp15 = NULL;
		_tmp14 = NULL;
		def_frag = (_tmp15 = (_tmp14 = self->priv->source_type_member_declaration, (_tmp14 == NULL ? NULL : g_object_ref (_tmp14))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp15);
	}
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) st)))) == NULL) {
		ValaCCodeTypeDefinition* _tmp20;
		ValaCCodeVariableDeclarator* _tmp19;
		char* _tmp18;
		char* _tmp17;
		char* _tmp16;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp20 = vala_ccode_type_definition_new ((_tmp17 = g_strdup_printf ("struct _%s", (_tmp16 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp19 = vala_ccode_variable_declarator_new ((_tmp18 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))))));
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		(_tmp18 = (g_free (_tmp18), NULL));
		(_tmp17 = (g_free (_tmp17), NULL));
		(_tmp16 = (g_free (_tmp16), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) st))) != NULL) {
		ValaCCodeComment* _tmp21;
		_tmp21 = NULL;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp21 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (((ValaCodeNode*) st)))))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	}
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	if (vala_struct_get_default_construction_method (st) != NULL) {
		char* _tmp23;
		char* _tmp22;
		ValaCCodeFunction* _tmp24;
		ValaCCodeFunction* function;
		ValaCCodeFormalParameter* _tmp27;
		char* _tmp26;
		char* _tmp25;
		ValaCCodeFunction* _tmp28;
		ValaCCodeBlock* cblock;
		ValaCCodeIdentifier* _tmp29;
		ValaCCodeFunctionCall* _tmp30;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp32;
		char* _tmp31;
		ValaCCodeIdentifier* _tmp33;
		ValaCCodeExpressionStatement* _tmp34;
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp24 = NULL;
		function = (_tmp24 = vala_ccode_function_new ((_tmp23 = g_strconcat ((_tmp22 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (st))), "free", NULL)), "void"), (_tmp23 = (g_free (_tmp23), NULL)), (_tmp22 = (g_free (_tmp22), NULL)), _tmp24);
		if (vala_symbol_get_access (((ValaSymbol*) st)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp27 = NULL;
		_tmp26 = NULL;
		_tmp25 = NULL;
		vala_ccode_function_add_parameter (function, (_tmp27 = vala_ccode_formal_parameter_new ("self", (_tmp26 = g_strconcat ((_tmp25 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)), "*", NULL)))));
		(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
		(_tmp26 = (g_free (_tmp26), NULL));
		(_tmp25 = (g_free (_tmp25), NULL));
		_tmp28 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp28 = vala_ccode_function_copy (function))));
		(_tmp28 = (g_object_unref (_tmp28), NULL));
		cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
		_tmp29 = NULL;
		_tmp30 = NULL;
		ccall = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("g_slice_free")))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), _tmp30);
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ((_tmp31 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))))));
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		(_tmp31 = (g_free (_tmp31), NULL));
		_tmp33 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("self"))));
		(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
		_tmp34 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp34 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
		vala_ccode_function_set_block (function, cblock);
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (function));
		(function == NULL ? NULL : (function = (g_object_unref (function), NULL)));
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	_tmp36 = NULL;
	_tmp35 = NULL;
	self->priv->current_type_symbol = (_tmp36 = (_tmp35 = old_type_symbol, (_tmp35 == NULL ? NULL : g_object_ref (_tmp35))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), _tmp36);
	_tmp38 = NULL;
	_tmp37 = NULL;
	self->priv->instance_struct = (_tmp38 = (_tmp37 = old_instance_struct, (_tmp37 == NULL ? NULL : g_object_ref (_tmp37))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), _tmp38);
	_tmp40 = NULL;
	_tmp39 = NULL;
	self->priv->instance_dispose_fragment = (_tmp40 = (_tmp39 = old_instance_dispose_fragment, (_tmp39 == NULL ? NULL : g_object_ref (_tmp39))), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), _tmp40);
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
	(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
}


gboolean vala_code_generator_get_memory_management (ValaCodeGenerator* self)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	return self->priv->_memory_management;
}


void vala_code_generator_set_memory_management (ValaCodeGenerator* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	self->priv->_memory_management = value;
}


static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	ValaCodeGenerator * self;
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_CODE_GENERATOR (obj);
	{
		GeeSet* _tmp0;
		GeeSet* _tmp1;
		_tmp0 = NULL;
		self->priv->predefined_marshal_set = (_tmp0 = GEE_SET (gee_hash_set_new (g_strdup, g_free, g_str_hash, g_str_equal)), (self->priv->predefined_marshal_set == NULL ? NULL : (self->priv->predefined_marshal_set = (g_object_unref (self->priv->predefined_marshal_set), NULL))), _tmp0);
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:VOID");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:BOOLEAN");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:CHAR");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UCHAR");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:INT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UINT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:LONG");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:ULONG");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:ENUM");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:FLAGS");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:FLOAT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:DOUBLE");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:STRING");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:OBJECT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "STRING:OBJECT,POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UINT,POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "BOOLEAN:FLAGS");
		_tmp1 = NULL;
		self->priv->c_keywords = (_tmp1 = GEE_SET (gee_hash_set_new (g_strdup, g_free, g_str_hash, g_str_equal)), (self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_object_unref (self->priv->c_keywords), NULL))), _tmp1);
		/* C99 keywords*/
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Bool");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Complex");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Imaginary");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "auto");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "break");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "case");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "char");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "const");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "continue");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "default");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "do");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "double");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "else");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "enum");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "extern");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "float");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "for");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "goto");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "if");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "inline");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "int");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "long");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "register");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "restrict");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "return");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "short");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "signed");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "sizeof");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "static");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "struct");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "switch");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "typedef");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "union");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "unsigned");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "void");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "volatile");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "while");
		/* MSVC keywords*/
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "cdecl");
	}
	return obj;
}


static void vala_code_generator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		g_value_set_boolean (value, vala_code_generator_get_memory_management (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_code_generator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		vala_code_generator_set_memory_management (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_code_generator_class_init (ValaCodeGeneratorClass * klass)
{
	vala_code_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_code_generator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_code_generator_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_code_generator_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_code_generator_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_code_generator_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_code_generator_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_callback = vala_code_generator_real_visit_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_code_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_code_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_code_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_code_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_code_generator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_code_generator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_code_generator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_code_generator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_block = vala_code_generator_real_visit_begin_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_block = vala_code_generator_real_visit_end_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_code_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_code_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_variable_declarator = vala_code_generator_real_visit_variable_declarator;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = vala_code_generator_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_code_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_code_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_code_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_code_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_code_generator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_code_generator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_code_generator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_foreach_statement = vala_code_generator_real_visit_begin_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_foreach_statement = vala_code_generator_real_visit_end_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_code_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_code_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_return_statement = vala_code_generator_real_visit_begin_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_return_statement = vala_code_generator_real_visit_end_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_code_generator_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_code_generator_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_code_generator_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_code_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = vala_code_generator_real_visit_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_code_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_code_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_code_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_code_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_code_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_code_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_literal_expression = vala_code_generator_real_visit_literal_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_code_generator_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_code_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_code_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_code_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_object_creation_expression = vala_code_generator_real_visit_end_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_code_generator_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_code_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_code_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_code_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_code_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_code_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_code_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_code_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_code_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_code_generator_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_lambda_expression = vala_code_generator_real_visit_end_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_assignment = vala_code_generator_real_visit_end_assignment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_code_generator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_code_generator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_invocation_expression = vala_code_generator_real_visit_end_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_code_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_code_generator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_code_generator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_code_generator_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_code_generator_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_code_generator_real_visit_struct;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_GENERATOR_MEMORY_MANAGEMENT, g_param_spec_boolean ("memory-management", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_code_generator_init (ValaCodeGenerator * self)
{
	self->priv = VALA_CODE_GENERATOR_GET_PRIVATE (self);
	self->priv->temp_vars = gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal);
	self->priv->temp_ref_vars = gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal);
	self->priv->next_temp_var_id = 0;
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
	self->priv->in_creation_method = FALSE;
	self->priv->current_method_inner_error = FALSE;
	self->priv->in_plugin = FALSE;
}


static void vala_code_generator_dispose (GObject * obj)
{
	ValaCodeGenerator * self;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	self = VALA_CODE_GENERATOR (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL)));
	(self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL)));
	(self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL)));
	(self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL)));
	(self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL)));
	(self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL)));
	(self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL)));
	(self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL)));
	(self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL)));
	(self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL)));
	(self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL)));
	(self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL)));
	(self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL)));
	(self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL)));
	(self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL)));
	(self->priv->class_init_fragment == NULL ? NULL : (self->priv->class_init_fragment = (g_object_unref (self->priv->class_init_fragment), NULL)));
	(self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL)));
	(self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL)));
	(self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL)));
	(self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL)));
	(self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL)));
	(self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL)));
	(self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL)));
	(self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL)));
	(self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL)));
	(self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL)));
	(self->priv->block == NULL ? NULL : (self->priv->block = (g_object_unref (self->priv->block), NULL)));
	(self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_object_unref (self->priv->temp_vars), NULL)));
	(self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_object_unref (self->priv->temp_ref_vars), NULL)));
	(self->priv->user_marshal_set == NULL ? NULL : (self->priv->user_marshal_set = (g_object_unref (self->priv->user_marshal_set), NULL)));
	(self->priv->predefined_marshal_set == NULL ? NULL : (self->priv->predefined_marshal_set = (g_object_unref (self->priv->predefined_marshal_set), NULL)));
	(self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_object_unref (self->priv->c_keywords), NULL)));
	(self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL)));
	(self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL)));
	(self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL)));
	(self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL)));
	(self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL)));
	(self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL)));
	(self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL)));
	(self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL)));
	(self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL)));
	(self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL)));
	(self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL)));
	(self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL)));
	(self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL)));
	(self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL)));
	(self->priv->gobject_type == NULL ? NULL : (self->priv->gobject_type = (g_object_unref (self->priv->gobject_type), NULL)));
	(self->priv->gerror_type == NULL ? NULL : (self->priv->gerror_type = (g_object_unref (self->priv->gerror_type), NULL)));
	(self->priv->glist_type == NULL ? NULL : (self->priv->glist_type = (g_object_unref (self->priv->glist_type), NULL)));
	(self->priv->gslist_type == NULL ? NULL : (self->priv->gslist_type = (g_object_unref (self->priv->gslist_type), NULL)));
	(self->priv->gstring_type == NULL ? NULL : (self->priv->gstring_type = (g_object_unref (self->priv->gstring_type), NULL)));
	(self->priv->garray_type == NULL ? NULL : (self->priv->garray_type = (g_object_unref (self->priv->garray_type), NULL)));
	(self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL)));
	(self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL)));
	(self->priv->iterable_type == NULL ? NULL : (self->priv->iterable_type = (g_object_unref (self->priv->iterable_type), NULL)));
	(self->priv->iterator_type == NULL ? NULL : (self->priv->iterator_type = (g_object_unref (self->priv->iterator_type), NULL)));
	(self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL)));
	(self->priv->map_type == NULL ? NULL : (self->priv->map_type = (g_object_unref (self->priv->map_type), NULL)));
	(self->priv->connection_type == NULL ? NULL : (self->priv->connection_type = (g_object_unref (self->priv->connection_type), NULL)));
	(self->priv->substring_method == NULL ? NULL : (self->priv->substring_method = (g_object_unref (self->priv->substring_method), NULL)));
	(self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL));
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_code_generator_get_type (void)
{
	static GType vala_code_generator_type_id = 0;
	if (G_UNLIKELY (vala_code_generator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeGenerator), 0, (GInstanceInitFunc) vala_code_generator_init };
		vala_code_generator_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaCodeGenerator", &g_define_type_info, 0);
	}
	return vala_code_generator_type_id;
}




