/* valadbusbindingprovider.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALADBUSBINDINGPROVIDER_H__
#define __VALADBUSBINDINGPROVIDER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valabindingprovider.h>
#include <vala/valasymbol.h>
#include <vala/valamemberaccess.h>
#include <vala/valacodecontext.h>

G_BEGIN_DECLS


#define VALA_TYPE_DBUS_BINDING_PROVIDER (vala_dbus_binding_provider_get_type ())
#define VALA_DBUS_BINDING_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_BINDING_PROVIDER, ValaDBusBindingProvider))
#define VALA_DBUS_BINDING_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_BINDING_PROVIDER, ValaDBusBindingProviderClass))
#define VALA_IS_DBUS_BINDING_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_BINDING_PROVIDER))
#define VALA_IS_DBUS_BINDING_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_BINDING_PROVIDER))
#define VALA_DBUS_BINDING_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_BINDING_PROVIDER, ValaDBusBindingProviderClass))

typedef struct _ValaDBusBindingProvider ValaDBusBindingProvider;
typedef struct _ValaDBusBindingProviderClass ValaDBusBindingProviderClass;
typedef struct _ValaDBusBindingProviderPrivate ValaDBusBindingProviderPrivate;

/**
 * Dynamic binding provider for DBus objects.
 */
struct _ValaDBusBindingProvider {
	GObject parent;
	ValaDBusBindingProviderPrivate * priv;
};
struct _ValaDBusBindingProviderClass {
	GObjectClass parent;
};

ValaDBusBindingProvider* vala_dbus_binding_provider_new (void);
void vala_dbus_binding_provider_set_context (ValaDBusBindingProvider* self, ValaCodeContext* value);
GType vala_dbus_binding_provider_get_type (void);

G_END_DECLS

#endif
