/* valainvokable.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valainvokable.h"
#include <vala/valatypereference.h>



gboolean vala_invokable_is_invokable (ValaInvokable* self)
{
	return VALA_INVOKABLE_GET_INTERFACE (self)->is_invokable (self);
}


ValaTypeReference* vala_invokable_get_return_type (ValaInvokable* self)
{
	return VALA_INVOKABLE_GET_INTERFACE (self)->get_return_type (self);
}


GeeCollection* vala_invokable_get_parameters (ValaInvokable* self)
{
	return VALA_INVOKABLE_GET_INTERFACE (self)->get_parameters (self);
}


static void vala_invokable_base_init (ValaInvokableIface * iface)
{
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType vala_invokable_get_type (void)
{
	static GType vala_invokable_type_id = 0;
	if (G_UNLIKELY (vala_invokable_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInvokableIface), (GBaseInitFunc) vala_invokable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL };
		vala_invokable_type_id = g_type_register_static (G_TYPE_INTERFACE, "ValaInvokable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (vala_invokable_type_id, VALA_TYPE_SYMBOL);
	}
	return vala_invokable_type_id;
}




