/* valatypeparameter.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valatypeparameter.h"
#include <gee/map.h>
#include <gee/hashmap.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valatypeparameter.h>
#include <vala/valaarray.h>
#include <vala/valascope.h>

struct _ValaTypeParameterPrivate {
	GeeMap* array_types;
};
#define VALA_TYPE_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPE_PARAMETER, ValaTypeParameterPrivate))
enum  {
	VALA_TYPE_PARAMETER_DUMMY_PROPERTY
};
static void vala_type_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_type_parameter_parent_class = NULL;
static void vala_type_parameter_dispose (GObject * obj);


/**
 * Creates a new generic type parameter.
 *
 * @param name   parameter name
 * @param source reference to source code
 * @return       newly created generic type parameter
 */
ValaTypeParameter* vala_type_parameter_new (const char* _name, ValaSourceReference* source)
{
	ValaTypeParameter * self;
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_TYPE_PARAMETER, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), _name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


static void vala_type_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaTypeParameter * self;
	self = ((ValaTypeParameter*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_type_parameter (visitor, self);
}


/**
 * Returns the array type for elements of this type parameter.
 *
 * @param rank the rank the array should be of
 * @return array type for this type parameter
 */
ValaArray* vala_type_parameter_get_array (ValaTypeParameter* self, gint rank)
{
	ValaArray* array_type;
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (self), NULL);
	array_type = NULL;
	if (self->priv->array_types != NULL) {
		ValaArray* _tmp0;
		_tmp0 = NULL;
		array_type = (_tmp0 = gee_map_get (((GeeMap*) self->priv->array_types), GINT_TO_POINTER (rank)), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp0);
	}
	if (array_type == NULL) {
		ValaArray* new_array_type;
		ValaArrayLengthField* _tmp3;
		ValaArrayLengthField* _tmp2;
		ValaArrayResizeMethod* _tmp5;
		ValaArrayResizeMethod* _tmp4;
		ValaArrayMoveMethod* _tmp7;
		ValaArrayMoveMethod* _tmp6;
		ValaArray* _tmp9;
		ValaArray* _tmp8;
		if (self->priv->array_types == NULL) {
			GeeMap* _tmp1;
			_tmp1 = NULL;
			self->priv->array_types = (_tmp1 = GEE_MAP (gee_hash_map_new (NULL, NULL, g_object_ref, g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal)), (self->priv->array_types == NULL ? NULL : (self->priv->array_types = (g_object_unref (self->priv->array_types), NULL))), _tmp1);
		}
		new_array_type = vala_array_new_with_type_parameter (self, rank, vala_code_node_get_source_reference (((ValaCodeNode*) self)));
		vala_scope_add (vala_symbol_get_scope (vala_symbol_get_parent_symbol (((ValaSymbol*) self))), vala_symbol_get_name (((ValaSymbol*) new_array_type)), VALA_SYMBOL (new_array_type));
		/* add internal length field */
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) new_array_type)), vala_symbol_get_name (((ValaSymbol*) (_tmp2 = vala_array_get_length_field (new_array_type)))), VALA_SYMBOL ((_tmp3 = vala_array_get_length_field (new_array_type))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		/* add internal resize method */
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) new_array_type)), vala_symbol_get_name (((ValaSymbol*) (_tmp4 = vala_array_get_resize_method (new_array_type)))), VALA_SYMBOL ((_tmp5 = vala_array_get_resize_method (new_array_type))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		/* add internal move method */
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) new_array_type)), vala_symbol_get_name (((ValaSymbol*) (_tmp6 = vala_array_get_move_method (new_array_type)))), VALA_SYMBOL ((_tmp7 = vala_array_get_move_method (new_array_type))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		/* link the array type to the same source as the container type */
		vala_code_node_set_source_reference (VALA_CODE_NODE (new_array_type), vala_code_node_get_source_reference (((ValaCodeNode*) self)));
		gee_map_set (((GeeMap*) self->priv->array_types), GINT_TO_POINTER (rank), new_array_type);
		_tmp9 = NULL;
		_tmp8 = NULL;
		array_type = (_tmp9 = (_tmp8 = new_array_type, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp9);
		(new_array_type == NULL ? NULL : (new_array_type = (g_object_unref (new_array_type), NULL)));
	}
	return array_type;
	(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
}


/**
 * Checks two type parameters for equality.
 *
 * @param param2 a type parameter
 * @return      true if this type parameter is equal to param2, false
 *              otherwise
 */
gboolean vala_type_parameter_equals (ValaTypeParameter* self, ValaTypeParameter* param2)
{
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (self), FALSE);
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (param2), FALSE);
	return TRUE;
}


static void vala_type_parameter_class_init (ValaTypeParameterClass * klass)
{
	vala_type_parameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeParameterPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_type_parameter_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_type_parameter_real_accept;
}


static void vala_type_parameter_init (ValaTypeParameter * self)
{
	self->priv = VALA_TYPE_PARAMETER_GET_PRIVATE (self);
}


static void vala_type_parameter_dispose (GObject * obj)
{
	ValaTypeParameter * self;
	ValaTypeParameterClass * klass;
	GObjectClass * parent_class;
	self = VALA_TYPE_PARAMETER (obj);
	(self->priv->array_types == NULL ? NULL : (self->priv->array_types = (g_object_unref (self->priv->array_types), NULL)));
	klass = VALA_TYPE_PARAMETER_CLASS (g_type_class_peek (VALA_TYPE_TYPE_PARAMETER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_type_parameter_get_type (void)
{
	static GType vala_type_parameter_type_id = 0;
	if (G_UNLIKELY (vala_type_parameter_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_type_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeParameter), 0, (GInstanceInitFunc) vala_type_parameter_init };
		vala_type_parameter_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaTypeParameter", &g_define_type_info, 0);
	}
	return vala_type_parameter_type_id;
}




