/* valaunaryexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAUNARYEXPRESSION_H__
#define __VALAUNARYEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpressionPrivate ValaUnaryExpressionPrivate;

/**
 * Represents an expression with one operand in the source code.
 *
 * Supports +, -, !, ~, ref, out.
 */
struct _ValaUnaryExpression {
	ValaExpression parent;
	ValaUnaryExpressionPrivate * priv;
};
struct _ValaUnaryExpressionClass {
	ValaExpressionClass parent;
};
typedef enum  {
	VALA_UNARY_OPERATOR_PLUS,
	VALA_UNARY_OPERATOR_MINUS,
	VALA_UNARY_OPERATOR_LOGICAL_NEGATION,
	VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT,
	VALA_UNARY_OPERATOR_INCREMENT,
	VALA_UNARY_OPERATOR_DECREMENT,
	VALA_UNARY_OPERATOR_REF,
	VALA_UNARY_OPERATOR_OUT
} ValaUnaryOperator;

ValaUnaryExpression* vala_unary_expression_new (ValaUnaryOperator op, ValaExpression* _inner, ValaSourceReference* source);
ValaUnaryOperator vala_unary_expression_get_operator (ValaUnaryExpression* self);
void vala_unary_expression_set_operator (ValaUnaryExpression* self, ValaUnaryOperator value);
ValaExpression* vala_unary_expression_get_inner (ValaUnaryExpression* self);
void vala_unary_expression_set_inner (ValaUnaryExpression* self, ValaExpression* value);
char* vala_unary_expression_get_operator_string (ValaUnaryExpression* self);
GType vala_unary_expression_get_type (void);

G_END_DECLS

#endif
