/* valaccodeunaryexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEUNARYEXPRESSION_H__
#define __CCODE_VALACCODEUNARYEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_UNARY_EXPRESSION (vala_ccode_unary_expression_get_type ())
#define VALA_CCODE_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_UNARY_EXPRESSION, ValaCCodeUnaryExpression))
#define VALA_CCODE_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_UNARY_EXPRESSION, ValaCCodeUnaryExpressionClass))
#define VALA_IS_CCODE_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_UNARY_EXPRESSION))
#define VALA_IS_CCODE_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_UNARY_EXPRESSION))
#define VALA_CCODE_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_UNARY_EXPRESSION, ValaCCodeUnaryExpressionClass))

typedef struct _ValaCCodeUnaryExpression ValaCCodeUnaryExpression;
typedef struct _ValaCCodeUnaryExpressionClass ValaCCodeUnaryExpressionClass;
typedef struct _ValaCCodeUnaryExpressionPrivate ValaCCodeUnaryExpressionPrivate;

/**
 * Represents an expression with one operand in the C code.
 */
struct _ValaCCodeUnaryExpression {
	ValaCCodeExpression parent;
	ValaCCodeUnaryExpressionPrivate * priv;
};
struct _ValaCCodeUnaryExpressionClass {
	ValaCCodeExpressionClass parent;
};
typedef enum  {
	VALA_CCODE_UNARY_OPERATOR_PLUS,
	VALA_CCODE_UNARY_OPERATOR_MINUS,
	VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION,
	VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT,
	VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION,
	VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF,
	VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT,
	VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT,
	VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT,
	VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT
} ValaCCodeUnaryOperator;

ValaCCodeUnaryExpression* vala_ccode_unary_expression_new (ValaCCodeUnaryOperator op, ValaCCodeExpression* expr);
ValaCCodeUnaryOperator vala_ccode_unary_expression_get_operator (ValaCCodeUnaryExpression* self);
void vala_ccode_unary_expression_set_operator (ValaCCodeUnaryExpression* self, ValaCCodeUnaryOperator value);
ValaCCodeExpression* vala_ccode_unary_expression_get_inner (ValaCCodeUnaryExpression* self);
void vala_ccode_unary_expression_set_inner (ValaCCodeUnaryExpression* self, ValaCCodeExpression* value);
GType vala_ccode_unary_expression_get_type (void);

G_END_DECLS

#endif
