/* collection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GEE_COLLECTION_H__
#define __GEE_COLLECTION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/iterable.h>

G_BEGIN_DECLS


#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

/**
 * Serves as the base interface for implementing collection classes. Defines
 * size, iteration, and modification methods.
 */
struct _GeeCollectionIface {
	GTypeInterface parent;
	gboolean (*contains) (GeeCollection* self, gpointer item);
	gboolean (*add) (GeeCollection* self, gpointer item);
	gboolean (*remove) (GeeCollection* self, gpointer item);
	void (*clear) (GeeCollection* self);
};

gboolean gee_collection_contains (GeeCollection* self, gpointer item);
gboolean gee_collection_add (GeeCollection* self, gpointer item);
gboolean gee_collection_remove (GeeCollection* self, gpointer item);
void gee_collection_clear (GeeCollection* self);
gint gee_collection_get_size (GeeCollection* self);
GType gee_collection_get_type (void);

G_END_DECLS

#endif
