/* valabooleanliteral.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valabooleanliteral.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaBooleanLiteralPrivate {
	gboolean _value;
};
#define VALA_BOOLEAN_LITERAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralPrivate))
enum  {
	VALA_BOOLEAN_LITERAL_DUMMY_PROPERTY,
	VALA_BOOLEAN_LITERAL_VALUE
};
static void vala_boolean_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_boolean_literal_real_to_string (ValaCodeNode* base);
static gpointer vala_boolean_literal_parent_class = NULL;
static void vala_boolean_literal_dispose (GObject * obj);


/**
 * Creates a new boolean literal.
 *
 * @param b      boolean value
 * @param source reference to source code
 * @return       newly created boolean literal
 */
ValaBooleanLiteral* vala_boolean_literal_new (gboolean b, ValaSourceReference* source) {
	ValaBooleanLiteral * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_BOOLEAN_LITERAL, 0, NULL);
	vala_boolean_literal_set_value (self, b);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


static void vala_boolean_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaBooleanLiteral * self;
	self = VALA_BOOLEAN_LITERAL (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_boolean_literal (visitor, self);
}


static char* vala_boolean_literal_real_to_string (ValaCodeNode* base) {
	ValaBooleanLiteral * self;
	self = VALA_BOOLEAN_LITERAL (base);
	if (vala_boolean_literal_get_value (self)) {
		return g_strdup ("true");
	} else {
		return g_strdup ("false");
	}
}


gboolean vala_boolean_literal_get_value (ValaBooleanLiteral* self) {
	g_return_val_if_fail (VALA_IS_BOOLEAN_LITERAL (self), FALSE);
	return self->priv->_value;
}


void vala_boolean_literal_set_value (ValaBooleanLiteral* self, gboolean value) {
	g_return_if_fail (VALA_IS_BOOLEAN_LITERAL (self));
	self->priv->_value = value;
}


static void vala_boolean_literal_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaBooleanLiteral * self;
	self = VALA_BOOLEAN_LITERAL (object);
	switch (property_id) {
		case VALA_BOOLEAN_LITERAL_VALUE:
		g_value_set_boolean (value, vala_boolean_literal_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_boolean_literal_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaBooleanLiteral * self;
	self = VALA_BOOLEAN_LITERAL (object);
	switch (property_id) {
		case VALA_BOOLEAN_LITERAL_VALUE:
		vala_boolean_literal_set_value (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_boolean_literal_class_init (ValaBooleanLiteralClass * klass) {
	vala_boolean_literal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaBooleanLiteralPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_boolean_literal_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_boolean_literal_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_boolean_literal_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_boolean_literal_real_accept;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_boolean_literal_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_BOOLEAN_LITERAL_VALUE, g_param_spec_boolean ("value", "value", "value", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_boolean_literal_init (ValaBooleanLiteral * self) {
	self->priv = VALA_BOOLEAN_LITERAL_GET_PRIVATE (self);
}


static void vala_boolean_literal_dispose (GObject * obj) {
	ValaBooleanLiteral * self;
	self = VALA_BOOLEAN_LITERAL (obj);
	G_OBJECT_CLASS (vala_boolean_literal_parent_class)->dispose (obj);
}


GType vala_boolean_literal_get_type (void) {
	static GType vala_boolean_literal_type_id = 0;
	if (G_UNLIKELY (vala_boolean_literal_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBooleanLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_boolean_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBooleanLiteral), 0, (GInstanceInitFunc) vala_boolean_literal_init };
		vala_boolean_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaBooleanLiteral", &g_define_type_info, 0);
	}
	return vala_boolean_literal_type_id;
}




